/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.findUsages;

import com.intellij.codeInsight.highlighting.HighlightUsagesDescriptionLocation;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.findUsages.JavaScriptFindUsagesProvider;
import com.intellij.lang.javascript.presentable.JSFormatUtil;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackage;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionProvider;
import com.intellij.psi.PsiElement;
import com.intellij.usageView.UsageViewLongNameLocation;
import com.intellij.usageView.UsageViewShortNameLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaScriptUsageViewDescriptionProvider
implements ElementDescriptionProvider {
    public String getElementDescription(@NotNull PsiElement element2, @NotNull ElementDescriptionLocation location) {
        if (element2 == null) {
            JavaScriptUsageViewDescriptionProvider.$$$reportNull$$$0(0);
        }
        if (location == null) {
            JavaScriptUsageViewDescriptionProvider.$$$reportNull$$$0(1);
        }
        if (location instanceof UsageViewLongNameLocation) {
            if (element2 instanceof JSFunction) {
                return JSFormatUtil.getFunctionLongDescription((JSFunction)element2, false, false, false, true, null);
            }
            if (element2 instanceof JSPackage || element2 instanceof JSPackageStatement || element2 instanceof JSClass || element2 instanceof JSVariable) {
                return JavaScriptUsageViewDescriptionProvider.nonEmptyName(((JSQualifiedNamedElement)element2).getQualifiedName());
            }
            if (DialectDetector.languageOfElement(element2).isKindOf((Language)JavascriptLanguage.INSTANCE)) {
                return new JavaScriptFindUsagesProvider().getDescriptiveName(element2);
            }
        } else if (location instanceof UsageViewShortNameLocation) {
            if (element2 instanceof JSNamedElement) {
                return JavaScriptUsageViewDescriptionProvider.nonEmptyName(((JSNamedElement)element2).getName());
            }
        } else if (element2 instanceof JSNamedElement && location instanceof HighlightUsagesDescriptionLocation) {
            JavaScriptFindUsagesProvider usagesProvider = new JavaScriptFindUsagesProvider();
            return usagesProvider.getType(element2) + " " + usagesProvider.getDescriptiveName(element2);
        }
        return null;
    }

    private static String nonEmptyName(@Nullable String name) {
        return StringUtil.isEmpty((String)name) ? JavaScriptBundle.message("element.name.anonymous", new Object[0]) : name;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "location";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/findUsages/JavaScriptUsageViewDescriptionProvider";
        objectArray[2] = "getElementDescription";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

