/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.macro;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.macro.JSMacroUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public class JSSuggestDefaultVariableKindMacro
extends Macro {
    public String getName() {
        return "jsSuggestDefaultVariableKind";
    }

    public String getPresentableName() {
        return JavaScriptBundle.message("macro.js.suggest.default.variable.kind", new Object[0]);
    }

    @NotNull
    public String getDefaultValue() {
        return "var";
    }

    public Result calculateResult(Expression @NotNull [] params, ExpressionContext context2) {
        VarKindAllowed allowedVarKinds;
        if (params == null) {
            JSSuggestDefaultVariableKindMacro.$$$reportNull$$$0(0);
        }
        return new TextResult((allowedVarKinds = JSSuggestDefaultVariableKindMacro.getAllowedVarKinds(params, context2)) == VarKindAllowed.OnlyVar ? "var" : (allowedVarKinds == VarKindAllowed.VarLet ? "let" : "const"));
    }

    private static VarKindAllowed getAllowedVarKinds(Expression @NotNull [] params, ExpressionContext context2) {
        PsiElement element2;
        if (params == null) {
            JSSuggestDefaultVariableKindMacro.$$$reportNull$$$0(1);
        }
        if ((element2 = context2.getPsiElementAtStartOffset()) == null || !DialectDetector.isES6(element2) && !DialectDetector.isTypeScript(element2)) {
            return VarKindAllowed.OnlyVar;
        }
        if (params.length == 0) {
            return VarKindAllowed.VarLetConst;
        }
        return VarKindAllowed.VarLet;
    }

    public LookupElement[] calculateLookupItems(Expression @NotNull [] params, ExpressionContext context2) {
        VarKindAllowed allowed;
        if (params == null) {
            JSSuggestDefaultVariableKindMacro.$$$reportNull$$$0(2);
        }
        if ((allowed = JSSuggestDefaultVariableKindMacro.getAllowedVarKinds(params, context2)) == VarKindAllowed.VarLetConst) {
            return new LookupElement[]{LookupElementBuilder.create((String)"const"), LookupElementBuilder.create((String)"let"), LookupElementBuilder.create((String)"var")};
        }
        if (allowed == VarKindAllowed.VarLet) {
            return new LookupElement[]{LookupElementBuilder.create((String)"let"), LookupElementBuilder.create((String)"var")};
        }
        return null;
    }

    public boolean isAcceptableInContext(TemplateContextType context2) {
        return JSMacroUtil.isJSLikeContext(context2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "params";
        objectArray2[1] = "com/intellij/lang/javascript/macro/JSSuggestDefaultVariableKindMacro";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateResult";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getAllowedVarKinds";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateLookupItems";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static enum VarKindAllowed {
        OnlyVar,
        VarLet,
        VarLetConst;

    }
}

