/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportCall;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.modules.InstallNodeModuleQuickFix;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.typescript.psi.TypeScriptExternalModuleReference;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001:\u0002&'B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0017H$J;\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\"\u001a\u00020\f2\u0006\u0010#\u001a\u00020\u0016H$\u00a2\u0006\u0002\u0010$J(\u0010%\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\f2\u0006\u0010#\u001a\u00020\u0016H$\u00a8\u0006("}, d2={"Lcom/intellij/lang/javascript/modules/JSModuleVisitor;", "Lcom/intellij/lang/javascript/psi/JSElementVisitor;", "<init>", "()V", "visitES6ImportCall", "", "importCall", "Lcom/intellij/lang/ecmascript6/psi/ES6ImportCall;", "visitTypeScriptImportStatement", "importStatement", "Lcom/intellij/lang/javascript/psi/ecma6/TypeScriptImportStatement;", "createLiteralValueResolver", "Lcom/intellij/lang/javascript/modules/JSModuleVisitor$ImportResolver;", "argument", "Lcom/intellij/lang/javascript/psi/JSLiteralExpression;", "visitES6FromClause", "fromClause", "Lcom/intellij/lang/ecmascript6/psi/ES6FromClause;", "visitJSCallExpression", "node", "Lcom/intellij/lang/javascript/psi/JSCallExpression;", "createLiteralPointerBuilder", "Lcom/intellij/lang/javascript/modules/JSModuleVisitor$ModulePointerBuilder;", "Lcom/intellij/psi/PsiElement;", "isAvailable", "", "element", "processImport", "literalElement", "quotedLiteralValue", "", "references", "", "Lcom/intellij/psi/PsiReference;", "importResolver", "pointerBuilder", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;[Lcom/intellij/psi/PsiReference;Lcom/intellij/lang/javascript/modules/JSModuleVisitor$ImportResolver;Lcom/intellij/lang/javascript/modules/JSModuleVisitor$ModulePointerBuilder;)V", "processRequire", "ImportResolver", "ModulePointerBuilder", "intellij.javascript.impl"})
public abstract class JSModuleVisitor
extends JSElementVisitor {
    protected JSModuleVisitor() {
    }

    @Override
    public void visitES6ImportCall(@NotNull ES6ImportCall importCall) {
        Intrinsics.checkNotNullParameter((Object)importCall, (String)"importCall");
        if (!this.isAvailable((PsiElement)importCall)) {
            return;
        }
        JSLiteralExpression argument = importCall.getStringArgument();
        if (argument == null) {
            return;
        }
        PsiElement psiElement = (PsiElement)argument;
        String string = argument.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        PsiReference[] psiReferenceArray = argument.getReferences();
        Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferences(...)");
        this.processImport(psiElement, string, psiReferenceArray, this.createLiteralValueResolver(argument), this.createLiteralPointerBuilder((PsiElement)argument));
    }

    @Override
    public void visitTypeScriptImportStatement(@NotNull TypeScriptImportStatement importStatement) {
        Intrinsics.checkNotNullParameter((Object)importStatement, (String)"importStatement");
        if (!this.isAvailable((PsiElement)importStatement)) {
            return;
        }
        TypeScriptExternalModuleReference externalModuleReference = importStatement.getExternalModuleReference();
        if (externalModuleReference == null) {
            return;
        }
        Pair<String, PsiElement> literalWithText = JSPsiImplUtils.getChildStringLiteralWithText((PsiElement)externalModuleReference);
        if (literalWithText == null) {
            return;
        }
        PsiElement literalElement = (PsiElement)literalWithText.second;
        String quotedLiteralValue = (String)literalWithText.first;
        if (quotedLiteralValue == null) {
            return;
        }
        Intrinsics.checkNotNull((Object)literalElement);
        PsiReference[] psiReferenceArray = externalModuleReference.getReferences();
        Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferences(...)");
        this.processImport(literalElement, quotedLiteralValue, psiReferenceArray, new ImportResolver(externalModuleReference){
            final /* synthetic */ TypeScriptExternalModuleReference $externalModuleReference;
            {
                this.$externalModuleReference = $externalModuleReference;
            }

            public Collection<PsiElement> resolveImportModules() {
                Collection<PsiElement> collection = JSFileReferencesUtil.resolveModuleReferences((PsiElement)this.$externalModuleReference);
                Intrinsics.checkNotNullExpressionValue(collection, (String)"resolveModuleReferences(...)");
                return collection;
            }
        }, this.createLiteralPointerBuilder(literalElement));
    }

    private final ImportResolver createLiteralValueResolver(JSLiteralExpression argument) {
        return new ImportResolver(argument){
            final /* synthetic */ JSLiteralExpression $argument;
            {
                this.$argument = $argument;
            }

            public Collection<PsiElement> resolveImportModules() {
                Collection<PsiElement> collection = JSFileReferencesUtil.resolveModuleReferences((PsiElement)this.$argument);
                Intrinsics.checkNotNullExpressionValue(collection, (String)"resolveModuleReferences(...)");
                return collection;
            }
        };
    }

    @Override
    public void visitES6FromClause(@NotNull ES6FromClause fromClause) {
        PsiElement literalElement;
        Pair<String, PsiElement> childStringLiteralWithText;
        Intrinsics.checkNotNullParameter((Object)fromClause, (String)"fromClause");
        if (!this.isAvailable((PsiElement)fromClause)) {
            return;
        }
        Pair<String, PsiElement> pair = childStringLiteralWithText = JSPsiImplUtils.getChildStringLiteralWithText((PsiElement)fromClause);
        Object object = literalElement = pair != null ? (PsiElement)pair.second : null;
        if (literalElement == null) {
            return;
        }
        String string = fromClause.getReferenceText();
        if (string == null) {
            String string2 = "Required value was null.";
            throw new IllegalStateException(string2.toString());
        }
        PsiReference[] psiReferenceArray = fromClause.getReferences();
        Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferences(...)");
        this.processImport(literalElement, string, psiReferenceArray, new ImportResolver(fromClause){
            final /* synthetic */ ES6FromClause $fromClause;
            {
                this.$fromClause = $fromClause;
            }

            public Collection<PsiElement> resolveImportModules() {
                Collection<PsiElement> collection = JSFileReferencesUtil.resolveModuleReferences((PsiElement)this.$fromClause, true);
                Intrinsics.checkNotNullExpressionValue(collection, (String)"resolveModuleReferences(...)");
                return collection;
            }
        }, new ModulePointerBuilder(fromClause){
            final /* synthetic */ ES6FromClause $fromClause;
            {
                this.$fromClause = $fromClause;
            }

            public InstallNodeModuleQuickFix.ModuleElement createPointer() {
                return new InstallNodeModuleQuickFix.ES6FromClauseModuleElement(this.$fromClause);
            }
        });
    }

    @Override
    public void visitJSCallExpression(@NotNull JSCallExpression node) {
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (!this.isAvailable((PsiElement)node)) break block7;
                JSExpression[] jSExpressionArray = node.getArguments();
                Intrinsics.checkNotNullExpressionValue((Object)jSExpressionArray, (String)"getArguments(...)");
                if (!(((Object[])jSExpressionArray).length == 0)) break block8;
            }
            return;
        }
        JSExpression argument = node.getArguments()[0];
        if (!(argument instanceof JSLiteralExpression)) {
            return;
        }
        if (node.isRequireCall()) {
            this.processRequire(node, (JSLiteralExpression)argument, this.createLiteralValueResolver((JSLiteralExpression)argument), this.createLiteralPointerBuilder((PsiElement)argument));
        } else if (node.isImportPhaseCall()) {
            PsiElement psiElement = (PsiElement)argument;
            String string = ((JSLiteralExpression)argument).getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            PsiReference[] psiReferenceArray = ((JSLiteralExpression)argument).getReferences();
            Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferences(...)");
            this.processImport(psiElement, string, psiReferenceArray, this.createLiteralValueResolver((JSLiteralExpression)argument), this.createLiteralPointerBuilder((PsiElement)argument));
        }
    }

    private final ModulePointerBuilder createLiteralPointerBuilder(PsiElement argument) {
        return new ModulePointerBuilder(argument){
            final /* synthetic */ PsiElement $argument;
            {
                this.$argument = $argument;
            }

            public InstallNodeModuleQuickFix.ModuleElement createPointer() {
                return new InstallNodeModuleQuickFix.StringLiteralModuleElement(this.$argument);
            }
        };
    }

    protected abstract boolean isAvailable(@NotNull PsiElement var1);

    protected abstract void processImport(@NotNull PsiElement var1, @NotNull String var2, @NotNull PsiReference[] var3, @NotNull ImportResolver var4, @NotNull ModulePointerBuilder var5);

    protected abstract void processRequire(@NotNull JSCallExpression var1, @NotNull JSLiteralExpression var2, @NotNull ImportResolver var3, @NotNull ModulePointerBuilder var4);

    @FunctionalInterface
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\bg\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0005\u00c0\u0006\u0001"}, d2={"Lcom/intellij/lang/javascript/modules/JSModuleVisitor$ImportResolver;", "", "resolveImportModules", "", "Lcom/intellij/psi/PsiElement;", "intellij.javascript.impl"})
    public static interface ImportResolver {
        @NotNull
        public Collection<PsiElement> resolveImportModules();
    }

    @FunctionalInterface
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\bg\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0004\u00c0\u0006\u0001"}, d2={"Lcom/intellij/lang/javascript/modules/JSModuleVisitor$ModulePointerBuilder;", "", "createPointer", "Lcom/intellij/lang/javascript/modules/InstallNodeModuleQuickFix$ModuleElement;", "intellij.javascript.impl"})
    public static interface ModulePointerBuilder {
        @NotNull
        public InstallNodeModuleQuickFix.ModuleElement createPointer();
    }
}

