/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.functionmetrics;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NotNull;

public final class FunctionWithMultipleReturnPointsJSInspection
extends JavaScriptInspection {
    @Override
    @InspectionMessage
    @NotNull
    public String buildErrorString(Object ... args) {
        JSFunction function = (JSFunction)((PsiElement)args[0]).getParent();
        assert (function != null);
        int returnPointCount = FunctionWithMultipleReturnPointsJSInspection.countReturnPoints(function);
        if (FunctionWithMultipleReturnPointsJSInspection.functionHasIdentifier(function)) {
            String string = InspectionJSBundle.message("function.contains.multiple.return.points.error.string", returnPointCount);
            if (string == null) {
                FunctionWithMultipleReturnPointsJSInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = InspectionJSBundle.message("anonymous.function.contains.multiple.return.points.error.string", returnPointCount);
        if (string == null) {
            FunctionWithMultipleReturnPointsJSInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static int countReturnPoints(JSFunction function) {
        PsiElement lastChild = function.getLastChild();
        if (!(lastChild instanceof JSBlockStatement)) {
            return 0;
        }
        boolean hasFallthroughReturn = false;
        if (ControlFlowUtils.statementMayCompleteNormally((JSStatement)lastChild)) {
            hasFallthroughReturn = true;
        }
        ReturnCountVisitor visitor = new ReturnCountVisitor();
        lastChild.accept((PsiElementVisitor)visitor);
        int returnCount = visitor.getReturnCount();
        if (hasFallthroughReturn) {
            return returnCount + 1;
        }
        return returnCount;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/functionmetrics/FunctionWithMultipleReturnPointsJSInspection", "buildErrorString"));
    }

    private static class ReturnCountVisitor
    extends JSRecursiveElementVisitor {
        private int returnCount = 0;

        private ReturnCountVisitor() {
        }

        @Override
        public void visitJSElement(@NotNull JSElement jsElement) {
            if (jsElement == null) {
                ReturnCountVisitor.$$$reportNull$$$0(0);
            }
            int oldCount = 0;
            if (jsElement instanceof JSFunction) {
                oldCount = this.returnCount;
            }
            super.visitJSElement(jsElement);
            if (jsElement instanceof JSFunction) {
                this.returnCount = oldCount;
            }
        }

        @Override
        public void visitJSReturnStatement(@NotNull JSReturnStatement statement) {
            if (statement == null) {
                ReturnCountVisitor.$$$reportNull$$$0(1);
            }
            super.visitJSReturnStatement(statement);
            ++this.returnCount;
        }

        public int getReturnCount() {
            return this.returnCount;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jsElement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            objectArray2[1] = "com/sixrr/inspectjs/functionmetrics/FunctionWithMultipleReturnPointsJSInspection$ReturnCountVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSReturnStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitJSFunctionDeclaration(@NotNull JSFunction function) {
            int returnPointCount;
            if (function == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            if ((returnPointCount = FunctionWithMultipleReturnPointsJSInspection.countReturnPoints(function)) <= 1) {
                return;
            }
            this.registerFunctionError(function);
        }

        @Override
        public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            this.visitJSFunctionDeclaration(node);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "function";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            objectArray2[1] = "com/sixrr/inspectjs/functionmetrics/FunctionWithMultipleReturnPointsJSInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSFunctionDeclaration";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSFunctionExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

