/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.core.CoreBundle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.NamedScriptableDefinition;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.util.ObjectUtils;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.UUID;
import javax.swing.Icon;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Configuration
implements JDOMExternalizable {
    @NonNls
    public static final String CONTEXT_VAR_NAME = "__context__";
    public static final Configuration[] EMPTY_ARRAY = new Configuration[0];
    @NonNls
    protected static final String NAME_ATTRIBUTE_NAME = "name";
    @NonNls
    private static final String CREATED_ATTRIBUTE_NAME = "created";
    @NonNls
    private static final String UUID_ATTRIBUTE_NAME = "uuid";
    @NonNls
    private static final String DESCRIPTION_ATTRIBUTE_NAME = "description";
    @NonNls
    private static final String SUPPRESS_ID_ATTRIBUTE_NAME = "suppressId";
    @NonNls
    private static final String PROBLEM_DESCRIPTOR_ATTRIBUTE_NAME = "problemDescriptor";
    @NonNls
    private static final String CLEANUP_ATTRIBUTE_NAME = "cleanup";
    @NonNls
    private static final String ORDER_ATTRIBUTE_NAME = "order";
    @NotNull
    @Nls(capitalization=Nls.Capitalization.Sentence)
    private String name;
    private String category;
    private boolean predefined;
    private long created;
    private String uuid;
    private String description;
    private String suppressId;
    private String problemDescriptor;
    private boolean cleanup;
    private int order;
    @NonNls
    private String refName;

    public Configuration() {
        this.name = "";
        this.category = "";
        this.created = -1L;
    }

    public Configuration(@NotNull @Nls(capitalization=Nls.Capitalization.Sentence) String name, @NotNull String category) {
        if (name == null) {
            Configuration.$$$reportNull$$$0(0);
        }
        if (category == null) {
            Configuration.$$$reportNull$$$0(1);
        }
        this.name = name;
        this.category = category;
        this.created = -1L;
    }

    protected Configuration(@NotNull Configuration configuration) {
        if (configuration == null) {
            Configuration.$$$reportNull$$$0(2);
        }
        this.name = configuration.name;
        this.category = configuration.category;
        this.created = -1L;
        this.predefined = false;
        this.uuid = configuration.uuid;
        this.description = configuration.description;
        this.suppressId = configuration.suppressId;
        this.problemDescriptor = configuration.problemDescriptor;
        this.cleanup = configuration.cleanup;
        this.order = configuration.order;
        this.refName = null;
    }

    @NotNull
    public abstract Configuration copy();

    @NotNull
    @Nls
    public String getName() {
        String string = this.name;
        if (string == null) {
            Configuration.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void setName(@NotNull @Nls(capitalization=Nls.Capitalization.Sentence) String value) {
        if (value == null) {
            Configuration.$$$reportNull$$$0(4);
        }
        if (this.uuid == null) {
            this.getUuid();
        }
        this.name = value;
    }

    @NotNull
    @Nls
    public String getTypeText() {
        LanguageFileType type = this.getFileType();
        String name = type == null ? CoreBundle.message((String)"filetype.unknown.display.name", (Object[])new Object[0]) : type.getLanguage().getDisplayName();
        String string = this.isPredefined() ? SSRBundle.message("predefined.configuration.type.text", name) : SSRBundle.message("predefined.configuration.type.text.user.defined", name);
        if (string == null) {
            Configuration.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getCategory() {
        String string = this.category;
        if (string == null) {
            Configuration.$$$reportNull$$$0(6);
        }
        return string;
    }

    public void setCategory(@NotNull String category) {
        if (category == null) {
            Configuration.$$$reportNull$$$0(7);
        }
        this.category = category;
    }

    public long getCreated() {
        return this.created;
    }

    public void setCreated(long created) {
        if (this.predefined) {
            throw new AssertionError();
        }
        this.created = created;
    }

    @NotNull
    public String getUuid() {
        if (this.uuid == null) {
            this.uuid = UUID.nameUUIDFromBytes(this.name.getBytes(StandardCharsets.UTF_8)).toString();
        }
        String string = this.uuid;
        if (string == null) {
            Configuration.$$$reportNull$$$0(8);
        }
        return string;
    }

    public void setUuid(@Nullable String uuid) {
        this.uuid = uuid;
    }

    @NlsSafe
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @NlsSafe
    @Nullable
    public String getSuppressId() {
        return this.suppressId;
    }

    public void setSuppressId(String suppressId) {
        this.suppressId = suppressId;
    }

    @NlsSafe
    @Nullable
    public String getProblemDescriptor() {
        return this.problemDescriptor;
    }

    public void setProblemDescriptor(String problemDescriptor) {
        this.problemDescriptor = problemDescriptor;
    }

    public boolean isCleanup() {
        return this.cleanup;
    }

    public void setCleanup(boolean cleanup) {
        this.cleanup = cleanup;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        if (order < 0) {
            throw new IllegalArgumentException();
        }
        this.order = order;
    }

    public void readExternal(Element element) {
        Attribute mainAttribute;
        Attribute attribute;
        Attribute problemDescriptorAttribute;
        Attribute suppressIdAttribute;
        Attribute descriptionAttribute;
        Attribute uuidAttribute;
        this.name = (String)ObjectUtils.notNull((Object)element.getAttributeValue(NAME_ATTRIBUTE_NAME), (Object)"");
        Attribute createdAttribute = element.getAttribute(CREATED_ATTRIBUTE_NAME);
        if (createdAttribute != null) {
            try {
                this.created = createdAttribute.getLongValue();
            }
            catch (DataConversionException dataConversionException) {
                // empty catch block
            }
        }
        if ((uuidAttribute = element.getAttribute(UUID_ATTRIBUTE_NAME)) != null) {
            try {
                this.uuid = uuidAttribute.getValue();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if ((descriptionAttribute = element.getAttribute(DESCRIPTION_ATTRIBUTE_NAME)) != null) {
            this.description = descriptionAttribute.getValue();
        }
        if ((suppressIdAttribute = element.getAttribute(SUPPRESS_ID_ATTRIBUTE_NAME)) != null) {
            this.suppressId = suppressIdAttribute.getValue();
        }
        if ((problemDescriptorAttribute = element.getAttribute(PROBLEM_DESCRIPTOR_ATTRIBUTE_NAME)) != null) {
            this.problemDescriptor = problemDescriptorAttribute.getValue();
        }
        if ((attribute = element.getAttribute(CLEANUP_ATTRIBUTE_NAME)) != null) {
            try {
                this.cleanup = attribute.getBooleanValue();
            }
            catch (DataConversionException e) {
                this.cleanup = false;
            }
        }
        if ((mainAttribute = element.getAttribute(ORDER_ATTRIBUTE_NAME)) != null) {
            try {
                this.order = Math.max(0, mainAttribute.getIntValue());
            }
            catch (DataConversionException dataConversionException) {
                // empty catch block
            }
        }
    }

    public void writeExternal(Element element) {
        element.setAttribute(NAME_ATTRIBUTE_NAME, this.name);
        if (this.created > 0L) {
            element.setAttribute(CREATED_ATTRIBUTE_NAME, String.valueOf(this.created));
        }
        if (this.uuid != null && !this.uuid.equals(UUID.nameUUIDFromBytes(this.name.getBytes(StandardCharsets.UTF_8)).toString())) {
            element.setAttribute(UUID_ATTRIBUTE_NAME, this.uuid);
        }
        if (!StringUtil.isEmpty((String)this.description)) {
            element.setAttribute(DESCRIPTION_ATTRIBUTE_NAME, this.description);
        }
        if (!StringUtil.isEmpty((String)this.suppressId)) {
            element.setAttribute(SUPPRESS_ID_ATTRIBUTE_NAME, this.suppressId);
        }
        if (!StringUtil.isEmpty((String)this.problemDescriptor)) {
            element.setAttribute(PROBLEM_DESCRIPTOR_ATTRIBUTE_NAME, this.problemDescriptor);
        }
        if (this.cleanup) {
            element.setAttribute(CLEANUP_ATTRIBUTE_NAME, String.valueOf(this.cleanup));
        }
        if (this.order != 0) {
            element.setAttribute(ORDER_ATTRIBUTE_NAME, String.valueOf(this.order));
        }
    }

    public boolean isPredefined() {
        return this.predefined;
    }

    public void setPredefined(boolean predefined) {
        this.predefined = predefined;
    }

    @NotNull
    public abstract MatchOptions getMatchOptions();

    @NotNull
    public abstract ReplaceOptions getReplaceOptions();

    public abstract NamedScriptableDefinition findVariable(@NotNull String var1);

    public abstract void removeUnusedVariables();

    public boolean equals(Object configuration) {
        if (!(configuration instanceof Configuration)) {
            return false;
        }
        Configuration other = (Configuration)configuration;
        return Objects.equals(this.category, other.category) && this.name.equals(other.name);
    }

    public int hashCode() {
        return 31 * this.name.hashCode() + (this.category != null ? this.category.hashCode() : 0);
    }

    @NotNull
    public Icon getIcon() {
        LanguageFileType type = this.getFileType();
        Icon icon = type == null || type.getIcon() == null ? AllIcons.FileTypes.Unknown : type.getIcon();
        if (icon == null) {
            Configuration.$$$reportNull$$$0(9);
        }
        return icon;
    }

    @Nullable
    public LanguageFileType getFileType() {
        return this.getMatchOptions().getFileType();
    }

    @NotNull
    @NonNls
    public String getRefName() {
        String string = this.refName == null || !this.predefined ? this.name : this.refName;
        if (string == null) {
            Configuration.$$$reportNull$$$0(10);
        }
        return string;
    }

    public void setRefName(String refName) {
        if (this.predefined) {
            this.refName = refName;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 6, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = NAME_ATTRIBUTE_NAME;
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/Configuration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/Configuration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCategory";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUuid";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setCategory";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 6, 8, 9, 10 -> new IllegalStateException(string);
        };
    }
}

