import { isAsyncAPIDocument, isOldAsyncAPIDocument, toAsyncAPIDocument, unstringify, } from '@asyncapi/parser';
import { isStringifiedDocument } from '@asyncapi/parser/cjs/document';
var SpecificationHelpers = (function () {
    function SpecificationHelpers() {
    }
    SpecificationHelpers.retrieveParsedSpec = function (schema) {
        if (!schema) {
            return undefined;
        }
        if (isAsyncAPIDocument(schema)) {
            return schema;
        }
        if (isOldAsyncAPIDocument(schema)) {
            var parsedJSON = schema.json();
            return toAsyncAPIDocument(parsedJSON);
        }
        if (typeof schema === 'string') {
            try {
                schema = JSON.parse(schema);
            }
            catch (e) {
                return undefined;
            }
        }
        if (isStringifiedDocument(schema)) {
            return unstringify(schema);
        }
        return toAsyncAPIDocument(schema);
    };
    SpecificationHelpers.containTags = function (schema, tags) {
        var tagsToCheck = typeof schema.tags === 'function' ? schema.tags() : undefined;
        if (tagsToCheck === undefined || !Array.isArray(tagsToCheck)) {
            return false;
        }
        var tagsArr = Array.isArray(tags) ? tags : [tags];
        return tagsToCheck.some(function (tag) {
            return tagsArr.some(function (t) { return t.name() === tag.name(); });
        });
    };
    SpecificationHelpers.operationsTags = function (spec) {
        var tags = new Map();
        Object.entries(spec.operations().all()).forEach(function (_a) {
            var operation = _a[1];
            if ((operation === null || operation === void 0 ? void 0 : operation.tags().length) > 0) {
                operation
                    .tags()
                    .all()
                    .forEach(function (tag) { return tags.set(tag.name(), tag); });
            }
        });
        return Array.from(tags.values());
    };
    SpecificationHelpers.serversTags = function (spec) {
        var tags = {};
        Object.entries(spec.servers()).forEach(function (_a) {
            var _ = _a[0], server = _a[1];
            if (server.tags().length > 0) {
                server
                    .tags()
                    .all()
                    .forEach(function (tag) {
                    if (tags[tag.name()]) {
                        tags[tag.name()].push(_);
                    }
                    else {
                        tags[tag.name()] = [_];
                    }
                });
            }
        });
        return tags;
    };
    return SpecificationHelpers;
}());
export { SpecificationHelpers };
//# sourceMappingURL=specification.js.map