#!/bin/sh

# Variables - do not modify them
CHF="compiled_rules.h"

# Checking the location.
ls -la register_rule.sh > /dev/null 2>&1
if [ ! $? = 0 ]; then
    LOCALDIR=`dirname $0`;
    cd ${LOCALDIR}

    ls -la register_rule.sh > /dev/null 2>&1
    if [ ! $? = 0 ]; then
        echo "ERROR: You must run this script from the same directory."
        exit 1;
    fi
fi

# Arguments
if [ "x$1" = "x" -o "x$1" = "xhelp" -o "x$1" = "x-h" ]; then
    echo "$0 add <function_name>"
    echo "$0 list"
    echo "$0 build"
    echo "$0 save"
    echo "$0 restore"
    exit 0;
fi

if [ "x$1" = "xlist" ]; then
    echo "*Available functions: "
    cat .function_list | sort | uniq;
    exit 0;

elif [ "x$1" = "xsave" ]; then
    ls -la /etc/ossec-init.conf > /dev/null 2>&1
    if [ ! $? = 0 ]; then
        echo "ERROR: Unable to save rules. You must have OSSEC installed to do so."
        exit 1;
    fi

    cat /etc/ossec-init.conf > /dev/null 2>&1
    if [ ! $? = 0 ]; then
        echo "ERROR: Unable to save rules. You must be root to do so."
        exit 1;
    fi

    . /etc/ossec-init.conf

    ls ${DIRECTORY}/compiled_rules > /dev/null 2>&1
    if [ ! $? = 0 ]; then
        mkdir ${DIRECTORY}/compiled_rules > /dev/null 2>&1
        if [ ! $? = 0 ]; then
            echo "ERROR: Unable to save rules. You must be root to do so."
            exit 1;
        fi
    fi

    cp .function_list ${DIRECTORY}/compiled_rules/function_list > /dev/null 2>&1
    if [ ! $? = 0 ]; then
        echo "ERROR: Unable to save rules. You must be root to do so."
        exit 1;
    fi

    for i in `ls *.c`; do
        if [ ! "x$i" = "xgeneric_samples.c" ]; then
            cp $i ${DIRECTORY}/compiled_rules/ > /dev/null 2>&1
        fi
    done
    echo "*Save completed at ${DIRECTORY}/compiled_rules/";
    exit 0;

elif [ "x$1" = "xrestore" ]; then

    ls -la /etc/ossec-init.conf > /dev/null 2>&1
    if [ ! $? = 0 ]; then
        echo "ERROR: Unable to restore rules. You must have OSSEC installed to do so."
        exit 1;
    fi

    cat /etc/ossec-init.conf > /dev/null 2>&1
    if [ ! $? = 0 ]; then
        echo "ERROR: Unable to restore rules. You must be root to do so."
        exit 1;
    fi

    . /etc/ossec-init.conf

    ls ${DIRECTORY}/compiled_rules/function_list > /dev/null 2>&1
    if [ ! $? = 0 ]; then
        echo "*No local compiled rules available to restore."
        exit 0;
    fi

    cat  ${DIRECTORY}/compiled_rules/function_list >> .function_list
    if [ ! $? = 0 ]; then
        echo "ERROR: Unable to restore rules. Function list not present."
        exit 1;
    fi

    for i in `ls ${DIRECTORY}/compiled_rules/*.c`; do
        if [ ! "x$i" = "xgeneric_samples.c" ]; then
            cp $i ./ > /dev/null 2>&1
        fi
    done
    echo "*Restore completed from ${DIRECTORY}/compiled_rules/";
    exit 0;

elif [ "x$1" = "xbuild" ]; then
    ls -la .function_list > /dev/null 2>&1
    if [ ! $? = 0 ]; then
        echo "ERROR: Unable to build. No function is registered."
        exit 1;
    fi

    # Auto generating the file.
    echo "/* This file is auto generated by $0. Do not touch it. */" > ${CHF}
    echo "" >> ${CHF};

    echo "/* Adding the function definitions. */" >> ${CHF};
    for i in `cat .function_list | sort| uniq`; do
        echo "void *$i(Eventinfo *lf);" >> ${CHF};
    done
    echo "" >> ${CHF};

    echo "/* Adding the rules list. */" >> ${CHF};
    echo "void *(compiled_rules_list[]) = " >> ${CHF};
    echo "{" >> ${CHF};
    for i in `cat .function_list | sort| uniq`; do
        echo "    $i," >> ${CHF};
    done
    echo "    NULL" >> ${CHF};
    echo "};" >> ${CHF};
    echo "" >> ${CHF};

    echo "/* Adding the rules list names. */" >> ${CHF};
    echo "const char *(compiled_rules_name[]) = " >> ${CHF};
    echo "{" >> ${CHF};
    for i in `cat .function_list |sort | uniq`; do
        echo "    \"$i\"," >> ${CHF};
    done
    echo "    NULL" >> ${CHF};
    echo "};" >> ${CHF};
    echo "" >> ${CHF};
    echo "/* EOF */" >> ${CHF};

    echo "*Build completed."

elif [ "x$1" = "xadd" ]; then
    if [ "x$2" = "x" ]; then
        echo "ERROR: Missing function name.";
        echo "ex: $0 add <function_name>";
        exit 1;
    fi

    grep $2 ./*.c > /dev/null 2>&1
    if [ ! $? = 0 ]; then
        echo "ERROR: Function '$2' not found.";
        exit 1;
    fi

    grep $2 .function_list > /dev/null 2>&1
    if [ $? = 0 ]; then
        echo "ERROR: Function '$2' already added.";
        exit 1;
    fi

    echo $2 >> .function_list;
    echo "*Function $2 added."

else
    echo "ERROR: Invalid argument.";
    exit 1;

fi

