// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/automl/v1beta1/service.proto

package automl // import "google.golang.org/genproto/googleapis/cloud/automl/v1beta1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import longrunning "google.golang.org/genproto/googleapis/longrunning"
import _ "google.golang.org/genproto/protobuf/field_mask"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Request message for [AutoMl.CreateDataset][google.cloud.automl.v1beta1.AutoMl.CreateDataset].
type CreateDatasetRequest struct {
	// The resource name of the project to create the dataset for.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The dataset to create.
	Dataset              *Dataset `protobuf:"bytes,2,opt,name=dataset,proto3" json:"dataset,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateDatasetRequest) Reset()         { *m = CreateDatasetRequest{} }
func (m *CreateDatasetRequest) String() string { return proto.CompactTextString(m) }
func (*CreateDatasetRequest) ProtoMessage()    {}
func (*CreateDatasetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_service_13046020da32bacb, []int{0}
}
func (m *CreateDatasetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateDatasetRequest.Unmarshal(m, b)
}
func (m *CreateDatasetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateDatasetRequest.Marshal(b, m, deterministic)
}
func (dst *CreateDatasetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateDatasetRequest.Merge(dst, src)
}
func (m *CreateDatasetRequest) XXX_Size() int {
	return xxx_messageInfo_CreateDatasetRequest.Size(m)
}
func (m *CreateDatasetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateDatasetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateDatasetRequest proto.InternalMessageInfo

func (m *CreateDatasetRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateDatasetRequest) GetDataset() *Dataset {
	if m != nil {
		return m.Dataset
	}
	return nil
}

// Request message for [AutoMl.GetDataset][google.cloud.automl.v1beta1.AutoMl.GetDataset].
type GetDatasetRequest struct {
	// The resource name of the dataset to retrieve.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetDatasetRequest) Reset()         { *m = GetDatasetRequest{} }
func (m *GetDatasetRequest) String() string { return proto.CompactTextString(m) }
func (*GetDatasetRequest) ProtoMessage()    {}
func (*GetDatasetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_service_13046020da32bacb, []int{1}
}
func (m *GetDatasetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetDatasetRequest.Unmarshal(m, b)
}
func (m *GetDatasetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetDatasetRequest.Marshal(b, m, deterministic)
}
func (dst *GetDatasetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDatasetRequest.Merge(dst, src)
}
func (m *GetDatasetRequest) XXX_Size() int {
	return xxx_messageInfo_GetDatasetRequest.Size(m)
}
func (m *GetDatasetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDatasetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetDatasetRequest proto.InternalMessageInfo

func (m *GetDatasetRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for [AutoMl.ListDatasets][google.cloud.automl.v1beta1.AutoMl.ListDatasets].
type ListDatasetsRequest struct {
	// The resource name of the project from which to list datasets.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// An expression for filtering the results of the request.
	//
	//   * `dataset_metadata` - for existence of the case.
	//
	// An example of using the filter is:
	//
	//   * `translation_dataset_metadata:*` --> The dataset has
	//                                          translation_dataset_metadata.
	Filter string `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
	// Requested page size. Server may return fewer results than requested.
	// If unspecified, server will pick a default size.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results for the server to return
	// Typically obtained via
	// [ListDatasetsResponse.next_page_token][google.cloud.automl.v1beta1.ListDatasetsResponse.next_page_token] of the previous
	// [AutoMl.ListDatasets][google.cloud.automl.v1beta1.AutoMl.ListDatasets] call.
	PageToken            string   `protobuf:"bytes,6,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListDatasetsRequest) Reset()         { *m = ListDatasetsRequest{} }
func (m *ListDatasetsRequest) String() string { return proto.CompactTextString(m) }
func (*ListDatasetsRequest) ProtoMessage()    {}
func (*ListDatasetsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_service_13046020da32bacb, []int{2}
}
func (m *ListDatasetsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDatasetsRequest.Unmarshal(m, b)
}
func (m *ListDatasetsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDatasetsRequest.Marshal(b, m, deterministic)
}
func (dst *ListDatasetsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDatasetsRequest.Merge(dst, src)
}
func (m *ListDatasetsRequest) XXX_Size() int {
	return xxx_messageInfo_ListDatasetsRequest.Size(m)
}
func (m *ListDatasetsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDatasetsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListDatasetsRequest proto.InternalMessageInfo

func (m *ListDatasetsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListDatasetsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListDatasetsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListDatasetsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response message for [AutoMl.ListDatasets][google.cloud.automl.v1beta1.AutoMl.ListDatasets].
type ListDatasetsResponse struct {
	// The datasets read.
	Datasets []*Dataset `protobuf:"bytes,1,rep,name=datasets,proto3" json:"datasets,omitempty"`
	// A token to retrieve next page of results.
	// Pass to [ListDatasetsRequest.page_token][google.cloud.automl.v1beta1.ListDatasetsRequest.page_token] to obtain that page.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListDatasetsResponse) Reset()         { *m = ListDatasetsResponse{} }
func (m *ListDatasetsResponse) String() string { return proto.CompactTextString(m) }
func (*ListDatasetsResponse) ProtoMessage()    {}
func (*ListDatasetsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_service_13046020da32bacb, []int{3}
}
func (m *ListDatasetsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDatasetsResponse.Unmarshal(m, b)
}
func (m *ListDatasetsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDatasetsResponse.Marshal(b, m, deterministic)
}
func (dst *ListDatasetsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDatasetsResponse.Merge(dst, src)
}
func (m *ListDatasetsResponse) XXX_Size() int {
	return xxx_messageInfo_ListDatasetsResponse.Size(m)
}
func (m *ListDatasetsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDatasetsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListDatasetsResponse proto.InternalMessageInfo

func (m *ListDatasetsResponse) GetDatasets() []*Dataset {
	if m != nil {
		return m.Datasets
	}
	return nil
}

func (m *ListDatasetsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for [AutoMl.DeleteDataset][google.cloud.automl.v1beta1.AutoMl.DeleteDataset].
type DeleteDatasetRequest struct {
	// The resource name of the dataset to delete.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteDatasetRequest) Reset()         { *m = DeleteDatasetRequest{} }
func (m *DeleteDatasetRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteDatasetRequest) ProtoMessage()    {}
func (*DeleteDatasetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_service_13046020da32bacb, []int{4}
}
func (m *DeleteDatasetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteDatasetRequest.Unmarshal(m, b)
}
func (m *DeleteDatasetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteDatasetRequest.Marshal(b, m, deterministic)
}
func (dst *DeleteDatasetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteDatasetRequest.Merge(dst, src)
}
func (m *DeleteDatasetRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteDatasetRequest.Size(m)
}
func (m *DeleteDatasetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteDatasetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteDatasetRequest proto.InternalMessageInfo

func (m *DeleteDatasetRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for [AutoMl.ImportData][google.cloud.automl.v1beta1.AutoMl.ImportData].
type ImportDataRequest struct {
	// Required. Dataset name. Dataset must already exist. All imported
	// annotations and examples will be added.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The desired input location.
	InputConfig          *InputConfig `protobuf:"bytes,3,opt,name=input_config,json=inputConfig,proto3" json:"input_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *ImportDataRequest) Reset()         { *m = ImportDataRequest{} }
func (m *ImportDataRequest) String() string { return proto.CompactTextString(m) }
func (*ImportDataRequest) ProtoMessage()    {}
func (*ImportDataRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_service_13046020da32bacb, []int{5}
}
func (m *ImportDataRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImportDataRequest.Unmarshal(m, b)
}
func (m *ImportDataRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImportDataRequest.Marshal(b, m, deterministic)
}
func (dst *ImportDataRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImportDataRequest.Merge(dst, src)
}
func (m *ImportDataRequest) XXX_Size() int {
	return xxx_messageInfo_ImportDataRequest.Size(m)
}
func (m *ImportDataRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ImportDataRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ImportDataRequest proto.InternalMessageInfo

func (m *ImportDataRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ImportDataRequest) GetInputConfig() *InputConfig {
	if m != nil {
		return m.InputConfig
	}
	return nil
}

// Request message for [AutoMl.ExportData][google.cloud.automl.v1beta1.AutoMl.ExportData].
type ExportDataRequest struct {
	// Required. The resource name of the dataset.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The desired output location.
	OutputConfig         *OutputConfig `protobuf:"bytes,3,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *ExportDataRequest) Reset()         { *m = ExportDataRequest{} }
func (m *ExportDataRequest) String() string { return proto.CompactTextString(m) }
func (*ExportDataRequest) ProtoMessage()    {}
func (*ExportDataRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_service_13046020da32bacb, []int{6}
}
func (m *ExportDataRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExportDataRequest.Unmarshal(m, b)
}
func (m *ExportDataRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExportDataRequest.Marshal(b, m, deterministic)
}
func (dst *ExportDataRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExportDataRequest.Merge(dst, src)
}
func (m *ExportDataRequest) XXX_Size() int {
	return xxx_messageInfo_ExportDataRequest.Size(m)
}
func (m *ExportDataRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ExportDataRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ExportDataRequest proto.InternalMessageInfo

func (m *ExportDataRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ExportDataRequest) GetOutputConfig() *OutputConfig {
	if m != nil {
		return m.OutputConfig
	}
	return nil
}

// Request message for [AutoMl.CreateModel][google.cloud.automl.v1beta1.AutoMl.CreateModel].
type CreateModelRequest struct {
	// Resource name of the parent project where the model is being created.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The model to create.
	Model                *Model   `protobuf:"bytes,4,opt,name=model,proto3" json:"model,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateModelRequest) Reset()         { *m = CreateModelRequest{} }
func (m *CreateModelRequest) String() string { return proto.CompactTextString(m) }
func (*CreateModelRequest) ProtoMessage()    {}
func (*CreateModelRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_service_13046020da32bacb, []int{7}
}
func (m *CreateModelRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateModelRequest.Unmarshal(m, b)
}
func (m *CreateModelRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateModelRequest.Marshal(b, m, deterministic)
}
func (dst *CreateModelRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateModelRequest.Merge(dst, src)
}
func (m *CreateModelRequest) XXX_Size() int {
	return xxx_messageInfo_CreateModelRequest.Size(m)
}
func (m *CreateModelRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateModelRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateModelRequest proto.InternalMessageInfo

func (m *CreateModelRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateModelRequest) GetModel() *Model {
	if m != nil {
		return m.Model
	}
	return nil
}

// Request message for [AutoMl.GetModel][google.cloud.automl.v1beta1.AutoMl.GetModel].
type GetModelRequest struct {
	// Resource name of the model.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetModelRequest) Reset()         { *m = GetModelRequest{} }
func (m *GetModelRequest) String() string { return proto.CompactTextString(m) }
func (*GetModelRequest) ProtoMessage()    {}
func (*GetModelRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_service_13046020da32bacb, []int{8}
}
func (m *GetModelRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetModelRequest.Unmarshal(m, b)
}
func (m *GetModelRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetModelRequest.Marshal(b, m, deterministic)
}
func (dst *GetModelRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetModelRequest.Merge(dst, src)
}
func (m *GetModelRequest) XXX_Size() int {
	return xxx_messageInfo_GetModelRequest.Size(m)
}
func (m *GetModelRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetModelRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetModelRequest proto.InternalMessageInfo

func (m *GetModelRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for [AutoMl.ListModels][google.cloud.automl.v1beta1.AutoMl.ListModels].
type ListModelsRequest struct {
	// Resource name of the project, from which to list the models.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// An expression for filtering the results of the request.
	//
	//   * `model_metadata` - for existence of the case.
	//   * `dataset_id` - for = or !=.
	//
	// Some examples of using the filter are:
	//
	//   * `image_classification_model_metadata:*` --> The model has
	//                                        image_classification_model_metadata.
	//   * `dataset_id=5` --> The model was created from a sibling dataset with
	//                    ID 5.
	Filter string `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
	// Requested page size.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results for the server to return
	// Typically obtained via
	// [ListModelsResponse.next_page_token][google.cloud.automl.v1beta1.ListModelsResponse.next_page_token] of the previous
	// [AutoMl.ListModels][google.cloud.automl.v1beta1.AutoMl.ListModels] call.
	PageToken            string   `protobuf:"bytes,6,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListModelsRequest) Reset()         { *m = ListModelsRequest{} }
func (m *ListModelsRequest) String() string { return proto.CompactTextString(m) }
func (*ListModelsRequest) ProtoMessage()    {}
func (*ListModelsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_service_13046020da32bacb, []int{9}
}
func (m *ListModelsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListModelsRequest.Unmarshal(m, b)
}
func (m *ListModelsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListModelsRequest.Marshal(b, m, deterministic)
}
func (dst *ListModelsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListModelsRequest.Merge(dst, src)
}
func (m *ListModelsRequest) XXX_Size() int {
	return xxx_messageInfo_ListModelsRequest.Size(m)
}
func (m *ListModelsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListModelsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListModelsRequest proto.InternalMessageInfo

func (m *ListModelsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListModelsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListModelsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListModelsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response message for [AutoMl.ListModels][google.cloud.automl.v1beta1.AutoMl.ListModels].
type ListModelsResponse struct {
	// List of models in the requested page.
	Model []*Model `protobuf:"bytes,1,rep,name=model,proto3" json:"model,omitempty"`
	// A token to retrieve next page of results.
	// Pass to [ListModels.page_token][] to obtain that page.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListModelsResponse) Reset()         { *m = ListModelsResponse{} }
func (m *ListModelsResponse) String() string { return proto.CompactTextString(m) }
func (*ListModelsResponse) ProtoMessage()    {}
func (*ListModelsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_service_13046020da32bacb, []int{10}
}
func (m *ListModelsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListModelsResponse.Unmarshal(m, b)
}
func (m *ListModelsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListModelsResponse.Marshal(b, m, deterministic)
}
func (dst *ListModelsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListModelsResponse.Merge(dst, src)
}
func (m *ListModelsResponse) XXX_Size() int {
	return xxx_messageInfo_ListModelsResponse.Size(m)
}
func (m *ListModelsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListModelsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListModelsResponse proto.InternalMessageInfo

func (m *ListModelsResponse) GetModel() []*Model {
	if m != nil {
		return m.Model
	}
	return nil
}

func (m *ListModelsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for [AutoMl.DeleteModel][google.cloud.automl.v1beta1.AutoMl.DeleteModel].
type DeleteModelRequest struct {
	// Resource name of the model being deleted.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteModelRequest) Reset()         { *m = DeleteModelRequest{} }
func (m *DeleteModelRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteModelRequest) ProtoMessage()    {}
func (*DeleteModelRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_service_13046020da32bacb, []int{11}
}
func (m *DeleteModelRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteModelRequest.Unmarshal(m, b)
}
func (m *DeleteModelRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteModelRequest.Marshal(b, m, deterministic)
}
func (dst *DeleteModelRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteModelRequest.Merge(dst, src)
}
func (m *DeleteModelRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteModelRequest.Size(m)
}
func (m *DeleteModelRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteModelRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteModelRequest proto.InternalMessageInfo

func (m *DeleteModelRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for [AutoMl.DeployModel][google.cloud.automl.v1beta1.AutoMl.DeployModel].
type DeployModelRequest struct {
	// Resource name of the model to deploy.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeployModelRequest) Reset()         { *m = DeployModelRequest{} }
func (m *DeployModelRequest) String() string { return proto.CompactTextString(m) }
func (*DeployModelRequest) ProtoMessage()    {}
func (*DeployModelRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_service_13046020da32bacb, []int{12}
}
func (m *DeployModelRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeployModelRequest.Unmarshal(m, b)
}
func (m *DeployModelRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeployModelRequest.Marshal(b, m, deterministic)
}
func (dst *DeployModelRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeployModelRequest.Merge(dst, src)
}
func (m *DeployModelRequest) XXX_Size() int {
	return xxx_messageInfo_DeployModelRequest.Size(m)
}
func (m *DeployModelRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeployModelRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeployModelRequest proto.InternalMessageInfo

func (m *DeployModelRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for [AutoMl.UndeployModel][google.cloud.automl.v1beta1.AutoMl.UndeployModel].
type UndeployModelRequest struct {
	// Resource name of the model to undeploy.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UndeployModelRequest) Reset()         { *m = UndeployModelRequest{} }
func (m *UndeployModelRequest) String() string { return proto.CompactTextString(m) }
func (*UndeployModelRequest) ProtoMessage()    {}
func (*UndeployModelRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_service_13046020da32bacb, []int{13}
}
func (m *UndeployModelRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UndeployModelRequest.Unmarshal(m, b)
}
func (m *UndeployModelRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UndeployModelRequest.Marshal(b, m, deterministic)
}
func (dst *UndeployModelRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UndeployModelRequest.Merge(dst, src)
}
func (m *UndeployModelRequest) XXX_Size() int {
	return xxx_messageInfo_UndeployModelRequest.Size(m)
}
func (m *UndeployModelRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UndeployModelRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UndeployModelRequest proto.InternalMessageInfo

func (m *UndeployModelRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for [AutoMl.GetModelEvaluation][google.cloud.automl.v1beta1.AutoMl.GetModelEvaluation].
type GetModelEvaluationRequest struct {
	// Resource name for the model evaluation.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetModelEvaluationRequest) Reset()         { *m = GetModelEvaluationRequest{} }
func (m *GetModelEvaluationRequest) String() string { return proto.CompactTextString(m) }
func (*GetModelEvaluationRequest) ProtoMessage()    {}
func (*GetModelEvaluationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_service_13046020da32bacb, []int{14}
}
func (m *GetModelEvaluationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetModelEvaluationRequest.Unmarshal(m, b)
}
func (m *GetModelEvaluationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetModelEvaluationRequest.Marshal(b, m, deterministic)
}
func (dst *GetModelEvaluationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetModelEvaluationRequest.Merge(dst, src)
}
func (m *GetModelEvaluationRequest) XXX_Size() int {
	return xxx_messageInfo_GetModelEvaluationRequest.Size(m)
}
func (m *GetModelEvaluationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetModelEvaluationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetModelEvaluationRequest proto.InternalMessageInfo

func (m *GetModelEvaluationRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for [AutoMl.ListModelEvaluations][google.cloud.automl.v1beta1.AutoMl.ListModelEvaluations].
type ListModelEvaluationsRequest struct {
	// Resource name of the model to list the model evaluations for.
	// If modelId is set as "-", this will list model evaluations from across all
	// models of the parent location.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// An expression for filtering the results of the request.
	//
	//   * `annotation_spec_id` - for =, !=  or existence. See example below for
	//                          the last.
	//
	// Some examples of using the filter are:
	//
	//   * `annotation_spec_id!=4` --> The model evaluation was done for
	//                             annotation spec with ID different than 4.
	//   * `NOT annotation_spec_id:*` --> The model evaluation was done for
	//                                aggregate of all annotation specs.
	Filter string `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
	// Requested page size.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results for the server to return.
	// Typically obtained via
	// `ListModelEvaluationsResponse.next_page_token` of the previous
	// [AutoMl.ListModelEvaluations][google.cloud.automl.v1beta1.AutoMl.ListModelEvaluations] call.
	PageToken            string   `protobuf:"bytes,6,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListModelEvaluationsRequest) Reset()         { *m = ListModelEvaluationsRequest{} }
func (m *ListModelEvaluationsRequest) String() string { return proto.CompactTextString(m) }
func (*ListModelEvaluationsRequest) ProtoMessage()    {}
func (*ListModelEvaluationsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_service_13046020da32bacb, []int{15}
}
func (m *ListModelEvaluationsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListModelEvaluationsRequest.Unmarshal(m, b)
}
func (m *ListModelEvaluationsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListModelEvaluationsRequest.Marshal(b, m, deterministic)
}
func (dst *ListModelEvaluationsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListModelEvaluationsRequest.Merge(dst, src)
}
func (m *ListModelEvaluationsRequest) XXX_Size() int {
	return xxx_messageInfo_ListModelEvaluationsRequest.Size(m)
}
func (m *ListModelEvaluationsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListModelEvaluationsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListModelEvaluationsRequest proto.InternalMessageInfo

func (m *ListModelEvaluationsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListModelEvaluationsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListModelEvaluationsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListModelEvaluationsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response message for [AutoMl.ListModelEvaluations][google.cloud.automl.v1beta1.AutoMl.ListModelEvaluations].
type ListModelEvaluationsResponse struct {
	// List of model evaluations in the requested page.
	ModelEvaluation []*ModelEvaluation `protobuf:"bytes,1,rep,name=model_evaluation,json=modelEvaluation,proto3" json:"model_evaluation,omitempty"`
	// A token to retrieve next page of results.
	// Pass to [ListModelEvaluations.page_token][] to obtain that page.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListModelEvaluationsResponse) Reset()         { *m = ListModelEvaluationsResponse{} }
func (m *ListModelEvaluationsResponse) String() string { return proto.CompactTextString(m) }
func (*ListModelEvaluationsResponse) ProtoMessage()    {}
func (*ListModelEvaluationsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_service_13046020da32bacb, []int{16}
}
func (m *ListModelEvaluationsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListModelEvaluationsResponse.Unmarshal(m, b)
}
func (m *ListModelEvaluationsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListModelEvaluationsResponse.Marshal(b, m, deterministic)
}
func (dst *ListModelEvaluationsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListModelEvaluationsResponse.Merge(dst, src)
}
func (m *ListModelEvaluationsResponse) XXX_Size() int {
	return xxx_messageInfo_ListModelEvaluationsResponse.Size(m)
}
func (m *ListModelEvaluationsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListModelEvaluationsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListModelEvaluationsResponse proto.InternalMessageInfo

func (m *ListModelEvaluationsResponse) GetModelEvaluation() []*ModelEvaluation {
	if m != nil {
		return m.ModelEvaluation
	}
	return nil
}

func (m *ListModelEvaluationsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func init() {
	proto.RegisterType((*CreateDatasetRequest)(nil), "google.cloud.automl.v1beta1.CreateDatasetRequest")
	proto.RegisterType((*GetDatasetRequest)(nil), "google.cloud.automl.v1beta1.GetDatasetRequest")
	proto.RegisterType((*ListDatasetsRequest)(nil), "google.cloud.automl.v1beta1.ListDatasetsRequest")
	proto.RegisterType((*ListDatasetsResponse)(nil), "google.cloud.automl.v1beta1.ListDatasetsResponse")
	proto.RegisterType((*DeleteDatasetRequest)(nil), "google.cloud.automl.v1beta1.DeleteDatasetRequest")
	proto.RegisterType((*ImportDataRequest)(nil), "google.cloud.automl.v1beta1.ImportDataRequest")
	proto.RegisterType((*ExportDataRequest)(nil), "google.cloud.automl.v1beta1.ExportDataRequest")
	proto.RegisterType((*CreateModelRequest)(nil), "google.cloud.automl.v1beta1.CreateModelRequest")
	proto.RegisterType((*GetModelRequest)(nil), "google.cloud.automl.v1beta1.GetModelRequest")
	proto.RegisterType((*ListModelsRequest)(nil), "google.cloud.automl.v1beta1.ListModelsRequest")
	proto.RegisterType((*ListModelsResponse)(nil), "google.cloud.automl.v1beta1.ListModelsResponse")
	proto.RegisterType((*DeleteModelRequest)(nil), "google.cloud.automl.v1beta1.DeleteModelRequest")
	proto.RegisterType((*DeployModelRequest)(nil), "google.cloud.automl.v1beta1.DeployModelRequest")
	proto.RegisterType((*UndeployModelRequest)(nil), "google.cloud.automl.v1beta1.UndeployModelRequest")
	proto.RegisterType((*GetModelEvaluationRequest)(nil), "google.cloud.automl.v1beta1.GetModelEvaluationRequest")
	proto.RegisterType((*ListModelEvaluationsRequest)(nil), "google.cloud.automl.v1beta1.ListModelEvaluationsRequest")
	proto.RegisterType((*ListModelEvaluationsResponse)(nil), "google.cloud.automl.v1beta1.ListModelEvaluationsResponse")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// AutoMlClient is the client API for AutoMl service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AutoMlClient interface {
	// Creates a dataset.
	CreateDataset(ctx context.Context, in *CreateDatasetRequest, opts ...grpc.CallOption) (*Dataset, error)
	// Gets a dataset.
	GetDataset(ctx context.Context, in *GetDatasetRequest, opts ...grpc.CallOption) (*Dataset, error)
	// Lists datasets in a project.
	ListDatasets(ctx context.Context, in *ListDatasetsRequest, opts ...grpc.CallOption) (*ListDatasetsResponse, error)
	// Deletes a dataset and all of its contents.
	// Returns empty response in the
	// [response][google.longrunning.Operation.response] field when it completes,
	// and `delete_details` in the
	// [metadata][google.longrunning.Operation.metadata] field.
	DeleteDataset(ctx context.Context, in *DeleteDatasetRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Imports data into a dataset.
	// Returns an empty response in the
	// [response][google.longrunning.Operation.response] field when it completes.
	ImportData(ctx context.Context, in *ImportDataRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Exports dataset's data to a Google Cloud Storage bucket.
	// Returns an empty response in the
	// [response][google.longrunning.Operation.response] field when it completes.
	ExportData(ctx context.Context, in *ExportDataRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Creates a model.
	// Returns a Model in the [response][google.longrunning.Operation.response]
	// field when it completes.
	// When you create a model, several model evaluations are created for it:
	// a global evaluation, and one evaluation for each annotation spec.
	CreateModel(ctx context.Context, in *CreateModelRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Gets a model.
	GetModel(ctx context.Context, in *GetModelRequest, opts ...grpc.CallOption) (*Model, error)
	// Lists models.
	ListModels(ctx context.Context, in *ListModelsRequest, opts ...grpc.CallOption) (*ListModelsResponse, error)
	// Deletes a model.
	// If a model is already deployed, this only deletes the model in AutoML BE,
	// and does not change the status of the deployed model in the production
	// environment.
	// Returns `google.protobuf.Empty` in the
	// [response][google.longrunning.Operation.response] field when it completes,
	// and `delete_details` in the
	// [metadata][google.longrunning.Operation.metadata] field.
	DeleteModel(ctx context.Context, in *DeleteModelRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deploys model.
	// Returns a [DeployModelResponse][] in the
	// [response][google.longrunning.Operation.response] field when it completes.
	DeployModel(ctx context.Context, in *DeployModelRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Undeploys model.
	// Returns an `UndeployModelResponse` in the
	// [response][google.longrunning.Operation.response] field when it completes.
	UndeployModel(ctx context.Context, in *UndeployModelRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Gets a model evaluation.
	GetModelEvaluation(ctx context.Context, in *GetModelEvaluationRequest, opts ...grpc.CallOption) (*ModelEvaluation, error)
	// Lists model evaluations.
	ListModelEvaluations(ctx context.Context, in *ListModelEvaluationsRequest, opts ...grpc.CallOption) (*ListModelEvaluationsResponse, error)
}

type autoMlClient struct {
	cc *grpc.ClientConn
}

func NewAutoMlClient(cc *grpc.ClientConn) AutoMlClient {
	return &autoMlClient{cc}
}

func (c *autoMlClient) CreateDataset(ctx context.Context, in *CreateDatasetRequest, opts ...grpc.CallOption) (*Dataset, error) {
	out := new(Dataset)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1beta1.AutoMl/CreateDataset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) GetDataset(ctx context.Context, in *GetDatasetRequest, opts ...grpc.CallOption) (*Dataset, error) {
	out := new(Dataset)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1beta1.AutoMl/GetDataset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) ListDatasets(ctx context.Context, in *ListDatasetsRequest, opts ...grpc.CallOption) (*ListDatasetsResponse, error) {
	out := new(ListDatasetsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1beta1.AutoMl/ListDatasets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) DeleteDataset(ctx context.Context, in *DeleteDatasetRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1beta1.AutoMl/DeleteDataset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) ImportData(ctx context.Context, in *ImportDataRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1beta1.AutoMl/ImportData", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) ExportData(ctx context.Context, in *ExportDataRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1beta1.AutoMl/ExportData", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) CreateModel(ctx context.Context, in *CreateModelRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1beta1.AutoMl/CreateModel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) GetModel(ctx context.Context, in *GetModelRequest, opts ...grpc.CallOption) (*Model, error) {
	out := new(Model)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1beta1.AutoMl/GetModel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) ListModels(ctx context.Context, in *ListModelsRequest, opts ...grpc.CallOption) (*ListModelsResponse, error) {
	out := new(ListModelsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1beta1.AutoMl/ListModels", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) DeleteModel(ctx context.Context, in *DeleteModelRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1beta1.AutoMl/DeleteModel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) DeployModel(ctx context.Context, in *DeployModelRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1beta1.AutoMl/DeployModel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) UndeployModel(ctx context.Context, in *UndeployModelRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1beta1.AutoMl/UndeployModel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) GetModelEvaluation(ctx context.Context, in *GetModelEvaluationRequest, opts ...grpc.CallOption) (*ModelEvaluation, error) {
	out := new(ModelEvaluation)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1beta1.AutoMl/GetModelEvaluation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoMlClient) ListModelEvaluations(ctx context.Context, in *ListModelEvaluationsRequest, opts ...grpc.CallOption) (*ListModelEvaluationsResponse, error) {
	out := new(ListModelEvaluationsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1beta1.AutoMl/ListModelEvaluations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AutoMlServer is the server API for AutoMl service.
type AutoMlServer interface {
	// Creates a dataset.
	CreateDataset(context.Context, *CreateDatasetRequest) (*Dataset, error)
	// Gets a dataset.
	GetDataset(context.Context, *GetDatasetRequest) (*Dataset, error)
	// Lists datasets in a project.
	ListDatasets(context.Context, *ListDatasetsRequest) (*ListDatasetsResponse, error)
	// Deletes a dataset and all of its contents.
	// Returns empty response in the
	// [response][google.longrunning.Operation.response] field when it completes,
	// and `delete_details` in the
	// [metadata][google.longrunning.Operation.metadata] field.
	DeleteDataset(context.Context, *DeleteDatasetRequest) (*longrunning.Operation, error)
	// Imports data into a dataset.
	// Returns an empty response in the
	// [response][google.longrunning.Operation.response] field when it completes.
	ImportData(context.Context, *ImportDataRequest) (*longrunning.Operation, error)
	// Exports dataset's data to a Google Cloud Storage bucket.
	// Returns an empty response in the
	// [response][google.longrunning.Operation.response] field when it completes.
	ExportData(context.Context, *ExportDataRequest) (*longrunning.Operation, error)
	// Creates a model.
	// Returns a Model in the [response][google.longrunning.Operation.response]
	// field when it completes.
	// When you create a model, several model evaluations are created for it:
	// a global evaluation, and one evaluation for each annotation spec.
	CreateModel(context.Context, *CreateModelRequest) (*longrunning.Operation, error)
	// Gets a model.
	GetModel(context.Context, *GetModelRequest) (*Model, error)
	// Lists models.
	ListModels(context.Context, *ListModelsRequest) (*ListModelsResponse, error)
	// Deletes a model.
	// If a model is already deployed, this only deletes the model in AutoML BE,
	// and does not change the status of the deployed model in the production
	// environment.
	// Returns `google.protobuf.Empty` in the
	// [response][google.longrunning.Operation.response] field when it completes,
	// and `delete_details` in the
	// [metadata][google.longrunning.Operation.metadata] field.
	DeleteModel(context.Context, *DeleteModelRequest) (*longrunning.Operation, error)
	// Deploys model.
	// Returns a [DeployModelResponse][] in the
	// [response][google.longrunning.Operation.response] field when it completes.
	DeployModel(context.Context, *DeployModelRequest) (*longrunning.Operation, error)
	// Undeploys model.
	// Returns an `UndeployModelResponse` in the
	// [response][google.longrunning.Operation.response] field when it completes.
	UndeployModel(context.Context, *UndeployModelRequest) (*longrunning.Operation, error)
	// Gets a model evaluation.
	GetModelEvaluation(context.Context, *GetModelEvaluationRequest) (*ModelEvaluation, error)
	// Lists model evaluations.
	ListModelEvaluations(context.Context, *ListModelEvaluationsRequest) (*ListModelEvaluationsResponse, error)
}

func RegisterAutoMlServer(s *grpc.Server, srv AutoMlServer) {
	s.RegisterService(&_AutoMl_serviceDesc, srv)
}

func _AutoMl_CreateDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).CreateDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1beta1.AutoMl/CreateDataset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).CreateDataset(ctx, req.(*CreateDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_GetDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).GetDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1beta1.AutoMl/GetDataset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).GetDataset(ctx, req.(*GetDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_ListDatasets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDatasetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).ListDatasets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1beta1.AutoMl/ListDatasets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).ListDatasets(ctx, req.(*ListDatasetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_DeleteDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).DeleteDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1beta1.AutoMl/DeleteDataset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).DeleteDataset(ctx, req.(*DeleteDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_ImportData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportDataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).ImportData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1beta1.AutoMl/ImportData",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).ImportData(ctx, req.(*ImportDataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_ExportData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportDataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).ExportData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1beta1.AutoMl/ExportData",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).ExportData(ctx, req.(*ExportDataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_CreateModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).CreateModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1beta1.AutoMl/CreateModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).CreateModel(ctx, req.(*CreateModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_GetModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).GetModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1beta1.AutoMl/GetModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).GetModel(ctx, req.(*GetModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_ListModels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListModelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).ListModels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1beta1.AutoMl/ListModels",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).ListModels(ctx, req.(*ListModelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_DeleteModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).DeleteModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1beta1.AutoMl/DeleteModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).DeleteModel(ctx, req.(*DeleteModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_DeployModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeployModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).DeployModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1beta1.AutoMl/DeployModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).DeployModel(ctx, req.(*DeployModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_UndeployModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UndeployModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).UndeployModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1beta1.AutoMl/UndeployModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).UndeployModel(ctx, req.(*UndeployModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_GetModelEvaluation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetModelEvaluationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).GetModelEvaluation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1beta1.AutoMl/GetModelEvaluation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).GetModelEvaluation(ctx, req.(*GetModelEvaluationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoMl_ListModelEvaluations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListModelEvaluationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoMlServer).ListModelEvaluations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1beta1.AutoMl/ListModelEvaluations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoMlServer).ListModelEvaluations(ctx, req.(*ListModelEvaluationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AutoMl_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.automl.v1beta1.AutoMl",
	HandlerType: (*AutoMlServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateDataset",
			Handler:    _AutoMl_CreateDataset_Handler,
		},
		{
			MethodName: "GetDataset",
			Handler:    _AutoMl_GetDataset_Handler,
		},
		{
			MethodName: "ListDatasets",
			Handler:    _AutoMl_ListDatasets_Handler,
		},
		{
			MethodName: "DeleteDataset",
			Handler:    _AutoMl_DeleteDataset_Handler,
		},
		{
			MethodName: "ImportData",
			Handler:    _AutoMl_ImportData_Handler,
		},
		{
			MethodName: "ExportData",
			Handler:    _AutoMl_ExportData_Handler,
		},
		{
			MethodName: "CreateModel",
			Handler:    _AutoMl_CreateModel_Handler,
		},
		{
			MethodName: "GetModel",
			Handler:    _AutoMl_GetModel_Handler,
		},
		{
			MethodName: "ListModels",
			Handler:    _AutoMl_ListModels_Handler,
		},
		{
			MethodName: "DeleteModel",
			Handler:    _AutoMl_DeleteModel_Handler,
		},
		{
			MethodName: "DeployModel",
			Handler:    _AutoMl_DeployModel_Handler,
		},
		{
			MethodName: "UndeployModel",
			Handler:    _AutoMl_UndeployModel_Handler,
		},
		{
			MethodName: "GetModelEvaluation",
			Handler:    _AutoMl_GetModelEvaluation_Handler,
		},
		{
			MethodName: "ListModelEvaluations",
			Handler:    _AutoMl_ListModelEvaluations_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/automl/v1beta1/service.proto",
}

func init() {
	proto.RegisterFile("google/cloud/automl/v1beta1/service.proto", fileDescriptor_service_13046020da32bacb)
}

var fileDescriptor_service_13046020da32bacb = []byte{
	// 1078 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x58, 0x4d, 0x8f, 0xdb, 0x44,
	0x18, 0xd6, 0x6c, 0xdb, 0xb0, 0x7d, 0xb3, 0xd1, 0xb2, 0xc3, 0xaa, 0x0a, 0xd9, 0x56, 0x44, 0xa6,
	0xd0, 0x34, 0x5a, 0xc5, 0x24, 0x45, 0x65, 0x9b, 0x7e, 0x88, 0xfd, 0xa8, 0x56, 0x05, 0x4a, 0x57,
	0x0b, 0x08, 0x89, 0x4b, 0xe4, 0x4d, 0x26, 0x96, 0xa9, 0x33, 0x63, 0xec, 0xf1, 0xb2, 0x2d, 0xaa,
	0xf8, 0xb8, 0x71, 0x46, 0x70, 0xa2, 0x82, 0x03, 0xea, 0x09, 0xf1, 0x33, 0xf8, 0x03, 0x1c, 0xb8,
	0x71, 0xe2, 0x87, 0x20, 0xcf, 0x8c, 0x63, 0x27, 0x36, 0x1e, 0xa7, 0x52, 0xb5, 0xb7, 0xcc, 0xf8,
	0x79, 0xfd, 0x3e, 0xf3, 0x7e, 0xcc, 0xf3, 0x3a, 0x70, 0xd5, 0x66, 0xcc, 0x76, 0x89, 0x39, 0x74,
	0x59, 0x38, 0x32, 0xad, 0x90, 0xb3, 0x89, 0x6b, 0x1e, 0x77, 0x8f, 0x08, 0xb7, 0xba, 0x66, 0x40,
	0xfc, 0x63, 0x67, 0x48, 0x3a, 0x9e, 0xcf, 0x38, 0xc3, 0x1b, 0x12, 0xda, 0x11, 0xd0, 0x8e, 0x84,
	0x76, 0x14, 0xb4, 0x71, 0x51, 0xbd, 0xc7, 0xf2, 0x1c, 0xd3, 0xa2, 0x94, 0x71, 0x8b, 0x3b, 0x8c,
	0x06, 0xd2, 0xb4, 0xf1, 0x76, 0x91, 0x97, 0x04, 0x3e, 0xf0, 0xac, 0x47, 0x2e, 0xb3, 0x46, 0xca,
	0xaa, 0x90, 0xdb, 0xc8, 0xe2, 0x56, 0x40, 0xb8, 0x82, 0x5e, 0x2e, 0x82, 0x3a, 0x4c, 0xa1, 0xae,
	0x14, 0xa1, 0x26, 0x6c, 0x44, 0x5c, 0x05, 0xec, 0x69, 0x81, 0x03, 0x72, 0x6c, 0xb9, 0xa1, 0x60,
	0xad, 0x6c, 0x36, 0x8b, 0x6c, 0x98, 0x47, 0xfc, 0x99, 0x88, 0xbc, 0xae, 0xd0, 0x2e, 0xa3, 0xb6,
	0x1f, 0x52, 0xea, 0x50, 0x3b, 0x0b, 0x6a, 0x2a, 0x90, 0x58, 0x1d, 0x85, 0x63, 0x73, 0xec, 0x10,
	0x77, 0x34, 0x98, 0x58, 0xc1, 0x43, 0x89, 0x30, 0x28, 0xac, 0xef, 0xfa, 0xc4, 0xe2, 0x64, 0x4f,
	0x86, 0xe3, 0x90, 0x7c, 0x11, 0x92, 0x80, 0xe3, 0x0b, 0x50, 0xf1, 0x2c, 0x9f, 0x50, 0x5e, 0x47,
	0x4d, 0xd4, 0x3a, 0x7f, 0xa8, 0x56, 0xf8, 0x0e, 0xbc, 0xa4, 0x02, 0x57, 0x5f, 0x6a, 0xa2, 0x56,
	0xb5, 0x77, 0xb9, 0x53, 0x90, 0xd5, 0x4e, 0xfc, 0xd6, 0xd8, 0xc8, 0xb8, 0x02, 0x6b, 0xfb, 0x84,
	0xcf, 0x39, 0xc3, 0x70, 0x96, 0x5a, 0x13, 0xa2, 0x5c, 0x89, 0xdf, 0xc6, 0xb7, 0x08, 0x5e, 0xf9,
	0xc0, 0x09, 0x62, 0x68, 0xa0, 0x23, 0x76, 0x01, 0x2a, 0x63, 0xc7, 0xe5, 0xc4, 0xaf, 0x9f, 0x91,
	0xfb, 0x72, 0x85, 0x37, 0xe0, 0xbc, 0x67, 0xd9, 0x64, 0x10, 0x38, 0x8f, 0x49, 0xfd, 0x6c, 0x13,
	0xb5, 0xce, 0x1d, 0x2e, 0x47, 0x1b, 0x1f, 0x39, 0x8f, 0x09, 0xbe, 0x04, 0x20, 0x1e, 0x72, 0xf6,
	0x90, 0xd0, 0x7a, 0x45, 0x18, 0x0a, 0xf8, 0xc7, 0xd1, 0x86, 0xf1, 0x0d, 0x82, 0xf5, 0x59, 0x0e,
	0x81, 0xc7, 0x68, 0x40, 0xf0, 0xbb, 0xb0, 0xac, 0x0e, 0x14, 0xd4, 0x51, 0xf3, 0x4c, 0xe9, 0x30,
	0x4c, 0xad, 0xf0, 0x9b, 0xb0, 0x4a, 0xc9, 0x09, 0x1f, 0xa4, 0xdc, 0x2f, 0x09, 0xf7, 0xb5, 0x68,
	0xfb, 0x60, 0x4a, 0xa1, 0x0d, 0xeb, 0x7b, 0xc4, 0x25, 0x99, 0xfc, 0xe4, 0x85, 0x8c, 0xc3, 0xda,
	0xbd, 0x89, 0xc7, 0x7c, 0xc1, 0xb7, 0x00, 0x88, 0xdf, 0x87, 0x15, 0x87, 0x7a, 0x21, 0x1f, 0x0c,
	0x19, 0x1d, 0x3b, 0xb6, 0x88, 0x58, 0xb5, 0xd7, 0x2a, 0x3c, 0xc2, 0xbd, 0xc8, 0x60, 0x57, 0xe0,
	0x0f, 0xab, 0x4e, 0xb2, 0x30, 0xbe, 0x84, 0xb5, 0xbb, 0x27, 0x65, 0xbc, 0x7e, 0x08, 0x35, 0x16,
	0xf2, 0x8c, 0xdb, 0xab, 0x85, 0x6e, 0x1f, 0x08, 0x0b, 0xe5, 0x77, 0x85, 0xa5, 0x56, 0xc6, 0x18,
	0xb0, 0x2c, 0xdd, 0xfb, 0x51, 0x3f, 0xe9, 0xea, 0x63, 0x0b, 0xce, 0x89, 0xbe, 0x13, 0x35, 0x50,
	0xed, 0x19, 0x85, 0x5e, 0xe5, 0x1b, 0xa5, 0x81, 0xf1, 0x06, 0xac, 0xee, 0x13, 0x3e, 0xe3, 0x24,
	0x2f, 0xfa, 0x5f, 0xc3, 0x5a, 0x54, 0x2b, 0x02, 0x77, 0x2a, 0xd5, 0x7a, 0x0c, 0x38, 0x4d, 0x40,
	0x95, 0xea, 0xf4, 0xdc, 0xb2, 0x4e, 0xcb, 0x9f, 0xbb, 0x74, 0x89, 0xb6, 0x00, 0xcb, 0x12, 0xd5,
	0x86, 0x48, 0x20, 0x3d, 0x97, 0x3d, 0xd2, 0x22, 0xdb, 0xb0, 0xfe, 0x09, 0x1d, 0x95, 0xc3, 0x9a,
	0xf0, 0x6a, 0x9c, 0x9f, 0xbb, 0xd3, 0x3b, 0xb5, 0xc8, 0xe0, 0x7b, 0x04, 0x1b, 0xd3, 0x48, 0x25,
	0x26, 0xa7, 0x92, 0xb4, 0x5f, 0x10, 0x5c, 0xcc, 0xe7, 0xa2, 0xf2, 0xf7, 0x29, 0xbc, 0x3c, 0xaf,
	0x17, 0x2a, 0x95, 0x9b, 0xfa, 0x54, 0xa6, 0xe2, 0xb1, 0x3a, 0x99, 0xdd, 0x28, 0x9b, 0xde, 0xde,
	0x3f, 0x18, 0x2a, 0xdb, 0x21, 0x67, 0xf7, 0x5d, 0xfc, 0x3b, 0x82, 0xda, 0x8c, 0x5a, 0xe0, 0x6e,
	0x21, 0x87, 0x3c, 0x65, 0x69, 0x94, 0xba, 0x29, 0x8d, 0x9d, 0xef, 0xfe, 0xfa, 0xf7, 0x87, 0xa5,
	0x5b, 0x46, 0x77, 0xaa, 0x80, 0x5f, 0xc9, 0x2c, 0xdc, 0xf6, 0x7c, 0xf6, 0x39, 0x19, 0xf2, 0xc0,
	0x6c, 0x9b, 0x2e, 0x1b, 0xca, 0x68, 0x99, 0xed, 0x27, 0xb1, 0x9e, 0x07, 0xfd, 0x58, 0x6b, 0xf0,
	0x53, 0x04, 0x90, 0x88, 0x0d, 0xee, 0x14, 0x3a, 0xce, 0xa8, 0x52, 0x49, 0xa2, 0x37, 0x04, 0xd1,
	0x6b, 0x38, 0x45, 0x34, 0x2a, 0xb2, 0xff, 0xa1, 0x39, 0x65, 0x69, 0xb6, 0x9f, 0xe0, 0x3f, 0x10,
	0xac, 0xa4, 0xe5, 0x05, 0xbf, 0x55, 0xe8, 0x31, 0x47, 0x0d, 0x1b, 0xdd, 0x05, 0x2c, 0x64, 0x41,
	0xe5, 0x11, 0x2e, 0x19, 0x59, 0xfc, 0x33, 0x82, 0xda, 0x8c, 0x1a, 0x69, 0xf2, 0x9f, 0xa7, 0x5c,
	0x8d, 0x4b, 0xb1, 0x49, 0x6a, 0x72, 0xe9, 0x3c, 0x88, 0x27, 0x97, 0x98, 0x5e, 0xfb, 0x39, 0xe2,
	0xf9, 0x1b, 0x02, 0x48, 0x04, 0x50, 0x93, 0xef, 0x8c, 0x52, 0xea, 0x88, 0xed, 0x0b, 0x62, 0xdb,
	0xc6, 0xad, 0x85, 0x89, 0xf5, 0x9d, 0xa9, 0xaf, 0x3e, 0x6a, 0x0b, 0x9a, 0x89, 0x62, 0x6a, 0x68,
	0x66, 0xa4, 0xf5, 0x05, 0xd2, 0x24, 0x27, 0x69, 0x9a, 0x4f, 0x11, 0x54, 0x53, 0xfa, 0x8a, 0xcd,
	0x12, 0xad, 0x9e, 0xbe, 0xab, 0x75, 0x44, 0xef, 0x08, 0xa2, 0x5b, 0x86, 0x59, 0xba, 0x0e, 0xc5,
	0x0d, 0x16, 0xf4, 0x95, 0x3c, 0xfd, 0x88, 0x60, 0x39, 0xbe, 0xf7, 0xf1, 0xa6, 0xae, 0xb7, 0x67,
	0x98, 0x95, 0x10, 0x41, 0xe3, 0x1d, 0x41, 0xaf, 0x8b, 0xcd, 0x72, 0x71, 0x94, 0xdc, 0xa2, 0x2a,
	0x7c, 0x86, 0x00, 0x12, 0x1d, 0xd6, 0xa4, 0x37, 0x33, 0x31, 0x34, 0xcc, 0xd2, 0x78, 0xd5, 0xcf,
	0x39, 0x44, 0x4b, 0xc5, 0x11, 0xff, 0x84, 0xa0, 0x9a, 0x12, 0x6e, 0x4d, 0x82, 0xb3, 0x12, 0xaf,
	0x4b, 0xb0, 0x22, 0xd6, 0x5e, 0x38, 0x82, 0xbf, 0x0a, 0x62, 0x53, 0xed, 0xd7, 0x12, 0x9b, 0x9f,
	0x12, 0x74, 0xc4, 0xb6, 0x05, 0xb1, 0x9b, 0xc6, 0xf5, 0x05, 0x89, 0xf5, 0xe5, 0x40, 0x12, 0x35,
	0xc7, 0x33, 0x04, 0xb5, 0x99, 0x01, 0x45, 0x73, 0x13, 0xe6, 0x0d, 0x33, 0x3a, 0x9a, 0xbb, 0x82,
	0xe6, 0x6d, 0x63, 0x6b, 0x51, 0x9a, 0x21, 0x4d, 0x88, 0xfe, 0x89, 0x00, 0x67, 0xa7, 0x23, 0x7c,
	0xbd, 0x54, 0xbf, 0x64, 0xc6, 0xa9, 0xc6, 0x42, 0x33, 0x87, 0xf1, 0x9e, 0x38, 0xc1, 0x1e, 0xde,
	0x59, 0xec, 0x04, 0xe6, 0xdc, 0xa8, 0x22, 0x8a, 0xe2, 0x6f, 0xf5, 0x2d, 0x36, 0x3f, 0x28, 0xe1,
	0xad, 0x72, 0x0d, 0x93, 0x9d, 0xf3, 0x1a, 0x37, 0x9e, 0xc3, 0x52, 0x35, 0x5d, 0xce, 0xc9, 0x0a,
	0x9b, 0x2e, 0xc9, 0x4e, 0xe6, 0x70, 0x3b, 0x01, 0xbc, 0x36, 0x64, 0x93, 0x22, 0x2e, 0x3b, 0x55,
	0x39, 0x80, 0x1d, 0x44, 0x9f, 0xec, 0x07, 0xe8, 0xb3, 0x6d, 0x85, 0xb5, 0x99, 0x6b, 0x51, 0xbb,
	0xc3, 0x7c, 0xdb, 0xb4, 0x09, 0x15, 0x1f, 0xf4, 0xa6, 0x7c, 0x64, 0x79, 0x4e, 0x90, 0xfb, 0x47,
	0xc2, 0x4d, 0xb9, 0x3c, 0xaa, 0x08, 0xf4, 0xb5, 0xff, 0x02, 0x00, 0x00, 0xff, 0xff, 0x61, 0x0b,
	0x95, 0xdd, 0xbf, 0x11, 0x00, 0x00,
}
