// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/bigtable/admin/table/v1/bigtable_table_service.proto

package table // import "google.golang.org/genproto/googleapis/bigtable/admin/table/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import empty "github.com/golang/protobuf/ptypes/empty"
import _ "google.golang.org/genproto/googleapis/api/annotations"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// BigtableTableServiceClient is the client API for BigtableTableService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BigtableTableServiceClient interface {
	// Creates a new table, to be served from a specified cluster.
	// The table can be created with a full set of initial column families,
	// specified in the request.
	CreateTable(ctx context.Context, in *CreateTableRequest, opts ...grpc.CallOption) (*Table, error)
	// Lists the names of all tables served from a specified cluster.
	ListTables(ctx context.Context, in *ListTablesRequest, opts ...grpc.CallOption) (*ListTablesResponse, error)
	// Gets the schema of the specified table, including its column families.
	GetTable(ctx context.Context, in *GetTableRequest, opts ...grpc.CallOption) (*Table, error)
	// Permanently deletes a specified table and all of its data.
	DeleteTable(ctx context.Context, in *DeleteTableRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Changes the name of a specified table.
	// Cannot be used to move tables between clusters, zones, or projects.
	RenameTable(ctx context.Context, in *RenameTableRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Creates a new column family within a specified table.
	CreateColumnFamily(ctx context.Context, in *CreateColumnFamilyRequest, opts ...grpc.CallOption) (*ColumnFamily, error)
	// Changes the configuration of a specified column family.
	UpdateColumnFamily(ctx context.Context, in *ColumnFamily, opts ...grpc.CallOption) (*ColumnFamily, error)
	// Permanently deletes a specified column family and all of its data.
	DeleteColumnFamily(ctx context.Context, in *DeleteColumnFamilyRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Delete all rows in a table corresponding to a particular prefix
	BulkDeleteRows(ctx context.Context, in *BulkDeleteRowsRequest, opts ...grpc.CallOption) (*empty.Empty, error)
}

type bigtableTableServiceClient struct {
	cc *grpc.ClientConn
}

func NewBigtableTableServiceClient(cc *grpc.ClientConn) BigtableTableServiceClient {
	return &bigtableTableServiceClient{cc}
}

func (c *bigtableTableServiceClient) CreateTable(ctx context.Context, in *CreateTableRequest, opts ...grpc.CallOption) (*Table, error) {
	out := new(Table)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.table.v1.BigtableTableService/CreateTable", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableServiceClient) ListTables(ctx context.Context, in *ListTablesRequest, opts ...grpc.CallOption) (*ListTablesResponse, error) {
	out := new(ListTablesResponse)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.table.v1.BigtableTableService/ListTables", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableServiceClient) GetTable(ctx context.Context, in *GetTableRequest, opts ...grpc.CallOption) (*Table, error) {
	out := new(Table)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.table.v1.BigtableTableService/GetTable", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableServiceClient) DeleteTable(ctx context.Context, in *DeleteTableRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.table.v1.BigtableTableService/DeleteTable", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableServiceClient) RenameTable(ctx context.Context, in *RenameTableRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.table.v1.BigtableTableService/RenameTable", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableServiceClient) CreateColumnFamily(ctx context.Context, in *CreateColumnFamilyRequest, opts ...grpc.CallOption) (*ColumnFamily, error) {
	out := new(ColumnFamily)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.table.v1.BigtableTableService/CreateColumnFamily", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableServiceClient) UpdateColumnFamily(ctx context.Context, in *ColumnFamily, opts ...grpc.CallOption) (*ColumnFamily, error) {
	out := new(ColumnFamily)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.table.v1.BigtableTableService/UpdateColumnFamily", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableServiceClient) DeleteColumnFamily(ctx context.Context, in *DeleteColumnFamilyRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.table.v1.BigtableTableService/DeleteColumnFamily", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableTableServiceClient) BulkDeleteRows(ctx context.Context, in *BulkDeleteRowsRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.table.v1.BigtableTableService/BulkDeleteRows", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BigtableTableServiceServer is the server API for BigtableTableService service.
type BigtableTableServiceServer interface {
	// Creates a new table, to be served from a specified cluster.
	// The table can be created with a full set of initial column families,
	// specified in the request.
	CreateTable(context.Context, *CreateTableRequest) (*Table, error)
	// Lists the names of all tables served from a specified cluster.
	ListTables(context.Context, *ListTablesRequest) (*ListTablesResponse, error)
	// Gets the schema of the specified table, including its column families.
	GetTable(context.Context, *GetTableRequest) (*Table, error)
	// Permanently deletes a specified table and all of its data.
	DeleteTable(context.Context, *DeleteTableRequest) (*empty.Empty, error)
	// Changes the name of a specified table.
	// Cannot be used to move tables between clusters, zones, or projects.
	RenameTable(context.Context, *RenameTableRequest) (*empty.Empty, error)
	// Creates a new column family within a specified table.
	CreateColumnFamily(context.Context, *CreateColumnFamilyRequest) (*ColumnFamily, error)
	// Changes the configuration of a specified column family.
	UpdateColumnFamily(context.Context, *ColumnFamily) (*ColumnFamily, error)
	// Permanently deletes a specified column family and all of its data.
	DeleteColumnFamily(context.Context, *DeleteColumnFamilyRequest) (*empty.Empty, error)
	// Delete all rows in a table corresponding to a particular prefix
	BulkDeleteRows(context.Context, *BulkDeleteRowsRequest) (*empty.Empty, error)
}

func RegisterBigtableTableServiceServer(s *grpc.Server, srv BigtableTableServiceServer) {
	s.RegisterService(&_BigtableTableService_serviceDesc, srv)
}

func _BigtableTableService_CreateTable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTableRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableServiceServer).CreateTable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.table.v1.BigtableTableService/CreateTable",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableServiceServer).CreateTable(ctx, req.(*CreateTableRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableService_ListTables_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTablesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableServiceServer).ListTables(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.table.v1.BigtableTableService/ListTables",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableServiceServer).ListTables(ctx, req.(*ListTablesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableService_GetTable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTableRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableServiceServer).GetTable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.table.v1.BigtableTableService/GetTable",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableServiceServer).GetTable(ctx, req.(*GetTableRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableService_DeleteTable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTableRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableServiceServer).DeleteTable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.table.v1.BigtableTableService/DeleteTable",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableServiceServer).DeleteTable(ctx, req.(*DeleteTableRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableService_RenameTable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RenameTableRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableServiceServer).RenameTable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.table.v1.BigtableTableService/RenameTable",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableServiceServer).RenameTable(ctx, req.(*RenameTableRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableService_CreateColumnFamily_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateColumnFamilyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableServiceServer).CreateColumnFamily(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.table.v1.BigtableTableService/CreateColumnFamily",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableServiceServer).CreateColumnFamily(ctx, req.(*CreateColumnFamilyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableService_UpdateColumnFamily_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ColumnFamily)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableServiceServer).UpdateColumnFamily(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.table.v1.BigtableTableService/UpdateColumnFamily",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableServiceServer).UpdateColumnFamily(ctx, req.(*ColumnFamily))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableService_DeleteColumnFamily_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteColumnFamilyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableServiceServer).DeleteColumnFamily(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.table.v1.BigtableTableService/DeleteColumnFamily",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableServiceServer).DeleteColumnFamily(ctx, req.(*DeleteColumnFamilyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableTableService_BulkDeleteRows_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BulkDeleteRowsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableTableServiceServer).BulkDeleteRows(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.table.v1.BigtableTableService/BulkDeleteRows",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableTableServiceServer).BulkDeleteRows(ctx, req.(*BulkDeleteRowsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _BigtableTableService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.bigtable.admin.table.v1.BigtableTableService",
	HandlerType: (*BigtableTableServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateTable",
			Handler:    _BigtableTableService_CreateTable_Handler,
		},
		{
			MethodName: "ListTables",
			Handler:    _BigtableTableService_ListTables_Handler,
		},
		{
			MethodName: "GetTable",
			Handler:    _BigtableTableService_GetTable_Handler,
		},
		{
			MethodName: "DeleteTable",
			Handler:    _BigtableTableService_DeleteTable_Handler,
		},
		{
			MethodName: "RenameTable",
			Handler:    _BigtableTableService_RenameTable_Handler,
		},
		{
			MethodName: "CreateColumnFamily",
			Handler:    _BigtableTableService_CreateColumnFamily_Handler,
		},
		{
			MethodName: "UpdateColumnFamily",
			Handler:    _BigtableTableService_UpdateColumnFamily_Handler,
		},
		{
			MethodName: "DeleteColumnFamily",
			Handler:    _BigtableTableService_DeleteColumnFamily_Handler,
		},
		{
			MethodName: "BulkDeleteRows",
			Handler:    _BigtableTableService_BulkDeleteRows_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/bigtable/admin/table/v1/bigtable_table_service.proto",
}

func init() {
	proto.RegisterFile("google/bigtable/admin/table/v1/bigtable_table_service.proto", fileDescriptor_bigtable_table_service_077fd6962a736aed)
}

var fileDescriptor_bigtable_table_service_077fd6962a736aed = []byte{
	// 560 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x95, 0xbf, 0x6f, 0xd4, 0x30,
	0x14, 0xc7, 0x65, 0x06, 0x84, 0x7c, 0x88, 0xc1, 0x42, 0x0c, 0x07, 0x62, 0x88, 0xc4, 0x12, 0xa1,
	0x58, 0xb9, 0x82, 0x68, 0xaf, 0xaa, 0x84, 0x72, 0xd7, 0x56, 0xa2, 0x20, 0x95, 0x03, 0x16, 0x96,
	0xca, 0xc9, 0x3d, 0xa2, 0x40, 0x62, 0x87, 0xd8, 0x39, 0x54, 0x50, 0x17, 0x16, 0xfe, 0x00, 0x58,
	0x61, 0x62, 0x64, 0x82, 0x1d, 0x76, 0x56, 0xfe, 0x05, 0xfe, 0x10, 0x14, 0x3b, 0xa1, 0x69, 0xf9,
	0xe1, 0x73, 0xd5, 0x25, 0xe7, 0xb3, 0xbf, 0xdf, 0xf7, 0x3e, 0xcf, 0x7e, 0x96, 0xf1, 0x7a, 0x2a,
	0x44, 0x9a, 0x03, 0x8d, 0xb3, 0x54, 0xb1, 0x38, 0x07, 0xca, 0xe6, 0x45, 0xc6, 0xa9, 0x19, 0x2f,
	0xc2, 0xdf, 0xf3, 0x7b, 0xe6, 0x2b, 0xa1, 0x5a, 0x64, 0x09, 0x04, 0x65, 0x25, 0x94, 0x20, 0x57,
	0x8d, 0x39, 0xe8, 0x44, 0x81, 0x36, 0x07, 0x66, 0xbc, 0x08, 0x87, 0x57, 0xda, 0xe0, 0xac, 0xcc,
	0x28, 0xe3, 0x5c, 0x28, 0xa6, 0x32, 0xc1, 0xa5, 0x71, 0x0f, 0x57, 0xdd, 0x52, 0xcf, 0x99, 0x62,
	0xad, 0x73, 0x7a, 0x22, 0xe8, 0xbd, 0x02, 0xa4, 0x64, 0x29, 0x74, 0xf9, 0x2f, 0xb7, 0x51, 0xf4,
	0xbf, 0xb8, 0x7e, 0x42, 0xa1, 0x28, 0xd5, 0xbe, 0x59, 0x1c, 0x7d, 0x3d, 0x8f, 0x2f, 0x46, 0x6d,
	0x98, 0x87, 0xcd, 0xe7, 0x81, 0x09, 0x42, 0x3e, 0x22, 0x3c, 0x98, 0x54, 0xc0, 0x94, 0x99, 0x26,
	0xa3, 0xe0, 0xff, 0x9b, 0x10, 0xf4, 0xc4, 0x33, 0x78, 0x5e, 0x83, 0x54, 0xc3, 0x6b, 0x36, 0x8f,
	0x56, 0x7b, 0xe3, 0xd7, 0x3f, 0x7e, 0xbe, 0x3d, 0x73, 0xc3, 0xa3, 0x4d, 0x4d, 0xaf, 0x38, 0x2b,
	0x60, 0xa3, 0xac, 0xc4, 0x53, 0x48, 0x94, 0xa4, 0x3e, 0x7d, 0x29, 0x38, 0x34, 0xbf, 0x49, 0x5e,
	0x4b, 0x05, 0x95, 0xa4, 0xfe, 0x81, 0xd9, 0x01, 0x39, 0x46, 0x3e, 0xf9, 0x84, 0x30, 0xbe, 0x9b,
	0x49, 0xa5, 0x23, 0x49, 0x12, 0xda, 0x32, 0x1e, 0x6a, 0x3b, 0xc8, 0x91, 0x8b, 0x45, 0x96, 0x82,
	0x4b, 0xf0, 0x6e, 0x69, 0xe2, 0x90, 0xb8, 0x12, 0x93, 0xf7, 0x08, 0x9f, 0xdb, 0x06, 0x13, 0x8e,
	0x50, 0x5b, 0xe6, 0x4e, 0xe9, 0xb8, 0x9f, 0x6b, 0x9a, 0x6e, 0x85, 0x84, 0x4b, 0xd2, 0xb5, 0x70,
	0xd4, 0x3f, 0x20, 0xef, 0x10, 0x1e, 0x4c, 0x21, 0x87, 0xa5, 0x4f, 0xbd, 0x27, 0xee, 0x28, 0x2f,
	0x75, 0x9e, 0xae, 0xe1, 0x82, 0xcd, 0xa6, 0xe1, 0x3a, 0x2c, 0xff, 0x04, 0x58, 0x1f, 0x10, 0x1e,
	0xcc, 0xa0, 0xb1, 0x2c, 0x89, 0xd5, 0x13, 0xdb, 0xb0, 0x26, 0x1a, 0x6b, 0xc3, 0x5b, 0x75, 0xc6,
	0x1a, 0x57, 0x3a, 0x4b, 0xd3, 0x86, 0xdf, 0x11, 0x26, 0xe6, 0x02, 0x4c, 0x44, 0x5e, 0x17, 0x7c,
	0x8b, 0x15, 0x59, 0xbe, 0x4f, 0xd6, 0x96, 0xbb, 0x34, 0x7d, 0x4f, 0x87, 0x7b, 0xdd, 0x6a, 0xed,
	0x99, 0xbc, 0x1d, 0x5d, 0xc4, 0xa6, 0x77, 0xdb, 0xb9, 0x08, 0x9a, 0x1c, 0xc6, 0xc9, 0xcc, 0x9d,
	0xfa, 0x86, 0x30, 0x79, 0x54, 0xce, 0x8f, 0x17, 0xe3, 0x44, 0xe4, 0xc8, 0x7f, 0x4f, 0xf3, 0x6f,
	0x0f, 0x23, 0x57, 0xfe, 0x63, 0xf8, 0xcd, 0xa9, 0x20, 0x9f, 0x7c, 0x41, 0x98, 0x98, 0xce, 0x74,
	0x3b, 0x8e, 0x3f, 0x3d, 0xb6, 0xee, 0xb9, 0xa3, 0xc1, 0xa7, 0xfe, 0x29, 0x80, 0x93, 0xcf, 0x08,
	0x5f, 0x88, 0xea, 0xfc, 0x99, 0xa1, 0x98, 0x89, 0x17, 0x92, 0xdc, 0xb4, 0x11, 0x1f, 0xd5, 0xdb,
	0x68, 0xef, 0x6b, 0xda, 0x1d, 0x6f, 0x4b, 0xd3, 0x9a, 0x57, 0xc3, 0xa9, 0xe3, 0xe3, 0x23, 0xe9,
	0xc6, 0xc8, 0x8f, 0xde, 0x20, 0xec, 0x25, 0xa2, 0xb0, 0x70, 0x46, 0xc3, 0xbf, 0x3d, 0x32, 0x72,
	0xb7, 0xc1, 0xdb, 0x45, 0x8f, 0x27, 0xad, 0x3b, 0x15, 0x39, 0xe3, 0x69, 0x20, 0xaa, 0x94, 0xa6,
	0xc0, 0x35, 0x3c, 0x35, 0x4b, 0xac, 0xcc, 0xe4, 0xbf, 0xde, 0xc1, 0x75, 0x3d, 0x88, 0xcf, 0x6a,
	0xfd, 0xca, 0xaf, 0x00, 0x00, 0x00, 0xff, 0xff, 0x03, 0x65, 0xb4, 0xe0, 0xeb, 0x07, 0x00, 0x00,
}
