// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google.golang.org/appengine/internal/image/images_service.proto

/*
Package image is a generated protocol buffer package.

It is generated from these files:
	google.golang.org/appengine/internal/image/images_service.proto

It has these top-level messages:
	ImagesServiceError
	ImagesServiceTransform
	Transform
	ImageData
	InputSettings
	OutputSettings
	ImagesTransformRequest
	ImagesTransformResponse
	CompositeImageOptions
	ImagesCanvas
	ImagesCompositeRequest
	ImagesCompositeResponse
	ImagesHistogramRequest
	ImagesHistogram
	ImagesHistogramResponse
	ImagesGetUrlBaseRequest
	ImagesGetUrlBaseResponse
	ImagesDeleteUrlBaseRequest
	ImagesDeleteUrlBaseResponse
*/
package image

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type ImagesServiceError_ErrorCode int32

const (
	ImagesServiceError_UNSPECIFIED_ERROR  ImagesServiceError_ErrorCode = 1
	ImagesServiceError_BAD_TRANSFORM_DATA ImagesServiceError_ErrorCode = 2
	ImagesServiceError_NOT_IMAGE          ImagesServiceError_ErrorCode = 3
	ImagesServiceError_BAD_IMAGE_DATA     ImagesServiceError_ErrorCode = 4
	ImagesServiceError_IMAGE_TOO_LARGE    ImagesServiceError_ErrorCode = 5
	ImagesServiceError_INVALID_BLOB_KEY   ImagesServiceError_ErrorCode = 6
	ImagesServiceError_ACCESS_DENIED      ImagesServiceError_ErrorCode = 7
	ImagesServiceError_OBJECT_NOT_FOUND   ImagesServiceError_ErrorCode = 8
)

var ImagesServiceError_ErrorCode_name = map[int32]string{
	1: "UNSPECIFIED_ERROR",
	2: "BAD_TRANSFORM_DATA",
	3: "NOT_IMAGE",
	4: "BAD_IMAGE_DATA",
	5: "IMAGE_TOO_LARGE",
	6: "INVALID_BLOB_KEY",
	7: "ACCESS_DENIED",
	8: "OBJECT_NOT_FOUND",
}
var ImagesServiceError_ErrorCode_value = map[string]int32{
	"UNSPECIFIED_ERROR":  1,
	"BAD_TRANSFORM_DATA": 2,
	"NOT_IMAGE":          3,
	"BAD_IMAGE_DATA":     4,
	"IMAGE_TOO_LARGE":    5,
	"INVALID_BLOB_KEY":   6,
	"ACCESS_DENIED":      7,
	"OBJECT_NOT_FOUND":   8,
}

func (x ImagesServiceError_ErrorCode) Enum() *ImagesServiceError_ErrorCode {
	p := new(ImagesServiceError_ErrorCode)
	*p = x
	return p
}
func (x ImagesServiceError_ErrorCode) String() string {
	return proto.EnumName(ImagesServiceError_ErrorCode_name, int32(x))
}
func (x *ImagesServiceError_ErrorCode) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(ImagesServiceError_ErrorCode_value, data, "ImagesServiceError_ErrorCode")
	if err != nil {
		return err
	}
	*x = ImagesServiceError_ErrorCode(value)
	return nil
}
func (ImagesServiceError_ErrorCode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{0, 0}
}

type ImagesServiceTransform_Type int32

const (
	ImagesServiceTransform_RESIZE           ImagesServiceTransform_Type = 1
	ImagesServiceTransform_ROTATE           ImagesServiceTransform_Type = 2
	ImagesServiceTransform_HORIZONTAL_FLIP  ImagesServiceTransform_Type = 3
	ImagesServiceTransform_VERTICAL_FLIP    ImagesServiceTransform_Type = 4
	ImagesServiceTransform_CROP             ImagesServiceTransform_Type = 5
	ImagesServiceTransform_IM_FEELING_LUCKY ImagesServiceTransform_Type = 6
)

var ImagesServiceTransform_Type_name = map[int32]string{
	1: "RESIZE",
	2: "ROTATE",
	3: "HORIZONTAL_FLIP",
	4: "VERTICAL_FLIP",
	5: "CROP",
	6: "IM_FEELING_LUCKY",
}
var ImagesServiceTransform_Type_value = map[string]int32{
	"RESIZE":           1,
	"ROTATE":           2,
	"HORIZONTAL_FLIP":  3,
	"VERTICAL_FLIP":    4,
	"CROP":             5,
	"IM_FEELING_LUCKY": 6,
}

func (x ImagesServiceTransform_Type) Enum() *ImagesServiceTransform_Type {
	p := new(ImagesServiceTransform_Type)
	*p = x
	return p
}
func (x ImagesServiceTransform_Type) String() string {
	return proto.EnumName(ImagesServiceTransform_Type_name, int32(x))
}
func (x *ImagesServiceTransform_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(ImagesServiceTransform_Type_value, data, "ImagesServiceTransform_Type")
	if err != nil {
		return err
	}
	*x = ImagesServiceTransform_Type(value)
	return nil
}
func (ImagesServiceTransform_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{1, 0}
}

type InputSettings_ORIENTATION_CORRECTION_TYPE int32

const (
	InputSettings_UNCHANGED_ORIENTATION InputSettings_ORIENTATION_CORRECTION_TYPE = 0
	InputSettings_CORRECT_ORIENTATION   InputSettings_ORIENTATION_CORRECTION_TYPE = 1
)

var InputSettings_ORIENTATION_CORRECTION_TYPE_name = map[int32]string{
	0: "UNCHANGED_ORIENTATION",
	1: "CORRECT_ORIENTATION",
}
var InputSettings_ORIENTATION_CORRECTION_TYPE_value = map[string]int32{
	"UNCHANGED_ORIENTATION": 0,
	"CORRECT_ORIENTATION":   1,
}

func (x InputSettings_ORIENTATION_CORRECTION_TYPE) Enum() *InputSettings_ORIENTATION_CORRECTION_TYPE {
	p := new(InputSettings_ORIENTATION_CORRECTION_TYPE)
	*p = x
	return p
}
func (x InputSettings_ORIENTATION_CORRECTION_TYPE) String() string {
	return proto.EnumName(InputSettings_ORIENTATION_CORRECTION_TYPE_name, int32(x))
}
func (x *InputSettings_ORIENTATION_CORRECTION_TYPE) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(InputSettings_ORIENTATION_CORRECTION_TYPE_value, data, "InputSettings_ORIENTATION_CORRECTION_TYPE")
	if err != nil {
		return err
	}
	*x = InputSettings_ORIENTATION_CORRECTION_TYPE(value)
	return nil
}
func (InputSettings_ORIENTATION_CORRECTION_TYPE) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{4, 0}
}

type OutputSettings_MIME_TYPE int32

const (
	OutputSettings_PNG  OutputSettings_MIME_TYPE = 0
	OutputSettings_JPEG OutputSettings_MIME_TYPE = 1
	OutputSettings_WEBP OutputSettings_MIME_TYPE = 2
)

var OutputSettings_MIME_TYPE_name = map[int32]string{
	0: "PNG",
	1: "JPEG",
	2: "WEBP",
}
var OutputSettings_MIME_TYPE_value = map[string]int32{
	"PNG":  0,
	"JPEG": 1,
	"WEBP": 2,
}

func (x OutputSettings_MIME_TYPE) Enum() *OutputSettings_MIME_TYPE {
	p := new(OutputSettings_MIME_TYPE)
	*p = x
	return p
}
func (x OutputSettings_MIME_TYPE) String() string {
	return proto.EnumName(OutputSettings_MIME_TYPE_name, int32(x))
}
func (x *OutputSettings_MIME_TYPE) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(OutputSettings_MIME_TYPE_value, data, "OutputSettings_MIME_TYPE")
	if err != nil {
		return err
	}
	*x = OutputSettings_MIME_TYPE(value)
	return nil
}
func (OutputSettings_MIME_TYPE) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{5, 0} }

type CompositeImageOptions_ANCHOR int32

const (
	CompositeImageOptions_TOP_LEFT     CompositeImageOptions_ANCHOR = 0
	CompositeImageOptions_TOP          CompositeImageOptions_ANCHOR = 1
	CompositeImageOptions_TOP_RIGHT    CompositeImageOptions_ANCHOR = 2
	CompositeImageOptions_LEFT         CompositeImageOptions_ANCHOR = 3
	CompositeImageOptions_CENTER       CompositeImageOptions_ANCHOR = 4
	CompositeImageOptions_RIGHT        CompositeImageOptions_ANCHOR = 5
	CompositeImageOptions_BOTTOM_LEFT  CompositeImageOptions_ANCHOR = 6
	CompositeImageOptions_BOTTOM       CompositeImageOptions_ANCHOR = 7
	CompositeImageOptions_BOTTOM_RIGHT CompositeImageOptions_ANCHOR = 8
)

var CompositeImageOptions_ANCHOR_name = map[int32]string{
	0: "TOP_LEFT",
	1: "TOP",
	2: "TOP_RIGHT",
	3: "LEFT",
	4: "CENTER",
	5: "RIGHT",
	6: "BOTTOM_LEFT",
	7: "BOTTOM",
	8: "BOTTOM_RIGHT",
}
var CompositeImageOptions_ANCHOR_value = map[string]int32{
	"TOP_LEFT":     0,
	"TOP":          1,
	"TOP_RIGHT":    2,
	"LEFT":         3,
	"CENTER":       4,
	"RIGHT":        5,
	"BOTTOM_LEFT":  6,
	"BOTTOM":       7,
	"BOTTOM_RIGHT": 8,
}

func (x CompositeImageOptions_ANCHOR) Enum() *CompositeImageOptions_ANCHOR {
	p := new(CompositeImageOptions_ANCHOR)
	*p = x
	return p
}
func (x CompositeImageOptions_ANCHOR) String() string {
	return proto.EnumName(CompositeImageOptions_ANCHOR_name, int32(x))
}
func (x *CompositeImageOptions_ANCHOR) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(CompositeImageOptions_ANCHOR_value, data, "CompositeImageOptions_ANCHOR")
	if err != nil {
		return err
	}
	*x = CompositeImageOptions_ANCHOR(value)
	return nil
}
func (CompositeImageOptions_ANCHOR) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{8, 0}
}

type ImagesServiceError struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *ImagesServiceError) Reset()                    { *m = ImagesServiceError{} }
func (m *ImagesServiceError) String() string            { return proto.CompactTextString(m) }
func (*ImagesServiceError) ProtoMessage()               {}
func (*ImagesServiceError) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

type ImagesServiceTransform struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *ImagesServiceTransform) Reset()                    { *m = ImagesServiceTransform{} }
func (m *ImagesServiceTransform) String() string            { return proto.CompactTextString(m) }
func (*ImagesServiceTransform) ProtoMessage()               {}
func (*ImagesServiceTransform) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

type Transform struct {
	Width            *int32   `protobuf:"varint,1,opt,name=width" json:"width,omitempty"`
	Height           *int32   `protobuf:"varint,2,opt,name=height" json:"height,omitempty"`
	CropToFit        *bool    `protobuf:"varint,11,opt,name=crop_to_fit,json=cropToFit,def=0" json:"crop_to_fit,omitempty"`
	CropOffsetX      *float32 `protobuf:"fixed32,12,opt,name=crop_offset_x,json=cropOffsetX,def=0.5" json:"crop_offset_x,omitempty"`
	CropOffsetY      *float32 `protobuf:"fixed32,13,opt,name=crop_offset_y,json=cropOffsetY,def=0.5" json:"crop_offset_y,omitempty"`
	Rotate           *int32   `protobuf:"varint,3,opt,name=rotate,def=0" json:"rotate,omitempty"`
	HorizontalFlip   *bool    `protobuf:"varint,4,opt,name=horizontal_flip,json=horizontalFlip,def=0" json:"horizontal_flip,omitempty"`
	VerticalFlip     *bool    `protobuf:"varint,5,opt,name=vertical_flip,json=verticalFlip,def=0" json:"vertical_flip,omitempty"`
	CropLeftX        *float32 `protobuf:"fixed32,6,opt,name=crop_left_x,json=cropLeftX,def=0" json:"crop_left_x,omitempty"`
	CropTopY         *float32 `protobuf:"fixed32,7,opt,name=crop_top_y,json=cropTopY,def=0" json:"crop_top_y,omitempty"`
	CropRightX       *float32 `protobuf:"fixed32,8,opt,name=crop_right_x,json=cropRightX,def=1" json:"crop_right_x,omitempty"`
	CropBottomY      *float32 `protobuf:"fixed32,9,opt,name=crop_bottom_y,json=cropBottomY,def=1" json:"crop_bottom_y,omitempty"`
	Autolevels       *bool    `protobuf:"varint,10,opt,name=autolevels,def=0" json:"autolevels,omitempty"`
	AllowStretch     *bool    `protobuf:"varint,14,opt,name=allow_stretch,json=allowStretch,def=0" json:"allow_stretch,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *Transform) Reset()                    { *m = Transform{} }
func (m *Transform) String() string            { return proto.CompactTextString(m) }
func (*Transform) ProtoMessage()               {}
func (*Transform) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

const Default_Transform_CropToFit bool = false
const Default_Transform_CropOffsetX float32 = 0.5
const Default_Transform_CropOffsetY float32 = 0.5
const Default_Transform_Rotate int32 = 0
const Default_Transform_HorizontalFlip bool = false
const Default_Transform_VerticalFlip bool = false
const Default_Transform_CropLeftX float32 = 0
const Default_Transform_CropTopY float32 = 0
const Default_Transform_CropRightX float32 = 1
const Default_Transform_CropBottomY float32 = 1
const Default_Transform_Autolevels bool = false
const Default_Transform_AllowStretch bool = false

func (m *Transform) GetWidth() int32 {
	if m != nil && m.Width != nil {
		return *m.Width
	}
	return 0
}

func (m *Transform) GetHeight() int32 {
	if m != nil && m.Height != nil {
		return *m.Height
	}
	return 0
}

func (m *Transform) GetCropToFit() bool {
	if m != nil && m.CropToFit != nil {
		return *m.CropToFit
	}
	return Default_Transform_CropToFit
}

func (m *Transform) GetCropOffsetX() float32 {
	if m != nil && m.CropOffsetX != nil {
		return *m.CropOffsetX
	}
	return Default_Transform_CropOffsetX
}

func (m *Transform) GetCropOffsetY() float32 {
	if m != nil && m.CropOffsetY != nil {
		return *m.CropOffsetY
	}
	return Default_Transform_CropOffsetY
}

func (m *Transform) GetRotate() int32 {
	if m != nil && m.Rotate != nil {
		return *m.Rotate
	}
	return Default_Transform_Rotate
}

func (m *Transform) GetHorizontalFlip() bool {
	if m != nil && m.HorizontalFlip != nil {
		return *m.HorizontalFlip
	}
	return Default_Transform_HorizontalFlip
}

func (m *Transform) GetVerticalFlip() bool {
	if m != nil && m.VerticalFlip != nil {
		return *m.VerticalFlip
	}
	return Default_Transform_VerticalFlip
}

func (m *Transform) GetCropLeftX() float32 {
	if m != nil && m.CropLeftX != nil {
		return *m.CropLeftX
	}
	return Default_Transform_CropLeftX
}

func (m *Transform) GetCropTopY() float32 {
	if m != nil && m.CropTopY != nil {
		return *m.CropTopY
	}
	return Default_Transform_CropTopY
}

func (m *Transform) GetCropRightX() float32 {
	if m != nil && m.CropRightX != nil {
		return *m.CropRightX
	}
	return Default_Transform_CropRightX
}

func (m *Transform) GetCropBottomY() float32 {
	if m != nil && m.CropBottomY != nil {
		return *m.CropBottomY
	}
	return Default_Transform_CropBottomY
}

func (m *Transform) GetAutolevels() bool {
	if m != nil && m.Autolevels != nil {
		return *m.Autolevels
	}
	return Default_Transform_Autolevels
}

func (m *Transform) GetAllowStretch() bool {
	if m != nil && m.AllowStretch != nil {
		return *m.AllowStretch
	}
	return Default_Transform_AllowStretch
}

type ImageData struct {
	Content          []byte  `protobuf:"bytes,1,req,name=content" json:"content,omitempty"`
	BlobKey          *string `protobuf:"bytes,2,opt,name=blob_key,json=blobKey" json:"blob_key,omitempty"`
	Width            *int32  `protobuf:"varint,3,opt,name=width" json:"width,omitempty"`
	Height           *int32  `protobuf:"varint,4,opt,name=height" json:"height,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *ImageData) Reset()                    { *m = ImageData{} }
func (m *ImageData) String() string            { return proto.CompactTextString(m) }
func (*ImageData) ProtoMessage()               {}
func (*ImageData) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *ImageData) GetContent() []byte {
	if m != nil {
		return m.Content
	}
	return nil
}

func (m *ImageData) GetBlobKey() string {
	if m != nil && m.BlobKey != nil {
		return *m.BlobKey
	}
	return ""
}

func (m *ImageData) GetWidth() int32 {
	if m != nil && m.Width != nil {
		return *m.Width
	}
	return 0
}

func (m *ImageData) GetHeight() int32 {
	if m != nil && m.Height != nil {
		return *m.Height
	}
	return 0
}

type InputSettings struct {
	CorrectExifOrientation     *InputSettings_ORIENTATION_CORRECTION_TYPE `protobuf:"varint,1,opt,name=correct_exif_orientation,json=correctExifOrientation,enum=appengine.InputSettings_ORIENTATION_CORRECTION_TYPE,def=0" json:"correct_exif_orientation,omitempty"`
	ParseMetadata              *bool                                      `protobuf:"varint,2,opt,name=parse_metadata,json=parseMetadata,def=0" json:"parse_metadata,omitempty"`
	TransparentSubstitutionRgb *int32                                     `protobuf:"varint,3,opt,name=transparent_substitution_rgb,json=transparentSubstitutionRgb" json:"transparent_substitution_rgb,omitempty"`
	XXX_unrecognized           []byte                                     `json:"-"`
}

func (m *InputSettings) Reset()                    { *m = InputSettings{} }
func (m *InputSettings) String() string            { return proto.CompactTextString(m) }
func (*InputSettings) ProtoMessage()               {}
func (*InputSettings) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

const Default_InputSettings_CorrectExifOrientation InputSettings_ORIENTATION_CORRECTION_TYPE = InputSettings_UNCHANGED_ORIENTATION
const Default_InputSettings_ParseMetadata bool = false

func (m *InputSettings) GetCorrectExifOrientation() InputSettings_ORIENTATION_CORRECTION_TYPE {
	if m != nil && m.CorrectExifOrientation != nil {
		return *m.CorrectExifOrientation
	}
	return Default_InputSettings_CorrectExifOrientation
}

func (m *InputSettings) GetParseMetadata() bool {
	if m != nil && m.ParseMetadata != nil {
		return *m.ParseMetadata
	}
	return Default_InputSettings_ParseMetadata
}

func (m *InputSettings) GetTransparentSubstitutionRgb() int32 {
	if m != nil && m.TransparentSubstitutionRgb != nil {
		return *m.TransparentSubstitutionRgb
	}
	return 0
}

type OutputSettings struct {
	MimeType         *OutputSettings_MIME_TYPE `protobuf:"varint,1,opt,name=mime_type,json=mimeType,enum=appengine.OutputSettings_MIME_TYPE,def=0" json:"mime_type,omitempty"`
	Quality          *int32                    `protobuf:"varint,2,opt,name=quality" json:"quality,omitempty"`
	XXX_unrecognized []byte                    `json:"-"`
}

func (m *OutputSettings) Reset()                    { *m = OutputSettings{} }
func (m *OutputSettings) String() string            { return proto.CompactTextString(m) }
func (*OutputSettings) ProtoMessage()               {}
func (*OutputSettings) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

const Default_OutputSettings_MimeType OutputSettings_MIME_TYPE = OutputSettings_PNG

func (m *OutputSettings) GetMimeType() OutputSettings_MIME_TYPE {
	if m != nil && m.MimeType != nil {
		return *m.MimeType
	}
	return Default_OutputSettings_MimeType
}

func (m *OutputSettings) GetQuality() int32 {
	if m != nil && m.Quality != nil {
		return *m.Quality
	}
	return 0
}

type ImagesTransformRequest struct {
	Image            *ImageData      `protobuf:"bytes,1,req,name=image" json:"image,omitempty"`
	Transform        []*Transform    `protobuf:"bytes,2,rep,name=transform" json:"transform,omitempty"`
	Output           *OutputSettings `protobuf:"bytes,3,req,name=output" json:"output,omitempty"`
	Input            *InputSettings  `protobuf:"bytes,4,opt,name=input" json:"input,omitempty"`
	XXX_unrecognized []byte          `json:"-"`
}

func (m *ImagesTransformRequest) Reset()                    { *m = ImagesTransformRequest{} }
func (m *ImagesTransformRequest) String() string            { return proto.CompactTextString(m) }
func (*ImagesTransformRequest) ProtoMessage()               {}
func (*ImagesTransformRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *ImagesTransformRequest) GetImage() *ImageData {
	if m != nil {
		return m.Image
	}
	return nil
}

func (m *ImagesTransformRequest) GetTransform() []*Transform {
	if m != nil {
		return m.Transform
	}
	return nil
}

func (m *ImagesTransformRequest) GetOutput() *OutputSettings {
	if m != nil {
		return m.Output
	}
	return nil
}

func (m *ImagesTransformRequest) GetInput() *InputSettings {
	if m != nil {
		return m.Input
	}
	return nil
}

type ImagesTransformResponse struct {
	Image            *ImageData `protobuf:"bytes,1,req,name=image" json:"image,omitempty"`
	SourceMetadata   *string    `protobuf:"bytes,2,opt,name=source_metadata,json=sourceMetadata" json:"source_metadata,omitempty"`
	XXX_unrecognized []byte     `json:"-"`
}

func (m *ImagesTransformResponse) Reset()                    { *m = ImagesTransformResponse{} }
func (m *ImagesTransformResponse) String() string            { return proto.CompactTextString(m) }
func (*ImagesTransformResponse) ProtoMessage()               {}
func (*ImagesTransformResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *ImagesTransformResponse) GetImage() *ImageData {
	if m != nil {
		return m.Image
	}
	return nil
}

func (m *ImagesTransformResponse) GetSourceMetadata() string {
	if m != nil && m.SourceMetadata != nil {
		return *m.SourceMetadata
	}
	return ""
}

type CompositeImageOptions struct {
	SourceIndex      *int32                        `protobuf:"varint,1,req,name=source_index,json=sourceIndex" json:"source_index,omitempty"`
	XOffset          *int32                        `protobuf:"varint,2,req,name=x_offset,json=xOffset" json:"x_offset,omitempty"`
	YOffset          *int32                        `protobuf:"varint,3,req,name=y_offset,json=yOffset" json:"y_offset,omitempty"`
	Opacity          *float32                      `protobuf:"fixed32,4,req,name=opacity" json:"opacity,omitempty"`
	Anchor           *CompositeImageOptions_ANCHOR `protobuf:"varint,5,req,name=anchor,enum=appengine.CompositeImageOptions_ANCHOR" json:"anchor,omitempty"`
	XXX_unrecognized []byte                        `json:"-"`
}

func (m *CompositeImageOptions) Reset()                    { *m = CompositeImageOptions{} }
func (m *CompositeImageOptions) String() string            { return proto.CompactTextString(m) }
func (*CompositeImageOptions) ProtoMessage()               {}
func (*CompositeImageOptions) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *CompositeImageOptions) GetSourceIndex() int32 {
	if m != nil && m.SourceIndex != nil {
		return *m.SourceIndex
	}
	return 0
}

func (m *CompositeImageOptions) GetXOffset() int32 {
	if m != nil && m.XOffset != nil {
		return *m.XOffset
	}
	return 0
}

func (m *CompositeImageOptions) GetYOffset() int32 {
	if m != nil && m.YOffset != nil {
		return *m.YOffset
	}
	return 0
}

func (m *CompositeImageOptions) GetOpacity() float32 {
	if m != nil && m.Opacity != nil {
		return *m.Opacity
	}
	return 0
}

func (m *CompositeImageOptions) GetAnchor() CompositeImageOptions_ANCHOR {
	if m != nil && m.Anchor != nil {
		return *m.Anchor
	}
	return CompositeImageOptions_TOP_LEFT
}

type ImagesCanvas struct {
	Width            *int32          `protobuf:"varint,1,req,name=width" json:"width,omitempty"`
	Height           *int32          `protobuf:"varint,2,req,name=height" json:"height,omitempty"`
	Output           *OutputSettings `protobuf:"bytes,3,req,name=output" json:"output,omitempty"`
	Color            *int32          `protobuf:"varint,4,opt,name=color,def=-1" json:"color,omitempty"`
	XXX_unrecognized []byte          `json:"-"`
}

func (m *ImagesCanvas) Reset()                    { *m = ImagesCanvas{} }
func (m *ImagesCanvas) String() string            { return proto.CompactTextString(m) }
func (*ImagesCanvas) ProtoMessage()               {}
func (*ImagesCanvas) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

const Default_ImagesCanvas_Color int32 = -1

func (m *ImagesCanvas) GetWidth() int32 {
	if m != nil && m.Width != nil {
		return *m.Width
	}
	return 0
}

func (m *ImagesCanvas) GetHeight() int32 {
	if m != nil && m.Height != nil {
		return *m.Height
	}
	return 0
}

func (m *ImagesCanvas) GetOutput() *OutputSettings {
	if m != nil {
		return m.Output
	}
	return nil
}

func (m *ImagesCanvas) GetColor() int32 {
	if m != nil && m.Color != nil {
		return *m.Color
	}
	return Default_ImagesCanvas_Color
}

type ImagesCompositeRequest struct {
	Image            []*ImageData             `protobuf:"bytes,1,rep,name=image" json:"image,omitempty"`
	Options          []*CompositeImageOptions `protobuf:"bytes,2,rep,name=options" json:"options,omitempty"`
	Canvas           *ImagesCanvas            `protobuf:"bytes,3,req,name=canvas" json:"canvas,omitempty"`
	XXX_unrecognized []byte                   `json:"-"`
}

func (m *ImagesCompositeRequest) Reset()                    { *m = ImagesCompositeRequest{} }
func (m *ImagesCompositeRequest) String() string            { return proto.CompactTextString(m) }
func (*ImagesCompositeRequest) ProtoMessage()               {}
func (*ImagesCompositeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *ImagesCompositeRequest) GetImage() []*ImageData {
	if m != nil {
		return m.Image
	}
	return nil
}

func (m *ImagesCompositeRequest) GetOptions() []*CompositeImageOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

func (m *ImagesCompositeRequest) GetCanvas() *ImagesCanvas {
	if m != nil {
		return m.Canvas
	}
	return nil
}

type ImagesCompositeResponse struct {
	Image            *ImageData `protobuf:"bytes,1,req,name=image" json:"image,omitempty"`
	XXX_unrecognized []byte     `json:"-"`
}

func (m *ImagesCompositeResponse) Reset()                    { *m = ImagesCompositeResponse{} }
func (m *ImagesCompositeResponse) String() string            { return proto.CompactTextString(m) }
func (*ImagesCompositeResponse) ProtoMessage()               {}
func (*ImagesCompositeResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *ImagesCompositeResponse) GetImage() *ImageData {
	if m != nil {
		return m.Image
	}
	return nil
}

type ImagesHistogramRequest struct {
	Image            *ImageData `protobuf:"bytes,1,req,name=image" json:"image,omitempty"`
	XXX_unrecognized []byte     `json:"-"`
}

func (m *ImagesHistogramRequest) Reset()                    { *m = ImagesHistogramRequest{} }
func (m *ImagesHistogramRequest) String() string            { return proto.CompactTextString(m) }
func (*ImagesHistogramRequest) ProtoMessage()               {}
func (*ImagesHistogramRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *ImagesHistogramRequest) GetImage() *ImageData {
	if m != nil {
		return m.Image
	}
	return nil
}

type ImagesHistogram struct {
	Red              []int32 `protobuf:"varint,1,rep,name=red" json:"red,omitempty"`
	Green            []int32 `protobuf:"varint,2,rep,name=green" json:"green,omitempty"`
	Blue             []int32 `protobuf:"varint,3,rep,name=blue" json:"blue,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *ImagesHistogram) Reset()                    { *m = ImagesHistogram{} }
func (m *ImagesHistogram) String() string            { return proto.CompactTextString(m) }
func (*ImagesHistogram) ProtoMessage()               {}
func (*ImagesHistogram) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *ImagesHistogram) GetRed() []int32 {
	if m != nil {
		return m.Red
	}
	return nil
}

func (m *ImagesHistogram) GetGreen() []int32 {
	if m != nil {
		return m.Green
	}
	return nil
}

func (m *ImagesHistogram) GetBlue() []int32 {
	if m != nil {
		return m.Blue
	}
	return nil
}

type ImagesHistogramResponse struct {
	Histogram        *ImagesHistogram `protobuf:"bytes,1,req,name=histogram" json:"histogram,omitempty"`
	XXX_unrecognized []byte           `json:"-"`
}

func (m *ImagesHistogramResponse) Reset()                    { *m = ImagesHistogramResponse{} }
func (m *ImagesHistogramResponse) String() string            { return proto.CompactTextString(m) }
func (*ImagesHistogramResponse) ProtoMessage()               {}
func (*ImagesHistogramResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *ImagesHistogramResponse) GetHistogram() *ImagesHistogram {
	if m != nil {
		return m.Histogram
	}
	return nil
}

type ImagesGetUrlBaseRequest struct {
	BlobKey          *string `protobuf:"bytes,1,req,name=blob_key,json=blobKey" json:"blob_key,omitempty"`
	CreateSecureUrl  *bool   `protobuf:"varint,2,opt,name=create_secure_url,json=createSecureUrl,def=0" json:"create_secure_url,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *ImagesGetUrlBaseRequest) Reset()                    { *m = ImagesGetUrlBaseRequest{} }
func (m *ImagesGetUrlBaseRequest) String() string            { return proto.CompactTextString(m) }
func (*ImagesGetUrlBaseRequest) ProtoMessage()               {}
func (*ImagesGetUrlBaseRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

const Default_ImagesGetUrlBaseRequest_CreateSecureUrl bool = false

func (m *ImagesGetUrlBaseRequest) GetBlobKey() string {
	if m != nil && m.BlobKey != nil {
		return *m.BlobKey
	}
	return ""
}

func (m *ImagesGetUrlBaseRequest) GetCreateSecureUrl() bool {
	if m != nil && m.CreateSecureUrl != nil {
		return *m.CreateSecureUrl
	}
	return Default_ImagesGetUrlBaseRequest_CreateSecureUrl
}

type ImagesGetUrlBaseResponse struct {
	Url              *string `protobuf:"bytes,1,req,name=url" json:"url,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *ImagesGetUrlBaseResponse) Reset()                    { *m = ImagesGetUrlBaseResponse{} }
func (m *ImagesGetUrlBaseResponse) String() string            { return proto.CompactTextString(m) }
func (*ImagesGetUrlBaseResponse) ProtoMessage()               {}
func (*ImagesGetUrlBaseResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *ImagesGetUrlBaseResponse) GetUrl() string {
	if m != nil && m.Url != nil {
		return *m.Url
	}
	return ""
}

type ImagesDeleteUrlBaseRequest struct {
	BlobKey          *string `protobuf:"bytes,1,req,name=blob_key,json=blobKey" json:"blob_key,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *ImagesDeleteUrlBaseRequest) Reset()                    { *m = ImagesDeleteUrlBaseRequest{} }
func (m *ImagesDeleteUrlBaseRequest) String() string            { return proto.CompactTextString(m) }
func (*ImagesDeleteUrlBaseRequest) ProtoMessage()               {}
func (*ImagesDeleteUrlBaseRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

func (m *ImagesDeleteUrlBaseRequest) GetBlobKey() string {
	if m != nil && m.BlobKey != nil {
		return *m.BlobKey
	}
	return ""
}

type ImagesDeleteUrlBaseResponse struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *ImagesDeleteUrlBaseResponse) Reset()                    { *m = ImagesDeleteUrlBaseResponse{} }
func (m *ImagesDeleteUrlBaseResponse) String() string            { return proto.CompactTextString(m) }
func (*ImagesDeleteUrlBaseResponse) ProtoMessage()               {}
func (*ImagesDeleteUrlBaseResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

func init() {
	proto.RegisterType((*ImagesServiceError)(nil), "appengine.ImagesServiceError")
	proto.RegisterType((*ImagesServiceTransform)(nil), "appengine.ImagesServiceTransform")
	proto.RegisterType((*Transform)(nil), "appengine.Transform")
	proto.RegisterType((*ImageData)(nil), "appengine.ImageData")
	proto.RegisterType((*InputSettings)(nil), "appengine.InputSettings")
	proto.RegisterType((*OutputSettings)(nil), "appengine.OutputSettings")
	proto.RegisterType((*ImagesTransformRequest)(nil), "appengine.ImagesTransformRequest")
	proto.RegisterType((*ImagesTransformResponse)(nil), "appengine.ImagesTransformResponse")
	proto.RegisterType((*CompositeImageOptions)(nil), "appengine.CompositeImageOptions")
	proto.RegisterType((*ImagesCanvas)(nil), "appengine.ImagesCanvas")
	proto.RegisterType((*ImagesCompositeRequest)(nil), "appengine.ImagesCompositeRequest")
	proto.RegisterType((*ImagesCompositeResponse)(nil), "appengine.ImagesCompositeResponse")
	proto.RegisterType((*ImagesHistogramRequest)(nil), "appengine.ImagesHistogramRequest")
	proto.RegisterType((*ImagesHistogram)(nil), "appengine.ImagesHistogram")
	proto.RegisterType((*ImagesHistogramResponse)(nil), "appengine.ImagesHistogramResponse")
	proto.RegisterType((*ImagesGetUrlBaseRequest)(nil), "appengine.ImagesGetUrlBaseRequest")
	proto.RegisterType((*ImagesGetUrlBaseResponse)(nil), "appengine.ImagesGetUrlBaseResponse")
	proto.RegisterType((*ImagesDeleteUrlBaseRequest)(nil), "appengine.ImagesDeleteUrlBaseRequest")
	proto.RegisterType((*ImagesDeleteUrlBaseResponse)(nil), "appengine.ImagesDeleteUrlBaseResponse")
}

func init() {
	proto.RegisterFile("google.golang.org/appengine/internal/image/images_service.proto", fileDescriptor0)
}

var fileDescriptor0 = []byte{
	// 1460 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x56, 0xdd, 0x6e, 0xe3, 0xc6,
	0x15, 0x5e, 0x52, 0xff, 0xc7, 0xb2, 0xcc, 0x9d, 0xec, 0x0f, 0x77, 0x93, 0xa2, 0x0a, 0x83, 0xc5,
	0x1a, 0x41, 0x2a, 0xaf, 0x8d, 0x16, 0x2d, 0x7c, 0x93, 0xea, 0x87, 0x92, 0x99, 0x95, 0x44, 0x75,
	0x44, 0xa7, 0xeb, 0xbd, 0x19, 0xd0, 0xf2, 0x48, 0x26, 0x4a, 0x73, 0x98, 0xe1, 0xc8, 0xb1, 0x7a,
	0x51, 0xf4, 0xa6, 0x17, 0x05, 0xfa, 0x06, 0x7d, 0x8a, 0xbe, 0x45, 0x81, 0xbe, 0x41, 0xfb, 0x32,
	0xc5, 0x0c, 0x49, 0x99, 0xf6, 0x3a, 0x4d, 0xb3, 0x37, 0xc2, 0xcc, 0x39, 0xdf, 0xf9, 0x9d, 0x8f,
	0xe7, 0x08, 0xbe, 0x5e, 0x31, 0xb6, 0x0a, 0x69, 0x67, 0xc5, 0x42, 0x3f, 0x5a, 0x75, 0x18, 0x5f,
	0x1d, 0xf8, 0x71, 0x4c, 0xa3, 0x55, 0x10, 0xd1, 0x83, 0x20, 0x12, 0x94, 0x47, 0x7e, 0x78, 0x10,
	0x5c, 0xf9, 0x2b, 0x9a, 0xfe, 0x26, 0x24, 0xa1, 0xfc, 0x3a, 0x58, 0xd0, 0x4e, 0xcc, 0x99, 0x60,
	0xa8, 0xb1, 0x85, 0x5b, 0xff, 0xd4, 0x00, 0x39, 0x0a, 0x33, 0x4f, 0x21, 0x36, 0xe7, 0x8c, 0x5b,
	0xff, 0xd0, 0xa0, 0xa1, 0x4e, 0x7d, 0x76, 0x41, 0xd1, 0x53, 0x78, 0x7c, 0x3a, 0x9d, 0xcf, 0xec,
	0xbe, 0x33, 0x74, 0xec, 0x01, 0xb1, 0x31, 0x76, 0xb1, 0xa1, 0xa1, 0x67, 0x80, 0x7a, 0xdd, 0x01,
	0xf1, 0x70, 0x77, 0x3a, 0x1f, 0xba, 0x78, 0x42, 0x06, 0x5d, 0xaf, 0x6b, 0xe8, 0x68, 0x17, 0x1a,
	0x53, 0xd7, 0x23, 0xce, 0xa4, 0x3b, 0xb2, 0x8d, 0x12, 0x42, 0xd0, 0x92, 0x30, 0x75, 0x4d, 0x21,
	0x65, 0xf4, 0x09, 0xec, 0xa5, 0x77, 0xcf, 0x75, 0xc9, 0xb8, 0x8b, 0x47, 0xb6, 0x51, 0x41, 0x4f,
	0xc0, 0x70, 0xa6, 0xdf, 0x76, 0xc7, 0xce, 0x80, 0xf4, 0xc6, 0x6e, 0x8f, 0xbc, 0xb5, 0xcf, 0x8c,
	0x2a, 0x7a, 0x0c, 0xbb, 0xdd, 0x7e, 0xdf, 0x9e, 0xcf, 0xc9, 0xc0, 0x9e, 0x3a, 0xf6, 0xc0, 0xa8,
	0x49, 0xa0, 0xdb, 0xfb, 0xc6, 0xee, 0x7b, 0x44, 0xc6, 0x19, 0xba, 0xa7, 0xd3, 0x81, 0x51, 0xb7,
	0xfe, 0xac, 0xc1, 0xb3, 0x3b, 0xa5, 0x78, 0xdc, 0x8f, 0x92, 0x25, 0xe3, 0x57, 0xd6, 0x12, 0xca,
	0xde, 0x26, 0xa6, 0x08, 0xa0, 0x8a, 0xed, 0xb9, 0xf3, 0xde, 0x36, 0x34, 0x75, 0x76, 0xbd, 0xae,
	0x67, 0x1b, 0xba, 0x4c, 0xe7, 0xc4, 0xc5, 0xce, 0x7b, 0x77, 0xea, 0x75, 0xc7, 0x64, 0x38, 0x76,
	0x66, 0x46, 0x49, 0x06, 0xfe, 0xd6, 0xc6, 0x9e, 0xd3, 0xcf, 0x45, 0x65, 0x54, 0x87, 0x72, 0x1f,
	0xbb, 0xb3, 0x2c, 0xd7, 0x09, 0x19, 0xda, 0xf6, 0xd8, 0x99, 0x8e, 0xc8, 0xf8, 0xb4, 0xff, 0xf6,
	0xcc, 0xa8, 0x5a, 0x7f, 0x2b, 0x43, 0x63, 0x1b, 0x15, 0x3d, 0x81, 0xca, 0xf7, 0xc1, 0x85, 0xb8,
	0x34, 0xb5, 0xb6, 0xb6, 0x5f, 0xc1, 0xe9, 0x05, 0x3d, 0x83, 0xea, 0x25, 0x0d, 0x56, 0x97, 0xc2,
	0xd4, 0x95, 0x38, 0xbb, 0xa1, 0x57, 0xb0, 0xb3, 0xe0, 0x2c, 0x26, 0x82, 0x91, 0x65, 0x20, 0xcc,
	0x9d, 0xb6, 0xb6, 0x5f, 0x3f, 0xae, 0x2c, 0xfd, 0x30, 0xa1, 0xb8, 0x21, 0x35, 0x1e, 0x1b, 0x06,
	0x02, 0xbd, 0x86, 0x5d, 0x05, 0x63, 0xcb, 0x65, 0x42, 0x05, 0xb9, 0x31, 0x9b, 0x6d, 0x6d, 0x5f,
	0x3f, 0x2e, 0xbd, 0xe9, 0xfc, 0x0a, 0x2b, 0x07, 0xae, 0x52, 0xbc, 0xbb, 0x0f, 0xdc, 0x98, 0xbb,
	0x0f, 0x02, 0xcf, 0xd0, 0x0b, 0xa8, 0x72, 0x26, 0x7c, 0x41, 0xcd, 0x92, 0x4c, 0xe8, 0x58, 0x7b,
	0x83, 0x33, 0x01, 0xea, 0xc0, 0xde, 0x25, 0xe3, 0xc1, 0x1f, 0x59, 0x24, 0xfc, 0x90, 0x2c, 0xc3,
	0x20, 0x36, 0xcb, 0xc5, 0xbc, 0x5a, 0xb7, 0xda, 0x61, 0x18, 0xc4, 0xe8, 0x4b, 0xd8, 0xbd, 0xa6,
	0x5c, 0x04, 0x8b, 0x1c, 0x5d, 0x29, 0xa2, 0x9b, 0xb9, 0x4e, 0x61, 0x3f, 0xcf, 0xea, 0x0d, 0xe9,
	0x52, 0x96, 0x51, 0x55, 0xd9, 0x69, 0x6f, 0xd2, 0x5a, 0xc7, 0x74, 0x29, 0xde, 0xa1, 0x9f, 0x03,
	0x64, 0x2d, 0x89, 0xc9, 0xc6, 0xac, 0xe5, 0x88, 0x7a, 0xda, 0x8d, 0xf8, 0x0c, 0x7d, 0x01, 0x4d,
	0x05, 0xe0, 0xb2, 0x83, 0xe4, 0xc6, 0xac, 0xa7, 0x90, 0x43, 0xac, 0xec, 0xb0, 0x94, 0xbe, 0x43,
	0xaf, 0xb2, 0x46, 0x9c, 0x33, 0x21, 0xd8, 0x15, 0xd9, 0x98, 0x8d, 0x1c, 0xa5, 0x12, 0xe8, 0x29,
	0xf1, 0x19, 0x7a, 0x05, 0xe0, 0xaf, 0x05, 0x0b, 0xe9, 0x35, 0x0d, 0x13, 0x13, 0x8a, 0x89, 0x17,
	0x14, 0xb2, 0x44, 0x3f, 0x0c, 0xd9, 0xf7, 0x24, 0x11, 0x9c, 0x8a, 0xc5, 0xa5, 0xd9, 0xba, 0x53,
	0xa2, 0xd2, 0xcd, 0x53, 0x95, 0xc5, 0xa1, 0xa1, 0x08, 0x39, 0xf0, 0x85, 0x8f, 0x3e, 0x83, 0xda,
	0x82, 0x45, 0x82, 0x46, 0xc2, 0xd4, 0xda, 0xfa, 0x7e, 0xb3, 0xa7, 0xd7, 0x35, 0x9c, 0x8b, 0xd0,
	0x0b, 0xa8, 0x9f, 0x87, 0xec, 0x9c, 0xfc, 0x81, 0x6e, 0x14, 0x2f, 0x1a, 0xb8, 0x26, 0xef, 0x6f,
	0xe9, 0xe6, 0x96, 0x46, 0xa5, 0x87, 0x69, 0x54, 0x2e, 0xd2, 0xc8, 0xfa, 0xb7, 0x0e, 0xbb, 0x4e,
	0x14, 0xaf, 0xc5, 0x9c, 0x0a, 0x11, 0x44, 0xab, 0x04, 0xfd, 0x45, 0x03, 0x73, 0xc1, 0x38, 0xa7,
	0x0b, 0x41, 0xe8, 0x4d, 0xb0, 0x24, 0x8c, 0x07, 0x34, 0x12, 0xbe, 0x08, 0x58, 0xa4, 0xa8, 0xd9,
	0x3a, 0xfa, 0x65, 0x67, 0x3b, 0x11, 0x3a, 0x77, 0x8c, 0x3b, 0x2e, 0x76, 0xec, 0xa9, 0xd7, 0xf5,
	0x1c, 0x77, 0x4a, 0xfa, 0x2e, 0xc6, 0x76, 0x5f, 0x1d, 0xbd, 0xb3, 0x99, 0x7d, 0xfc, 0xf4, 0x74,
	0xda, 0x3f, 0xe9, 0x4e, 0x47, 0xf6, 0x80, 0x14, 0x60, 0xf8, 0x59, 0x16, 0xcc, 0xbe, 0x09, 0x96,
	0xee, 0x6d, 0x28, 0xf4, 0x15, 0xb4, 0x62, 0x9f, 0x27, 0x94, 0x5c, 0x51, 0xe1, 0x5f, 0xf8, 0xc2,
	0x57, 0x85, 0x6e, 0x5b, 0xb7, 0xab, 0x94, 0x93, 0x4c, 0x87, 0x7e, 0x0b, 0x9f, 0x09, 0xf9, 0x25,
	0xc5, 0x3e, 0xa7, 0x91, 0x20, 0xc9, 0xfa, 0x3c, 0x11, 0x81, 0x58, 0x4b, 0x4f, 0x84, 0xaf, 0xce,
	0xb3, 0x66, 0xbc, 0x2c, 0x60, 0xe6, 0x05, 0x08, 0x5e, 0x9d, 0x5b, 0xbf, 0x83, 0x4f, 0xff, 0x47,
	0xf6, 0xe8, 0x05, 0x3c, 0x9c, 0xbf, 0xf1, 0x08, 0x3d, 0x87, 0x4f, 0x32, 0xf4, 0x1d, 0x85, 0x66,
	0xfd, 0x5d, 0x83, 0x96, 0xbb, 0x16, 0xc5, 0xee, 0xda, 0xd0, 0xb8, 0x0a, 0xae, 0x28, 0x11, 0x9b,
	0x98, 0x66, 0xdd, 0xfc, 0xa2, 0xd0, 0xcd, 0xbb, 0xe8, 0xce, 0xc4, 0x99, 0xd8, 0x69, 0xf3, 0x4a,
	0xb3, 0xe9, 0x08, 0xd7, 0xa5, 0xa9, 0x9a, 0x4c, 0x26, 0xd4, 0xbe, 0x5b, 0xfb, 0x61, 0x20, 0x36,
	0xd9, 0x58, 0xc8, 0xaf, 0xd6, 0x3e, 0x34, 0xb6, 0x56, 0xa8, 0x06, 0xd2, 0xce, 0x78, 0x24, 0x27,
	0xd1, 0x37, 0x33, 0x7b, 0x64, 0x68, 0xf2, 0xf4, 0x7b, 0xbb, 0x37, 0x33, 0x74, 0xeb, 0x3f, 0xdb,
	0x01, 0xb8, 0x9d, 0x41, 0x98, 0x7e, 0xb7, 0xa6, 0x89, 0x40, 0x5f, 0x42, 0x45, 0x6d, 0x02, 0x45,
	0xbd, 0x9d, 0xa3, 0x27, 0xc5, 0xf7, 0xce, 0x19, 0x8a, 0x53, 0x08, 0x3a, 0x82, 0x86, 0xc8, 0xed,
	0x4d, 0xbd, 0x5d, 0xba, 0x87, 0xbf, 0xf5, 0x7d, 0x0b, 0x43, 0x87, 0x50, 0x65, 0xaa, 0x52, 0xb3,
	0xa4, 0x02, 0xbc, 0xf8, 0xc1, 0x16, 0xe0, 0x0c, 0x88, 0x3a, 0x50, 0x09, 0x24, 0xd5, 0x14, 0x7f,
	0x77, 0x8e, 0xcc, 0x1f, 0xa2, 0x20, 0x4e, 0x61, 0x56, 0x04, 0xcf, 0x3f, 0x28, 0x2e, 0x89, 0x59,
	0x94, 0xd0, 0x9f, 0x54, 0xdd, 0x6b, 0xd8, 0x4b, 0xd8, 0x9a, 0x2f, 0xee, 0xd1, 0xb0, 0x81, 0x5b,
	0xa9, 0x38, 0x27, 0xa0, 0xf5, 0x2f, 0x1d, 0x9e, 0xf6, 0xd9, 0x55, 0xcc, 0x92, 0x40, 0x50, 0xe5,
	0xc6, 0x8d, 0x25, 0xb5, 0x12, 0xf4, 0x39, 0x34, 0x33, 0x17, 0x41, 0x74, 0x41, 0x6f, 0x54, 0xd4,
	0x0a, 0xde, 0x49, 0x65, 0x8e, 0x14, 0xc9, 0xcf, 0xf9, 0x26, 0x9b, 0xbc, 0xa6, 0xae, 0xd4, 0xb5,
	0x9b, 0x74, 0xde, 0x4a, 0xd5, 0x26, 0x57, 0x95, 0x52, 0xd5, 0x26, 0x53, 0x99, 0x50, 0x63, 0xb1,
	0xbf, 0x90, 0x24, 0x28, 0xb7, 0xf5, 0x7d, 0x1d, 0xe7, 0x57, 0xf4, 0x35, 0x54, 0xfd, 0x68, 0x71,
	0xc9, 0xb8, 0x59, 0x69, 0xeb, 0xfb, 0xad, 0xa3, 0xd7, 0x85, 0x12, 0x1f, 0x4c, 0xb2, 0xd3, 0x9d,
	0xf6, 0x4f, 0x5c, 0x8c, 0x33, 0x33, 0xeb, 0x4f, 0x50, 0x4d, 0x25, 0xa8, 0x09, 0x75, 0xcf, 0x9d,
	0x91, 0xb1, 0x3d, 0xf4, 0x8c, 0x47, 0x92, 0x50, 0x9e, 0x3b, 0x33, 0x34, 0xb9, 0xb4, 0xa5, 0x18,
	0x3b, 0xa3, 0x13, 0xcf, 0xd0, 0x25, 0xab, 0x14, 0xa2, 0x24, 0xf7, 0x64, 0xdf, 0x9e, 0x7a, 0x36,
	0x36, 0xca, 0xa8, 0x01, 0x95, 0x14, 0x50, 0x41, 0x7b, 0xb0, 0xd3, 0x73, 0x3d, 0xcf, 0x9d, 0xa4,
	0x9e, 0xaa, 0x12, 0x97, 0x0a, 0x8c, 0x1a, 0x32, 0xa0, 0x99, 0x29, 0x53, 0x78, 0xdd, 0xfa, 0xab,
	0x06, 0xcd, 0xf4, 0xf9, 0xfa, 0x7e, 0x74, 0xed, 0x27, 0xc5, 0xe5, 0xa8, 0x3f, 0xbc, 0x1c, 0xf5,
	0xc2, 0x72, 0xfc, 0x08, 0x7e, 0x99, 0x50, 0x59, 0xb0, 0x90, 0xf1, 0x74, 0x3e, 0x1e, 0xeb, 0xbf,
	0x38, 0xc4, 0xa9, 0x40, 0xfe, 0xb9, 0xc9, 0xbe, 0x93, 0x6d, 0xeb, 0x1e, 0xf8, 0x4e, 0x4a, 0x3f,
	0xc6, 0xa4, 0x63, 0xf9, 0x5a, 0xaa, 0xd9, 0xd9, 0x57, 0xd2, 0xfe, 0xb1, 0x47, 0xc1, 0xb9, 0x01,
	0x3a, 0x80, 0xea, 0x42, 0xf5, 0x21, 0xab, 0xe7, 0xf9, 0xfd, 0x40, 0x59, 0x9b, 0x70, 0x06, 0xb3,
	0xec, 0x9c, 0xfd, 0x85, 0x94, 0x7f, 0x3a, 0xfb, 0xad, 0x41, 0x5e, 0xf9, 0x49, 0x90, 0x08, 0xb6,
	0xe2, 0xfe, 0xc7, 0x4c, 0x08, 0x6b, 0x02, 0x7b, 0xf7, 0xbc, 0x20, 0x03, 0x4a, 0x9c, 0x5e, 0xa8,
	0xb6, 0x55, 0xb0, 0x3c, 0xca, 0x07, 0x5e, 0x71, 0x4a, 0x23, 0xd5, 0x9c, 0x0a, 0x4e, 0x2f, 0x08,
	0x41, 0xf9, 0x3c, 0x5c, 0xcb, 0xbf, 0x1a, 0x52, 0xa8, 0xce, 0xd6, 0x3c, 0xaf, 0xad, 0x90, 0x54,
	0x56, 0xdb, 0x6f, 0xa0, 0x71, 0x99, 0x0b, 0xb3, 0xcc, 0x5e, 0x7e, 0xd0, 0xaa, 0x5b, 0xb3, 0x5b,
	0xb0, 0xb5, 0xca, 0x9d, 0x8e, 0xa8, 0x38, 0xe5, 0x61, 0xcf, 0x4f, 0xb6, 0x8f, 0x5c, 0xdc, 0xb5,
	0xd2, 0x67, 0x61, 0xd7, 0x1e, 0xc2, 0xe3, 0x05, 0xa7, 0xbe, 0xa0, 0x24, 0xa1, 0x8b, 0x35, 0xa7,
	0x64, 0xcd, 0xc3, 0xbb, 0x6b, 0x6a, 0x2f, 0xd5, 0xcf, 0x95, 0xfa, 0x94, 0x87, 0xd6, 0x57, 0x60,
	0x7e, 0x18, 0x28, 0x4b, 0xdf, 0x80, 0x92, 0x74, 0x90, 0x06, 0x91, 0x47, 0xeb, 0xd7, 0xf0, 0x32,
	0x45, 0x0f, 0x68, 0x48, 0x05, 0xfd, 0xbf, 0x33, 0xb3, 0x7e, 0x06, 0x9f, 0x3e, 0x68, 0x98, 0x46,
	0xea, 0xd5, 0xde, 0xa7, 0x6f, 0xf3, 0xdf, 0x00, 0x00, 0x00, 0xff, 0xff, 0xfa, 0x74, 0x30, 0x89,
	0x1d, 0x0c, 0x00, 0x00,
}
