/***************************************************************************
 *   Copyright (C) 2004 by EVER Sp. z o.o.                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _IOCTLDEF_H_
#define _IOCTLDEF_H_

#include <unistd.h>

/* General library control function */
typedef int (*LPFNIOCTL)(long lCommand, void *lpvBuff, int *lpibuffsize);


/*
 * Error codes
 */

/* No error - success */
#define IOCTL_ERROR_SUCCESS						(  0 )
/* General error */
#define IOCTL_ERROR								( -1 )
/* critical error - program termination */
#define IOCTL_CRITICAL_ERROR					( -2 )
/* One or more specified arguments is not acceptable. */
#define IOCTL_ERROR_INVALIDARGUMENT				( -3 )
/* Specified command is not supported by this driver. */
#define IOCTL_ERROR_CMD_NOTSUPPORTED			( -4 )
/* Not enough memory. */
#define IOCTL_ERROR_MEMALLOC					( -5 )
/* Buffer size pointed by lpibuffsize is too small. */
#define IOCTL_ERROR_BUFFER_TOOSMALL				(-10 )
/* if driver communication options wasn't yet configured */
#define IOCTL_ERROR_NOTYETCONFIGURED			(-12 )
/* if driver communication wasn't yet initialized */
#define IOCTL_ERROR_NOTYETINITIALIZED			(-13 )
/* if driver cannot configure serial port using DCB and COMMTIMEOUTS */
#define IOCTL_ERROR_CONFIGURATIONFAIL			(-14 )
/* if driver is already initialized by other instance */
#define IOCTL_ERROR_ALREADYINITIALIZED			(-15 )
/* no communication with ups */
#define IOCTL_ERROR_COMM_LINKFAIL				(-40 )
/* communication with ups terminated */
#define IOCTL_ERROR_COMM_LINKTERMINATED			(-41 )

/* additional error codes valid only when IOCTL_ERROR error occured */
/* serial port initialization failed */
#define IOCTL_ERROR_COMM_INITFAIL				(-100 )
#define IOCTL_ERROR_COMM_INITCFGFAIL			(-101 )
/* serial port configuration failed */
#define IOCTL_ERROR_COMM_CONFIGFAIL				(-102 )
/* UPS tables reading fail */
#define IOCTL_ERROR_COMM_READTABLES				(-103 )
/* config file write fail */
#define IOCTL_ERROR_CONFIG_WRITEFAIL			(-110 )
/* config file read fail */
#define IOCTL_ERROR_CONFIG_READFAIL				(-111 )

/* additional error codes valid only when IOCTL_ERROR_COMM_LINKFAIL error occured */
/* no D0 code */
#define IOCTL_ERROR_COMM_INVALIDCODE			(-401 )
/* invalid frame start code - no 1F */
#define IOCTL_ERROR_COMM_INVALIDFRAME			(-402 )
/* invalid checksum - CRC */
#define IOCTL_ERROR_COMM_INVALIDCRC				(-403 )
/* invalid frame length */
#define IOCTL_ERROR_COMM_INVALIDLENGTH			(-404 )
#define IOCTL_ERROR_COMM_FAILTOSEND				(-405 )
#define IOCTL_ERROR_COMM_FAILTORECEIVE			(-406 )
/* Nieprawidowa ilo bajtw w ramce */
#define IOCTL_ERROR_COMM_BADFRAMELENGTH			(-407 )
/* Nieznany typ rozkazu */
#define IOCTL_ERROR_COMM_UNKNOWNCOMMANDTYPE		(-408 )
/* Nieznany rozkaz */
#define IOCTL_ERROR_COMM_UNKNOWNCOMMAND			(-409 )
/* Bd CRC */
#define IOCTL_ERROR_COMM_BADCRC					(-410 )
/* Data integrity error */
#define IOCTL_ERROR_COMM_DATAINTEGRITY			(-411 )


/* 
 * IOCTL Commands
 */
#define IOCTL_INIT						0x0001
#define IOCTL_UNINIT					0x0002
#define IOCTL_AUTOCONFIGURE				0x0003
#define IOCTL_CONFIGURE					0x0004

/* _sups_info_ structure manipulation */
#define IOCTL_GET_UPSINFOMASK			0x0005
#define IOCTL_SET_UPSINFOMASK			0x0006

/* ups state manipulation */
#define IOCTL_GET_UPSSTATESMASK			0x0007
#define IOCTL_SET_UPSSTATESMASK			0x0008
#define IOCTL_GET_UPSSTATE				0x0009

/* _sups_parameters_ & _sups_setup_parameters_ structures manipulation */
#define IOCTL_GET_UPSPARAMSMASK			0x000A
#define IOCTL_SET_UPSPARAMSMASK			0x000B
#define IOCTL_GET_UPSPARAMS				0x000C
#define IOCTL_GET_UPSSETUPPARAMSMASK	0x000D
#define IOCTL_SET_UPSSETUPPARAMSMASK	0x000E
#define IOCTL_GET_UPSSETUPPARAMS		0x000F
#define IOCTL_SET_UPSSETUPPARAMS		0x0010

/* _sups_characteristic structure manipulation */
#define IOCTL_GET_UPSCHARACTERISTICMASK	0x0011
#define IOCTL_GET_UPSCHARACTERISTIC		0x0012

/* _sdrv_info_ structure manipulation */
#define IOCTL_GET_DRIVER_INFO			0x0013
/* test communication */
#define IOCTL_TESTUPSLINK				0x0015
#define IOCTL_TESTUPSLINK2				0x0016

/* verify if configuration has been written successfully */
#define IOCTL_VERIFYCONFIG				0x0020

/* get specified table - unofficial */
#define IOCTL_GET_TABLE_INFORMATIONS	0x0040
#define IOCTL_GET_TABLE_SETUP			0x0041
#define IOCTL_GET_TABLE_SPECIAL			0x0042
#define IOCTL_GET_TABLE_HARDWARE		0x0043
#define IOCTL_GET_TABLE_CHARACTERISTICS	0x0044

/* get extended error info */
#define IOCTL_GET_ERRORNO				0x0080

#define IOCTL_GETCONFIGPARAMSCOUNT		0x0081
#define IOCTL_GETCONFIGPARAMS			0x0082
#define IOCTL_GETCONFIGPARAM			0x0083
#define IOCTL_SETCONFIGPARAMS			0x0084
#define IOCTL_SETCONFIGPARAM			0x0085
#define IOCTL_UPDATECONFIG				0x0086
#define IOCTL_SHUTDOWNUPS				0x0087

/* get actual driver mode: 0:master or 1:slave */
#define IOCTL_GETDRIVERMODE				0x0090

/* !2005 version! - get additional parameters */
#define IOCTL_GET_UPSEXTPARAMS_COUNT	0x00B0
#define IOCTL_GET_UPSEXTPARAMS			0x00B1

/* !2005 version! - get ups statistics */
#define IOCTL_GET_UPSSTATISTICSCOUNT	0x00B2
#define IOCTL_GET_UPSSTATISTICS			0x00B3

//////////////////////////////////////////////////////
// Bear in mind to always define it, because it is	//
// not available in Windows.						//
//////////////////////////////////////////////////////
#define IOCTL_GETCONFIGFILENAME			0x00F0

/* additional status definitions */
#define DRV_MODE_MASTER					1
#define DRV_MODE_SLAVE					0

/* !2005 version! - statistics data */
#define STAT_NAME_MAX					0x100
#define STAT_VALUE_SIZE					sizeof(UINT)

typedef struct tagStatistic {
	// Statistic item name
	char statName[STAT_NAME_MAX];
	// Statistic item value
	unsigned int value;
}STATISTIC, *LPSTATISTIC;

#endif /*_IOCTLDEF_H_*/
