/***************************************************************************
 *   Property rights (C) 2004-2006 by EVER Sp. z o.o.                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef UPSINTS_H
#define UPSINTS_H

#include "ioctldef.h"
/*
 * Include all available UPS interfaces
 */

/* SINLINE CDS series - RS232 */
#include "sinline.h"
/* SINLINE CDS series - USB */
#include "sinline_usb.h"
/* SINLINE XL series - RS232 */
#include "sinlinexl.h"
/* SINLINE XL series - USB */
#include "sinlinexl_usb.h"
/* ECO Pro CDS series - USB-FTDI */
#include "ecoprocds.h"
/* ECO Pro series - RS232 */
#include "ecopro.h"
/* DUO Pro series - RS232 */
#include "duopro.h"
/* Net 3000 series - RS232 */
#include "net3000.h"
/* Net series - RS232 */
#include "net.h"
/* Sinline XL series - SNMP Card */
//#include "snmp.h"

/* 
 * UPS interfaces 
 * used to declare available UPS drivers
 * also remember to include new driver in upsints.h
 */
struct _upsint_ {
	/* the name of the ups - configured in psplus.conf file */
	char	*ups_name;
	/* pointer to a control function */
	LPFNIOCTL	fnctl;
} ups_interface[] = {
	{ "sinlinexl", sinlinexl_ioctl },
	{ "sinlinexl_usb", sinlinexlusb_ioctl },
	{ "sinlinepro", sinlinexl_ioctl },
	{ "sinlinepro_usb", sinlinexlusb_ioctl },
	{ "sinline", sinline_ioctl },
	{ "sinline_usb", sinlineusb_ioctl },
	{ "duopro", duopro_ioctl },
	{ "ecopro", ecopro_ioctl },
	{ "ecopro_usb", ecoprocds_ioctl },
	{ "net3000", net3k_ioctl },
	{ "netstd", net_ioctl },
//	{ "snmpcard", snmp_ioctl },
	{ 0, NULL }
};

#endif/*UPSINTS_H*/
