/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.xml;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.xml.Lexer;
import org.jetbrains.letsPlot.commons.xml.Parser;
import org.jetbrains.letsPlot.commons.xml.Token;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\n"}, d2={"Lorg/jetbrains/letsPlot/commons/xml/Xml;", "", "()V", "parse", "Lorg/jetbrains/letsPlot/commons/xml/Xml$XmlNode;", "xml", "", "parseSafe", "Lkotlin/Pair;", "XmlNode", "commons"})
public final class Xml {
    @NotNull
    public static final Xml INSTANCE = new Xml();

    private Xml() {
    }

    @NotNull
    public final XmlNode parse(@NotNull String xml) {
        Intrinsics.checkNotNullParameter((Object)xml, (String)"xml");
        Lexer lexer = new Lexer(xml);
        Parser parser = new Parser(lexer);
        return parser.parse();
    }

    @NotNull
    public final Pair<XmlNode, String> parseSafe(@NotNull String xml) {
        Pair pair2;
        Intrinsics.checkNotNullParameter((Object)xml, (String)"xml");
        Lexer lexer = new Lexer(xml);
        Parser parser = new Parser(lexer);
        XmlNode doc = parser.parse();
        if (Intrinsics.areEqual((Object)Token.Companion.getEOF(), (Object)lexer.nextToken())) {
            pair2 = TuplesKt.to((Object)doc, (Object)"");
        } else {
            String string = lexer.getInput().substring(lexer.getTokenPos());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            pair2 = TuplesKt.to((Object)doc, (Object)string);
        }
        return pair2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/letsPlot/commons/xml/Xml$XmlNode;", "", "()V", "Element", "Text", "Lorg/jetbrains/letsPlot/commons/xml/Xml$XmlNode$Element;", "Lorg/jetbrains/letsPlot/commons/xml/Xml$XmlNode$Text;", "commons"})
    public static abstract class XmlNode {
        private XmlNode() {
        }

        public /* synthetic */ XmlNode(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007H\u00c6\u0003J9\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/letsPlot/commons/xml/Xml$XmlNode$Element;", "Lorg/jetbrains/letsPlot/commons/xml/Xml$XmlNode;", "name", "", "attributes", "", "children", "", "(Ljava/lang/String;Ljava/util/Map;Ljava/util/List;)V", "getAttributes", "()Ljava/util/Map;", "getChildren", "()Ljava/util/List;", "getName", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "commons"})
        public static final class Element
        extends XmlNode {
            @NotNull
            private final String name;
            @NotNull
            private final Map<String, String> attributes;
            @NotNull
            private final List<XmlNode> children;

            public Element(@NotNull String name, @NotNull Map<String, String> attributes2, @NotNull List<? extends XmlNode> children2) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter(attributes2, (String)"attributes");
                Intrinsics.checkNotNullParameter(children2, (String)"children");
                super(null);
                this.name = name;
                this.attributes = attributes2;
                this.children = children2;
            }

            public /* synthetic */ Element(String string, Map map2, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    map2 = MapsKt.emptyMap();
                }
                if ((n & 4) != 0) {
                    list2 = CollectionsKt.emptyList();
                }
                this(string, map2, list2);
            }

            @NotNull
            public final String getName() {
                return this.name;
            }

            @NotNull
            public final Map<String, String> getAttributes() {
                return this.attributes;
            }

            @NotNull
            public final List<XmlNode> getChildren() {
                return this.children;
            }

            @NotNull
            public final String component1() {
                return this.name;
            }

            @NotNull
            public final Map<String, String> component2() {
                return this.attributes;
            }

            @NotNull
            public final List<XmlNode> component3() {
                return this.children;
            }

            @NotNull
            public final Element copy(@NotNull String name, @NotNull Map<String, String> attributes2, @NotNull List<? extends XmlNode> children2) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter(attributes2, (String)"attributes");
                Intrinsics.checkNotNullParameter(children2, (String)"children");
                return new Element(name, attributes2, children2);
            }

            public static /* synthetic */ Element copy$default(Element element, String string, Map map2, List list2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = element.name;
                }
                if ((n & 2) != 0) {
                    map2 = element.attributes;
                }
                if ((n & 4) != 0) {
                    list2 = element.children;
                }
                return element.copy(string, map2, list2);
            }

            @NotNull
            public String toString() {
                return "Element(name=" + this.name + ", attributes=" + this.attributes + ", children=" + this.children + ')';
            }

            public int hashCode() {
                int result2 = this.name.hashCode();
                result2 = result2 * 31 + ((Object)this.attributes).hashCode();
                result2 = result2 * 31 + ((Object)this.children).hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Element)) {
                    return false;
                }
                Element element = (Element)other;
                if (!Intrinsics.areEqual((Object)this.name, (Object)element.name)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.attributes, element.attributes)) {
                    return false;
                }
                return Intrinsics.areEqual(this.children, element.children);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/letsPlot/commons/xml/Xml$XmlNode$Text;", "Lorg/jetbrains/letsPlot/commons/xml/Xml$XmlNode;", "content", "", "(Ljava/lang/String;)V", "getContent", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "commons"})
        public static final class Text
        extends XmlNode {
            @NotNull
            private final String content;

            public Text(@NotNull String content) {
                Intrinsics.checkNotNullParameter((Object)content, (String)"content");
                super(null);
                this.content = content;
            }

            @NotNull
            public final String getContent() {
                return this.content;
            }

            @NotNull
            public final String component1() {
                return this.content;
            }

            @NotNull
            public final Text copy(@NotNull String content) {
                Intrinsics.checkNotNullParameter((Object)content, (String)"content");
                return new Text(content);
            }

            public static /* synthetic */ Text copy$default(Text text2, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = text2.content;
                }
                return text2.copy(string);
            }

            @NotNull
            public String toString() {
                return "Text(content=" + this.content + ')';
            }

            public int hashCode() {
                return this.content.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Text)) {
                    return false;
                }
                Text text2 = (Text)other;
                return Intrinsics.areEqual((Object)this.content, (Object)text2.content);
            }
        }
    }
}

