/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile;

import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.nodejs.run.profile.heap.IndexFiles;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CategoryIndexFiles<T extends Enum>
implements IndexFiles<T> {
    private final Map<T, List<File>> myFilesMap;
    private final Object myLock;
    private final File myRootDir;

    public CategoryIndexFiles(File rootDir) {
        this.myRootDir = rootDir;
        this.myLock = new Object();
        this.myFilesMap = new HashMap<T, List<File>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<T, List<File>> getFilesMap() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myFilesMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Map<T, List<File>> map) {
        Object object = this.myLock;
        synchronized (object) {
            this.myFilesMap.putAll(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<File> getFiles(T category) {
        Object object = this.myLock;
        synchronized (object) {
            return this.myFilesMap.get(category);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getOneFile(T category) throws IOException {
        List<File> files;
        Object object = this.myLock;
        synchronized (object) {
            files = this.myFilesMap.get(category);
        }
        if (files.size() != 1) {
            throw new IOException("Wrong number of index files of type: " + String.valueOf(category));
        }
        return files.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File generate(@NotNull T category, @Nullable String postfix) throws IOException {
        if (category == null) {
            CategoryIndexFiles.$$$reportNull$$$0(0);
        }
        File file = FileUtil.createTempFile((File)this.myRootDir, (String)"v8", (String)postfix, (boolean)true, (boolean)false);
        Object object = this.myLock;
        synchronized (object) {
            List<File> list = this.myFilesMap.get(category);
            if (list == null) {
                list = new ArrayList<File>();
                this.myFilesMap.put(category, list);
            }
            list.add(file);
        }
        return file;
    }

    @Override
    public void close() throws IOException {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/jetbrains/nodejs/run/profile/CategoryIndexFiles", "generate"));
    }
}

