/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.chat;

import dev.langchain4j.Experimental;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.exception.UnsupportedFeatureException;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.chat.Capability;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.listener.ListenersUtil;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.ResponseFormat;
import dev.langchain4j.model.chat.request.ResponseFormatType;
import dev.langchain4j.model.chat.request.ToolChoice;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.ChatResponseMetadata;
import dev.langchain4j.model.output.Response;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public interface ChatLanguageModel {
    @Experimental
    default public ChatResponse chat(ChatRequest chatRequest) {
        ChatRequest finalChatRequest = ChatRequest.builder().messages(chatRequest.messages()).parameters(this.defaultRequestParameters().overrideWith(chatRequest.parameters())).build();
        List<ChatModelListener> listeners = this.listeners();
        ConcurrentHashMap<Object, Object> attributes = new ConcurrentHashMap<Object, Object>();
        ListenersUtil.onRequest(finalChatRequest, attributes, listeners);
        try {
            ChatResponse chatResponse = this.doChat(finalChatRequest);
            ListenersUtil.onResponse(chatResponse, finalChatRequest, attributes, listeners);
            return chatResponse;
        }
        catch (Exception error) {
            ListenersUtil.onError(error, finalChatRequest, attributes, listeners);
            throw error;
        }
    }

    @Experimental
    default public String chat(String userMessage) {
        ChatRequest chatRequest = ChatRequest.builder().messages(UserMessage.from(userMessage)).build();
        ChatResponse chatResponse = this.chat(chatRequest);
        return chatResponse.aiMessage().text();
    }

    @Experimental
    default public ChatResponse chat(ChatMessage ... messages) {
        ChatRequest chatRequest = ChatRequest.builder().messages(messages).build();
        return this.chat(chatRequest);
    }

    @Experimental
    default public ChatResponse chat(List<ChatMessage> messages) {
        ChatRequest chatRequest = ChatRequest.builder().messages(messages).build();
        return this.chat(chatRequest);
    }

    default public List<ChatModelListener> listeners() {
        return Collections.emptyList();
    }

    @Experimental
    default public ChatResponse doChat(ChatRequest chatRequest) {
        Response<AiMessage> response;
        ChatRequestParameters parameters = chatRequest.parameters();
        ChatLanguageModel.validate(parameters);
        ChatLanguageModel.validate(parameters.toolChoice());
        ChatLanguageModel.validate(parameters.responseFormat());
        List<ToolSpecification> toolSpecifications = parameters.toolSpecifications();
        if (Utils.isNullOrEmpty(toolSpecifications)) {
            response = this.generate(chatRequest.messages());
        } else if (parameters.toolChoice() == ToolChoice.REQUIRED) {
            if (toolSpecifications.size() != 1) {
                throw new UnsupportedFeatureException(String.format("%s.%s is currently supported only when there is a single tool", ToolChoice.class.getSimpleName(), ToolChoice.REQUIRED.name()));
            }
            response = this.generate(chatRequest.messages(), toolSpecifications.get(0));
        } else {
            response = this.generate(chatRequest.messages(), toolSpecifications);
        }
        return ChatResponse.builder().aiMessage(response.content()).metadata(((ChatResponseMetadata.Builder)((ChatResponseMetadata.Builder)ChatResponseMetadata.builder().tokenUsage(response.tokenUsage())).finishReason(response.finishReason())).build()).build();
    }

    public static void validate(ChatRequestParameters parameters) {
        String errorTemplate = "%s is not supported yet by this model provider";
        if (parameters.modelName() != null) {
            throw new UnsupportedFeatureException(String.format(errorTemplate, "'modelName' parameter"));
        }
        if (parameters.temperature() != null) {
            throw new UnsupportedFeatureException(String.format(errorTemplate, "'temperature' parameter"));
        }
        if (parameters.topP() != null) {
            throw new UnsupportedFeatureException(String.format(errorTemplate, "'topP' parameter"));
        }
        if (parameters.topK() != null) {
            throw new UnsupportedFeatureException(String.format(errorTemplate, "'topK' parameter"));
        }
        if (parameters.frequencyPenalty() != null) {
            throw new UnsupportedFeatureException(String.format(errorTemplate, "'frequencyPenalty' parameter"));
        }
        if (parameters.presencePenalty() != null) {
            throw new UnsupportedFeatureException(String.format(errorTemplate, "'presencePenalty' parameter"));
        }
        if (parameters.maxOutputTokens() != null) {
            throw new UnsupportedFeatureException(String.format(errorTemplate, "'maxOutputTokens' parameter"));
        }
        if (parameters.stopSequences() != null) {
            throw new UnsupportedFeatureException(String.format(errorTemplate, "'stopSequences' parameter"));
        }
    }

    public static void validate(ToolChoice toolChoice) {
        if (toolChoice == ToolChoice.REQUIRED) {
            throw new UnsupportedFeatureException(String.format("%s.%s is not supported yet by this model provider", ToolChoice.class.getSimpleName(), ToolChoice.REQUIRED.name()));
        }
    }

    public static void validate(ResponseFormat responseFormat) {
        String errorTemplate = "%s is not supported yet by this model provider";
        if (responseFormat != null && responseFormat.type() == ResponseFormatType.JSON) {
            throw new UnsupportedFeatureException(String.format(errorTemplate, "JSON response format"));
        }
    }

    @Experimental
    default public ChatRequestParameters defaultRequestParameters() {
        return ChatRequestParameters.builder().build();
    }

    @Experimental
    default public Set<Capability> supportedCapabilities() {
        return Set.of();
    }

    @Deprecated(forRemoval=true)
    default public String generate(String userMessage) {
        return this.generate(UserMessage.from(userMessage)).content().text();
    }

    @Deprecated(forRemoval=true)
    default public Response<AiMessage> generate(ChatMessage ... messages) {
        return this.generate(Arrays.asList(messages));
    }

    @Deprecated(forRemoval=true)
    public Response<AiMessage> generate(List<ChatMessage> var1);

    @Deprecated(forRemoval=true)
    default public Response<AiMessage> generate(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications) {
        throw new UnsupportedFeatureException("tools are currently not supported by " + this.getClass().getSimpleName());
    }

    @Deprecated(forRemoval=true)
    default public Response<AiMessage> generate(List<ChatMessage> messages, ToolSpecification toolSpecification) {
        throw new UnsupportedFeatureException("tools and tool choice are currently not supported by " + this.getClass().getSimpleName());
    }
}

