/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.statistic;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceSshTunnelConfiguration;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DdlMappingsManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.SchemaControl;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.model.ModelExternalData;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.statistic.IntrospectionLevelStat;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternEntryKey;
import com.intellij.database.util.TreePatternFun;
import com.intellij.database.util.TreePatternNode;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.IntEventField;
import com.intellij.internal.statistic.eventLog.events.NullableEnumEventField;
import com.intellij.internal.statistic.eventLog.events.PrimitiveEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.lang.Language;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.toolWindow.EnableStripeGroup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NavigableMap;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseUsagesCollectors {
    private static String lowerEnumName(Enum<?> v) {
        return StringUtil.toLowerCase((String)v.name());
    }

    public static final class DbmsValidationRule
    extends CustomValidationRule {
        public static final String ID = "dbms";

        @NotNull
        public String getRuleId() {
            return ID;
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String data, @NotNull EventContext context) {
            boolean safe2;
            Dbms dbms;
            if (data == null) {
                DbmsValidationRule.$$$reportNull$$$0(0);
            }
            if (context == null) {
                DbmsValidationRule.$$$reportNull$$$0(1);
            }
            if ((dbms = Dbms.byName((String)data)) == null) {
                ValidationResultType validationResultType = ValidationResultType.REJECTED;
                if (validationResultType == null) {
                    DbmsValidationRule.$$$reportNull$$$0(2);
                }
                return validationResultType;
            }
            boolean bl = safe2 = Dbms.isPredefined((Dbms)dbms) || PluginInfoDetectorKt.getPluginInfoByDescriptor((PluginDescriptor)Dbms.getPluginDescriptor((Dbms)dbms)).isSafeToReport();
            if (safe2) {
                ValidationResultType validationResultType = ValidationResultType.ACCEPTED;
                if (validationResultType == null) {
                    DbmsValidationRule.$$$reportNull$$$0(3);
                }
                return validationResultType;
            }
            ValidationResultType validationResultType = ValidationResultType.THIRD_PARTY;
            if (validationResultType == null) {
                DbmsValidationRule.$$$reportNull$$$0(4);
            }
            return validationResultType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/statistic/DatabaseUsagesCollectors$DbmsValidationRule";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/statistic/DatabaseUsagesCollectors$DbmsValidationRule";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doValidate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doValidate";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }

    public static class DbmsEventField
    extends PrimitiveEventField<Dbms> {
        private final String myName;

        public DbmsEventField(@NotNull String name2) {
            if (name2 == null) {
                DbmsEventField.$$$reportNull$$$0(0);
            }
            this.myName = name2;
        }

        @NotNull
        public List<String> getValidationRule() {
            List<String> list = Arrays.asList("{util#dbms}", "{enum:" + StringUtil.join((Collection)Dbms.allValues(), Dbms::getName, (String)"|") + "}");
            if (list == null) {
                DbmsEventField.$$$reportNull$$$0(1);
            }
            return list;
        }

        public void addData(@NotNull FeatureUsageData fuData, Dbms value) {
            if (fuData == null) {
                DbmsEventField.$$$reportNull$$$0(2);
            }
            if (value != null) {
                fuData.addData(this.getName(), value.getName());
            }
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                DbmsEventField.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/statistic/DatabaseUsagesCollectors$DbmsEventField";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fuData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/statistic/DatabaseUsagesCollectors$DbmsEventField";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValidationRule";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "addData";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 3 -> new IllegalStateException(string);
            };
        }
    }

    public static final class SettingsState
    extends ApplicationUsagesCollector {
        private static final EventLogGroup GROUP = new EventLogGroup("db.settings", 2);
        private static final DatabaseSettings.ExecOption DEFAULT_EXEC_OPTION = new DatabaseSettings.ExecOption();
        private final IntEventField INDEX = EventFields.Int((String)"index");
        private final BooleanEventField NEW_TAB = EventFields.Boolean((String)"new_tab");
        private final NullableEnumEventField<InsideOption> INSIDE = EventFields.NullableEnum((String)"inside", InsideOption.class, null, DatabaseUsagesCollectors::lowerEnumName);
        private final NullableEnumEventField<OutsideOption> OUTSIDE = EventFields.NullableEnum((String)"outside", OutsideOption.class, null, DatabaseUsagesCollectors::lowerEnumName);
        private final NullableEnumEventField<SelectionOption> SELECTION = EventFields.NullableEnum((String)"selection", SelectionOption.class, null, DatabaseUsagesCollectors::lowerEnumName);
        private final VarargEventId EXEC_OPTION_EVENT = GROUP.registerVarargEvent("exec_option", new EventField[]{this.INDEX, this.NEW_TAB, this.INSIDE, this.OUTSIDE, this.SELECTION});

        public EventLogGroup getGroup() {
            return GROUP;
        }

        @NotNull
        public Set<MetricEvent> getMetrics() {
            LinkedHashSet<MetricEvent> metrics = new LinkedHashSet<MetricEvent>();
            List execOptions = DatabaseSettings.getSettings().execOptions;
            for (int i = 0; i < execOptions.size(); ++i) {
                DatabaseSettings.ExecOption execOption = (DatabaseSettings.ExecOption)execOptions.get(i);
                if (DEFAULT_EXEC_OPTION.equals((Object)execOption)) continue;
                ArrayList<EventPair> pairs = new ArrayList<EventPair>();
                pairs.add(this.INDEX.with((Object)(i + 1)));
                if (SettingsState.DEFAULT_EXEC_OPTION.newTab != execOption.newTab) {
                    pairs.add(this.NEW_TAB.with((Object)execOption.newTab));
                }
                if (SettingsState.DEFAULT_EXEC_OPTION.execInside != execOption.execInside) {
                    pairs.add(this.INSIDE.with((Object)((InsideOption)this.find(InsideOption.values(), execOption.execInside))));
                }
                if (SettingsState.DEFAULT_EXEC_OPTION.execOutside != execOption.execOutside) {
                    pairs.add(this.OUTSIDE.with((Object)((OutsideOption)this.find(OutsideOption.values(), execOption.execOutside))));
                }
                if (SettingsState.DEFAULT_EXEC_OPTION.execSelection != execOption.execSelection) {
                    pairs.add(this.SELECTION.with((Object)((SelectionOption)this.find(SelectionOption.values(), execOption.execSelection))));
                }
                metrics.add(this.EXEC_OPTION_EVENT.metric(pairs));
            }
            LinkedHashSet<MetricEvent> linkedHashSet = metrics;
            if (linkedHashSet == null) {
                SettingsState.$$$reportNull$$$0(0);
            }
            return linkedHashSet;
        }

        @Nullable
        <T extends Option> T find(T @NotNull [] options, int value) {
            if (options == null) {
                SettingsState.$$$reportNull$$$0(1);
            }
            for (T option : options) {
                if (option.getValue() != value) continue;
                return option;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/statistic/DatabaseUsagesCollectors$SettingsState";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "options";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMetrics";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/statistic/DatabaseUsagesCollectors$SettingsState";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "find";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }

        private static enum InsideOption implements Option
        {
            SHOW_CHOOSER(1),
            SUBQUERY(2),
            SMALLEST(3),
            LARGEST(4),
            BATCH(5),
            WHOLE_SCRIPT(6),
            SCRIPT_TAIL(7);

            final int value;

            private InsideOption(int value) {
                this.value = value;
            }

            @Override
            public int getValue() {
                return this.value;
            }
        }

        private static enum OutsideOption implements Option
        {
            NOTHING(1),
            WHOLE_SCRIPT(2),
            SCRIPT_TAIL(3);

            final int value;

            private OutsideOption(int value) {
                this.value = value;
            }

            @Override
            public int getValue() {
                return this.value;
            }
        }

        private static enum SelectionOption implements Option
        {
            EXACTLY_ONE(1),
            EXACTLY_SCRIPT(2),
            SMART_EXPAND(3);

            final int value;

            private SelectionOption(int value) {
                this.value = value;
            }

            @Override
            public int getValue() {
                return this.value;
            }
        }

        private static interface Option {
            public int getValue();
        }
    }

    public static final class IdeConfigState
    extends ApplicationUsagesCollector {
        private static final EventLogGroup GROUP = new EventLogGroup("db.ide.config", 2);
        private final BooleanEventField SINGLE_STRIPE = EventFields.Boolean((String)"single_stripe");
        private final VarargEventId CONFIG_EVENT = GROUP.registerVarargEvent("config", new EventField[]{this.SINGLE_STRIPE});

        public EventLogGroup getGroup() {
            return GROUP;
        }

        @NotNull
        public Set<MetricEvent> getMetrics() {
            Set<MetricEvent> set = Collections.singleton(this.CONFIG_EVENT.metric(new EventPair[]{this.SINGLE_STRIPE.with((Object)EnableStripeGroup.Companion.isSingleStripeEnabled())}));
            if (set == null) {
                IdeConfigState.$$$reportNull$$$0(0);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/statistic/DatabaseUsagesCollectors$IdeConfigState", "getMetrics"));
        }
    }

    public static final class ConfigPrj
    extends ProjectUsagesCollector {
        private final ConfigImpl myImpl = new ConfigImpl();

        public EventLogGroup getGroup() {
            return this.myImpl.CONFIG_GROUP;
        }

        @NotNull
        public Set<MetricEvent> getMetrics(@NotNull Project p2) {
            if (p2 == null) {
                ConfigPrj.$$$reportNull$$$0(0);
            }
            Set<MetricEvent> set = this.myImpl.configImpl(p2);
            if (set == null) {
                ConfigPrj.$$$reportNull$$$0(1);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "p";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/statistic/DatabaseUsagesCollectors$ConfigPrj";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/statistic/DatabaseUsagesCollectors$ConfigPrj";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMetrics";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getMetrics";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static final class ConfigApp
    extends ApplicationUsagesCollector {
        private final ConfigImpl myImpl = new ConfigImpl();

        public EventLogGroup getGroup() {
            return this.myImpl.CONFIG_GROUP;
        }

        @NotNull
        public Set<MetricEvent> getMetrics() {
            Set<MetricEvent> set = this.myImpl.configImpl(null);
            if (set == null) {
                ConfigApp.$$$reportNull$$$0(0);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/statistic/DatabaseUsagesCollectors$ConfigApp", "getMetrics"));
        }
    }

    private static class ConfigImpl {
        private final EventLogGroup CONFIG_GROUP = new EventLogGroup("db.datasource.config", 25);
        private final BooleanEventField READ_ONLY = EventFields.Boolean((String)"read-only");
        private final BooleanEventField AUTO_SYNC = EventFields.Boolean((String)"auto-sync");
        private final BooleanEventField AUTO_COMMIT = EventFields.Boolean((String)"auto-commit");
        private final BooleanEventField SSH = EventFields.Boolean((String)"ssh");
        private final BooleanEventField SSL = EventFields.Boolean((String)"ssl");
        private final BooleanEventField MAPPED_TO_DDL = EventFields.Boolean((String)"mapped-to-ddl");
        private final BooleanEventField JDBC_INTROSPECTOR = EventFields.Boolean((String)"legacy-introspector");
        private final EnumEventField<SchemaControl> SCHEMA_CONTROL = EventFields.Enum((String)"schema-control", SchemaControl.class, DatabaseUsagesCollectors::lowerEnumName);
        private final EnumEventField<DBIntrospectionOptions.SourceLoading> LOAD_SOURCES = EventFields.Enum((String)"introspect", DBIntrospectionOptions.SourceLoading.class, DatabaseUsagesCollectors::lowerEnumName);
        private final NullableEnumEventField<IntrospectionLevelStat> INTROSPECTION_LEVEL = EventFields.NullableEnum((String)"introspection-level", IntrospectionLevelStat.class, null, DatabaseUsagesCollectors::lowerEnumName);
        private final EventField<Dbms> DBMS = new DbmsEventField("dbms");
        private final EventField<Class<?>> AUTH_PROVIDER = EventFields.Class((String)"auth-provider");
        private final BooleanEventField CUSTOM_DRIVER = EventFields.Boolean((String)"custom-driver");
        private final BooleanEventField INIT_SCRIPT = EventFields.Boolean((String)"init-script");
        private final BooleanEventField BEFORE_TASKS = EventFields.Boolean((String)"before-tasks");
        private final BooleanEventField EXTERNAL_DATA = EventFields.Boolean((String)"external-data");
        private final BooleanEventField OPT_ALL_DATABASES = EventFields.Boolean((String)"option-all-databases");
        private final BooleanEventField OPT_ALL_SCHEMAS = EventFields.Boolean((String)"option-all-schemas");
        private final VarargEventId CONFIG_EVENT = this.CONFIG_GROUP.registerVarargEvent("datasource", new EventField[]{EventFields.Version, this.READ_ONLY, this.AUTO_SYNC, this.AUTO_COMMIT, this.SSH, this.SSL, this.MAPPED_TO_DDL, this.JDBC_INTROSPECTOR, this.SCHEMA_CONTROL, this.LOAD_SOURCES, this.DBMS, this.AUTH_PROVIDER, this.CUSTOM_DRIVER, this.INIT_SCRIPT, this.BEFORE_TASKS, this.EXTERNAL_DATA, this.INTROSPECTION_LEVEL, this.OPT_ALL_DATABASES, this.OPT_ALL_SCHEMAS});

        private ConfigImpl() {
        }

        @NotNull
        private Set<MetricEvent> configImpl(@Nullable Project p2) {
            DataSourceStorage storage = DbSrcUtils.getDataSourceStorage(p2);
            HashSet<MetricEvent> result = new HashSet<MetricEvent>();
            for (LocalDataSource dataSource : storage.getOwnDataSources()) {
                Boolean optionAllSchemas;
                Boolean optionAllDatabases;
                Dbms dbms = dataSource.getDbms();
                ArrayList<EventPair> pairs = new ArrayList<EventPair>(20);
                pairs.add(EventFields.Version.with((Object)dataSource.getVersion().toString()));
                pairs.add(this.READ_ONLY.with((Object)dataSource.isReadOnly()));
                pairs.add(this.AUTO_SYNC.with((Object)dataSource.isAutoSynchronize()));
                pairs.add(this.AUTO_COMMIT.with((Object)dataSource.isAutoCommit()));
                pairs.add(this.MAPPED_TO_DDL.with((Object)(p2 != null && DdlMappingsManager.getInstance((Project)p2).findByDataSourceId(dataSource.getUniqueId()).isNotEmpty() ? 1 : 0)));
                pairs.add(this.SSH.with((Object)DataSourceSshTunnelConfiguration.hasTunnel((DatabaseConnectionPoint)dataSource)));
                pairs.add(this.SSL.with((Object)(dataSource.getSslCfg() != null && dataSource.getSslCfg().myEnabled ? 1 : 0)));
                pairs.add(this.JDBC_INTROSPECTOR.with((Object)dataSource.useJdbcIntrospector()));
                pairs.add(this.SCHEMA_CONTROL.with((Object)dataSource.getSchemaControl()));
                pairs.add(this.LOAD_SOURCES.with((Object)dataSource.getSourceLoading()));
                pairs.add(this.DBMS.with((Object)dbms));
                pairs.add(this.AUTH_PROVIDER.with(DatabaseAuthProvider.get((DatabaseConnectionPoint)dataSource).getClass()));
                pairs.add(this.CUSTOM_DRIVER.with((Object)(dataSource.getDatabaseDriver() != null && !dataSource.getDatabaseDriver().isPredefined() ? 1 : 0)));
                pairs.add(this.INIT_SCRIPT.with((Object)StringUtil.isNotEmpty((String)dataSource.getInitScript())));
                pairs.add(this.BEFORE_TASKS.with((Object)(!dataSource.getBeforeTasks().isEmpty() ? 1 : 0)));
                pairs.add(this.EXTERNAL_DATA.with((Object)StringUtil.isNotEmpty((String)ModelExternalData.getExternalDataPath((LocalDataSource)dataSource))));
                pairs.add(this.INTROSPECTION_LEVEL.with((Object)IntrospectionLevelStat.getIntrospectionLevelStat(dataSource)));
                TreePattern scope2 = dataSource.getIntrospectionScope();
                boolean multiDatabase = ModelFun.isMultiDatabase((Dbms)dbms);
                if (multiDatabase && (optionAllDatabases = ConfigImpl.scopeHasOptionAllDatabases(scope2)) != null) {
                    pairs.add(this.OPT_ALL_DATABASES.with((Object)optionAllDatabases));
                }
                if ((optionAllSchemas = ConfigImpl.scopeHasOptionAllSchemas(scope2, multiDatabase)) != null) {
                    pairs.add(this.OPT_ALL_SCHEMAS.with((Object)optionAllSchemas));
                }
                result.add(this.CONFIG_EVENT.metric(pairs));
            }
            HashSet<MetricEvent> hashSet = result;
            if (hashSet == null) {
                ConfigImpl.$$$reportNull$$$0(0);
            }
            return hashSet;
        }

        private static Boolean scopeHasOptionAllDatabases(@Nullable TreePattern scope2) {
            if (scope2 == null || scope2.isEmpty()) {
                return null;
            }
            NavigableMap map2 = TreePatternFun.extractMap((TreePatternNode)scope2.root, (ObjectKind)ObjectKind.DATABASE);
            if (map2.isEmpty()) {
                return null;
            }
            return map2.containsKey(TreePatternEntryKey.All.INSTANCE);
        }

        private static Boolean scopeHasOptionAllSchemas(@Nullable TreePattern scope2, boolean multiDatabase) {
            if (scope2 == null || scope2.isEmpty()) {
                return null;
            }
            if (multiDatabase) {
                NavigableMap map1 = TreePatternFun.extractMap((TreePatternNode)scope2.root, (ObjectKind)ObjectKind.DATABASE);
                if (map1.isEmpty()) {
                    return null;
                }
                for (TreePatternNode dbNode : map1.values()) {
                    NavigableMap map2 = TreePatternFun.extractMap((TreePatternNode)dbNode, (ObjectKind)ObjectKind.SCHEMA);
                    if (!map2.containsKey(TreePatternEntryKey.All.INSTANCE)) continue;
                    return true;
                }
                return false;
            }
            NavigableMap map2 = TreePatternFun.extractMap((TreePatternNode)scope2.root, (ObjectKind)ObjectKind.SCHEMA);
            if (map2.isEmpty()) {
                return null;
            }
            return map2.containsKey(TreePatternEntryKey.All.INSTANCE);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/statistic/DatabaseUsagesCollectors$ConfigImpl", "configImpl"));
        }
    }

    public static final class ManagersPrj
    extends ProjectUsagesCollector {
        private final EventLogGroup MANAGERS_GROUP = new EventLogGroup("db.managers", 4);
        private final EventId2<String, Language> MANAGER_EVENT = this.MANAGERS_GROUP.registerEvent("manager", (EventField)EventFields.String((String)"name", Arrays.asList("local", "sql", "android")), (EventField)EventFields.Language);

        public EventLogGroup getGroup() {
            return this.MANAGERS_GROUP;
        }

        protected boolean requiresReadAccess() {
            return true;
        }

        @NotNull
        public Set<MetricEvent> getMetrics(@NotNull Project p2) {
            if (p2 == null) {
                ManagersPrj.$$$reportNull$$$0(0);
            }
            DbPsiFacade facade = DbPsiFacade.getInstance((Project)p2);
            HashSet<MetricEvent> result = new HashSet<MetricEvent>();
            for (DbDataSource ds : facade.getDataSources()) {
                Class<?> aClass = facade.getDataSourceManager(ds).getClass();
                String managerName = StringUtil.toLowerCase((String)StringUtil.trimEnd((String)aClass.getSimpleName(), (String)"DataSourceManager"));
                result.add(this.MANAGER_EVENT.metric((Object)managerName, (Object)ds.getQueryLanguage()));
            }
            HashSet<MetricEvent> hashSet = result;
            if (hashSet == null) {
                ManagersPrj.$$$reportNull$$$0(1);
            }
            return hashSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "p";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/statistic/DatabaseUsagesCollectors$ManagersPrj";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/statistic/DatabaseUsagesCollectors$ManagersPrj";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMetrics";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getMetrics";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

