/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement;

import com.intellij.openapi.fileEditor.TrailingSpacesOptionsProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.ec4j.core.ResourceProperties;
import org.editorconfig.Utils;
import org.editorconfig.configmanagement.StandardEditorConfigProperties;
import org.editorconfig.plugincomponents.EditorConfigPropertiesService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001f\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lorg/editorconfig/configmanagement/EditorConfigTrailingSpacesOptionsProvider;", "Lcom/intellij/openapi/fileEditor/TrailingSpacesOptionsProvider;", "Lorg/editorconfig/configmanagement/StandardEditorConfigProperties;", "<init>", "()V", "getOptions", "Lcom/intellij/openapi/fileEditor/TrailingSpacesOptionsProvider$Options;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getBooleanValue", "", "properties", "Lorg/ec4j/core/ResourceProperties;", "key", "", "(Lorg/ec4j/core/ResourceProperties;Ljava/lang/String;)Ljava/lang/Boolean;", "FileOptions", "intellij.editorconfig.backend"})
public final class EditorConfigTrailingSpacesOptionsProvider
implements TrailingSpacesOptionsProvider,
StandardEditorConfigProperties {
    @Nullable
    public TrailingSpacesOptionsProvider.Options getOptions(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (Utils.INSTANCE.isEnabledFor(project, file)) {
            ResourceProperties properties = EditorConfigPropertiesService.Companion.getInstance(project).getProperties(file);
            Boolean trimTrailingWhitespace = this.getBooleanValue(properties, "trim_trailing_whitespace");
            Boolean insertFinalNewline = this.getBooleanValue(properties, "insert_final_newline");
            if (trimTrailingWhitespace != null || insertFinalNewline != null) {
                return new FileOptions(trimTrailingWhitespace, insertFinalNewline);
            }
        }
        return null;
    }

    private final Boolean getBooleanValue(ResourceProperties properties, String key) {
        String rawValue = Utils.INSTANCE.configValueForKey(properties, key);
        return StringsKt.equals((String)"false", (String)rawValue, (boolean)true) ? Boolean.valueOf(false) : (StringsKt.equals((String)"true", (String)rawValue, (boolean)true) ? Boolean.valueOf(true) : null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\tJ\u000f\u0010\n\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\tJ\u000f\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\tJ\u000f\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\tJ\u000f\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\tR\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lorg/editorconfig/configmanagement/EditorConfigTrailingSpacesOptionsProvider$FileOptions;", "Lcom/intellij/openapi/fileEditor/TrailingSpacesOptionsProvider$Options;", "myTrimTrailingSpaces", "", "myInsertFinalNewLine", "<init>", "(Ljava/lang/Boolean;Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "getStripTrailingSpaces", "()Ljava/lang/Boolean;", "getEnsureNewLineAtEOF", "getRemoveTrailingBlankLines", "getChangedLinesOnly", "getKeepTrailingSpacesOnCaretLine", "intellij.editorconfig.backend"})
    private static final class FileOptions
    implements TrailingSpacesOptionsProvider.Options {
        @Nullable
        private final Boolean myTrimTrailingSpaces;
        @Nullable
        private final Boolean myInsertFinalNewLine;

        public FileOptions(@Nullable Boolean myTrimTrailingSpaces, @Nullable Boolean myInsertFinalNewLine) {
            this.myTrimTrailingSpaces = myTrimTrailingSpaces;
            this.myInsertFinalNewLine = myInsertFinalNewLine;
        }

        @Nullable
        public Boolean getStripTrailingSpaces() {
            return this.myTrimTrailingSpaces;
        }

        @Nullable
        public Boolean getEnsureNewLineAtEOF() {
            return this.myInsertFinalNewLine;
        }

        @Nullable
        public Boolean getRemoveTrailingBlankLines() {
            return null;
        }

        @Nullable
        public Boolean getChangedLinesOnly() {
            return this.myTrimTrailingSpaces != null ? Boolean.valueOf(this.myTrimTrailingSpaces == false) : null;
        }

        @Nullable
        public Boolean getKeepTrailingSpacesOnCaretLine() {
            return null;
        }
    }
}

