/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mysqlbase;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.connection.EitherKt;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatementFactoryService;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dialects.AbstractDefinitionProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.util.DasUtil;
import com.intellij.util.PairConsumer;
import org.jetbrains.annotations.NotNull;

public final class MysqlBaseDefinitionProvider
extends AbstractDefinitionProvider {
    @Override
    public boolean isSupported(@NotNull DasObject object) {
        ObjectKind kind;
        if (object == null) {
            MysqlBaseDefinitionProvider.$$$reportNull$$$0(0);
        }
        return (kind = object.getKind()) == ObjectKind.SCHEMA || kind == ObjectKind.VIEW || kind == ObjectKind.ROUTINE || kind == ObjectKind.TRIGGER || kind == ObjectKind.TABLE;
    }

    @Override
    protected void fetchSources(@NotNull Iterable<? extends DasObject> objects, @NotNull DatabaseConnectionCore connection, @NotNull PairConsumer<DasObject, Object> consumer) {
        if (objects == null) {
            MysqlBaseDefinitionProvider.$$$reportNull$$$0(1);
        }
        if (connection == null) {
            MysqlBaseDefinitionProvider.$$$reportNull$$$0(2);
        }
        if (consumer == null) {
            MysqlBaseDefinitionProvider.$$$reportNull$$$0(3);
        }
        try (ReusableSmartStatement<String> statement = SmartStatementFactoryService.getInstance().poweredBy(connection).simple().reuse();){
            for (DasObject dasObject : objects) {
                Object result2 = EitherKt.any(statement.execute(MysqlBaseDefinitionProvider.getQuery(dasObject, connection.getDbms()), (ExecutionMode)StandardExecutionMode.QUERY, StandardResultsProcessors.throwableResultsTransformer(rs -> !rs.next() ? null : rs.getString(MysqlBaseDefinitionProvider.getColumn(object)))));
                consumer.consume((Object)dasObject, result2);
            }
        }
    }

    private static int getColumn(@NotNull DasObject object) {
        ObjectKind kind;
        if (object == null) {
            MysqlBaseDefinitionProvider.$$$reportNull$$$0(4);
        }
        if ((kind = object.getKind()) == ObjectKind.TRIGGER || kind == ObjectKind.ROUTINE) {
            return 3;
        }
        return 2;
    }

    private static String getQuery(@NotNull DasObject obj2, @NotNull Dbms dbms) {
        if (obj2 == null) {
            MysqlBaseDefinitionProvider.$$$reportNull$$$0(5);
        }
        if (dbms == null) {
            MysqlBaseDefinitionProvider.$$$reportNull$$$0(6);
        }
        NamingService namingService = NamingServices.getNamingService(dbms);
        ObjectKind kind = obj2.getKind();
        StringBuilder res = new StringBuilder("SHOW CREATE ");
        if (kind == ObjectKind.ROUTINE) {
            res.append(obj2 instanceof DasRoutine && ((DasRoutine)obj2).getRoutineKind() == DasRoutine.Kind.FUNCTION ? "FUNCTION" : "PROCEDURE");
        } else {
            res.append(kind.name());
        }
        res.append(" ");
        if (kind != ObjectKind.SCHEMA) {
            res.append(namingService.enquote(DasUtil.getSchema(obj2), ObjectKind.SCHEMA)).append(".");
        }
        res.append(namingService.enquote(obj2.getName(), kind));
        return res.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dialects/mysqlbase/MysqlBaseDefinitionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupported";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fetchSources";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getColumn";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getQuery";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

