/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.core;

import com.intellij.javascript.nodejs.library.core.NodeCoreModulesCatalog;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class NodeCoreSourcesSnapshot {
    private static final Logger LOG = Logger.getInstance(NodeCoreSourcesSnapshot.class);
    private final VirtualFile myCoreModulesSrcDir;
    private final Map<String, VirtualFile> myAllPathToFileMap;
    private final Set<VirtualFile> myAllFiles;

    NodeCoreSourcesSnapshot(@NotNull VirtualFile coreModulesSrcDir) {
        if (coreModulesSrcDir == null) {
            NodeCoreSourcesSnapshot.$$$reportNull$$$0(0);
        }
        this.myCoreModulesSrcDir = coreModulesSrcDir;
        Map pathToFileMap = (Map)ReadAction.compute(() -> NodeCoreSourcesSnapshot.buildPathToFileMap(coreModulesSrcDir));
        this.myAllPathToFileMap = Map.copyOf(pathToFileMap);
        this.myAllFiles = Set.copyOf(pathToFileMap.values());
    }

    @NotNull
    VirtualFile getCoreModulesSrcDir() {
        VirtualFile virtualFile = this.myCoreModulesSrcDir;
        if (virtualFile == null) {
            NodeCoreSourcesSnapshot.$$$reportNull$$$0(1);
        }
        return virtualFile;
    }

    boolean isCoreModuleFile(@NotNull VirtualFile file) {
        if (file == null) {
            NodeCoreSourcesSnapshot.$$$reportNull$$$0(2);
        }
        return this.myAllFiles.contains(file);
    }

    @Nullable
    public VirtualFile getFileByModuleName(@NotNull String moduleName) {
        if (moduleName == null) {
            NodeCoreSourcesSnapshot.$$$reportNull$$$0(3);
        }
        return this.myAllPathToFileMap.get(moduleName);
    }

    private static Map<String, VirtualFile> buildPathToFileMap(final @NotNull VirtualFile coreModulesSrcDir) {
        if (coreModulesSrcDir == null) {
            NodeCoreSourcesSnapshot.$$$reportNull$$$0(4);
        }
        if (!coreModulesSrcDir.isValid() || !coreModulesSrcDir.isDirectory()) {
            LOG.error(coreModulesSrcDir.getPath() + " isValid: " + coreModulesSrcDir.isValid() + ", isDirectory: " + coreModulesSrcDir.isDirectory());
            return Collections.emptyMap();
        }
        final HashMap<String, VirtualFile> pathToFile = new HashMap<String, VirtualFile>();
        VfsUtilCore.visitChildrenRecursively((VirtualFile)coreModulesSrcDir, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!file.isDirectory()) {
                    String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)coreModulesSrcDir);
                    if (relativePath == null) {
                        LOG.error("Cannot find relative path: " + file.getPath() + " relative to " + coreModulesSrcDir.getPath());
                    } else {
                        pathToFile.put(FileUtilRt.getNameWithoutExtension((String)relativePath), file);
                    }
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/nodejs/library/core/NodeCoreSourcesSnapshot$1", "visitFile"));
            }
        });
        return pathToFile;
    }

    @NotNull
    Set<VirtualFile> getFilesToIndex() {
        HashSet<VirtualFile> result2 = new HashSet<VirtualFile>();
        for (Map.Entry<String, VirtualFile> entry : this.myAllPathToFileMap.entrySet()) {
            String moduleName = FileUtilRt.getNameWithoutExtension((String)entry.getKey());
            if (!NodeCoreModulesCatalog.INSTANCE.isIncludedCoreModule(moduleName)) continue;
            result2.add(entry.getValue());
        }
        HashSet<VirtualFile> hashSet = result2;
        if (hashSet == null) {
            NodeCoreSourcesSnapshot.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coreModulesSrcDir";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/library/core/NodeCoreSourcesSnapshot";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/library/core/NodeCoreSourcesSnapshot";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoreModulesSrcDir";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesToIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isCoreModuleFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFileByModuleName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildPathToFileMap";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5 -> new IllegalStateException(string);
        };
    }
}

