/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J3\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0007H\u0016J\b\u0010\u0014\u001a\u00020\u0007H\u0017J(\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0002\u001a\u00020\u0018H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/lang/javascript/validation/fixes/ES6ConvertSpecifierToDefaultFix;", "Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "element", "Lcom/intellij/lang/ecmascript6/psi/ES6ImportSpecifier;", "<init>", "(Lcom/intellij/lang/ecmascript6/psi/ES6ImportSpecifier;)V", "specifierName", "", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "psiFile", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "getText", "getFamilyName", "isAvailable", "", "getDefaultElementName", "Lcom/intellij/lang/javascript/psi/JSElement;", "findDefaultExportElement", "declaration", "Lcom/intellij/lang/ecmascript6/psi/ES6ImportDeclaration;", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nES6ConvertSpecifierToDefaultFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ES6ConvertSpecifierToDefaultFix.kt\ncom/intellij/lang/javascript/validation/fixes/ES6ConvertSpecifierToDefaultFix\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,81:1\n1#2:82\n*E\n"})
public final class ES6ConvertSpecifierToDefaultFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    @NotNull
    private final String specifierName;

    public ES6ConvertSpecifierToDefaultFix(@NotNull ES6ImportSpecifier element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        super((PsiElement)element2);
        String string = StringUtil.notNullize((String)element2.getName());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"notNullize(...)");
        this.specifierName = string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        if (!(startElement instanceof ES6ImportSpecifier)) {
            return;
        }
        ES6ImportDeclaration eS6ImportDeclaration = ((ES6ImportSpecifier)startElement).getDeclaration();
        if (eS6ImportDeclaration == null) {
            return;
        }
        ES6ImportDeclaration declaration = eS6ImportDeclaration;
        ES6ImportedBinding[] eS6ImportedBindingArray = declaration.getImportedBindings();
        Intrinsics.checkNotNullExpressionValue((Object)eS6ImportedBindingArray, (String)"getImportedBindings(...)");
        if (!(((Object[])eS6ImportedBindingArray).length == 0)) {
            return;
        }
        JSElement jSElement = this.findDefaultExportElement(declaration);
        if (jSElement == null) {
            return;
        }
        JSElement element2 = jSElement;
        String string = this.getDefaultElementName(element2);
        if (string == null) {
            return;
        }
        String defaultElementName = string;
        if (StringUtil.isEmpty((String)defaultElementName)) {
            return;
        }
        WriteAction.run(() -> ES6ConvertSpecifierToDefaultFix.invoke$lambda$1(declaration, defaultElementName));
    }

    @NotNull
    public String getText() {
        Object[] objectArray = new Object[]{this.specifierName};
        String string = JavaScriptBundle.message("es6.change.to.default.fix", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        if (!(startElement instanceof ES6ImportSpecifier)) {
            return false;
        }
        ES6ImportDeclaration eS6ImportDeclaration = ((ES6ImportSpecifier)startElement).getDeclaration();
        if (eS6ImportDeclaration == null) {
            return false;
        }
        ES6ImportDeclaration declaration = eS6ImportDeclaration;
        ES6ImportedBinding[] eS6ImportedBindingArray = declaration.getImportedBindings();
        Intrinsics.checkNotNullExpressionValue((Object)eS6ImportedBindingArray, (String)"getImportedBindings(...)");
        if (!(((Object[])eS6ImportedBindingArray).length == 0) || PsiUtilCore.hasErrorElementChild((PsiElement)((PsiElement)declaration))) {
            return false;
        }
        JSElement jSElement = this.findDefaultExportElement(declaration);
        if (jSElement == null) {
            return false;
        }
        JSElement element2 = jSElement;
        String string = this.getDefaultElementName(element2);
        if (string == null) {
            return false;
        }
        String defaultElementName = string;
        String name = ((ES6ImportSpecifier)startElement).getReferenceName();
        return StringUtil.equals((CharSequence)name, (CharSequence)defaultElementName);
    }

    private final String getDefaultElementName(JSElement element2) {
        if (element2 instanceof JSExportAssignment) {
            JSElement jSElement = ((JSExportAssignment)element2).getStubSafeElement();
            return jSElement != null ? jSElement.getName() : null;
        }
        return element2.getName();
    }

    private final JSElement findDefaultExportElement(ES6ImportDeclaration declaration) {
        PsiElement psiElement;
        Collection<PsiElement> collection = ES6PsiUtil.resolveDefaultExport(declaration);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"resolveDefaultExport(...)");
        Collection<PsiElement> results = collection;
        return results.size() == 1 ? ((psiElement = results.iterator().next()) instanceof JSElement ? (JSElement)psiElement : null) : null;
    }

    private static final void invoke$lambda$1(ES6ImportDeclaration $declaration, String $defaultElementName) {
        block4: {
            ES6ImportSpecifier specifier;
            Object object;
            block3: {
                ES6ImportedBinding eS6ImportedBinding = ES6ImportPsiUtil.insertBinding($declaration, $defaultElementName);
                if (eS6ImportedBinding == null) {
                    return;
                }
                ES6ImportedBinding binding = eS6ImportedBinding;
                ES6ImportDeclaration eS6ImportDeclaration = binding.getDeclaration();
                if (eS6ImportDeclaration == null) {
                    return;
                }
                ES6ImportDeclaration newDeclaration = eS6ImportDeclaration;
                ES6ImportSpecifier[] eS6ImportSpecifierArray = newDeclaration.getImportSpecifiers();
                Intrinsics.checkNotNullExpressionValue((Object)eS6ImportSpecifierArray, (String)"getImportSpecifiers(...)");
                for (Object object2 : (Object[])eS6ImportSpecifierArray) {
                    ES6ImportSpecifier it = (ES6ImportSpecifier)object2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getReferenceName(), (Object)$defaultElementName)) continue;
                    object = object2;
                    break block3;
                }
                object = null;
            }
            ES6ImportSpecifier eS6ImportSpecifier = specifier = (ES6ImportSpecifier)object;
            if (eS6ImportSpecifier == null) break block4;
            eS6ImportSpecifier.delete();
        }
    }
}

