/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_vai_Latn extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_SA = "Lahabu";
        final String metaValue_DE = "Jamáĩ";
        final String metaValue_GR = "Hɛlɛŋ";
        final String metaValue_US = "Poo";
        final String metaValue_ES = "Panyɛĩ";
        final String metaValue_FR = "Fɛŋsi";
        final String metaValue_PT = "Potokíi";
        final String metaValue_RW = "Rawunda";
        final Object[][] data = new Object[][] {
            { "AD", "Aŋdóra" },
            { "AE", "Yunaitɛ Arabhi Ɛmire" },
            { "AF", "Afigándesitaŋ" },
            { "AG", "Aŋtígwa Ɓahabhuda" },
            { "AI", "Aŋgíla" },
            { "AL", "Abhaniya" },
            { "AM", "Améniya" },
            { "AO", "Aŋgóla" },
            { "AR", "Ajɛŋtína" },
            { "AS", "Poo Sambowa" },
            { "AT", "Ɔ́situwa" },
            { "AU", "Ɔsituwéeliya" },
            { "AW", "Arubha" },
            { "AZ", "Azabhaijaŋ" },
            { "BA", "Bhɔsiniya" },
            { "BB", "Bhabhedo" },
            { "BD", "Bhangiladɛ̀shi" },
            { "BE", "Bhɛgiyɔŋ" },
            { "BF", "Bhokina Fáso" },
            { "BG", "Bhɔgeriya" },
            { "BH", "Bharɛŋ" },
            { "BI", "Bhurundi" },
            { "BJ", "Bhɛni" },
            { "BM", "Bhɛmuda" },
            { "BN", "Bhurunɛĩ" },
            { "BO", "Bholiviya" },
            { "BR", "Bhurazeli" },
            { "BS", "Bahámasi" },
            { "BT", "Bhutaŋ" },
            { "BW", "Bhosuwana" },
            { "BY", "Bhɛlarusi" },
            { "BZ", "Bheliz" },
            { "CA", "Kánáda" },
            { "CD", "Avorekoo" },
            { "CF", "Áfíríka Lumaã Tɛ Boloe" },
            { "CG", "Kóngo" },
            { "CH", "Suweza Lumaã" },
            { "CI", "Kódivówa" },
            { "CK", "Kóki Tiŋŋɛ" },
            { "CL", "Chéli" },
            { "CM", "Kameruŋ" },
            { "CN", "Cháína" },
            { "CO", "Kɔlɔmbiya" },
            { "CR", "Kósíta Ríko" },
            { "CU", "Kiyubha" },
            { "CV", "Kepi Vɛdi Tiŋŋɛ" },
            { "CY", "Saɛpurɔ" },
            { "CZ", "Chɛki Boloe" },
            { "DE", metaValue_DE },
            { "DJ", "Jibhuti" },
            { "DK", "Danimaha" },
            { "DM", "Domíiníka" },
            { "DO", "Domíiníka Ɓoloe" },
            { "DZ", "Agiriya" },
            { "EC", "Ɛ́kúwédɔ" },
            { "EE", "Ɛsitóninya" },
            { "EG", "Míséla" },
            { "ER", "Ɛritera" },
            { "ES", metaValue_ES },
            { "ET", "Ítiyópiya" },
            { "FI", "Fiŋlɛŋ" },
            { "FJ", "Fíji" },
            { "FK", "Fáháki Luma Tiŋŋɛ" },
            { "FM", "Mikonisiya" },
            { "FR", metaValue_FR },
            { "GA", "Gabhɔŋ" },
            { "GB", "Yunaitɛ Kíŋdɔŋ" },
            { "GD", "Gurinéda" },
            { "GE", "Jɔɔjiya" },
            { "GF", "Fɛŋsi Giwana" },
            { "GH", "Gana" },
            { "GI", "Jibhurata" },
            { "GL", "Jamba Kuwa Lumaã" },
            { "GM", "Gambiya" },
            { "GN", "Gini" },
            { "GP", "Guwadelupe" },
            { "GQ", "Dúúnyá Tɛ Giini" },
            { "GR", metaValue_GR },
            { "GT", "Guwatɛmala" },
            { "GU", "Guwami" },
            { "GW", "Gini Bhisawo" },
            { "GY", "Guyana" },
            { "HN", "Hɔndura" },
            { "HR", "Koresiya" },
            { "HT", "Háiti" },
            { "HU", "Hɔ́ngare" },
            { "ID", "Índonisiya" },
            { "IE", "Áre Lumaã" },
            { "IL", "Bhanísiláila" },
            { "IN", "Índiya" },
            { "IQ", "Iraki" },
            { "IR", "Iraŋ" },
            { "IS", "Áisi Lumaã" },
            { "IT", "Ítali" },
            { "JM", "Jamaika" },
            { "JO", "Jɔɔdaŋ" },
            { "JP", "Japaŋ" },
            { "KE", "Kénya" },
            { "KG", "Kigisitaŋ" },
            { "KH", "Kaŋbhodiya" },
            { "KI", "Kiribhati" },
            { "KM", "Komorosi" },
            { "KN", "Siŋ Kisi ɓɛ́ Nevisi" },
            { "KP", "Koriya Kɔi Kaŋndɔ" },
            { "KR", "Koriya Kɔi Leŋŋɛ Lɔ" },
            { "KW", "Kuweti" },
            { "KY", "Keemaŋ Tiŋŋɛ" },
            { "KZ", "Kazasitaŋ" },
            { "LA", "Lawosi" },
            { "LB", "Lebhanɔ" },
            { "LC", "Siŋ Lusiya" },
            { "LK", "Suri Laŋka" },
            { "LR", "Laibhiya" },
            { "LS", "Lisóto" },
            { "LT", "Lituweninya" },
            { "LU", "Lusimbɔ" },
            { "LV", "Lativiya" },
            { "LY", "Lebhiya" },
            { "MA", "Mɔroko" },
            { "MC", "Mɔnako" },
            { "MD", "Mɔlidova" },
            { "MG", "Madagasita" },
            { "MH", "Masha Tiŋŋɛ" },
            { "ML", "Mali" },
            { "MM", "Miyamaha" },
            { "MN", "Mɔngoliya" },
            { "MP", "Kɔi Kaŋndɔ Mariyana Tiŋŋɛ" },
            { "MQ", "Matiniki" },
            { "MR", "Mɔretaninya" },
            { "MS", "Mɔserati" },
            { "MT", "Malita" },
            { "MU", "Mɔreshɔ" },
            { "MV", "Malidavi" },
            { "MW", "Malawi" },
            { "MX", "Mɛsíko" },
            { "MY", "Malesiya" },
            { "MZ", "Mozambiki" },
            { "NA", "Namibiya" },
            { "NC", "Kalidoninya Námaá" },
            { "NE", "Naĩja" },
            { "NF", "Nɔfɔ Tiŋŋɛ" },
            { "NG", "Naĩjiriya" },
            { "NI", "Nikaraguwa" },
            { "NL", "Nidɔlɛŋ" },
            { "NO", "Nɔɔwe" },
            { "NP", "Nepa" },
            { "NR", "Noru" },
            { "NU", "Niwe" },
            { "NZ", "Zilɛŋ Námaá" },
            { "OM", "Omaŋ" },
            { "PA", "Panama" },
            { "PE", "Pɛru" },
            { "PF", "Fɛŋsi Polinísiya" },
            { "PG", "Papuwa Gini Námaá" },
            { "PH", "Félepiŋ" },
            { "PK", "Pakisitaŋ" },
            { "PL", "Pólɛŋ" },
            { "PM", "Siŋ Piiyɛ ɓɛ́ Mikelɔŋ" },
            { "PN", "Pitikɛŋ" },
            { "PR", "Piyuto Riko" },
            { "PS", "Palesitininya Tele Jii Kɔiyɛ lá hĩ Gaza" },
            { "PT", metaValue_PT },
            { "PW", "Palo" },
            { "PY", "Paragɔe" },
            { "QA", "Kataha" },
            { "RE", "Renyɔɔ̃" },
            { "RO", "Romininya" },
            { "RU", "Rɔshiya" },
            { "RW", metaValue_RW },
            { "SA", metaValue_SA },
            { "SB", "Sulaimaãna Tiŋŋɛ" },
            { "SC", "Seshɛɛ" },
            { "SD", "Sudɛŋ" },
            { "SE", "Suwidɛŋ" },
            { "SG", "Síingapoo" },
            { "SH", "Siŋ Hɛlina" },
            { "SI", "Suloveninya" },
            { "SK", "Sulovakiya" },
            { "SL", "Gbeya Bahawɔ" },
            { "SM", "Saŋ Marindo" },
            { "SN", "Sinigaha" },
            { "SO", "Somaliya" },
            { "SR", "Surinambe" },
            { "ST", "Sawo Tombe ɓɛ a Gbawoe" },
            { "SV", "Ɛlɛ Sávádɔ" },
            { "SY", "Síyaŋ" },
            { "SZ", "Suwazi Lumaã" },
            { "TC", "Tukisi ɓɛ̀ Kaikóosi Tiŋŋɛ" },
            { "TD", "Chádi" },
            { "TG", "Togo" },
            { "TH", "Tai Lumaã" },
            { "TJ", "Tajikisitaŋ" },
            { "TK", "Tokelo" },
            { "TL", "Tele Ɓɔ́ Timɔɔ̃" },
            { "TM", "Tukimɛnisitaŋ" },
            { "TN", "Tunisiya" },
            { "TO", "Tɔnga" },
            { "TR", "Tɔ́ɔ́ki" },
            { "TT", "Turindeda ɓɛ́ Tobhego" },
            { "TV", "Tuválu" },
            { "TW", "Taiwaŋ" },
            { "TZ", "Taŋzaninya" },
            { "UA", "Yukuréŋ" },
            { "UG", "Yuganda" },
            { "US", metaValue_US },
            { "UY", "Yuwegɔwe" },
            { "UZ", "Yubhɛkisitaŋ" },
            { "VA", "Vatikaŋ Ɓoloe" },
            { "VC", "Siŋ Viŋsi" },
            { "VE", "Vɛnɛzuwela" },
            { "VG", "Jengéesi Bhɛɛ Lɔ Musu Tiŋŋɛ" },
            { "VI", "Poo Bhɛɛ lɔ Musu Tiŋŋɛ" },
            { "VN", "Viyanami" },
            { "VU", "Vanuwátu" },
            { "WF", "Walísi" },
            { "WS", "Samowa" },
            { "YE", "Yemɛni" },
            { "YT", "Mavote" },
            { "ZA", "Afirika Kɔi Leŋŋɛ Lɔ" },
            { "ZM", "Zambiya" },
            { "ZW", "Zimbabhuwe" },
            { "ak", "Akaŋ" },
            { "am", "Amihári" },
            { "ar", metaValue_SA },
            { "be", "Bhelarusaŋ" },
            { "bg", "Bhɔgerɛŋ" },
            { "bn", "Bhɛŋgáli" },
            { "cs", "Chɛ" },
            { "de", metaValue_DE },
            { "el", metaValue_GR },
            { "en", metaValue_US },
            { "es", metaValue_ES },
            { "fa", "Pɛɛsiyɛŋ" },
            { "fr", metaValue_FR },
            { "ha", "Hawusa" },
            { "hi", "Híiŋdi" },
            { "hu", "Hɔŋgérɛŋ" },
            { "id", "Índonisiyɛŋ" },
            { "ig", "Ígbo" },
            { "it", "Itáliyɛŋ" },
            { "ja", "Japaníĩ" },
            { "jv", "Javaníĩ" },
            { "km", "Kimɛɛ̃ tɛ" },
            { "ko", "Koríyɛŋ" },
            { "ms", "Maléee" },
            { "my", "Bhɛmísi" },
            { "ne", "Nipali" },
            { "nl", "Dɔchi" },
            { "pa", "Puŋjabhi" },
            { "pl", "Pɔ́lési" },
            { "pt", metaValue_PT },
            { "ro", "Romíniyɛŋ" },
            { "ru", "Rɔshiyɛŋ" },
            { "rw", metaValue_RW },
            { "so", "Somáli" },
            { "sv", "Súwídɛŋ" },
            { "ta", "Tamíli" },
            { "th", "Tái" },
            { "tr", "Tɔ́ki" },
            { "uk", "Yukureniyɛŋ" },
            { "ur", "Ɔdu" },
            { "vi", "Viyamíĩ" },
            { "yo", "Yóróbha" },
            { "zh", "Chaniĩ" },
            { "zu", "Zúlu" },
            { "vai", "Vai" },
        };
        return data;
    }
}
