//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: cActionMapper.hpp
// Project: Shooting Star
// Author: 
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================
#ifndef cActionMapper_hpp
#define cActionMapper_hpp
//==============================================================================
// Includes
#include <map>
#include <SDL.h>
#include "cAction.hpp"
//------------------------------------------------------------------------------
// Namespaces
using namespace std;
namespace ShootingStar {
//------------------------------------------------------------------------------
// Forward declarations
//==============================================================================
	
//! ActionMapper
class cActionMapper
{
	// Constructor & Destructor
	public:
		//! Constructor
		cActionMapper (void);
		//! Destructor
		~cActionMapper (void);
	
	// Public methods
	public:
		//! Register keyboard action
		void RegisterKeyboardAction (SDLKey key, Uint8 state, const cAction &action);
        //! Register mouse action
        void RegisterMouseAction (Uint8 button, Uint8 state, const cAction &action);
		//! Clear all bindings
		void ClearBindings (void) 
        {    
            mKeyDownActions.clear ();
            mKeyUpActions.clear (); 
            mButtonDownActions.clear ();
            mButtonUpActions.clear ();
        };

	
		//! Map keyboard event to action
		const cAction &MapKeyboardEvent (const SDL_KeyboardEvent *pEvent);
        //! Map mouse event to action
        const cAction &MapMouseEvent (const SDL_MouseButtonEvent *pEvent);
	// Member variables
	private:
		map<SDLKey, cAction> mKeyDownActions;
		map<SDLKey, cAction> mKeyUpActions;
        map<Uint8, cAction> mButtonDownActions;
        map<Uint8, cAction> mButtonUpActions;
};

//==============================================================================
}		// End of the ShootingStar namespace
#endif // cActionMapper_hpp
//------------------------------------------------------------------------------
// EOF
//==============================================================================
