/*serial_w32.c

    icdprog - an open source PIC programmer for use with the Microchip ICD(1)
    Copyright (C) 2001-2004  Geir Thomassen.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <windows.h>
#include "icdprog.h"
#include "serial.h"

HANDLE icd_fd;  /* file descriptor for serial port */

#ifndef WIN32
#error "You are trying to compile serial_w32.c in a non Microsoft Windows"
       "environment, don't do that ... "
#endif

void udelay(unsigned usec)
{
	DWORD msec;

	msec  = usec / 1000;

	if(usec % 1000)
		msec++;

	Sleep(msec);
}

void dtr_set()
{
	if(!EscapeCommFunction(icd_fd,SETDTR)) {
		perror("EcapeCommFunction( .. , SETDTR)");
		exit(-1);
	}
}

void dtr_clear()
{
	if(!EscapeCommFunction(icd_fd,CLRDTR)) {
		perror("EcapeCommFunction( .. , CLRDTR)");
		exit(-1);
	}
}

void rts_set()
{
	if(!EscapeCommFunction(icd_fd,SETRTS)) {
		perror("EcapeCommFunction( .. , SETRTS)");
		exit(-1);
	}
}

void rts_clear()
{
	if(!EscapeCommFunction(icd_fd,CLRRTS)) {
		perror("EcapeCommFunction( .. , CLRRTS)");
		exit(-1);
	}
}

int icd_read(char *ch)
{
	DWORD n_read;

	if(!ReadFile(icd_fd, ch, 1, &n_read, NULL)) {
		perror("ReadFile");
		return -1;
	}

	return n_read;
}

int icd_write(void *data, unsigned n_bytes)
{
	DWORD n_written=0;

	if(!WriteFile(icd_fd,data,n_bytes,&n_written,NULL)) {
		perror("WriteFile");
		exit(-1);
	}

	if(n_written != n_bytes) {
		printf("WTF is going on ?\n");
	}

	return 0;
}

int serial_open(char *port)
{
	DCB CommParams;
	COMMTIMEOUTS CommTimeouts;

	icd_fd = CreateFile(port, GENERIC_READ | GENERIC_WRITE, 0, NULL,
			    OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);


	if(!GetCommState(icd_fd, &CommParams)) {
		perror("GetCommState");
		exit(1);
	}

	CommParams.BaudRate = BAUD_RATE;
	CommParams.fParity = FALSE;
	CommParams.fOutxCtsFlow = FALSE;
	CommParams.fOutxDsrFlow = FALSE;
	CommParams.fDtrControl = DTR_CONTROL_DISABLE;
	CommParams.fDsrSensitivity = FALSE;
	CommParams.fOutX = FALSE;
	CommParams.fInX = FALSE;
	CommParams.fNull = FALSE;
	CommParams.fRtsControl = RTS_CONTROL_DISABLE;
	CommParams.fAbortOnError = FALSE;
	CommParams.ByteSize = 8;
	CommParams.Parity = NOPARITY;
	CommParams.StopBits = ONESTOPBIT;

	if(!SetCommState(icd_fd,&CommParams)) {
		perror("SetCommState");
		exit(1);
	}

	if(!GetCommTimeouts(icd_fd,&CommTimeouts)) {
		perror("GetCommTimeouts");
		exit(1);
	}

	CommTimeouts.ReadIntervalTimeout = 1000;
	CommTimeouts.ReadTotalTimeoutMultiplier = 1000; 
	CommTimeouts.ReadTotalTimeoutConstant=1000;
	CommTimeouts.WriteTotalTimeoutMultiplier=0;
	CommTimeouts.WriteTotalTimeoutConstant=0;

	if(!SetCommTimeouts(icd_fd,&CommTimeouts)) {
		perror("SetCommTimeouts");
		exit(1);
	}

	return 0;
}

void serial_close()
{
	CloseHandle(icd_fd);
}

