// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq)]
pub struct StartAsyncInvokeInput {
    /// <p>Specify idempotency token to ensure that requests are not duplicated.</p>
    pub client_request_token: ::std::option::Option<::std::string::String>,
    /// <p>The model to invoke.</p>
    pub model_id: ::std::option::Option<::std::string::String>,
    /// <p>Input to send to the model.</p>
    pub model_input: ::std::option::Option<::aws_smithy_types::Document>,
    /// <p>Where to store the output.</p>
    pub output_data_config: ::std::option::Option<crate::types::AsyncInvokeOutputDataConfig>,
    /// <p>Tags to apply to the invocation.</p>
    pub tags: ::std::option::Option<::std::vec::Vec<crate::types::Tag>>,
}
impl StartAsyncInvokeInput {
    /// <p>Specify idempotency token to ensure that requests are not duplicated.</p>
    pub fn client_request_token(&self) -> ::std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>The model to invoke.</p>
    pub fn model_id(&self) -> ::std::option::Option<&str> {
        self.model_id.as_deref()
    }
    /// <p>Input to send to the model.</p>
    pub fn model_input(&self) -> ::std::option::Option<&::aws_smithy_types::Document> {
        self.model_input.as_ref()
    }
    /// <p>Where to store the output.</p>
    pub fn output_data_config(&self) -> ::std::option::Option<&crate::types::AsyncInvokeOutputDataConfig> {
        self.output_data_config.as_ref()
    }
    /// <p>Tags to apply to the invocation.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.tags.is_none()`.
    pub fn tags(&self) -> &[crate::types::Tag] {
        self.tags.as_deref().unwrap_or_default()
    }
}
impl ::std::fmt::Debug for StartAsyncInvokeInput {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        let mut formatter = f.debug_struct("StartAsyncInvokeInput");
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("model_id", &self.model_id);
        formatter.field("model_input", &"*** Sensitive Data Redacted ***");
        formatter.field("output_data_config", &self.output_data_config);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
impl StartAsyncInvokeInput {
    /// Creates a new builder-style object to manufacture [`StartAsyncInvokeInput`](crate::operation::start_async_invoke::StartAsyncInvokeInput).
    pub fn builder() -> crate::operation::start_async_invoke::builders::StartAsyncInvokeInputBuilder {
        crate::operation::start_async_invoke::builders::StartAsyncInvokeInputBuilder::default()
    }
}

/// A builder for [`StartAsyncInvokeInput`](crate::operation::start_async_invoke::StartAsyncInvokeInput).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default)]
#[non_exhaustive]
pub struct StartAsyncInvokeInputBuilder {
    pub(crate) client_request_token: ::std::option::Option<::std::string::String>,
    pub(crate) model_id: ::std::option::Option<::std::string::String>,
    pub(crate) model_input: ::std::option::Option<::aws_smithy_types::Document>,
    pub(crate) output_data_config: ::std::option::Option<crate::types::AsyncInvokeOutputDataConfig>,
    pub(crate) tags: ::std::option::Option<::std::vec::Vec<crate::types::Tag>>,
}
impl StartAsyncInvokeInputBuilder {
    /// <p>Specify idempotency token to ensure that requests are not duplicated.</p>
    pub fn client_request_token(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.client_request_token = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Specify idempotency token to ensure that requests are not duplicated.</p>
    pub fn set_client_request_token(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.client_request_token = input;
        self
    }
    /// <p>Specify idempotency token to ensure that requests are not duplicated.</p>
    pub fn get_client_request_token(&self) -> &::std::option::Option<::std::string::String> {
        &self.client_request_token
    }
    /// <p>The model to invoke.</p>
    /// This field is required.
    pub fn model_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.model_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The model to invoke.</p>
    pub fn set_model_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.model_id = input;
        self
    }
    /// <p>The model to invoke.</p>
    pub fn get_model_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.model_id
    }
    /// <p>Input to send to the model.</p>
    /// This field is required.
    pub fn model_input(mut self, input: ::aws_smithy_types::Document) -> Self {
        self.model_input = ::std::option::Option::Some(input);
        self
    }
    /// <p>Input to send to the model.</p>
    pub fn set_model_input(mut self, input: ::std::option::Option<::aws_smithy_types::Document>) -> Self {
        self.model_input = input;
        self
    }
    /// <p>Input to send to the model.</p>
    pub fn get_model_input(&self) -> &::std::option::Option<::aws_smithy_types::Document> {
        &self.model_input
    }
    /// <p>Where to store the output.</p>
    /// This field is required.
    pub fn output_data_config(mut self, input: crate::types::AsyncInvokeOutputDataConfig) -> Self {
        self.output_data_config = ::std::option::Option::Some(input);
        self
    }
    /// <p>Where to store the output.</p>
    pub fn set_output_data_config(mut self, input: ::std::option::Option<crate::types::AsyncInvokeOutputDataConfig>) -> Self {
        self.output_data_config = input;
        self
    }
    /// <p>Where to store the output.</p>
    pub fn get_output_data_config(&self) -> &::std::option::Option<crate::types::AsyncInvokeOutputDataConfig> {
        &self.output_data_config
    }
    /// Appends an item to `tags`.
    ///
    /// To override the contents of this collection use [`set_tags`](Self::set_tags).
    ///
    /// <p>Tags to apply to the invocation.</p>
    pub fn tags(mut self, input: crate::types::Tag) -> Self {
        let mut v = self.tags.unwrap_or_default();
        v.push(input);
        self.tags = ::std::option::Option::Some(v);
        self
    }
    /// <p>Tags to apply to the invocation.</p>
    pub fn set_tags(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::Tag>>) -> Self {
        self.tags = input;
        self
    }
    /// <p>Tags to apply to the invocation.</p>
    pub fn get_tags(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::Tag>> {
        &self.tags
    }
    /// Consumes the builder and constructs a [`StartAsyncInvokeInput`](crate::operation::start_async_invoke::StartAsyncInvokeInput).
    pub fn build(
        self,
    ) -> ::std::result::Result<crate::operation::start_async_invoke::StartAsyncInvokeInput, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::operation::start_async_invoke::StartAsyncInvokeInput {
            client_request_token: self.client_request_token,
            model_id: self.model_id,
            model_input: self.model_input,
            output_data_config: self.output_data_config,
            tags: self.tags,
        })
    }
}
impl ::std::fmt::Debug for StartAsyncInvokeInputBuilder {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        let mut formatter = f.debug_struct("StartAsyncInvokeInputBuilder");
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("model_id", &self.model_id);
        formatter.field("model_input", &"*** Sensitive Data Redacted ***");
        formatter.field("output_data_config", &self.output_data_config);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
