// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Contain an image which user wants guarded. This block is accepted by the guardrails independent API.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq)]
pub struct GuardrailImageBlock {
    /// <p>The format details for the file type of the image blocked by the guardrail.</p>
    pub format: crate::types::GuardrailImageFormat,
    /// <p>The image source (image bytes) details of the image blocked by the guardrail.</p>
    pub source: ::std::option::Option<crate::types::GuardrailImageSource>,
}
impl GuardrailImageBlock {
    /// <p>The format details for the file type of the image blocked by the guardrail.</p>
    pub fn format(&self) -> &crate::types::GuardrailImageFormat {
        &self.format
    }
    /// <p>The image source (image bytes) details of the image blocked by the guardrail.</p>
    pub fn source(&self) -> ::std::option::Option<&crate::types::GuardrailImageSource> {
        self.source.as_ref()
    }
}
impl ::std::fmt::Debug for GuardrailImageBlock {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        let mut formatter = f.debug_struct("GuardrailImageBlock");
        formatter.field("format", &"*** Sensitive Data Redacted ***");
        formatter.field("source", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
impl GuardrailImageBlock {
    /// Creates a new builder-style object to manufacture [`GuardrailImageBlock`](crate::types::GuardrailImageBlock).
    pub fn builder() -> crate::types::builders::GuardrailImageBlockBuilder {
        crate::types::builders::GuardrailImageBlockBuilder::default()
    }
}

/// A builder for [`GuardrailImageBlock`](crate::types::GuardrailImageBlock).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default)]
#[non_exhaustive]
pub struct GuardrailImageBlockBuilder {
    pub(crate) format: ::std::option::Option<crate::types::GuardrailImageFormat>,
    pub(crate) source: ::std::option::Option<crate::types::GuardrailImageSource>,
}
impl GuardrailImageBlockBuilder {
    /// <p>The format details for the file type of the image blocked by the guardrail.</p>
    /// This field is required.
    pub fn format(mut self, input: crate::types::GuardrailImageFormat) -> Self {
        self.format = ::std::option::Option::Some(input);
        self
    }
    /// <p>The format details for the file type of the image blocked by the guardrail.</p>
    pub fn set_format(mut self, input: ::std::option::Option<crate::types::GuardrailImageFormat>) -> Self {
        self.format = input;
        self
    }
    /// <p>The format details for the file type of the image blocked by the guardrail.</p>
    pub fn get_format(&self) -> &::std::option::Option<crate::types::GuardrailImageFormat> {
        &self.format
    }
    /// <p>The image source (image bytes) details of the image blocked by the guardrail.</p>
    /// This field is required.
    pub fn source(mut self, input: crate::types::GuardrailImageSource) -> Self {
        self.source = ::std::option::Option::Some(input);
        self
    }
    /// <p>The image source (image bytes) details of the image blocked by the guardrail.</p>
    pub fn set_source(mut self, input: ::std::option::Option<crate::types::GuardrailImageSource>) -> Self {
        self.source = input;
        self
    }
    /// <p>The image source (image bytes) details of the image blocked by the guardrail.</p>
    pub fn get_source(&self) -> &::std::option::Option<crate::types::GuardrailImageSource> {
        &self.source
    }
    /// Consumes the builder and constructs a [`GuardrailImageBlock`](crate::types::GuardrailImageBlock).
    /// This method will fail if any of the following fields are not set:
    /// - [`format`](crate::types::builders::GuardrailImageBlockBuilder::format)
    pub fn build(self) -> ::std::result::Result<crate::types::GuardrailImageBlock, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::GuardrailImageBlock {
            format: self.format.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "format",
                    "format was not specified but it is required when building GuardrailImageBlock",
                )
            })?,
            source: self.source,
        })
    }
}
impl ::std::fmt::Debug for GuardrailImageBlockBuilder {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        let mut formatter = f.debug_struct("GuardrailImageBlockBuilder");
        formatter.field("format", &"*** Sensitive Data Redacted ***");
        formatter.field("source", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
