/*
 * Decompiled with CFR 0.152.
 */
package martin.tempest.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JPanel;
import martin.tempest.gui.scale.LogScale;

public class SNRVisualizer
extends JPanel {
    private static final double DB_PADDING = 2.0;
    private static final double FONT_SPACING_COEFF = 1.5;
    private static final double LOWEST_DB = -50.7;
    private static final double HIGHEST_DB = 0.6;
    private static final double FONT_SIZE_COEFF = 0.8;
    private static final long serialVersionUID = 6629300250729955406L;
    private int nwidth = 1;
    private int nheight = 1;
    private double snr_db = -60.7;
    private double max_snr_db;
    private double min_snr_db;
    private boolean max_min_set = false;
    private boolean font_set = false;
    private Font font;
    private static final Color background = new Color(150, 170, 130);
    private static final Color default_txt_colour_background;
    private static final Color snr_txt_colour_background;
    private int fontsize = 12;
    private final LogScale scale_y = new LogScale(default_txt_colour_background, 1.5, -50.7, 0.6);
    private final Object locker = new Object();

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        this.nwidth = n3;
        this.nheight = n4;
        this.scale_y.setDimentions(this.nwidth, this.nheight);
        super.setBounds(n, n2, n3, n4);
    }

    @Override
    public void setBounds(Rectangle rectangle) {
        this.nwidth = rectangle.width;
        this.nheight = rectangle.height;
        this.scale_y.setDimentions(this.nwidth, this.nheight);
        super.setBounds(rectangle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSNRValue(double d) {
        Object object = this.locker;
        synchronized (object) {
            this.snr_db = this.scale_y.valtodb(d);
            if (!this.max_min_set) {
                this.max_min_set = true;
                this.min_snr_db = this.snr_db;
                this.max_snr_db = this.snr_db;
            } else if (this.snr_db > this.max_snr_db) {
                this.max_snr_db = this.snr_db;
            } else if (this.snr_db < this.min_snr_db) {
                this.min_snr_db = this.snr_db;
            }
            this.scale_y.setLowestHighestDb(this.min_snr_db - 2.0, this.max_snr_db + 2.0);
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics graphics) {
        Object object = this.locker;
        synchronized (object) {
            int n = this.nwidth;
            int n2 = this.nheight;
            if (!this.font_set) {
                Font font = graphics.getFont();
                this.font = new Font(font.getFontName(), 0, (int)((double)font.getSize() * 0.8));
                graphics.setFont(this.font);
                this.font_set = true;
                this.fontsize = graphics.getFont().getSize();
            } else {
                graphics.setFont(this.font);
            }
            graphics.setColor(background);
            graphics.fillRect(0, 0, n, n2);
            if (this.snr_db < this.scale_y.getHighestDb() && this.snr_db > this.scale_y.getLowestDb()) {
                int n3 = this.scale_y.dbtopx(this.snr_db);
                graphics.setColor(snr_txt_colour_background);
                graphics.drawLine(0, n3, this.nwidth, n3);
                graphics.drawString(String.format("%.2f", this.snr_db), 0, (int)((double)n3 + 1.5 * (double)this.fontsize));
                graphics.drawString("dB", 0, (int)((double)n3 - 0.5 * (double)this.fontsize));
            }
            this.scale_y.paintScale(graphics);
        }
    }

    static {
        snr_txt_colour_background = default_txt_colour_background = Color.DARK_GRAY;
    }
}

