# This file has been automatically generated from a template file.
# Please make modifications to `templates/gRPC-C++.podspec.template`
# instead. This file can be regenerated from the template by running
# `tools/buildgen/generate_projects.sh`.

# gRPC C++ CocoaPods podspec
#
# Copyright 2017 gRPC authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

Pod::Spec.new do |s|
  s.name     = 'gRPC-C++'
  # TODO (mxyan): use version that match gRPC version when pod is stabilized
  version = '1.78.1'
  s.version  = version
  s.summary  = 'gRPC C++ library'
  s.homepage = 'https://grpc.io'
  s.license  = 'Apache License, Version 2.0'
  s.authors  = { 'The gRPC contributors' => 'grpc-packages@google.com' }

  s.source = {
    :git => 'https://github.com/grpc/grpc.git',
    :tag => "v#{version}",
  }

  s.ios.deployment_target = '15.0'
  s.osx.deployment_target = '11.0'
  s.tvos.deployment_target = '13.0'
  s.watchos.deployment_target = '6.0'
  s.visionos.deployment_target = '1.0'

  s.requires_arc = false

  name = 'grpcpp'
  # Use `grpcpp` as framework name so that `#include <grpcpp/xxx.h>` works when built as
  # framework.
  s.module_name = name

  # Add include prefix `grpcpp` so that `#include <grpcpp/xxx.h>` works when built as static
  # library.
  s.header_dir = name

  s.pod_target_xcconfig = {
    'HEADER_SEARCH_PATHS' => '"$(inherited)" "$(PODS_TARGET_SRCROOT)/include"'\
        ' "$(PODS_TARGET_SRCROOT)/third_party/address_sorting/include"',
    'USER_HEADER_SEARCH_PATHS' => '"$(PODS_TARGET_SRCROOT)"'\
        ' "$(PODS_TARGET_SRCROOT)/src/core/ext/upb-gen"'\
        ' "$(PODS_TARGET_SRCROOT)/src/core/ext/upbdefs-gen"'\
        ' "$(PODS_TARGET_SRCROOT)/third_party/re2"'\
        ' "$(PODS_TARGET_SRCROOT)/third_party/upb"'\
        ' "$(PODS_TARGET_SRCROOT)/third_party/xxhash"',
    'GCC_PREPROCESSOR_DEFINITIONS' => '"$(inherited)" "COCOAPODS=1"',
    'CLANG_WARN_STRICT_PROTOTYPES' => 'NO',
    'CLANG_WARN_DOCUMENTATION_COMMENTS' => 'NO',

    # If we don't set these two settings, `include/grpc/support/time.h` and
    # `src/core/lib/support/string.h` shadow the system `<time.h>` and `<string.h>`, breaking the
    # build.
    'USE_HEADERMAP' => 'NO',
    'ALWAYS_SEARCH_USER_PATHS' => 'NO',
    'CLANG_CXX_LANGUAGE_STANDARD' => 'c++17',
  }

  s.libraries = 'c++'
  s.compiler_flags = '-Wno-comma -Wno-unreachable-code -Wno-shorten-64-to-32'

  s.default_subspecs = 'Interface', 'Implementation'

  # Certificates, to be able to establish TLS connections:
  s.resource_bundles = { 'gRPCCertificates-Cpp' => ['etc/roots.pem'] }

  s.header_mappings_dir = 'include/grpcpp'

  # Exposes the privacy manifest. Depended on by any subspecs containing
  # non-interface files.
  s.subspec 'Privacy' do |ss|
    ss.resource_bundles = {
      s.module_name => 'src/objective-c/PrivacyInfo.xcprivacy'
    }
  end

  s.subspec 'Interface' do |ss|
    ss.header_mappings_dir = 'include/grpcpp'

    ss.source_files = 'include/grpcpp/alarm.h',
                      'include/grpcpp/channel.h',
                      'include/grpcpp/client_context.h',
                      'include/grpcpp/completion_queue.h',
                      'include/grpcpp/create_channel.h',
                      'include/grpcpp/create_channel_posix.h',
                      'include/grpcpp/ext/call_metric_recorder.h',
                      'include/grpcpp/ext/health_check_service_server_builder_option.h',
                      'include/grpcpp/ext/server_metric_recorder.h',
                      'include/grpcpp/generic/async_generic_service.h',
                      'include/grpcpp/generic/callback_generic_service.h',
                      'include/grpcpp/generic/generic_stub.h',
                      'include/grpcpp/generic/generic_stub_callback.h',
                      'include/grpcpp/grpcpp.h',
                      'include/grpcpp/health_check_service_interface.h',
                      'include/grpcpp/impl/call.h',
                      'include/grpcpp/impl/call_hook.h',
                      'include/grpcpp/impl/call_op_set.h',
                      'include/grpcpp/impl/call_op_set_interface.h',
                      'include/grpcpp/impl/channel_argument_option.h',
                      'include/grpcpp/impl/channel_interface.h',
                      'include/grpcpp/impl/client_unary_call.h',
                      'include/grpcpp/impl/codegen/async_generic_service.h',
                      'include/grpcpp/impl/codegen/async_stream.h',
                      'include/grpcpp/impl/codegen/async_unary_call.h',
                      'include/grpcpp/impl/codegen/byte_buffer.h',
                      'include/grpcpp/impl/codegen/call.h',
                      'include/grpcpp/impl/codegen/call_hook.h',
                      'include/grpcpp/impl/codegen/call_op_set.h',
                      'include/grpcpp/impl/codegen/call_op_set_interface.h',
                      'include/grpcpp/impl/codegen/callback_common.h',
                      'include/grpcpp/impl/codegen/channel_interface.h',
                      'include/grpcpp/impl/codegen/client_callback.h',
                      'include/grpcpp/impl/codegen/client_context.h',
                      'include/grpcpp/impl/codegen/client_interceptor.h',
                      'include/grpcpp/impl/codegen/client_unary_call.h',
                      'include/grpcpp/impl/codegen/completion_queue.h',
                      'include/grpcpp/impl/codegen/completion_queue_tag.h',
                      'include/grpcpp/impl/codegen/config.h',
                      'include/grpcpp/impl/codegen/create_auth_context.h',
                      'include/grpcpp/impl/codegen/delegating_channel.h',
                      'include/grpcpp/impl/codegen/intercepted_channel.h',
                      'include/grpcpp/impl/codegen/interceptor.h',
                      'include/grpcpp/impl/codegen/interceptor_common.h',
                      'include/grpcpp/impl/codegen/message_allocator.h',
                      'include/grpcpp/impl/codegen/metadata_map.h',
                      'include/grpcpp/impl/codegen/method_handler.h',
                      'include/grpcpp/impl/codegen/method_handler_impl.h',
                      'include/grpcpp/impl/codegen/rpc_method.h',
                      'include/grpcpp/impl/codegen/rpc_service_method.h',
                      'include/grpcpp/impl/codegen/security/auth_context.h',
                      'include/grpcpp/impl/codegen/serialization_traits.h',
                      'include/grpcpp/impl/codegen/server_callback.h',
                      'include/grpcpp/impl/codegen/server_callback_handlers.h',
                      'include/grpcpp/impl/codegen/server_context.h',
                      'include/grpcpp/impl/codegen/server_interceptor.h',
                      'include/grpcpp/impl/codegen/server_interface.h',
                      'include/grpcpp/impl/codegen/service_type.h',
                      'include/grpcpp/impl/codegen/slice.h',
                      'include/grpcpp/impl/codegen/status.h',
                      'include/grpcpp/impl/codegen/status_code_enum.h',
                      'include/grpcpp/impl/codegen/string_ref.h',
                      'include/grpcpp/impl/codegen/stub_options.h',
                      'include/grpcpp/impl/codegen/sync.h',
                      'include/grpcpp/impl/codegen/sync_stream.h',
                      'include/grpcpp/impl/codegen/time.h',
                      'include/grpcpp/impl/completion_queue_tag.h',
                      'include/grpcpp/impl/create_auth_context.h',
                      'include/grpcpp/impl/delegating_channel.h',
                      'include/grpcpp/impl/generic_serialize.h',
                      'include/grpcpp/impl/generic_stub_internal.h',
                      'include/grpcpp/impl/grpc_library.h',
                      'include/grpcpp/impl/intercepted_channel.h',
                      'include/grpcpp/impl/interceptor_common.h',
                      'include/grpcpp/impl/metadata_map.h',
                      'include/grpcpp/impl/method_handler_impl.h',
                      'include/grpcpp/impl/proto_utils.h',
                      'include/grpcpp/impl/rpc_method.h',
                      'include/grpcpp/impl/rpc_service_method.h',
                      'include/grpcpp/impl/serialization_traits.h',
                      'include/grpcpp/impl/server_builder_option.h',
                      'include/grpcpp/impl/server_builder_plugin.h',
                      'include/grpcpp/impl/server_callback_handlers.h',
                      'include/grpcpp/impl/server_initializer.h',
                      'include/grpcpp/impl/service_type.h',
                      'include/grpcpp/impl/status.h',
                      'include/grpcpp/impl/sync.h',
                      'include/grpcpp/passive_listener.h',
                      'include/grpcpp/ports_def.inc',
                      'include/grpcpp/ports_undef.inc',
                      'include/grpcpp/resource_quota.h',
                      'include/grpcpp/security/audit_logging.h',
                      'include/grpcpp/security/auth_context.h',
                      'include/grpcpp/security/auth_metadata_processor.h',
                      'include/grpcpp/security/authorization_policy_provider.h',
                      'include/grpcpp/security/credentials.h',
                      'include/grpcpp/security/server_credentials.h',
                      'include/grpcpp/security/tls_certificate_provider.h',
                      'include/grpcpp/security/tls_certificate_verifier.h',
                      'include/grpcpp/security/tls_credentials_options.h',
                      'include/grpcpp/security/tls_crl_provider.h',
                      'include/grpcpp/server.h',
                      'include/grpcpp/server_builder.h',
                      'include/grpcpp/server_context.h',
                      'include/grpcpp/server_interface.h',
                      'include/grpcpp/server_posix.h',
                      'include/grpcpp/support/async_stream.h',
                      'include/grpcpp/support/async_unary_call.h',
                      'include/grpcpp/support/byte_buffer.h',
                      'include/grpcpp/support/callback_common.h',
                      'include/grpcpp/support/channel_arguments.h',
                      'include/grpcpp/support/client_callback.h',
                      'include/grpcpp/support/client_interceptor.h',
                      'include/grpcpp/support/config.h',
                      'include/grpcpp/support/global_callback_hook.h',
                      'include/grpcpp/support/interceptor.h',
                      'include/grpcpp/support/message_allocator.h',
                      'include/grpcpp/support/method_handler.h',
                      'include/grpcpp/support/proto_buffer_reader.h',
                      'include/grpcpp/support/proto_buffer_writer.h',
                      'include/grpcpp/support/server_callback.h',
                      'include/grpcpp/support/server_interceptor.h',
                      'include/grpcpp/support/slice.h',
                      'include/grpcpp/support/status.h',
                      'include/grpcpp/support/status_code_enum.h',
                      'include/grpcpp/support/string_ref.h',
                      'include/grpcpp/support/stub_options.h',
                      'include/grpcpp/support/sync_stream.h',
                      'include/grpcpp/support/time.h',
                      'include/grpcpp/support/validate_service_config.h',
                      'include/grpcpp/version_info.h',
                      'include/grpcpp/xds_server_builder.h'
  end

  s.subspec 'Implementation' do |ss|
    ss.header_mappings_dir = '.'
    ss.dependency "#{s.name}/Privacy", version
    ss.dependency "#{s.name}/Interface", version
    ss.dependency 'gRPC-Core', version
    abseil_version = '~> 1.20250512.1'
    ss.dependency 'abseil/algorithm/container', abseil_version
    ss.dependency 'abseil/base/base', abseil_version
    ss.dependency 'abseil/base/config', abseil_version
    ss.dependency 'abseil/base/core_headers', abseil_version
    ss.dependency 'abseil/base/dynamic_annotations', abseil_version
    ss.dependency 'abseil/base/log_severity', abseil_version
    ss.dependency 'abseil/base/no_destructor', abseil_version
    ss.dependency 'abseil/base/prefetch', abseil_version
    ss.dependency 'abseil/cleanup/cleanup', abseil_version
    ss.dependency 'abseil/container/btree', abseil_version
    ss.dependency 'abseil/container/flat_hash_map', abseil_version
    ss.dependency 'abseil/container/flat_hash_set', abseil_version
    ss.dependency 'abseil/container/inlined_vector', abseil_version
    ss.dependency 'abseil/container/layout', abseil_version
    ss.dependency 'abseil/container/node_hash_map', abseil_version
    ss.dependency 'abseil/flags/flag', abseil_version
    ss.dependency 'abseil/flags/marshalling', abseil_version
    ss.dependency 'abseil/functional/any_invocable', abseil_version
    ss.dependency 'abseil/functional/bind_front', abseil_version
    ss.dependency 'abseil/functional/function_ref', abseil_version
    ss.dependency 'abseil/hash/hash', abseil_version
    ss.dependency 'abseil/log/absl_check', abseil_version
    ss.dependency 'abseil/log/absl_log', abseil_version
    ss.dependency 'abseil/log/check', abseil_version
    ss.dependency 'abseil/log/globals', abseil_version
    ss.dependency 'abseil/log/log', abseil_version
    ss.dependency 'abseil/memory/memory', abseil_version
    ss.dependency 'abseil/meta/type_traits', abseil_version
    ss.dependency 'abseil/numeric/bits', abseil_version
    ss.dependency 'abseil/random/bit_gen_ref', abseil_version
    ss.dependency 'abseil/random/distributions', abseil_version
    ss.dependency 'abseil/random/random', abseil_version
    ss.dependency 'abseil/status/status', abseil_version
    ss.dependency 'abseil/status/statusor', abseil_version
    ss.dependency 'abseil/strings/cord', abseil_version
    ss.dependency 'abseil/strings/internal', abseil_version
    ss.dependency 'abseil/strings/str_format', abseil_version
    ss.dependency 'abseil/strings/string_view', abseil_version
    ss.dependency 'abseil/strings/strings', abseil_version
    ss.dependency 'abseil/synchronization/synchronization', abseil_version
    ss.dependency 'abseil/time/time', abseil_version
    ss.dependency 'abseil/types/optional', abseil_version
    ss.dependency 'abseil/types/span', abseil_version
    ss.dependency 'abseil/utility/utility', abseil_version

    ss.source_files = 'src/core/call/call_arena_allocator.h',
                      'src/core/call/call_destination.h',
                      'src/core/call/call_filters.h',
                      'src/core/call/call_finalization.h',
                      'src/core/call/call_spine.h',
                      'src/core/call/call_state.h',
                      'src/core/call/channelz_context.h',
                      'src/core/call/client_call.h',
                      'src/core/call/custom_metadata.h',
                      'src/core/call/filter_fusion.h',
                      'src/core/call/interception_chain.h',
                      'src/core/call/message.h',
                      'src/core/call/metadata.h',
                      'src/core/call/metadata_batch.h',
                      'src/core/call/metadata_compression_traits.h',
                      'src/core/call/metadata_info.h',
                      'src/core/call/parsed_metadata.h',
                      'src/core/call/request_buffer.h',
                      'src/core/call/security_context.h',
                      'src/core/call/server_call.h',
                      'src/core/call/simple_slice_based_metadata.h',
                      'src/core/call/status_util.h',
                      'src/core/channelz/channel_trace.h',
                      'src/core/channelz/channelz.h',
                      'src/core/channelz/channelz_registry.h',
                      'src/core/channelz/property_list.h',
                      'src/core/channelz/text_encode.h',
                      'src/core/channelz/v2tov1/convert.h',
                      'src/core/channelz/v2tov1/legacy_api.h',
                      'src/core/channelz/v2tov1/property_list.h',
                      'src/core/channelz/ztrace_collector.h',
                      'src/core/client_channel/backup_poller.h',
                      'src/core/client_channel/buffered_call.h',
                      'src/core/client_channel/client_channel.h',
                      'src/core/client_channel/client_channel_args.h',
                      'src/core/client_channel/client_channel_factory.h',
                      'src/core/client_channel/client_channel_filter.h',
                      'src/core/client_channel/client_channel_internal.h',
                      'src/core/client_channel/client_channel_service_config.h',
                      'src/core/client_channel/config_selector.h',
                      'src/core/client_channel/connector.h',
                      'src/core/client_channel/direct_channel.h',
                      'src/core/client_channel/dynamic_filters.h',
                      'src/core/client_channel/global_subchannel_pool.h',
                      'src/core/client_channel/lb_metadata.h',
                      'src/core/client_channel/load_balanced_call_destination.h',
                      'src/core/client_channel/local_subchannel_pool.h',
                      'src/core/client_channel/retry_filter.h',
                      'src/core/client_channel/retry_filter_legacy_call_data.h',
                      'src/core/client_channel/retry_interceptor.h',
                      'src/core/client_channel/retry_service_config.h',
                      'src/core/client_channel/retry_throttle.h',
                      'src/core/client_channel/subchannel.h',
                      'src/core/client_channel/subchannel_interface_internal.h',
                      'src/core/client_channel/subchannel_pool_interface.h',
                      'src/core/client_channel/subchannel_stream_client.h',
                      'src/core/config/config_vars.h',
                      'src/core/config/core_configuration.h',
                      'src/core/config/load_config.h',
                      'src/core/credentials/call/call_credentials.h',
                      'src/core/credentials/call/call_creds_registry.h',
                      'src/core/credentials/call/call_creds_util.h',
                      'src/core/credentials/call/composite/composite_call_credentials.h',
                      'src/core/credentials/call/external/aws_external_account_credentials.h',
                      'src/core/credentials/call/external/aws_request_signer.h',
                      'src/core/credentials/call/external/external_account_credentials.h',
                      'src/core/credentials/call/external/file_external_account_credentials.h',
                      'src/core/credentials/call/external/url_external_account_credentials.h',
                      'src/core/credentials/call/gcp_service_account_identity/gcp_service_account_identity_credentials.h',
                      'src/core/credentials/call/iam/iam_credentials.h',
                      'src/core/credentials/call/json_util.h',
                      'src/core/credentials/call/jwt/json_token.h',
                      'src/core/credentials/call/jwt/jwt_credentials.h',
                      'src/core/credentials/call/jwt/jwt_verifier.h',
                      'src/core/credentials/call/jwt_token_file/jwt_token_file_call_credentials.h',
                      'src/core/credentials/call/jwt_util.h',
                      'src/core/credentials/call/oauth2/oauth2_credentials.h',
                      'src/core/credentials/call/plugin/plugin_credentials.h',
                      'src/core/credentials/call/token_fetcher/token_fetcher_credentials.h',
                      'src/core/credentials/transport/alts/alts_credentials.h',
                      'src/core/credentials/transport/alts/alts_security_connector.h',
                      'src/core/credentials/transport/alts/check_gcp_environment.h',
                      'src/core/credentials/transport/alts/grpc_alts_credentials_options.h',
                      'src/core/credentials/transport/channel_creds_registry.h',
                      'src/core/credentials/transport/composite/composite_channel_credentials.h',
                      'src/core/credentials/transport/fake/fake_credentials.h',
                      'src/core/credentials/transport/fake/fake_security_connector.h',
                      'src/core/credentials/transport/google_default/google_default_credentials.h',
                      'src/core/credentials/transport/insecure/insecure_credentials.h',
                      'src/core/credentials/transport/insecure/insecure_security_connector.h',
                      'src/core/credentials/transport/local/local_credentials.h',
                      'src/core/credentials/transport/local/local_security_connector.h',
                      'src/core/credentials/transport/security_connector.h',
                      'src/core/credentials/transport/ssl/ssl_credentials.h',
                      'src/core/credentials/transport/ssl/ssl_security_connector.h',
                      'src/core/credentials/transport/tls/certificate_provider_factory.h',
                      'src/core/credentials/transport/tls/certificate_provider_registry.h',
                      'src/core/credentials/transport/tls/grpc_tls_certificate_distributor.h',
                      'src/core/credentials/transport/tls/grpc_tls_certificate_provider.h',
                      'src/core/credentials/transport/tls/grpc_tls_certificate_verifier.h',
                      'src/core/credentials/transport/tls/grpc_tls_credentials_options.h',
                      'src/core/credentials/transport/tls/grpc_tls_crl_provider.h',
                      'src/core/credentials/transport/tls/load_system_roots.h',
                      'src/core/credentials/transport/tls/load_system_roots_supported.h',
                      'src/core/credentials/transport/tls/spiffe_utils.h',
                      'src/core/credentials/transport/tls/ssl_utils.h',
                      'src/core/credentials/transport/tls/tls_credentials.h',
                      'src/core/credentials/transport/tls/tls_security_connector.h',
                      'src/core/credentials/transport/tls/tls_utils.h',
                      'src/core/credentials/transport/transport_credentials.h',
                      'src/core/credentials/transport/xds/xds_credentials.h',
                      'src/core/ext/filters/backend_metrics/backend_metric_filter.h',
                      'src/core/ext/filters/backend_metrics/backend_metric_provider.h',
                      'src/core/ext/filters/channel_idle/idle_filter_state.h',
                      'src/core/ext/filters/channel_idle/legacy_channel_idle_filter.h',
                      'src/core/ext/filters/fault_injection/fault_injection_filter.h',
                      'src/core/ext/filters/fault_injection/fault_injection_service_config_parser.h',
                      'src/core/ext/filters/gcp_authentication/gcp_authentication_filter.h',
                      'src/core/ext/filters/gcp_authentication/gcp_authentication_service_config_parser.h',
                      'src/core/ext/filters/http/client/http_client_filter.h',
                      'src/core/ext/filters/http/client_authority_filter.h',
                      'src/core/ext/filters/http/message_compress/compression_filter.h',
                      'src/core/ext/filters/http/server/http_server_filter.h',
                      'src/core/ext/filters/message_size/message_size_filter.h',
                      'src/core/ext/filters/rbac/rbac_filter.h',
                      'src/core/ext/filters/rbac/rbac_service_config_parser.h',
                      'src/core/ext/filters/stateful_session/stateful_session_filter.h',
                      'src/core/ext/filters/stateful_session/stateful_session_service_config_parser.h',
                      'src/core/ext/transport/chttp2/alpn/alpn.h',
                      'src/core/ext/transport/chttp2/client/chttp2_connector.h',
                      'src/core/ext/transport/chttp2/server/chttp2_server.h',
                      'src/core/ext/transport/chttp2/transport/bin_decoder.h',
                      'src/core/ext/transport/chttp2/transport/bin_encoder.h',
                      'src/core/ext/transport/chttp2/transport/call_tracer_wrapper.h',
                      'src/core/ext/transport/chttp2/transport/chttp2_transport.h',
                      'src/core/ext/transport/chttp2/transport/decode_huff.h',
                      'src/core/ext/transport/chttp2/transport/flow_control.h',
                      'src/core/ext/transport/chttp2/transport/flow_control_manager.h',
                      'src/core/ext/transport/chttp2/transport/frame.h',
                      'src/core/ext/transport/chttp2/transport/frame_data.h',
                      'src/core/ext/transport/chttp2/transport/frame_goaway.h',
                      'src/core/ext/transport/chttp2/transport/frame_ping.h',
                      'src/core/ext/transport/chttp2/transport/frame_rst_stream.h',
                      'src/core/ext/transport/chttp2/transport/frame_security.h',
                      'src/core/ext/transport/chttp2/transport/frame_settings.h',
                      'src/core/ext/transport/chttp2/transport/frame_window_update.h',
                      'src/core/ext/transport/chttp2/transport/goaway.h',
                      'src/core/ext/transport/chttp2/transport/header_assembler.h',
                      'src/core/ext/transport/chttp2/transport/hpack_constants.h',
                      'src/core/ext/transport/chttp2/transport/hpack_encoder.h',
                      'src/core/ext/transport/chttp2/transport/hpack_encoder_table.h',
                      'src/core/ext/transport/chttp2/transport/hpack_parse_result.h',
                      'src/core/ext/transport/chttp2/transport/hpack_parser.h',
                      'src/core/ext/transport/chttp2/transport/hpack_parser_table.h',
                      'src/core/ext/transport/chttp2/transport/http2_client_transport.h',
                      'src/core/ext/transport/chttp2/transport/http2_settings.h',
                      'src/core/ext/transport/chttp2/transport/http2_settings_manager.h',
                      'src/core/ext/transport/chttp2/transport/http2_settings_promises.h',
                      'src/core/ext/transport/chttp2/transport/http2_stats_collector.h',
                      'src/core/ext/transport/chttp2/transport/http2_status.h',
                      'src/core/ext/transport/chttp2/transport/http2_transport.h',
                      'src/core/ext/transport/chttp2/transport/http2_ztrace_collector.h',
                      'src/core/ext/transport/chttp2/transport/huffsyms.h',
                      'src/core/ext/transport/chttp2/transport/incoming_metadata_tracker.h',
                      'src/core/ext/transport/chttp2/transport/internal.h',
                      'src/core/ext/transport/chttp2/transport/internal_channel_arg_names.h',
                      'src/core/ext/transport/chttp2/transport/keepalive.h',
                      'src/core/ext/transport/chttp2/transport/legacy_frame.h',
                      'src/core/ext/transport/chttp2/transport/message_assembler.h',
                      'src/core/ext/transport/chttp2/transport/ping_abuse_policy.h',
                      'src/core/ext/transport/chttp2/transport/ping_callbacks.h',
                      'src/core/ext/transport/chttp2/transport/ping_promise.h',
                      'src/core/ext/transport/chttp2/transport/ping_rate_policy.h',
                      'src/core/ext/transport/chttp2/transport/security_frame.h',
                      'src/core/ext/transport/chttp2/transport/stream.h',
                      'src/core/ext/transport/chttp2/transport/stream_data_queue.h',
                      'src/core/ext/transport/chttp2/transport/stream_lists.h',
                      'src/core/ext/transport/chttp2/transport/transport_common.h',
                      'src/core/ext/transport/chttp2/transport/varint.h',
                      'src/core/ext/transport/chttp2/transport/writable_streams.h',
                      'src/core/ext/transport/chttp2/transport/write_size_policy.h',
                      'src/core/ext/transport/inproc/inproc_transport.h',
                      'src/core/ext/transport/inproc/legacy_inproc_transport.h',
                      'src/core/ext/upb-gen/envoy/admin/v3/certs.upb.h',
                      'src/core/ext/upb-gen/envoy/admin/v3/certs.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/admin/v3/clusters.upb.h',
                      'src/core/ext/upb-gen/envoy/admin/v3/clusters.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/admin/v3/config_dump.upb.h',
                      'src/core/ext/upb-gen/envoy/admin/v3/config_dump.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/admin/v3/config_dump_shared.upb.h',
                      'src/core/ext/upb-gen/envoy/admin/v3/config_dump_shared.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/admin/v3/init_dump.upb.h',
                      'src/core/ext/upb-gen/envoy/admin/v3/init_dump.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/admin/v3/listeners.upb.h',
                      'src/core/ext/upb-gen/envoy/admin/v3/listeners.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/admin/v3/memory.upb.h',
                      'src/core/ext/upb-gen/envoy/admin/v3/memory.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/admin/v3/metrics.upb.h',
                      'src/core/ext/upb-gen/envoy/admin/v3/metrics.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/admin/v3/mutex_stats.upb.h',
                      'src/core/ext/upb-gen/envoy/admin/v3/mutex_stats.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/admin/v3/server_info.upb.h',
                      'src/core/ext/upb-gen/envoy/admin/v3/server_info.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/admin/v3/tap.upb.h',
                      'src/core/ext/upb-gen/envoy/admin/v3/tap.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/annotations/deprecation.upb.h',
                      'src/core/ext/upb-gen/envoy/annotations/deprecation.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/annotations/resource.upb.h',
                      'src/core/ext/upb-gen/envoy/annotations/resource.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/config/accesslog/v3/accesslog.upb.h',
                      'src/core/ext/upb-gen/envoy/config/accesslog/v3/accesslog.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/config/bootstrap/v3/bootstrap.upb.h',
                      'src/core/ext/upb-gen/envoy/config/bootstrap/v3/bootstrap.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/config/cluster/v3/circuit_breaker.upb.h',
                      'src/core/ext/upb-gen/envoy/config/cluster/v3/circuit_breaker.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/config/cluster/v3/cluster.upb.h',
                      'src/core/ext/upb-gen/envoy/config/cluster/v3/cluster.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/config/cluster/v3/filter.upb.h',
                      'src/core/ext/upb-gen/envoy/config/cluster/v3/filter.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/config/cluster/v3/outlier_detection.upb.h',
                      'src/core/ext/upb-gen/envoy/config/cluster/v3/outlier_detection.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/config/common/matcher/v3/matcher.upb.h',
                      'src/core/ext/upb-gen/envoy/config/common/matcher/v3/matcher.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/config/core/v3/address.upb.h',
                      'src/core/ext/upb-gen/envoy/config/core/v3/address.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/config/core/v3/backoff.upb.h',
                      'src/core/ext/upb-gen/envoy/config/core/v3/backoff.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/config/core/v3/base.upb.h',
                      'src/core/ext/upb-gen/envoy/config/core/v3/base.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/config/core/v3/config_source.upb.h',
                      'src/core/ext/upb-gen/envoy/config/core/v3/config_source.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/config/core/v3/event_service_config.upb.h',
                      'src/core/ext/upb-gen/envoy/config/core/v3/event_service_config.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/config/core/v3/extension.upb.h',
                      'src/core/ext/upb-gen/envoy/config/core/v3/extension.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/config/core/v3/grpc_method_list.upb.h',
                      'src/core/ext/upb-gen/envoy/config/core/v3/grpc_method_list.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/config/core/v3/grpc_service.upb.h',
                      'src/core/ext/upb-gen/envoy/config/core/v3/grpc_service.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/config/core/v3/health_check.upb.h',
                      'src/core/ext/upb-gen/envoy/config/core/v3/health_check.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/config/core/v3/http_service.upb.h',
                      'src/core/ext/upb-gen/envoy/config/core/v3/http_service.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/config/core/v3/http_uri.upb.h',
                      'src/core/ext/upb-gen/envoy/config/core/v3/http_uri.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/config/core/v3/protocol.upb.h',
                      'src/core/ext/upb-gen/envoy/config/core/v3/protocol.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/config/core/v3/proxy_protocol.upb.h',
                      'src/core/ext/upb-gen/envoy/config/core/v3/proxy_protocol.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/config/core/v3/resolver.upb.h',
                      'src/core/ext/upb-gen/envoy/config/core/v3/resolver.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/config/core/v3/socket_cmsg_headers.upb.h',
                      'src/core/ext/upb-gen/envoy/config/core/v3/socket_cmsg_headers.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/config/core/v3/socket_option.upb.h',
                      'src/core/ext/upb-gen/envoy/config/core/v3/socket_option.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/config/core/v3/substitution_format_string.upb.h',
                      'src/core/ext/upb-gen/envoy/config/core/v3/substitution_format_string.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/config/core/v3/udp_socket_config.upb.h',
                      'src/core/ext/upb-gen/envoy/config/core/v3/udp_socket_config.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/config/endpoint/v3/endpoint.upb.h',
                      'src/core/ext/upb-gen/envoy/config/endpoint/v3/endpoint.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/config/endpoint/v3/endpoint_components.upb.h',
                      'src/core/ext/upb-gen/envoy/config/endpoint/v3/endpoint_components.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/config/endpoint/v3/load_report.upb.h',
                      'src/core/ext/upb-gen/envoy/config/endpoint/v3/load_report.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/config/listener/v3/api_listener.upb.h',
                      'src/core/ext/upb-gen/envoy/config/listener/v3/api_listener.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/config/listener/v3/listener.upb.h',
                      'src/core/ext/upb-gen/envoy/config/listener/v3/listener.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/config/listener/v3/listener_components.upb.h',
                      'src/core/ext/upb-gen/envoy/config/listener/v3/listener_components.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/config/listener/v3/quic_config.upb.h',
                      'src/core/ext/upb-gen/envoy/config/listener/v3/quic_config.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/config/listener/v3/udp_listener_config.upb.h',
                      'src/core/ext/upb-gen/envoy/config/listener/v3/udp_listener_config.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/config/metrics/v3/metrics_service.upb.h',
                      'src/core/ext/upb-gen/envoy/config/metrics/v3/metrics_service.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/config/metrics/v3/stats.upb.h',
                      'src/core/ext/upb-gen/envoy/config/metrics/v3/stats.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/config/overload/v3/overload.upb.h',
                      'src/core/ext/upb-gen/envoy/config/overload/v3/overload.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/config/rbac/v3/rbac.upb.h',
                      'src/core/ext/upb-gen/envoy/config/rbac/v3/rbac.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/config/route/v3/route.upb.h',
                      'src/core/ext/upb-gen/envoy/config/route/v3/route.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/config/route/v3/route_components.upb.h',
                      'src/core/ext/upb-gen/envoy/config/route/v3/route_components.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/config/route/v3/scoped_route.upb.h',
                      'src/core/ext/upb-gen/envoy/config/route/v3/scoped_route.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/config/tap/v3/common.upb.h',
                      'src/core/ext/upb-gen/envoy/config/tap/v3/common.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/config/trace/v3/datadog.upb.h',
                      'src/core/ext/upb-gen/envoy/config/trace/v3/datadog.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/config/trace/v3/dynamic_ot.upb.h',
                      'src/core/ext/upb-gen/envoy/config/trace/v3/dynamic_ot.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/config/trace/v3/http_tracer.upb.h',
                      'src/core/ext/upb-gen/envoy/config/trace/v3/http_tracer.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/config/trace/v3/lightstep.upb.h',
                      'src/core/ext/upb-gen/envoy/config/trace/v3/lightstep.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/config/trace/v3/opentelemetry.upb.h',
                      'src/core/ext/upb-gen/envoy/config/trace/v3/opentelemetry.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/config/trace/v3/service.upb.h',
                      'src/core/ext/upb-gen/envoy/config/trace/v3/service.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/config/trace/v3/skywalking.upb.h',
                      'src/core/ext/upb-gen/envoy/config/trace/v3/skywalking.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/config/trace/v3/trace.upb.h',
                      'src/core/ext/upb-gen/envoy/config/trace/v3/trace.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/config/trace/v3/xray.upb.h',
                      'src/core/ext/upb-gen/envoy/config/trace/v3/xray.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/config/trace/v3/zipkin.upb.h',
                      'src/core/ext/upb-gen/envoy/config/trace/v3/zipkin.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/data/accesslog/v3/accesslog.upb.h',
                      'src/core/ext/upb-gen/envoy/data/accesslog/v3/accesslog.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/extensions/clusters/aggregate/v3/cluster.upb.h',
                      'src/core/ext/upb-gen/envoy/extensions/clusters/aggregate/v3/cluster.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/extensions/filters/common/fault/v3/fault.upb.h',
                      'src/core/ext/upb-gen/envoy/extensions/filters/common/fault/v3/fault.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/extensions/filters/http/fault/v3/fault.upb.h',
                      'src/core/ext/upb-gen/envoy/extensions/filters/http/fault/v3/fault.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/extensions/filters/http/gcp_authn/v3/gcp_authn.upb.h',
                      'src/core/ext/upb-gen/envoy/extensions/filters/http/gcp_authn/v3/gcp_authn.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/extensions/filters/http/rbac/v3/rbac.upb.h',
                      'src/core/ext/upb-gen/envoy/extensions/filters/http/rbac/v3/rbac.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/extensions/filters/http/router/v3/router.upb.h',
                      'src/core/ext/upb-gen/envoy/extensions/filters/http/router/v3/router.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/extensions/filters/http/stateful_session/v3/stateful_session.upb.h',
                      'src/core/ext/upb-gen/envoy/extensions/filters/http/stateful_session/v3/stateful_session.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/extensions/filters/network/http_connection_manager/v3/http_connection_manager.upb.h',
                      'src/core/ext/upb-gen/envoy/extensions/filters/network/http_connection_manager/v3/http_connection_manager.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/extensions/http/stateful_session/cookie/v3/cookie.upb.h',
                      'src/core/ext/upb-gen/envoy/extensions/http/stateful_session/cookie/v3/cookie.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/extensions/load_balancing_policies/client_side_weighted_round_robin/v3/client_side_weighted_round_robin.upb.h',
                      'src/core/ext/upb-gen/envoy/extensions/load_balancing_policies/client_side_weighted_round_robin/v3/client_side_weighted_round_robin.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/extensions/load_balancing_policies/common/v3/common.upb.h',
                      'src/core/ext/upb-gen/envoy/extensions/load_balancing_policies/common/v3/common.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/extensions/load_balancing_policies/pick_first/v3/pick_first.upb.h',
                      'src/core/ext/upb-gen/envoy/extensions/load_balancing_policies/pick_first/v3/pick_first.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/extensions/load_balancing_policies/ring_hash/v3/ring_hash.upb.h',
                      'src/core/ext/upb-gen/envoy/extensions/load_balancing_policies/ring_hash/v3/ring_hash.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/extensions/load_balancing_policies/wrr_locality/v3/wrr_locality.upb.h',
                      'src/core/ext/upb-gen/envoy/extensions/load_balancing_policies/wrr_locality/v3/wrr_locality.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/extensions/transport_sockets/http_11_proxy/v3/upstream_http_11_connect.upb.h',
                      'src/core/ext/upb-gen/envoy/extensions/transport_sockets/http_11_proxy/v3/upstream_http_11_connect.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/extensions/transport_sockets/tls/v3/cert.upb.h',
                      'src/core/ext/upb-gen/envoy/extensions/transport_sockets/tls/v3/cert.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/extensions/transport_sockets/tls/v3/common.upb.h',
                      'src/core/ext/upb-gen/envoy/extensions/transport_sockets/tls/v3/common.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/extensions/transport_sockets/tls/v3/secret.upb.h',
                      'src/core/ext/upb-gen/envoy/extensions/transport_sockets/tls/v3/secret.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/extensions/transport_sockets/tls/v3/tls.upb.h',
                      'src/core/ext/upb-gen/envoy/extensions/transport_sockets/tls/v3/tls.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/extensions/transport_sockets/tls/v3/tls_spiffe_validator_config.upb.h',
                      'src/core/ext/upb-gen/envoy/extensions/transport_sockets/tls/v3/tls_spiffe_validator_config.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/extensions/upstreams/http/v3/http_protocol_options.upb.h',
                      'src/core/ext/upb-gen/envoy/extensions/upstreams/http/v3/http_protocol_options.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/service/discovery/v3/ads.upb.h',
                      'src/core/ext/upb-gen/envoy/service/discovery/v3/ads.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/service/discovery/v3/discovery.upb.h',
                      'src/core/ext/upb-gen/envoy/service/discovery/v3/discovery.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/service/load_stats/v3/lrs.upb.h',
                      'src/core/ext/upb-gen/envoy/service/load_stats/v3/lrs.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/service/status/v3/csds.upb.h',
                      'src/core/ext/upb-gen/envoy/service/status/v3/csds.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/type/http/v3/cookie.upb.h',
                      'src/core/ext/upb-gen/envoy/type/http/v3/cookie.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/type/http/v3/path_transformation.upb.h',
                      'src/core/ext/upb-gen/envoy/type/http/v3/path_transformation.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/type/matcher/v3/address.upb.h',
                      'src/core/ext/upb-gen/envoy/type/matcher/v3/address.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/type/matcher/v3/filter_state.upb.h',
                      'src/core/ext/upb-gen/envoy/type/matcher/v3/filter_state.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/type/matcher/v3/http_inputs.upb.h',
                      'src/core/ext/upb-gen/envoy/type/matcher/v3/http_inputs.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/type/matcher/v3/metadata.upb.h',
                      'src/core/ext/upb-gen/envoy/type/matcher/v3/metadata.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/type/matcher/v3/node.upb.h',
                      'src/core/ext/upb-gen/envoy/type/matcher/v3/node.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/type/matcher/v3/number.upb.h',
                      'src/core/ext/upb-gen/envoy/type/matcher/v3/number.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/type/matcher/v3/path.upb.h',
                      'src/core/ext/upb-gen/envoy/type/matcher/v3/path.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/type/matcher/v3/regex.upb.h',
                      'src/core/ext/upb-gen/envoy/type/matcher/v3/regex.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/type/matcher/v3/status_code_input.upb.h',
                      'src/core/ext/upb-gen/envoy/type/matcher/v3/status_code_input.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/type/matcher/v3/string.upb.h',
                      'src/core/ext/upb-gen/envoy/type/matcher/v3/string.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/type/matcher/v3/struct.upb.h',
                      'src/core/ext/upb-gen/envoy/type/matcher/v3/struct.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/type/matcher/v3/value.upb.h',
                      'src/core/ext/upb-gen/envoy/type/matcher/v3/value.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/type/metadata/v3/metadata.upb.h',
                      'src/core/ext/upb-gen/envoy/type/metadata/v3/metadata.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/type/tracing/v3/custom_tag.upb.h',
                      'src/core/ext/upb-gen/envoy/type/tracing/v3/custom_tag.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/type/v3/hash_policy.upb.h',
                      'src/core/ext/upb-gen/envoy/type/v3/hash_policy.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/type/v3/http.upb.h',
                      'src/core/ext/upb-gen/envoy/type/v3/http.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/type/v3/http_status.upb.h',
                      'src/core/ext/upb-gen/envoy/type/v3/http_status.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/type/v3/percent.upb.h',
                      'src/core/ext/upb-gen/envoy/type/v3/percent.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/type/v3/range.upb.h',
                      'src/core/ext/upb-gen/envoy/type/v3/range.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/type/v3/ratelimit_strategy.upb.h',
                      'src/core/ext/upb-gen/envoy/type/v3/ratelimit_strategy.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/type/v3/ratelimit_unit.upb.h',
                      'src/core/ext/upb-gen/envoy/type/v3/ratelimit_unit.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/type/v3/semantic_version.upb.h',
                      'src/core/ext/upb-gen/envoy/type/v3/semantic_version.upb_minitable.h',
                      'src/core/ext/upb-gen/envoy/type/v3/token_bucket.upb.h',
                      'src/core/ext/upb-gen/envoy/type/v3/token_bucket.upb_minitable.h',
                      'src/core/ext/upb-gen/google/api/annotations.upb.h',
                      'src/core/ext/upb-gen/google/api/annotations.upb_minitable.h',
                      'src/core/ext/upb-gen/google/api/expr/v1alpha1/checked.upb.h',
                      'src/core/ext/upb-gen/google/api/expr/v1alpha1/checked.upb_minitable.h',
                      'src/core/ext/upb-gen/google/api/expr/v1alpha1/syntax.upb.h',
                      'src/core/ext/upb-gen/google/api/expr/v1alpha1/syntax.upb_minitable.h',
                      'src/core/ext/upb-gen/google/api/http.upb.h',
                      'src/core/ext/upb-gen/google/api/http.upb_minitable.h',
                      'src/core/ext/upb-gen/google/api/httpbody.upb.h',
                      'src/core/ext/upb-gen/google/api/httpbody.upb_minitable.h',
                      'src/core/ext/upb-gen/google/protobuf/any.upb.h',
                      'src/core/ext/upb-gen/google/protobuf/any.upb_minitable.h',
                      'src/core/ext/upb-gen/google/protobuf/descriptor.upb.h',
                      'src/core/ext/upb-gen/google/protobuf/descriptor.upb_minitable.h',
                      'src/core/ext/upb-gen/google/protobuf/duration.upb.h',
                      'src/core/ext/upb-gen/google/protobuf/duration.upb_minitable.h',
                      'src/core/ext/upb-gen/google/protobuf/empty.upb.h',
                      'src/core/ext/upb-gen/google/protobuf/empty.upb_minitable.h',
                      'src/core/ext/upb-gen/google/protobuf/struct.upb.h',
                      'src/core/ext/upb-gen/google/protobuf/struct.upb_minitable.h',
                      'src/core/ext/upb-gen/google/protobuf/timestamp.upb.h',
                      'src/core/ext/upb-gen/google/protobuf/timestamp.upb_minitable.h',
                      'src/core/ext/upb-gen/google/protobuf/wrappers.upb.h',
                      'src/core/ext/upb-gen/google/protobuf/wrappers.upb_minitable.h',
                      'src/core/ext/upb-gen/google/rpc/status.upb.h',
                      'src/core/ext/upb-gen/google/rpc/status.upb_minitable.h',
                      'src/core/ext/upb-gen/src/proto/grpc/channelz/channelz.upb.h',
                      'src/core/ext/upb-gen/src/proto/grpc/channelz/channelz.upb_minitable.h',
                      'src/core/ext/upb-gen/src/proto/grpc/channelz/v2/channelz.upb.h',
                      'src/core/ext/upb-gen/src/proto/grpc/channelz/v2/channelz.upb_minitable.h',
                      'src/core/ext/upb-gen/src/proto/grpc/channelz/v2/promise.upb.h',
                      'src/core/ext/upb-gen/src/proto/grpc/channelz/v2/promise.upb_minitable.h',
                      'src/core/ext/upb-gen/src/proto/grpc/channelz/v2/property_list.upb.h',
                      'src/core/ext/upb-gen/src/proto/grpc/channelz/v2/property_list.upb_minitable.h',
                      'src/core/ext/upb-gen/src/proto/grpc/channelz/v2/service.upb.h',
                      'src/core/ext/upb-gen/src/proto/grpc/channelz/v2/service.upb_minitable.h',
                      'src/core/ext/upb-gen/src/proto/grpc/gcp/altscontext.upb.h',
                      'src/core/ext/upb-gen/src/proto/grpc/gcp/altscontext.upb_minitable.h',
                      'src/core/ext/upb-gen/src/proto/grpc/gcp/handshaker.upb.h',
                      'src/core/ext/upb-gen/src/proto/grpc/gcp/handshaker.upb_minitable.h',
                      'src/core/ext/upb-gen/src/proto/grpc/gcp/transport_security_common.upb.h',
                      'src/core/ext/upb-gen/src/proto/grpc/gcp/transport_security_common.upb_minitable.h',
                      'src/core/ext/upb-gen/src/proto/grpc/health/v1/health.upb.h',
                      'src/core/ext/upb-gen/src/proto/grpc/health/v1/health.upb_minitable.h',
                      'src/core/ext/upb-gen/src/proto/grpc/lb/v1/load_balancer.upb.h',
                      'src/core/ext/upb-gen/src/proto/grpc/lb/v1/load_balancer.upb_minitable.h',
                      'src/core/ext/upb-gen/src/proto/grpc/lookup/v1/rls.upb.h',
                      'src/core/ext/upb-gen/src/proto/grpc/lookup/v1/rls.upb_minitable.h',
                      'src/core/ext/upb-gen/src/proto/grpc/lookup/v1/rls_config.upb.h',
                      'src/core/ext/upb-gen/src/proto/grpc/lookup/v1/rls_config.upb_minitable.h',
                      'src/core/ext/upb-gen/udpa/annotations/migrate.upb.h',
                      'src/core/ext/upb-gen/udpa/annotations/migrate.upb_minitable.h',
                      'src/core/ext/upb-gen/udpa/annotations/security.upb.h',
                      'src/core/ext/upb-gen/udpa/annotations/security.upb_minitable.h',
                      'src/core/ext/upb-gen/udpa/annotations/sensitive.upb.h',
                      'src/core/ext/upb-gen/udpa/annotations/sensitive.upb_minitable.h',
                      'src/core/ext/upb-gen/udpa/annotations/status.upb.h',
                      'src/core/ext/upb-gen/udpa/annotations/status.upb_minitable.h',
                      'src/core/ext/upb-gen/udpa/annotations/versioning.upb.h',
                      'src/core/ext/upb-gen/udpa/annotations/versioning.upb_minitable.h',
                      'src/core/ext/upb-gen/validate/validate.upb.h',
                      'src/core/ext/upb-gen/validate/validate.upb_minitable.h',
                      'src/core/ext/upb-gen/xds/annotations/v3/migrate.upb.h',
                      'src/core/ext/upb-gen/xds/annotations/v3/migrate.upb_minitable.h',
                      'src/core/ext/upb-gen/xds/annotations/v3/security.upb.h',
                      'src/core/ext/upb-gen/xds/annotations/v3/security.upb_minitable.h',
                      'src/core/ext/upb-gen/xds/annotations/v3/sensitive.upb.h',
                      'src/core/ext/upb-gen/xds/annotations/v3/sensitive.upb_minitable.h',
                      'src/core/ext/upb-gen/xds/annotations/v3/status.upb.h',
                      'src/core/ext/upb-gen/xds/annotations/v3/status.upb_minitable.h',
                      'src/core/ext/upb-gen/xds/annotations/v3/versioning.upb.h',
                      'src/core/ext/upb-gen/xds/annotations/v3/versioning.upb_minitable.h',
                      'src/core/ext/upb-gen/xds/core/v3/authority.upb.h',
                      'src/core/ext/upb-gen/xds/core/v3/authority.upb_minitable.h',
                      'src/core/ext/upb-gen/xds/core/v3/cidr.upb.h',
                      'src/core/ext/upb-gen/xds/core/v3/cidr.upb_minitable.h',
                      'src/core/ext/upb-gen/xds/core/v3/collection_entry.upb.h',
                      'src/core/ext/upb-gen/xds/core/v3/collection_entry.upb_minitable.h',
                      'src/core/ext/upb-gen/xds/core/v3/context_params.upb.h',
                      'src/core/ext/upb-gen/xds/core/v3/context_params.upb_minitable.h',
                      'src/core/ext/upb-gen/xds/core/v3/extension.upb.h',
                      'src/core/ext/upb-gen/xds/core/v3/extension.upb_minitable.h',
                      'src/core/ext/upb-gen/xds/core/v3/resource.upb.h',
                      'src/core/ext/upb-gen/xds/core/v3/resource.upb_minitable.h',
                      'src/core/ext/upb-gen/xds/core/v3/resource_locator.upb.h',
                      'src/core/ext/upb-gen/xds/core/v3/resource_locator.upb_minitable.h',
                      'src/core/ext/upb-gen/xds/core/v3/resource_name.upb.h',
                      'src/core/ext/upb-gen/xds/core/v3/resource_name.upb_minitable.h',
                      'src/core/ext/upb-gen/xds/data/orca/v3/orca_load_report.upb.h',
                      'src/core/ext/upb-gen/xds/data/orca/v3/orca_load_report.upb_minitable.h',
                      'src/core/ext/upb-gen/xds/service/orca/v3/orca.upb.h',
                      'src/core/ext/upb-gen/xds/service/orca/v3/orca.upb_minitable.h',
                      'src/core/ext/upb-gen/xds/type/matcher/v3/cel.upb.h',
                      'src/core/ext/upb-gen/xds/type/matcher/v3/cel.upb_minitable.h',
                      'src/core/ext/upb-gen/xds/type/matcher/v3/domain.upb.h',
                      'src/core/ext/upb-gen/xds/type/matcher/v3/domain.upb_minitable.h',
                      'src/core/ext/upb-gen/xds/type/matcher/v3/http_inputs.upb.h',
                      'src/core/ext/upb-gen/xds/type/matcher/v3/http_inputs.upb_minitable.h',
                      'src/core/ext/upb-gen/xds/type/matcher/v3/ip.upb.h',
                      'src/core/ext/upb-gen/xds/type/matcher/v3/ip.upb_minitable.h',
                      'src/core/ext/upb-gen/xds/type/matcher/v3/matcher.upb.h',
                      'src/core/ext/upb-gen/xds/type/matcher/v3/matcher.upb_minitable.h',
                      'src/core/ext/upb-gen/xds/type/matcher/v3/range.upb.h',
                      'src/core/ext/upb-gen/xds/type/matcher/v3/range.upb_minitable.h',
                      'src/core/ext/upb-gen/xds/type/matcher/v3/regex.upb.h',
                      'src/core/ext/upb-gen/xds/type/matcher/v3/regex.upb_minitable.h',
                      'src/core/ext/upb-gen/xds/type/matcher/v3/string.upb.h',
                      'src/core/ext/upb-gen/xds/type/matcher/v3/string.upb_minitable.h',
                      'src/core/ext/upb-gen/xds/type/v3/cel.upb.h',
                      'src/core/ext/upb-gen/xds/type/v3/cel.upb_minitable.h',
                      'src/core/ext/upb-gen/xds/type/v3/range.upb.h',
                      'src/core/ext/upb-gen/xds/type/v3/range.upb_minitable.h',
                      'src/core/ext/upb-gen/xds/type/v3/typed_struct.upb.h',
                      'src/core/ext/upb-gen/xds/type/v3/typed_struct.upb_minitable.h',
                      'src/core/ext/upbdefs-gen/envoy/admin/v3/certs.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/admin/v3/clusters.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/admin/v3/config_dump.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/admin/v3/config_dump_shared.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/admin/v3/init_dump.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/admin/v3/listeners.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/admin/v3/memory.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/admin/v3/metrics.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/admin/v3/mutex_stats.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/admin/v3/server_info.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/admin/v3/tap.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/annotations/deprecation.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/annotations/resource.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/config/accesslog/v3/accesslog.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/config/bootstrap/v3/bootstrap.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/config/cluster/v3/circuit_breaker.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/config/cluster/v3/cluster.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/config/cluster/v3/filter.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/config/cluster/v3/outlier_detection.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/config/common/matcher/v3/matcher.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/config/core/v3/address.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/config/core/v3/backoff.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/config/core/v3/base.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/config/core/v3/config_source.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/config/core/v3/event_service_config.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/config/core/v3/extension.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/config/core/v3/grpc_method_list.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/config/core/v3/grpc_service.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/config/core/v3/health_check.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/config/core/v3/http_service.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/config/core/v3/http_uri.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/config/core/v3/protocol.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/config/core/v3/proxy_protocol.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/config/core/v3/resolver.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/config/core/v3/socket_cmsg_headers.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/config/core/v3/socket_option.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/config/core/v3/substitution_format_string.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/config/core/v3/udp_socket_config.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/config/endpoint/v3/endpoint.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/config/endpoint/v3/endpoint_components.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/config/endpoint/v3/load_report.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/config/listener/v3/api_listener.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/config/listener/v3/listener.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/config/listener/v3/listener_components.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/config/listener/v3/quic_config.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/config/listener/v3/udp_listener_config.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/config/metrics/v3/metrics_service.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/config/metrics/v3/stats.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/config/overload/v3/overload.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/config/rbac/v3/rbac.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/config/route/v3/route.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/config/route/v3/route_components.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/config/route/v3/scoped_route.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/config/tap/v3/common.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/config/trace/v3/datadog.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/config/trace/v3/dynamic_ot.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/config/trace/v3/http_tracer.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/config/trace/v3/lightstep.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/config/trace/v3/opentelemetry.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/config/trace/v3/service.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/config/trace/v3/skywalking.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/config/trace/v3/trace.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/config/trace/v3/xray.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/config/trace/v3/zipkin.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/data/accesslog/v3/accesslog.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/extensions/clusters/aggregate/v3/cluster.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/extensions/filters/common/fault/v3/fault.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/extensions/filters/http/fault/v3/fault.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/extensions/filters/http/gcp_authn/v3/gcp_authn.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/extensions/filters/http/rbac/v3/rbac.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/extensions/filters/http/router/v3/router.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/extensions/filters/http/stateful_session/v3/stateful_session.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/extensions/filters/network/http_connection_manager/v3/http_connection_manager.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/extensions/http/stateful_session/cookie/v3/cookie.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/extensions/transport_sockets/http_11_proxy/v3/upstream_http_11_connect.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/extensions/transport_sockets/tls/v3/cert.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/extensions/transport_sockets/tls/v3/common.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/extensions/transport_sockets/tls/v3/secret.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/extensions/transport_sockets/tls/v3/tls.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/extensions/transport_sockets/tls/v3/tls_spiffe_validator_config.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/extensions/upstreams/http/v3/http_protocol_options.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/service/discovery/v3/ads.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/service/discovery/v3/discovery.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/service/load_stats/v3/lrs.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/service/status/v3/csds.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/type/http/v3/cookie.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/type/http/v3/path_transformation.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/type/matcher/v3/address.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/type/matcher/v3/filter_state.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/type/matcher/v3/http_inputs.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/type/matcher/v3/metadata.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/type/matcher/v3/node.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/type/matcher/v3/number.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/type/matcher/v3/path.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/type/matcher/v3/regex.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/type/matcher/v3/status_code_input.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/type/matcher/v3/string.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/type/matcher/v3/struct.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/type/matcher/v3/value.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/type/metadata/v3/metadata.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/type/tracing/v3/custom_tag.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/type/v3/hash_policy.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/type/v3/http.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/type/v3/http_status.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/type/v3/percent.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/type/v3/range.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/type/v3/ratelimit_strategy.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/type/v3/ratelimit_unit.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/type/v3/semantic_version.upbdefs.h',
                      'src/core/ext/upbdefs-gen/envoy/type/v3/token_bucket.upbdefs.h',
                      'src/core/ext/upbdefs-gen/google/api/annotations.upbdefs.h',
                      'src/core/ext/upbdefs-gen/google/api/expr/v1alpha1/checked.upbdefs.h',
                      'src/core/ext/upbdefs-gen/google/api/expr/v1alpha1/syntax.upbdefs.h',
                      'src/core/ext/upbdefs-gen/google/api/http.upbdefs.h',
                      'src/core/ext/upbdefs-gen/google/api/httpbody.upbdefs.h',
                      'src/core/ext/upbdefs-gen/google/protobuf/any.upbdefs.h',
                      'src/core/ext/upbdefs-gen/google/protobuf/descriptor.upbdefs.h',
                      'src/core/ext/upbdefs-gen/google/protobuf/duration.upbdefs.h',
                      'src/core/ext/upbdefs-gen/google/protobuf/empty.upbdefs.h',
                      'src/core/ext/upbdefs-gen/google/protobuf/struct.upbdefs.h',
                      'src/core/ext/upbdefs-gen/google/protobuf/timestamp.upbdefs.h',
                      'src/core/ext/upbdefs-gen/google/protobuf/wrappers.upbdefs.h',
                      'src/core/ext/upbdefs-gen/google/rpc/status.upbdefs.h',
                      'src/core/ext/upbdefs-gen/src/proto/grpc/channelz/channelz.upbdefs.h',
                      'src/core/ext/upbdefs-gen/src/proto/grpc/channelz/v2/channelz.upbdefs.h',
                      'src/core/ext/upbdefs-gen/src/proto/grpc/channelz/v2/promise.upbdefs.h',
                      'src/core/ext/upbdefs-gen/src/proto/grpc/channelz/v2/property_list.upbdefs.h',
                      'src/core/ext/upbdefs-gen/src/proto/grpc/channelz/v2/service.upbdefs.h',
                      'src/core/ext/upbdefs-gen/src/proto/grpc/lookup/v1/rls_config.upbdefs.h',
                      'src/core/ext/upbdefs-gen/udpa/annotations/migrate.upbdefs.h',
                      'src/core/ext/upbdefs-gen/udpa/annotations/security.upbdefs.h',
                      'src/core/ext/upbdefs-gen/udpa/annotations/sensitive.upbdefs.h',
                      'src/core/ext/upbdefs-gen/udpa/annotations/status.upbdefs.h',
                      'src/core/ext/upbdefs-gen/udpa/annotations/versioning.upbdefs.h',
                      'src/core/ext/upbdefs-gen/validate/validate.upbdefs.h',
                      'src/core/ext/upbdefs-gen/xds/annotations/v3/migrate.upbdefs.h',
                      'src/core/ext/upbdefs-gen/xds/annotations/v3/security.upbdefs.h',
                      'src/core/ext/upbdefs-gen/xds/annotations/v3/sensitive.upbdefs.h',
                      'src/core/ext/upbdefs-gen/xds/annotations/v3/status.upbdefs.h',
                      'src/core/ext/upbdefs-gen/xds/annotations/v3/versioning.upbdefs.h',
                      'src/core/ext/upbdefs-gen/xds/core/v3/authority.upbdefs.h',
                      'src/core/ext/upbdefs-gen/xds/core/v3/cidr.upbdefs.h',
                      'src/core/ext/upbdefs-gen/xds/core/v3/collection_entry.upbdefs.h',
                      'src/core/ext/upbdefs-gen/xds/core/v3/context_params.upbdefs.h',
                      'src/core/ext/upbdefs-gen/xds/core/v3/extension.upbdefs.h',
                      'src/core/ext/upbdefs-gen/xds/core/v3/resource.upbdefs.h',
                      'src/core/ext/upbdefs-gen/xds/core/v3/resource_locator.upbdefs.h',
                      'src/core/ext/upbdefs-gen/xds/core/v3/resource_name.upbdefs.h',
                      'src/core/ext/upbdefs-gen/xds/type/matcher/v3/cel.upbdefs.h',
                      'src/core/ext/upbdefs-gen/xds/type/matcher/v3/domain.upbdefs.h',
                      'src/core/ext/upbdefs-gen/xds/type/matcher/v3/http_inputs.upbdefs.h',
                      'src/core/ext/upbdefs-gen/xds/type/matcher/v3/ip.upbdefs.h',
                      'src/core/ext/upbdefs-gen/xds/type/matcher/v3/matcher.upbdefs.h',
                      'src/core/ext/upbdefs-gen/xds/type/matcher/v3/range.upbdefs.h',
                      'src/core/ext/upbdefs-gen/xds/type/matcher/v3/regex.upbdefs.h',
                      'src/core/ext/upbdefs-gen/xds/type/matcher/v3/string.upbdefs.h',
                      'src/core/ext/upbdefs-gen/xds/type/v3/cel.upbdefs.h',
                      'src/core/ext/upbdefs-gen/xds/type/v3/range.upbdefs.h',
                      'src/core/ext/upbdefs-gen/xds/type/v3/typed_struct.upbdefs.h',
                      'src/core/filter/auth/auth_filters.h',
                      'src/core/filter/blackboard.h',
                      'src/core/filter/filter_args.h',
                      'src/core/handshaker/endpoint_info/endpoint_info_handshaker.h',
                      'src/core/handshaker/handshaker.h',
                      'src/core/handshaker/handshaker_factory.h',
                      'src/core/handshaker/handshaker_registry.h',
                      'src/core/handshaker/http_connect/http_connect_handshaker.h',
                      'src/core/handshaker/http_connect/http_proxy_mapper.h',
                      'src/core/handshaker/http_connect/xds_http_proxy_mapper.h',
                      'src/core/handshaker/proxy_mapper.h',
                      'src/core/handshaker/proxy_mapper_registry.h',
                      'src/core/handshaker/security/secure_endpoint.h',
                      'src/core/handshaker/security/security_handshaker.h',
                      'src/core/handshaker/tcp_connect/tcp_connect_handshaker.h',
                      'src/core/lib/address_utils/parse_address.h',
                      'src/core/lib/address_utils/sockaddr_utils.h',
                      'src/core/lib/channel/channel_args.h',
                      'src/core/lib/channel/channel_args_preconditioning.h',
                      'src/core/lib/channel/channel_fwd.h',
                      'src/core/lib/channel/channel_stack.h',
                      'src/core/lib/channel/channel_stack_builder.h',
                      'src/core/lib/channel/channel_stack_builder_impl.h',
                      'src/core/lib/channel/connected_channel.h',
                      'src/core/lib/channel/promise_based_filter.h',
                      'src/core/lib/compression/compression_internal.h',
                      'src/core/lib/compression/message_compress.h',
                      'src/core/lib/debug/trace.h',
                      'src/core/lib/debug/trace_flags.h',
                      'src/core/lib/debug/trace_impl.h',
                      'src/core/lib/event_engine/ares_resolver.h',
                      'src/core/lib/event_engine/cf_engine/cf_engine.h',
                      'src/core/lib/event_engine/cf_engine/cfsocket_listener.h',
                      'src/core/lib/event_engine/cf_engine/cfstream_endpoint.h',
                      'src/core/lib/event_engine/cf_engine/cftype_unique_ref.h',
                      'src/core/lib/event_engine/cf_engine/dns_service_resolver.h',
                      'src/core/lib/event_engine/channel_args_endpoint_config.h',
                      'src/core/lib/event_engine/common_closures.h',
                      'src/core/lib/event_engine/default_event_engine.h',
                      'src/core/lib/event_engine/default_event_engine_factory.h',
                      'src/core/lib/event_engine/endpoint_channel_arg_wrapper.h',
                      'src/core/lib/event_engine/event_engine_context.h',
                      'src/core/lib/event_engine/extensions/blocking_dns.h',
                      'src/core/lib/event_engine/extensions/can_track_errors.h',
                      'src/core/lib/event_engine/extensions/channelz.h',
                      'src/core/lib/event_engine/extensions/chaotic_good_extension.h',
                      'src/core/lib/event_engine/extensions/iomgr_compatible.h',
                      'src/core/lib/event_engine/extensions/supports_fd.h',
                      'src/core/lib/event_engine/extensions/supports_win_sockets.h',
                      'src/core/lib/event_engine/extensions/tcp_trace.h',
                      'src/core/lib/event_engine/grpc_polled_fd.h',
                      'src/core/lib/event_engine/handle_containers.h',
                      'src/core/lib/event_engine/memory_allocator_factory.h',
                      'src/core/lib/event_engine/nameser.h',
                      'src/core/lib/event_engine/poller.h',
                      'src/core/lib/event_engine/posix.h',
                      'src/core/lib/event_engine/posix_engine/ev_epoll1_linux.h',
                      'src/core/lib/event_engine/posix_engine/ev_poll_posix.h',
                      'src/core/lib/event_engine/posix_engine/event_poller.h',
                      'src/core/lib/event_engine/posix_engine/event_poller_posix_default.h',
                      'src/core/lib/event_engine/posix_engine/file_descriptor_collection.h',
                      'src/core/lib/event_engine/posix_engine/grpc_polled_fd_posix.h',
                      'src/core/lib/event_engine/posix_engine/internal_errqueue.h',
                      'src/core/lib/event_engine/posix_engine/lockfree_event.h',
                      'src/core/lib/event_engine/posix_engine/native_posix_dns_resolver.h',
                      'src/core/lib/event_engine/posix_engine/posix_endpoint.h',
                      'src/core/lib/event_engine/posix_engine/posix_engine.h',
                      'src/core/lib/event_engine/posix_engine/posix_engine_closure.h',
                      'src/core/lib/event_engine/posix_engine/posix_engine_listener.h',
                      'src/core/lib/event_engine/posix_engine/posix_engine_listener_utils.h',
                      'src/core/lib/event_engine/posix_engine/posix_interface.h',
                      'src/core/lib/event_engine/posix_engine/posix_write_event_sink.h',
                      'src/core/lib/event_engine/posix_engine/tcp_socket_utils.h',
                      'src/core/lib/event_engine/posix_engine/timer.h',
                      'src/core/lib/event_engine/posix_engine/timer_heap.h',
                      'src/core/lib/event_engine/posix_engine/timer_manager.h',
                      'src/core/lib/event_engine/posix_engine/traced_buffer_list.h',
                      'src/core/lib/event_engine/posix_engine/wakeup_fd_eventfd.h',
                      'src/core/lib/event_engine/posix_engine/wakeup_fd_pipe.h',
                      'src/core/lib/event_engine/posix_engine/wakeup_fd_posix.h',
                      'src/core/lib/event_engine/posix_engine/wakeup_fd_posix_default.h',
                      'src/core/lib/event_engine/query_extensions.h',
                      'src/core/lib/event_engine/ref_counted_dns_resolver_interface.h',
                      'src/core/lib/event_engine/resolved_address_internal.h',
                      'src/core/lib/event_engine/shim.h',
                      'src/core/lib/event_engine/tcp_socket_utils.h',
                      'src/core/lib/event_engine/thread_local.h',
                      'src/core/lib/event_engine/thread_pool/thread_count.h',
                      'src/core/lib/event_engine/thread_pool/thread_pool.h',
                      'src/core/lib/event_engine/thread_pool/work_stealing_thread_pool.h',
                      'src/core/lib/event_engine/thready_event_engine/thready_event_engine.h',
                      'src/core/lib/event_engine/time_util.h',
                      'src/core/lib/event_engine/utils.h',
                      'src/core/lib/event_engine/windows/grpc_polled_fd_windows.h',
                      'src/core/lib/event_engine/windows/iocp.h',
                      'src/core/lib/event_engine/windows/native_windows_dns_resolver.h',
                      'src/core/lib/event_engine/windows/win_socket.h',
                      'src/core/lib/event_engine/windows/windows_endpoint.h',
                      'src/core/lib/event_engine/windows/windows_engine.h',
                      'src/core/lib/event_engine/windows/windows_listener.h',
                      'src/core/lib/event_engine/work_queue/basic_work_queue.h',
                      'src/core/lib/event_engine/work_queue/work_queue.h',
                      'src/core/lib/experiments/config.h',
                      'src/core/lib/experiments/experiments.h',
                      'src/core/lib/iomgr/block_annotate.h',
                      'src/core/lib/iomgr/buffer_list.h',
                      'src/core/lib/iomgr/call_combiner.h',
                      'src/core/lib/iomgr/cfstream_handle.h',
                      'src/core/lib/iomgr/closure.h',
                      'src/core/lib/iomgr/combiner.h',
                      'src/core/lib/iomgr/dynamic_annotations.h',
                      'src/core/lib/iomgr/endpoint.h',
                      'src/core/lib/iomgr/endpoint_cfstream.h',
                      'src/core/lib/iomgr/endpoint_pair.h',
                      'src/core/lib/iomgr/error.h',
                      'src/core/lib/iomgr/error_cfstream.h',
                      'src/core/lib/iomgr/ev_apple.h',
                      'src/core/lib/iomgr/ev_epoll1_linux.h',
                      'src/core/lib/iomgr/ev_poll_posix.h',
                      'src/core/lib/iomgr/ev_posix.h',
                      'src/core/lib/iomgr/event_engine_shims/closure.h',
                      'src/core/lib/iomgr/event_engine_shims/endpoint.h',
                      'src/core/lib/iomgr/event_engine_shims/tcp_client.h',
                      'src/core/lib/iomgr/exec_ctx.h',
                      'src/core/lib/iomgr/internal_errqueue.h',
                      'src/core/lib/iomgr/iocp_windows.h',
                      'src/core/lib/iomgr/iomgr.h',
                      'src/core/lib/iomgr/iomgr_fwd.h',
                      'src/core/lib/iomgr/iomgr_internal.h',
                      'src/core/lib/iomgr/lockfree_event.h',
                      'src/core/lib/iomgr/nameser.h',
                      'src/core/lib/iomgr/polling_entity.h',
                      'src/core/lib/iomgr/pollset.h',
                      'src/core/lib/iomgr/pollset_set.h',
                      'src/core/lib/iomgr/pollset_set_windows.h',
                      'src/core/lib/iomgr/pollset_windows.h',
                      'src/core/lib/iomgr/port.h',
                      'src/core/lib/iomgr/resolve_address.h',
                      'src/core/lib/iomgr/resolve_address_impl.h',
                      'src/core/lib/iomgr/resolve_address_posix.h',
                      'src/core/lib/iomgr/resolve_address_windows.h',
                      'src/core/lib/iomgr/resolved_address.h',
                      'src/core/lib/iomgr/sockaddr.h',
                      'src/core/lib/iomgr/sockaddr_posix.h',
                      'src/core/lib/iomgr/sockaddr_windows.h',
                      'src/core/lib/iomgr/socket_factory_posix.h',
                      'src/core/lib/iomgr/socket_mutator.h',
                      'src/core/lib/iomgr/socket_utils.h',
                      'src/core/lib/iomgr/socket_utils_posix.h',
                      'src/core/lib/iomgr/socket_windows.h',
                      'src/core/lib/iomgr/systemd_utils.h',
                      'src/core/lib/iomgr/tcp_client.h',
                      'src/core/lib/iomgr/tcp_client_posix.h',
                      'src/core/lib/iomgr/tcp_posix.h',
                      'src/core/lib/iomgr/tcp_server.h',
                      'src/core/lib/iomgr/tcp_server_utils_posix.h',
                      'src/core/lib/iomgr/tcp_windows.h',
                      'src/core/lib/iomgr/timer.h',
                      'src/core/lib/iomgr/timer_generic.h',
                      'src/core/lib/iomgr/timer_heap.h',
                      'src/core/lib/iomgr/timer_manager.h',
                      'src/core/lib/iomgr/unix_sockets_posix.h',
                      'src/core/lib/iomgr/vsock.h',
                      'src/core/lib/iomgr/wakeup_fd_pipe.h',
                      'src/core/lib/iomgr/wakeup_fd_posix.h',
                      'src/core/lib/promise/activity.h',
                      'src/core/lib/promise/all_ok.h',
                      'src/core/lib/promise/arena_promise.h',
                      'src/core/lib/promise/cancel_callback.h',
                      'src/core/lib/promise/context.h',
                      'src/core/lib/promise/detail/basic_seq.h',
                      'src/core/lib/promise/detail/join_state.h',
                      'src/core/lib/promise/detail/promise_factory.h',
                      'src/core/lib/promise/detail/promise_like.h',
                      'src/core/lib/promise/detail/promise_variant.h',
                      'src/core/lib/promise/detail/seq_state.h',
                      'src/core/lib/promise/detail/status.h',
                      'src/core/lib/promise/exec_ctx_wakeup_scheduler.h',
                      'src/core/lib/promise/for_each.h',
                      'src/core/lib/promise/if.h',
                      'src/core/lib/promise/inter_activity_latch.h',
                      'src/core/lib/promise/inter_activity_mutex.h',
                      'src/core/lib/promise/interceptor_list.h',
                      'src/core/lib/promise/latch.h',
                      'src/core/lib/promise/loop.h',
                      'src/core/lib/promise/map.h',
                      'src/core/lib/promise/match_promise.h',
                      'src/core/lib/promise/mpsc.h',
                      'src/core/lib/promise/observable.h',
                      'src/core/lib/promise/party.h',
                      'src/core/lib/promise/pipe.h',
                      'src/core/lib/promise/poll.h',
                      'src/core/lib/promise/prioritized_race.h',
                      'src/core/lib/promise/promise.h',
                      'src/core/lib/promise/race.h',
                      'src/core/lib/promise/seq.h',
                      'src/core/lib/promise/sleep.h',
                      'src/core/lib/promise/status_flag.h',
                      'src/core/lib/promise/try_join.h',
                      'src/core/lib/promise/try_seq.h',
                      'src/core/lib/promise/wait_set.h',
                      'src/core/lib/resource_quota/api.h',
                      'src/core/lib/resource_quota/arena.h',
                      'src/core/lib/resource_quota/connection_quota.h',
                      'src/core/lib/resource_quota/memory_quota.h',
                      'src/core/lib/resource_quota/periodic_update.h',
                      'src/core/lib/resource_quota/resource_quota.h',
                      'src/core/lib/resource_quota/stream_quota.h',
                      'src/core/lib/resource_quota/telemetry.h',
                      'src/core/lib/resource_quota/thread_quota.h',
                      'src/core/lib/resource_tracker/resource_tracker.h',
                      'src/core/lib/security/authorization/audit_logging.h',
                      'src/core/lib/security/authorization/authorization_engine.h',
                      'src/core/lib/security/authorization/authorization_policy_provider.h',
                      'src/core/lib/security/authorization/evaluate_args.h',
                      'src/core/lib/security/authorization/grpc_authorization_engine.h',
                      'src/core/lib/security/authorization/grpc_server_authz_filter.h',
                      'src/core/lib/security/authorization/matchers.h',
                      'src/core/lib/security/authorization/rbac_policy.h',
                      'src/core/lib/security/authorization/stdout_logger.h',
                      'src/core/lib/slice/percent_encoding.h',
                      'src/core/lib/slice/slice.h',
                      'src/core/lib/slice/slice_buffer.h',
                      'src/core/lib/slice/slice_internal.h',
                      'src/core/lib/slice/slice_refcount.h',
                      'src/core/lib/slice/slice_string_helpers.h',
                      'src/core/lib/surface/call.h',
                      'src/core/lib/surface/call_test_only.h',
                      'src/core/lib/surface/call_utils.h',
                      'src/core/lib/surface/channel.h',
                      'src/core/lib/surface/channel_create.h',
                      'src/core/lib/surface/channel_init.h',
                      'src/core/lib/surface/channel_stack_type.h',
                      'src/core/lib/surface/completion_queue.h',
                      'src/core/lib/surface/completion_queue_factory.h',
                      'src/core/lib/surface/connection_context.h',
                      'src/core/lib/surface/event_string.h',
                      'src/core/lib/surface/filter_stack_call.h',
                      'src/core/lib/surface/init.h',
                      'src/core/lib/surface/init_internally.h',
                      'src/core/lib/surface/lame_client.h',
                      'src/core/lib/surface/legacy_channel.h',
                      'src/core/lib/surface/validate_metadata.h',
                      'src/core/lib/transport/bdp_estimator.h',
                      'src/core/lib/transport/call_final_info.h',
                      'src/core/lib/transport/connectivity_state.h',
                      'src/core/lib/transport/error_utils.h',
                      'src/core/lib/transport/promise_endpoint.h',
                      'src/core/lib/transport/status_conversion.h',
                      'src/core/lib/transport/timeout_encoding.h',
                      'src/core/lib/transport/transport.h',
                      'src/core/lib/transport/transport_framing_endpoint_extension.h',
                      'src/core/lib/transport/transport_fwd.h',
                      'src/core/load_balancing/address_filtering.h',
                      'src/core/load_balancing/backend_metric_data.h',
                      'src/core/load_balancing/backend_metric_parser.h',
                      'src/core/load_balancing/child_policy_handler.h',
                      'src/core/load_balancing/delegating_helper.h',
                      'src/core/load_balancing/endpoint_list.h',
                      'src/core/load_balancing/grpclb/client_load_reporting_filter.h',
                      'src/core/load_balancing/grpclb/grpclb.h',
                      'src/core/load_balancing/grpclb/grpclb_balancer_addresses.h',
                      'src/core/load_balancing/grpclb/grpclb_client_stats.h',
                      'src/core/load_balancing/grpclb/load_balancer_api.h',
                      'src/core/load_balancing/health_check_client.h',
                      'src/core/load_balancing/health_check_client_internal.h',
                      'src/core/load_balancing/lb_policy.h',
                      'src/core/load_balancing/lb_policy_factory.h',
                      'src/core/load_balancing/lb_policy_registry.h',
                      'src/core/load_balancing/oob_backend_metric.h',
                      'src/core/load_balancing/oob_backend_metric_internal.h',
                      'src/core/load_balancing/outlier_detection/outlier_detection.h',
                      'src/core/load_balancing/pick_first/pick_first.h',
                      'src/core/load_balancing/ring_hash/ring_hash.h',
                      'src/core/load_balancing/rls/rls.h',
                      'src/core/load_balancing/subchannel_interface.h',
                      'src/core/load_balancing/weighted_round_robin/static_stride_scheduler.h',
                      'src/core/load_balancing/weighted_target/weighted_target.h',
                      'src/core/load_balancing/xds/xds_channel_args.h',
                      'src/core/load_balancing/xds/xds_override_host.h',
                      'src/core/net/socket_mutator.h',
                      'src/core/resolver/dns/c_ares/dns_resolver_ares.h',
                      'src/core/resolver/dns/c_ares/grpc_ares_ev_driver.h',
                      'src/core/resolver/dns/c_ares/grpc_ares_wrapper.h',
                      'src/core/resolver/dns/dns_resolver_plugin.h',
                      'src/core/resolver/dns/event_engine/event_engine_client_channel_resolver.h',
                      'src/core/resolver/dns/event_engine/service_config_helper.h',
                      'src/core/resolver/dns/native/dns_resolver.h',
                      'src/core/resolver/endpoint_addresses.h',
                      'src/core/resolver/fake/fake_resolver.h',
                      'src/core/resolver/polling_resolver.h',
                      'src/core/resolver/resolver.h',
                      'src/core/resolver/resolver_factory.h',
                      'src/core/resolver/resolver_registry.h',
                      'src/core/resolver/server_address.h',
                      'src/core/resolver/xds/xds_config.h',
                      'src/core/resolver/xds/xds_dependency_manager.h',
                      'src/core/resolver/xds/xds_resolver_attributes.h',
                      'src/core/server/server.h',
                      'src/core/server/server_call_tracer_filter.h',
                      'src/core/server/server_config_selector.h',
                      'src/core/server/server_config_selector_filter.h',
                      'src/core/server/server_interface.h',
                      'src/core/server/xds_channel_stack_modifier.h',
                      'src/core/service_config/service_config.h',
                      'src/core/service_config/service_config_call_data.h',
                      'src/core/service_config/service_config_channel_arg_filter.h',
                      'src/core/service_config/service_config_impl.h',
                      'src/core/service_config/service_config_parser.h',
                      'src/core/telemetry/call_tracer.h',
                      'src/core/telemetry/context_list_entry.h',
                      'src/core/telemetry/default_tcp_tracer.h',
                      'src/core/telemetry/histogram.h',
                      'src/core/telemetry/histogram_view.h',
                      'src/core/telemetry/instrument.h',
                      'src/core/telemetry/metrics.h',
                      'src/core/telemetry/stats.h',
                      'src/core/telemetry/stats_data.h',
                      'src/core/telemetry/tcp_tracer.h',
                      'src/core/transport/auth_context.h',
                      'src/core/transport/auth_context_comparator_registry.h',
                      'src/core/transport/endpoint_transport.h',
                      'src/core/transport/endpoint_transport_client_channel_factory.h',
                      'src/core/tsi/alts/crypt/gsec.h',
                      'src/core/tsi/alts/frame_protector/alts_counter.h',
                      'src/core/tsi/alts/frame_protector/alts_crypter.h',
                      'src/core/tsi/alts/frame_protector/alts_frame_protector.h',
                      'src/core/tsi/alts/frame_protector/alts_record_protocol_crypter_common.h',
                      'src/core/tsi/alts/frame_protector/frame_handler.h',
                      'src/core/tsi/alts/handshaker/alts_handshaker_client.h',
                      'src/core/tsi/alts/handshaker/alts_shared_resource.h',
                      'src/core/tsi/alts/handshaker/alts_tsi_handshaker.h',
                      'src/core/tsi/alts/handshaker/alts_tsi_handshaker_private.h',
                      'src/core/tsi/alts/handshaker/alts_tsi_utils.h',
                      'src/core/tsi/alts/handshaker/transport_security_common_api.h',
                      'src/core/tsi/alts/zero_copy_frame_protector/alts_grpc_integrity_only_record_protocol.h',
                      'src/core/tsi/alts/zero_copy_frame_protector/alts_grpc_privacy_integrity_record_protocol.h',
                      'src/core/tsi/alts/zero_copy_frame_protector/alts_grpc_record_protocol.h',
                      'src/core/tsi/alts/zero_copy_frame_protector/alts_grpc_record_protocol_common.h',
                      'src/core/tsi/alts/zero_copy_frame_protector/alts_iovec_record_protocol.h',
                      'src/core/tsi/alts/zero_copy_frame_protector/alts_zero_copy_grpc_protector.h',
                      'src/core/tsi/fake_transport_security.h',
                      'src/core/tsi/local_transport_security.h',
                      'src/core/tsi/ssl/key_logging/ssl_key_logging.h',
                      'src/core/tsi/ssl/session_cache/ssl_session.h',
                      'src/core/tsi/ssl/session_cache/ssl_session_cache.h',
                      'src/core/tsi/ssl_transport_security.h',
                      'src/core/tsi/ssl_transport_security_utils.h',
                      'src/core/tsi/ssl_types.h',
                      'src/core/tsi/transport_security.h',
                      'src/core/tsi/transport_security_grpc.h',
                      'src/core/tsi/transport_security_interface.h',
                      'src/core/util/alloc.h',
                      'src/core/util/atomic_utils.h',
                      'src/core/util/avl.h',
                      'src/core/util/backoff.h',
                      'src/core/util/bitset.h',
                      'src/core/util/check_class_size.h',
                      'src/core/util/chunked_vector.h',
                      'src/core/util/construct_destruct.h',
                      'src/core/util/cpp_impl_of.h',
                      'src/core/util/crash.h',
                      'src/core/util/debug_location.h',
                      'src/core/util/directory_reader.h',
                      'src/core/util/down_cast.h',
                      'src/core/util/dual_ref_counted.h',
                      'src/core/util/dump_args.h',
                      'src/core/util/env.h',
                      'src/core/util/event_log.h',
                      'src/core/util/examine_stack.h',
                      'src/core/util/fork.h',
                      'src/core/util/function_signature.h',
                      'src/core/util/gcp_metadata_query.h',
                      'src/core/util/gethostname.h',
                      'src/core/util/glob.h',
                      'src/core/util/grpc_check.h',
                      'src/core/util/grpc_if_nametoindex.h',
                      'src/core/util/host_port.h',
                      'src/core/util/http_client/format_request.h',
                      'src/core/util/http_client/httpcli.h',
                      'src/core/util/http_client/httpcli_ssl_credentials.h',
                      'src/core/util/http_client/parser.h',
                      'src/core/util/if_list.h',
                      'src/core/util/json/json.h',
                      'src/core/util/json/json_args.h',
                      'src/core/util/json/json_channel_args.h',
                      'src/core/util/json/json_object_loader.h',
                      'src/core/util/json/json_reader.h',
                      'src/core/util/json/json_util.h',
                      'src/core/util/json/json_writer.h',
                      'src/core/util/latent_see.h',
                      'src/core/util/load_file.h',
                      'src/core/util/lru_cache.h',
                      'src/core/util/manual_constructor.h',
                      'src/core/util/match.h',
                      'src/core/util/matchers.h',
                      'src/core/util/memory.h',
                      'src/core/util/memory_usage.h',
                      'src/core/util/mpscq.h',
                      'src/core/util/no_destruct.h',
                      'src/core/util/notification.h',
                      'src/core/util/orphanable.h',
                      'src/core/util/overload.h',
                      'src/core/util/packed_table.h',
                      'src/core/util/per_cpu.h',
                      'src/core/util/postmortem_emit.h',
                      'src/core/util/random_early_detection.h',
                      'src/core/util/ref_counted.h',
                      'src/core/util/ref_counted_ptr.h',
                      'src/core/util/ref_counted_string.h',
                      'src/core/util/shared_bit_gen.h',
                      'src/core/util/single_set_ptr.h',
                      'src/core/util/sorted_pack.h',
                      'src/core/util/spinlock.h',
                      'src/core/util/stat.h',
                      'src/core/util/status_helper.h',
                      'src/core/util/strerror.h',
                      'src/core/util/string.h',
                      'src/core/util/sync.h',
                      'src/core/util/table.h',
                      'src/core/util/tchar.h',
                      'src/core/util/thd.h',
                      'src/core/util/time.h',
                      'src/core/util/time_averaged_stats.h',
                      'src/core/util/time_precise.h',
                      'src/core/util/time_util.h',
                      'src/core/util/tmpfile.h',
                      'src/core/util/trie_lookup.h',
                      'src/core/util/type_list.h',
                      'src/core/util/unique_ptr_with_bitset.h',
                      'src/core/util/unique_type_name.h',
                      'src/core/util/upb_utils.h',
                      'src/core/util/uri.h',
                      'src/core/util/useful.h',
                      'src/core/util/uuid_v4.h',
                      'src/core/util/validation_errors.h',
                      'src/core/util/wait_for_single_owner.h',
                      'src/core/util/work_serializer.h',
                      'src/core/util/xxhash_inline.h',
                      'src/core/xds/grpc/certificate_provider_store.h',
                      'src/core/xds/grpc/file_watcher_certificate_provider_factory.h',
                      'src/core/xds/grpc/xds_audit_logger_registry.h',
                      'src/core/xds/grpc/xds_bootstrap_grpc.h',
                      'src/core/xds/grpc/xds_certificate_provider.h',
                      'src/core/xds/grpc/xds_client_grpc.h',
                      'src/core/xds/grpc/xds_cluster.h',
                      'src/core/xds/grpc/xds_cluster_parser.h',
                      'src/core/xds/grpc/xds_cluster_specifier_plugin.h',
                      'src/core/xds/grpc/xds_common_types.h',
                      'src/core/xds/grpc/xds_common_types_parser.h',
                      'src/core/xds/grpc/xds_enabled_server.h',
                      'src/core/xds/grpc/xds_endpoint.h',
                      'src/core/xds/grpc/xds_endpoint_parser.h',
                      'src/core/xds/grpc/xds_health_status.h',
                      'src/core/xds/grpc/xds_http_fault_filter.h',
                      'src/core/xds/grpc/xds_http_filter.h',
                      'src/core/xds/grpc/xds_http_filter_registry.h',
                      'src/core/xds/grpc/xds_http_gcp_authn_filter.h',
                      'src/core/xds/grpc/xds_http_rbac_filter.h',
                      'src/core/xds/grpc/xds_http_stateful_session_filter.h',
                      'src/core/xds/grpc/xds_lb_policy_registry.h',
                      'src/core/xds/grpc/xds_listener.h',
                      'src/core/xds/grpc/xds_listener_parser.h',
                      'src/core/xds/grpc/xds_matcher.h',
                      'src/core/xds/grpc/xds_matcher_action.h',
                      'src/core/xds/grpc/xds_matcher_context.h',
                      'src/core/xds/grpc/xds_matcher_input.h',
                      'src/core/xds/grpc/xds_matcher_parse.h',
                      'src/core/xds/grpc/xds_metadata.h',
                      'src/core/xds/grpc/xds_metadata_parser.h',
                      'src/core/xds/grpc/xds_route_config.h',
                      'src/core/xds/grpc/xds_route_config_parser.h',
                      'src/core/xds/grpc/xds_routing.h',
                      'src/core/xds/grpc/xds_server_grpc.h',
                      'src/core/xds/grpc/xds_server_grpc_interface.h',
                      'src/core/xds/grpc/xds_transport_grpc.h',
                      'src/core/xds/xds_client/lrs_client.h',
                      'src/core/xds/xds_client/xds_api.h',
                      'src/core/xds/xds_client/xds_backend_metric_propagation.h',
                      'src/core/xds/xds_client/xds_bootstrap.h',
                      'src/core/xds/xds_client/xds_channel_args.h',
                      'src/core/xds/xds_client/xds_client.h',
                      'src/core/xds/xds_client/xds_locality.h',
                      'src/core/xds/xds_client/xds_metrics.h',
                      'src/core/xds/xds_client/xds_resource_type.h',
                      'src/core/xds/xds_client/xds_resource_type_impl.h',
                      'src/core/xds/xds_client/xds_transport.h',
                      'src/cpp/client/call_credentials.cc',
                      'src/cpp/client/channel_cc.cc',
                      'src/cpp/client/channel_credentials.cc',
                      'src/cpp/client/client_callback.cc',
                      'src/cpp/client/client_context.cc',
                      'src/cpp/client/client_interceptor.cc',
                      'src/cpp/client/client_stats_interceptor.cc',
                      'src/cpp/client/client_stats_interceptor.h',
                      'src/cpp/client/create_channel.cc',
                      'src/cpp/client/create_channel_internal.cc',
                      'src/cpp/client/create_channel_internal.h',
                      'src/cpp/client/create_channel_posix.cc',
                      'src/cpp/client/global_callback_hook.cc',
                      'src/cpp/client/insecure_credentials.cc',
                      'src/cpp/client/secure_credentials.cc',
                      'src/cpp/client/secure_credentials.h',
                      'src/cpp/client/xds_credentials.cc',
                      'src/cpp/common/alarm.cc',
                      'src/cpp/common/auth_property_iterator.cc',
                      'src/cpp/common/channel_arguments.cc',
                      'src/cpp/common/completion_queue_cc.cc',
                      'src/cpp/common/resource_quota_cc.cc',
                      'src/cpp/common/rpc_method.cc',
                      'src/cpp/common/secure_auth_context.cc',
                      'src/cpp/common/secure_auth_context.h',
                      'src/cpp/common/secure_create_auth_context.cc',
                      'src/cpp/common/tls_certificate_provider.cc',
                      'src/cpp/common/tls_certificate_verifier.cc',
                      'src/cpp/common/tls_credentials_options.cc',
                      'src/cpp/common/validate_service_config.cc',
                      'src/cpp/common/version_cc.cc',
                      'src/cpp/server/async_generic_service.cc',
                      'src/cpp/server/backend_metric_recorder.cc',
                      'src/cpp/server/backend_metric_recorder.h',
                      'src/cpp/server/channel_argument_option.cc',
                      'src/cpp/server/create_default_thread_pool.cc',
                      'src/cpp/server/dynamic_thread_pool.h',
                      'src/cpp/server/external_connection_acceptor_impl.cc',
                      'src/cpp/server/external_connection_acceptor_impl.h',
                      'src/cpp/server/health/default_health_check_service.cc',
                      'src/cpp/server/health/default_health_check_service.h',
                      'src/cpp/server/health/health_check_service.cc',
                      'src/cpp/server/health/health_check_service_server_builder_option.cc',
                      'src/cpp/server/insecure_server_credentials.cc',
                      'src/cpp/server/secure_server_credentials.cc',
                      'src/cpp/server/secure_server_credentials.h',
                      'src/cpp/server/server_builder.cc',
                      'src/cpp/server/server_callback.cc',
                      'src/cpp/server/server_cc.cc',
                      'src/cpp/server/server_context.cc',
                      'src/cpp/server/server_credentials.cc',
                      'src/cpp/server/server_posix.cc',
                      'src/cpp/server/thread_pool_interface.h',
                      'src/cpp/server/xds_server_builder.cc',
                      'src/cpp/server/xds_server_credentials.cc',
                      'src/cpp/thread_manager/thread_manager.cc',
                      'src/cpp/thread_manager/thread_manager.h',
                      'src/cpp/util/byte_buffer_cc.cc',
                      'src/cpp/util/status.cc',
                      'src/cpp/util/string_ref.cc',
                      'src/cpp/util/time_cc.cc',
                      'third_party/address_sorting/address_sorting_internal.h',
                      'third_party/address_sorting/include/address_sorting/address_sorting.h',
                      'third_party/re2/re2/bitmap256.h',
                      'third_party/re2/re2/filtered_re2.h',
                      'third_party/re2/re2/pod_array.h',
                      'third_party/re2/re2/prefilter.h',
                      'third_party/re2/re2/prefilter_tree.h',
                      'third_party/re2/re2/prog.h',
                      'third_party/re2/re2/re2.h',
                      'third_party/re2/re2/regexp.h',
                      'third_party/re2/re2/set.h',
                      'third_party/re2/re2/sparse_array.h',
                      'third_party/re2/re2/sparse_set.h',
                      'third_party/re2/re2/stringpiece.h',
                      'third_party/re2/re2/unicode_casefold.h',
                      'third_party/re2/re2/unicode_groups.h',
                      'third_party/re2/re2/walker-inl.h',
                      'third_party/re2/util/logging.h',
                      'third_party/re2/util/mix.h',
                      'third_party/re2/util/mutex.h',
                      'third_party/re2/util/strutil.h',
                      'third_party/re2/util/utf.h',
                      'third_party/re2/util/util.h',
                      'third_party/upb/upb/base/descriptor_constants.h',
                      'third_party/upb/upb/base/internal/endian.h',
                      'third_party/upb/upb/base/internal/log2.h',
                      'third_party/upb/upb/base/status.h',
                      'third_party/upb/upb/base/status.hpp',
                      'third_party/upb/upb/base/string_view.h',
                      'third_party/upb/upb/base/upcast.h',
                      'third_party/upb/upb/generated_code_support.h',
                      'third_party/upb/upb/hash/common.h',
                      'third_party/upb/upb/hash/int_table.h',
                      'third_party/upb/upb/hash/str_table.h',
                      'third_party/upb/upb/json/decode.h',
                      'third_party/upb/upb/json/encode.h',
                      'third_party/upb/upb/lex/atoi.h',
                      'third_party/upb/upb/lex/round_trip.h',
                      'third_party/upb/upb/lex/strtod.h',
                      'third_party/upb/upb/lex/unicode.h',
                      'third_party/upb/upb/mem/alloc.h',
                      'third_party/upb/upb/mem/arena.h',
                      'third_party/upb/upb/mem/arena.hpp',
                      'third_party/upb/upb/mem/internal/arena.h',
                      'third_party/upb/upb/message/accessors.h',
                      'third_party/upb/upb/message/array.h',
                      'third_party/upb/upb/message/compat.h',
                      'third_party/upb/upb/message/copy.h',
                      'third_party/upb/upb/message/internal/accessors.h',
                      'third_party/upb/upb/message/internal/array.h',
                      'third_party/upb/upb/message/internal/extension.h',
                      'third_party/upb/upb/message/internal/iterator.h',
                      'third_party/upb/upb/message/internal/map.h',
                      'third_party/upb/upb/message/internal/map_entry.h',
                      'third_party/upb/upb/message/internal/map_sorter.h',
                      'third_party/upb/upb/message/internal/message.h',
                      'third_party/upb/upb/message/internal/tagged_ptr.h',
                      'third_party/upb/upb/message/internal/types.h',
                      'third_party/upb/upb/message/map.h',
                      'third_party/upb/upb/message/map_gencode_util.h',
                      'third_party/upb/upb/message/merge.h',
                      'third_party/upb/upb/message/message.h',
                      'third_party/upb/upb/message/tagged_ptr.h',
                      'third_party/upb/upb/message/value.h',
                      'third_party/upb/upb/mini_descriptor/build_enum.h',
                      'third_party/upb/upb/mini_descriptor/decode.h',
                      'third_party/upb/upb/mini_descriptor/internal/base92.h',
                      'third_party/upb/upb/mini_descriptor/internal/decoder.h',
                      'third_party/upb/upb/mini_descriptor/internal/encode.h',
                      'third_party/upb/upb/mini_descriptor/internal/encode.hpp',
                      'third_party/upb/upb/mini_descriptor/internal/modifiers.h',
                      'third_party/upb/upb/mini_descriptor/internal/wire_constants.h',
                      'third_party/upb/upb/mini_descriptor/link.h',
                      'third_party/upb/upb/mini_table/enum.h',
                      'third_party/upb/upb/mini_table/extension.h',
                      'third_party/upb/upb/mini_table/extension_registry.h',
                      'third_party/upb/upb/mini_table/field.h',
                      'third_party/upb/upb/mini_table/file.h',
                      'third_party/upb/upb/mini_table/internal/enum.h',
                      'third_party/upb/upb/mini_table/internal/extension.h',
                      'third_party/upb/upb/mini_table/internal/field.h',
                      'third_party/upb/upb/mini_table/internal/file.h',
                      'third_party/upb/upb/mini_table/internal/message.h',
                      'third_party/upb/upb/mini_table/internal/size_log2.h',
                      'third_party/upb/upb/mini_table/internal/sub.h',
                      'third_party/upb/upb/mini_table/message.h',
                      'third_party/upb/upb/mini_table/sub.h',
                      'third_party/upb/upb/port/atomic.h',
                      'third_party/upb/upb/port/def.inc',
                      'third_party/upb/upb/port/undef.inc',
                      'third_party/upb/upb/port/vsnprintf_compat.h',
                      'third_party/upb/upb/reflection/common.h',
                      'third_party/upb/upb/reflection/def.h',
                      'third_party/upb/upb/reflection/def.hpp',
                      'third_party/upb/upb/reflection/def_pool.h',
                      'third_party/upb/upb/reflection/def_type.h',
                      'third_party/upb/upb/reflection/descriptor_bootstrap.h',
                      'third_party/upb/upb/reflection/enum_def.h',
                      'third_party/upb/upb/reflection/enum_reserved_range.h',
                      'third_party/upb/upb/reflection/enum_value_def.h',
                      'third_party/upb/upb/reflection/extension_range.h',
                      'third_party/upb/upb/reflection/field_def.h',
                      'third_party/upb/upb/reflection/file_def.h',
                      'third_party/upb/upb/reflection/internal/def_builder.h',
                      'third_party/upb/upb/reflection/internal/def_pool.h',
                      'third_party/upb/upb/reflection/internal/desc_state.h',
                      'third_party/upb/upb/reflection/internal/enum_def.h',
                      'third_party/upb/upb/reflection/internal/enum_reserved_range.h',
                      'third_party/upb/upb/reflection/internal/enum_value_def.h',
                      'third_party/upb/upb/reflection/internal/extension_range.h',
                      'third_party/upb/upb/reflection/internal/field_def.h',
                      'third_party/upb/upb/reflection/internal/file_def.h',
                      'third_party/upb/upb/reflection/internal/message_def.h',
                      'third_party/upb/upb/reflection/internal/message_reserved_range.h',
                      'third_party/upb/upb/reflection/internal/method_def.h',
                      'third_party/upb/upb/reflection/internal/oneof_def.h',
                      'third_party/upb/upb/reflection/internal/service_def.h',
                      'third_party/upb/upb/reflection/internal/strdup2.h',
                      'third_party/upb/upb/reflection/internal/upb_edition_defaults.h',
                      'third_party/upb/upb/reflection/message.h',
                      'third_party/upb/upb/reflection/message.hpp',
                      'third_party/upb/upb/reflection/message_def.h',
                      'third_party/upb/upb/reflection/message_reserved_range.h',
                      'third_party/upb/upb/reflection/method_def.h',
                      'third_party/upb/upb/reflection/oneof_def.h',
                      'third_party/upb/upb/reflection/service_def.h',
                      'third_party/upb/upb/text/encode.h',
                      'third_party/upb/upb/text/internal/encode.h',
                      'third_party/upb/upb/text/options.h',
                      'third_party/upb/upb/wire/decode.h',
                      'third_party/upb/upb/wire/encode.h',
                      'third_party/upb/upb/wire/eps_copy_input_stream.h',
                      'third_party/upb/upb/wire/internal/constants.h',
                      'third_party/upb/upb/wire/internal/decode_fast.h',
                      'third_party/upb/upb/wire/internal/decoder.h',
                      'third_party/upb/upb/wire/internal/reader.h',
                      'third_party/upb/upb/wire/reader.h',
                      'third_party/upb/upb/wire/types.h',
                      'third_party/utf8_range/utf8_range.h',
                      'third_party/utf8_range/utf8_range_neon.inc',
                      'third_party/utf8_range/utf8_range_sse.inc',
                      'third_party/xxhash/xxhash.h',
                      'third_party/zlib/crc32.h',
                      'third_party/zlib/deflate.h',
                      'third_party/zlib/gzguts.h',
                      'third_party/zlib/inffast.h',
                      'third_party/zlib/inffixed.h',
                      'third_party/zlib/inflate.h',
                      'third_party/zlib/inftrees.h',
                      'third_party/zlib/trees.h',
                      'third_party/zlib/zconf.h',
                      'third_party/zlib/zlib.h',
                      'third_party/zlib/zutil.h'

    ss.private_header_files = 'src/core/call/call_arena_allocator.h',
                              'src/core/call/call_destination.h',
                              'src/core/call/call_filters.h',
                              'src/core/call/call_finalization.h',
                              'src/core/call/call_spine.h',
                              'src/core/call/call_state.h',
                              'src/core/call/channelz_context.h',
                              'src/core/call/client_call.h',
                              'src/core/call/custom_metadata.h',
                              'src/core/call/filter_fusion.h',
                              'src/core/call/interception_chain.h',
                              'src/core/call/message.h',
                              'src/core/call/metadata.h',
                              'src/core/call/metadata_batch.h',
                              'src/core/call/metadata_compression_traits.h',
                              'src/core/call/metadata_info.h',
                              'src/core/call/parsed_metadata.h',
                              'src/core/call/request_buffer.h',
                              'src/core/call/security_context.h',
                              'src/core/call/server_call.h',
                              'src/core/call/simple_slice_based_metadata.h',
                              'src/core/call/status_util.h',
                              'src/core/channelz/channel_trace.h',
                              'src/core/channelz/channelz.h',
                              'src/core/channelz/channelz_registry.h',
                              'src/core/channelz/property_list.h',
                              'src/core/channelz/text_encode.h',
                              'src/core/channelz/v2tov1/convert.h',
                              'src/core/channelz/v2tov1/legacy_api.h',
                              'src/core/channelz/v2tov1/property_list.h',
                              'src/core/channelz/ztrace_collector.h',
                              'src/core/client_channel/backup_poller.h',
                              'src/core/client_channel/buffered_call.h',
                              'src/core/client_channel/client_channel.h',
                              'src/core/client_channel/client_channel_args.h',
                              'src/core/client_channel/client_channel_factory.h',
                              'src/core/client_channel/client_channel_filter.h',
                              'src/core/client_channel/client_channel_internal.h',
                              'src/core/client_channel/client_channel_service_config.h',
                              'src/core/client_channel/config_selector.h',
                              'src/core/client_channel/connector.h',
                              'src/core/client_channel/direct_channel.h',
                              'src/core/client_channel/dynamic_filters.h',
                              'src/core/client_channel/global_subchannel_pool.h',
                              'src/core/client_channel/lb_metadata.h',
                              'src/core/client_channel/load_balanced_call_destination.h',
                              'src/core/client_channel/local_subchannel_pool.h',
                              'src/core/client_channel/retry_filter.h',
                              'src/core/client_channel/retry_filter_legacy_call_data.h',
                              'src/core/client_channel/retry_interceptor.h',
                              'src/core/client_channel/retry_service_config.h',
                              'src/core/client_channel/retry_throttle.h',
                              'src/core/client_channel/subchannel.h',
                              'src/core/client_channel/subchannel_interface_internal.h',
                              'src/core/client_channel/subchannel_pool_interface.h',
                              'src/core/client_channel/subchannel_stream_client.h',
                              'src/core/config/config_vars.h',
                              'src/core/config/core_configuration.h',
                              'src/core/config/load_config.h',
                              'src/core/credentials/call/call_credentials.h',
                              'src/core/credentials/call/call_creds_registry.h',
                              'src/core/credentials/call/call_creds_util.h',
                              'src/core/credentials/call/composite/composite_call_credentials.h',
                              'src/core/credentials/call/external/aws_external_account_credentials.h',
                              'src/core/credentials/call/external/aws_request_signer.h',
                              'src/core/credentials/call/external/external_account_credentials.h',
                              'src/core/credentials/call/external/file_external_account_credentials.h',
                              'src/core/credentials/call/external/url_external_account_credentials.h',
                              'src/core/credentials/call/gcp_service_account_identity/gcp_service_account_identity_credentials.h',
                              'src/core/credentials/call/iam/iam_credentials.h',
                              'src/core/credentials/call/json_util.h',
                              'src/core/credentials/call/jwt/json_token.h',
                              'src/core/credentials/call/jwt/jwt_credentials.h',
                              'src/core/credentials/call/jwt/jwt_verifier.h',
                              'src/core/credentials/call/jwt_token_file/jwt_token_file_call_credentials.h',
                              'src/core/credentials/call/jwt_util.h',
                              'src/core/credentials/call/oauth2/oauth2_credentials.h',
                              'src/core/credentials/call/plugin/plugin_credentials.h',
                              'src/core/credentials/call/token_fetcher/token_fetcher_credentials.h',
                              'src/core/credentials/transport/alts/alts_credentials.h',
                              'src/core/credentials/transport/alts/alts_security_connector.h',
                              'src/core/credentials/transport/alts/check_gcp_environment.h',
                              'src/core/credentials/transport/alts/grpc_alts_credentials_options.h',
                              'src/core/credentials/transport/channel_creds_registry.h',
                              'src/core/credentials/transport/composite/composite_channel_credentials.h',
                              'src/core/credentials/transport/fake/fake_credentials.h',
                              'src/core/credentials/transport/fake/fake_security_connector.h',
                              'src/core/credentials/transport/google_default/google_default_credentials.h',
                              'src/core/credentials/transport/insecure/insecure_credentials.h',
                              'src/core/credentials/transport/insecure/insecure_security_connector.h',
                              'src/core/credentials/transport/local/local_credentials.h',
                              'src/core/credentials/transport/local/local_security_connector.h',
                              'src/core/credentials/transport/security_connector.h',
                              'src/core/credentials/transport/ssl/ssl_credentials.h',
                              'src/core/credentials/transport/ssl/ssl_security_connector.h',
                              'src/core/credentials/transport/tls/certificate_provider_factory.h',
                              'src/core/credentials/transport/tls/certificate_provider_registry.h',
                              'src/core/credentials/transport/tls/grpc_tls_certificate_distributor.h',
                              'src/core/credentials/transport/tls/grpc_tls_certificate_provider.h',
                              'src/core/credentials/transport/tls/grpc_tls_certificate_verifier.h',
                              'src/core/credentials/transport/tls/grpc_tls_credentials_options.h',
                              'src/core/credentials/transport/tls/grpc_tls_crl_provider.h',
                              'src/core/credentials/transport/tls/load_system_roots.h',
                              'src/core/credentials/transport/tls/load_system_roots_supported.h',
                              'src/core/credentials/transport/tls/spiffe_utils.h',
                              'src/core/credentials/transport/tls/ssl_utils.h',
                              'src/core/credentials/transport/tls/tls_credentials.h',
                              'src/core/credentials/transport/tls/tls_security_connector.h',
                              'src/core/credentials/transport/tls/tls_utils.h',
                              'src/core/credentials/transport/transport_credentials.h',
                              'src/core/credentials/transport/xds/xds_credentials.h',
                              'src/core/ext/filters/backend_metrics/backend_metric_filter.h',
                              'src/core/ext/filters/backend_metrics/backend_metric_provider.h',
                              'src/core/ext/filters/channel_idle/idle_filter_state.h',
                              'src/core/ext/filters/channel_idle/legacy_channel_idle_filter.h',
                              'src/core/ext/filters/fault_injection/fault_injection_filter.h',
                              'src/core/ext/filters/fault_injection/fault_injection_service_config_parser.h',
                              'src/core/ext/filters/gcp_authentication/gcp_authentication_filter.h',
                              'src/core/ext/filters/gcp_authentication/gcp_authentication_service_config_parser.h',
                              'src/core/ext/filters/http/client/http_client_filter.h',
                              'src/core/ext/filters/http/client_authority_filter.h',
                              'src/core/ext/filters/http/message_compress/compression_filter.h',
                              'src/core/ext/filters/http/server/http_server_filter.h',
                              'src/core/ext/filters/message_size/message_size_filter.h',
                              'src/core/ext/filters/rbac/rbac_filter.h',
                              'src/core/ext/filters/rbac/rbac_service_config_parser.h',
                              'src/core/ext/filters/stateful_session/stateful_session_filter.h',
                              'src/core/ext/filters/stateful_session/stateful_session_service_config_parser.h',
                              'src/core/ext/transport/chttp2/alpn/alpn.h',
                              'src/core/ext/transport/chttp2/client/chttp2_connector.h',
                              'src/core/ext/transport/chttp2/server/chttp2_server.h',
                              'src/core/ext/transport/chttp2/transport/bin_decoder.h',
                              'src/core/ext/transport/chttp2/transport/bin_encoder.h',
                              'src/core/ext/transport/chttp2/transport/call_tracer_wrapper.h',
                              'src/core/ext/transport/chttp2/transport/chttp2_transport.h',
                              'src/core/ext/transport/chttp2/transport/decode_huff.h',
                              'src/core/ext/transport/chttp2/transport/flow_control.h',
                              'src/core/ext/transport/chttp2/transport/flow_control_manager.h',
                              'src/core/ext/transport/chttp2/transport/frame.h',
                              'src/core/ext/transport/chttp2/transport/frame_data.h',
                              'src/core/ext/transport/chttp2/transport/frame_goaway.h',
                              'src/core/ext/transport/chttp2/transport/frame_ping.h',
                              'src/core/ext/transport/chttp2/transport/frame_rst_stream.h',
                              'src/core/ext/transport/chttp2/transport/frame_security.h',
                              'src/core/ext/transport/chttp2/transport/frame_settings.h',
                              'src/core/ext/transport/chttp2/transport/frame_window_update.h',
                              'src/core/ext/transport/chttp2/transport/goaway.h',
                              'src/core/ext/transport/chttp2/transport/header_assembler.h',
                              'src/core/ext/transport/chttp2/transport/hpack_constants.h',
                              'src/core/ext/transport/chttp2/transport/hpack_encoder.h',
                              'src/core/ext/transport/chttp2/transport/hpack_encoder_table.h',
                              'src/core/ext/transport/chttp2/transport/hpack_parse_result.h',
                              'src/core/ext/transport/chttp2/transport/hpack_parser.h',
                              'src/core/ext/transport/chttp2/transport/hpack_parser_table.h',
                              'src/core/ext/transport/chttp2/transport/http2_client_transport.h',
                              'src/core/ext/transport/chttp2/transport/http2_settings.h',
                              'src/core/ext/transport/chttp2/transport/http2_settings_manager.h',
                              'src/core/ext/transport/chttp2/transport/http2_settings_promises.h',
                              'src/core/ext/transport/chttp2/transport/http2_stats_collector.h',
                              'src/core/ext/transport/chttp2/transport/http2_status.h',
                              'src/core/ext/transport/chttp2/transport/http2_transport.h',
                              'src/core/ext/transport/chttp2/transport/http2_ztrace_collector.h',
                              'src/core/ext/transport/chttp2/transport/huffsyms.h',
                              'src/core/ext/transport/chttp2/transport/incoming_metadata_tracker.h',
                              'src/core/ext/transport/chttp2/transport/internal.h',
                              'src/core/ext/transport/chttp2/transport/internal_channel_arg_names.h',
                              'src/core/ext/transport/chttp2/transport/keepalive.h',
                              'src/core/ext/transport/chttp2/transport/legacy_frame.h',
                              'src/core/ext/transport/chttp2/transport/message_assembler.h',
                              'src/core/ext/transport/chttp2/transport/ping_abuse_policy.h',
                              'src/core/ext/transport/chttp2/transport/ping_callbacks.h',
                              'src/core/ext/transport/chttp2/transport/ping_promise.h',
                              'src/core/ext/transport/chttp2/transport/ping_rate_policy.h',
                              'src/core/ext/transport/chttp2/transport/security_frame.h',
                              'src/core/ext/transport/chttp2/transport/stream.h',
                              'src/core/ext/transport/chttp2/transport/stream_data_queue.h',
                              'src/core/ext/transport/chttp2/transport/stream_lists.h',
                              'src/core/ext/transport/chttp2/transport/transport_common.h',
                              'src/core/ext/transport/chttp2/transport/varint.h',
                              'src/core/ext/transport/chttp2/transport/writable_streams.h',
                              'src/core/ext/transport/chttp2/transport/write_size_policy.h',
                              'src/core/ext/transport/inproc/inproc_transport.h',
                              'src/core/ext/transport/inproc/legacy_inproc_transport.h',
                              'src/core/ext/upb-gen/envoy/admin/v3/certs.upb.h',
                              'src/core/ext/upb-gen/envoy/admin/v3/certs.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/admin/v3/clusters.upb.h',
                              'src/core/ext/upb-gen/envoy/admin/v3/clusters.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/admin/v3/config_dump.upb.h',
                              'src/core/ext/upb-gen/envoy/admin/v3/config_dump.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/admin/v3/config_dump_shared.upb.h',
                              'src/core/ext/upb-gen/envoy/admin/v3/config_dump_shared.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/admin/v3/init_dump.upb.h',
                              'src/core/ext/upb-gen/envoy/admin/v3/init_dump.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/admin/v3/listeners.upb.h',
                              'src/core/ext/upb-gen/envoy/admin/v3/listeners.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/admin/v3/memory.upb.h',
                              'src/core/ext/upb-gen/envoy/admin/v3/memory.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/admin/v3/metrics.upb.h',
                              'src/core/ext/upb-gen/envoy/admin/v3/metrics.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/admin/v3/mutex_stats.upb.h',
                              'src/core/ext/upb-gen/envoy/admin/v3/mutex_stats.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/admin/v3/server_info.upb.h',
                              'src/core/ext/upb-gen/envoy/admin/v3/server_info.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/admin/v3/tap.upb.h',
                              'src/core/ext/upb-gen/envoy/admin/v3/tap.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/annotations/deprecation.upb.h',
                              'src/core/ext/upb-gen/envoy/annotations/deprecation.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/annotations/resource.upb.h',
                              'src/core/ext/upb-gen/envoy/annotations/resource.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/config/accesslog/v3/accesslog.upb.h',
                              'src/core/ext/upb-gen/envoy/config/accesslog/v3/accesslog.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/config/bootstrap/v3/bootstrap.upb.h',
                              'src/core/ext/upb-gen/envoy/config/bootstrap/v3/bootstrap.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/config/cluster/v3/circuit_breaker.upb.h',
                              'src/core/ext/upb-gen/envoy/config/cluster/v3/circuit_breaker.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/config/cluster/v3/cluster.upb.h',
                              'src/core/ext/upb-gen/envoy/config/cluster/v3/cluster.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/config/cluster/v3/filter.upb.h',
                              'src/core/ext/upb-gen/envoy/config/cluster/v3/filter.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/config/cluster/v3/outlier_detection.upb.h',
                              'src/core/ext/upb-gen/envoy/config/cluster/v3/outlier_detection.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/config/common/matcher/v3/matcher.upb.h',
                              'src/core/ext/upb-gen/envoy/config/common/matcher/v3/matcher.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/config/core/v3/address.upb.h',
                              'src/core/ext/upb-gen/envoy/config/core/v3/address.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/config/core/v3/backoff.upb.h',
                              'src/core/ext/upb-gen/envoy/config/core/v3/backoff.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/config/core/v3/base.upb.h',
                              'src/core/ext/upb-gen/envoy/config/core/v3/base.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/config/core/v3/config_source.upb.h',
                              'src/core/ext/upb-gen/envoy/config/core/v3/config_source.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/config/core/v3/event_service_config.upb.h',
                              'src/core/ext/upb-gen/envoy/config/core/v3/event_service_config.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/config/core/v3/extension.upb.h',
                              'src/core/ext/upb-gen/envoy/config/core/v3/extension.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/config/core/v3/grpc_method_list.upb.h',
                              'src/core/ext/upb-gen/envoy/config/core/v3/grpc_method_list.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/config/core/v3/grpc_service.upb.h',
                              'src/core/ext/upb-gen/envoy/config/core/v3/grpc_service.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/config/core/v3/health_check.upb.h',
                              'src/core/ext/upb-gen/envoy/config/core/v3/health_check.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/config/core/v3/http_service.upb.h',
                              'src/core/ext/upb-gen/envoy/config/core/v3/http_service.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/config/core/v3/http_uri.upb.h',
                              'src/core/ext/upb-gen/envoy/config/core/v3/http_uri.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/config/core/v3/protocol.upb.h',
                              'src/core/ext/upb-gen/envoy/config/core/v3/protocol.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/config/core/v3/proxy_protocol.upb.h',
                              'src/core/ext/upb-gen/envoy/config/core/v3/proxy_protocol.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/config/core/v3/resolver.upb.h',
                              'src/core/ext/upb-gen/envoy/config/core/v3/resolver.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/config/core/v3/socket_cmsg_headers.upb.h',
                              'src/core/ext/upb-gen/envoy/config/core/v3/socket_cmsg_headers.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/config/core/v3/socket_option.upb.h',
                              'src/core/ext/upb-gen/envoy/config/core/v3/socket_option.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/config/core/v3/substitution_format_string.upb.h',
                              'src/core/ext/upb-gen/envoy/config/core/v3/substitution_format_string.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/config/core/v3/udp_socket_config.upb.h',
                              'src/core/ext/upb-gen/envoy/config/core/v3/udp_socket_config.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/config/endpoint/v3/endpoint.upb.h',
                              'src/core/ext/upb-gen/envoy/config/endpoint/v3/endpoint.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/config/endpoint/v3/endpoint_components.upb.h',
                              'src/core/ext/upb-gen/envoy/config/endpoint/v3/endpoint_components.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/config/endpoint/v3/load_report.upb.h',
                              'src/core/ext/upb-gen/envoy/config/endpoint/v3/load_report.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/config/listener/v3/api_listener.upb.h',
                              'src/core/ext/upb-gen/envoy/config/listener/v3/api_listener.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/config/listener/v3/listener.upb.h',
                              'src/core/ext/upb-gen/envoy/config/listener/v3/listener.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/config/listener/v3/listener_components.upb.h',
                              'src/core/ext/upb-gen/envoy/config/listener/v3/listener_components.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/config/listener/v3/quic_config.upb.h',
                              'src/core/ext/upb-gen/envoy/config/listener/v3/quic_config.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/config/listener/v3/udp_listener_config.upb.h',
                              'src/core/ext/upb-gen/envoy/config/listener/v3/udp_listener_config.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/config/metrics/v3/metrics_service.upb.h',
                              'src/core/ext/upb-gen/envoy/config/metrics/v3/metrics_service.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/config/metrics/v3/stats.upb.h',
                              'src/core/ext/upb-gen/envoy/config/metrics/v3/stats.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/config/overload/v3/overload.upb.h',
                              'src/core/ext/upb-gen/envoy/config/overload/v3/overload.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/config/rbac/v3/rbac.upb.h',
                              'src/core/ext/upb-gen/envoy/config/rbac/v3/rbac.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/config/route/v3/route.upb.h',
                              'src/core/ext/upb-gen/envoy/config/route/v3/route.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/config/route/v3/route_components.upb.h',
                              'src/core/ext/upb-gen/envoy/config/route/v3/route_components.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/config/route/v3/scoped_route.upb.h',
                              'src/core/ext/upb-gen/envoy/config/route/v3/scoped_route.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/config/tap/v3/common.upb.h',
                              'src/core/ext/upb-gen/envoy/config/tap/v3/common.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/config/trace/v3/datadog.upb.h',
                              'src/core/ext/upb-gen/envoy/config/trace/v3/datadog.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/config/trace/v3/dynamic_ot.upb.h',
                              'src/core/ext/upb-gen/envoy/config/trace/v3/dynamic_ot.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/config/trace/v3/http_tracer.upb.h',
                              'src/core/ext/upb-gen/envoy/config/trace/v3/http_tracer.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/config/trace/v3/lightstep.upb.h',
                              'src/core/ext/upb-gen/envoy/config/trace/v3/lightstep.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/config/trace/v3/opentelemetry.upb.h',
                              'src/core/ext/upb-gen/envoy/config/trace/v3/opentelemetry.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/config/trace/v3/service.upb.h',
                              'src/core/ext/upb-gen/envoy/config/trace/v3/service.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/config/trace/v3/skywalking.upb.h',
                              'src/core/ext/upb-gen/envoy/config/trace/v3/skywalking.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/config/trace/v3/trace.upb.h',
                              'src/core/ext/upb-gen/envoy/config/trace/v3/trace.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/config/trace/v3/xray.upb.h',
                              'src/core/ext/upb-gen/envoy/config/trace/v3/xray.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/config/trace/v3/zipkin.upb.h',
                              'src/core/ext/upb-gen/envoy/config/trace/v3/zipkin.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/data/accesslog/v3/accesslog.upb.h',
                              'src/core/ext/upb-gen/envoy/data/accesslog/v3/accesslog.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/extensions/clusters/aggregate/v3/cluster.upb.h',
                              'src/core/ext/upb-gen/envoy/extensions/clusters/aggregate/v3/cluster.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/extensions/filters/common/fault/v3/fault.upb.h',
                              'src/core/ext/upb-gen/envoy/extensions/filters/common/fault/v3/fault.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/extensions/filters/http/fault/v3/fault.upb.h',
                              'src/core/ext/upb-gen/envoy/extensions/filters/http/fault/v3/fault.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/extensions/filters/http/gcp_authn/v3/gcp_authn.upb.h',
                              'src/core/ext/upb-gen/envoy/extensions/filters/http/gcp_authn/v3/gcp_authn.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/extensions/filters/http/rbac/v3/rbac.upb.h',
                              'src/core/ext/upb-gen/envoy/extensions/filters/http/rbac/v3/rbac.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/extensions/filters/http/router/v3/router.upb.h',
                              'src/core/ext/upb-gen/envoy/extensions/filters/http/router/v3/router.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/extensions/filters/http/stateful_session/v3/stateful_session.upb.h',
                              'src/core/ext/upb-gen/envoy/extensions/filters/http/stateful_session/v3/stateful_session.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/extensions/filters/network/http_connection_manager/v3/http_connection_manager.upb.h',
                              'src/core/ext/upb-gen/envoy/extensions/filters/network/http_connection_manager/v3/http_connection_manager.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/extensions/http/stateful_session/cookie/v3/cookie.upb.h',
                              'src/core/ext/upb-gen/envoy/extensions/http/stateful_session/cookie/v3/cookie.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/extensions/load_balancing_policies/client_side_weighted_round_robin/v3/client_side_weighted_round_robin.upb.h',
                              'src/core/ext/upb-gen/envoy/extensions/load_balancing_policies/client_side_weighted_round_robin/v3/client_side_weighted_round_robin.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/extensions/load_balancing_policies/common/v3/common.upb.h',
                              'src/core/ext/upb-gen/envoy/extensions/load_balancing_policies/common/v3/common.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/extensions/load_balancing_policies/pick_first/v3/pick_first.upb.h',
                              'src/core/ext/upb-gen/envoy/extensions/load_balancing_policies/pick_first/v3/pick_first.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/extensions/load_balancing_policies/ring_hash/v3/ring_hash.upb.h',
                              'src/core/ext/upb-gen/envoy/extensions/load_balancing_policies/ring_hash/v3/ring_hash.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/extensions/load_balancing_policies/wrr_locality/v3/wrr_locality.upb.h',
                              'src/core/ext/upb-gen/envoy/extensions/load_balancing_policies/wrr_locality/v3/wrr_locality.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/extensions/transport_sockets/http_11_proxy/v3/upstream_http_11_connect.upb.h',
                              'src/core/ext/upb-gen/envoy/extensions/transport_sockets/http_11_proxy/v3/upstream_http_11_connect.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/extensions/transport_sockets/tls/v3/cert.upb.h',
                              'src/core/ext/upb-gen/envoy/extensions/transport_sockets/tls/v3/cert.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/extensions/transport_sockets/tls/v3/common.upb.h',
                              'src/core/ext/upb-gen/envoy/extensions/transport_sockets/tls/v3/common.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/extensions/transport_sockets/tls/v3/secret.upb.h',
                              'src/core/ext/upb-gen/envoy/extensions/transport_sockets/tls/v3/secret.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/extensions/transport_sockets/tls/v3/tls.upb.h',
                              'src/core/ext/upb-gen/envoy/extensions/transport_sockets/tls/v3/tls.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/extensions/transport_sockets/tls/v3/tls_spiffe_validator_config.upb.h',
                              'src/core/ext/upb-gen/envoy/extensions/transport_sockets/tls/v3/tls_spiffe_validator_config.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/extensions/upstreams/http/v3/http_protocol_options.upb.h',
                              'src/core/ext/upb-gen/envoy/extensions/upstreams/http/v3/http_protocol_options.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/service/discovery/v3/ads.upb.h',
                              'src/core/ext/upb-gen/envoy/service/discovery/v3/ads.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/service/discovery/v3/discovery.upb.h',
                              'src/core/ext/upb-gen/envoy/service/discovery/v3/discovery.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/service/load_stats/v3/lrs.upb.h',
                              'src/core/ext/upb-gen/envoy/service/load_stats/v3/lrs.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/service/status/v3/csds.upb.h',
                              'src/core/ext/upb-gen/envoy/service/status/v3/csds.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/type/http/v3/cookie.upb.h',
                              'src/core/ext/upb-gen/envoy/type/http/v3/cookie.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/type/http/v3/path_transformation.upb.h',
                              'src/core/ext/upb-gen/envoy/type/http/v3/path_transformation.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/type/matcher/v3/address.upb.h',
                              'src/core/ext/upb-gen/envoy/type/matcher/v3/address.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/type/matcher/v3/filter_state.upb.h',
                              'src/core/ext/upb-gen/envoy/type/matcher/v3/filter_state.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/type/matcher/v3/http_inputs.upb.h',
                              'src/core/ext/upb-gen/envoy/type/matcher/v3/http_inputs.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/type/matcher/v3/metadata.upb.h',
                              'src/core/ext/upb-gen/envoy/type/matcher/v3/metadata.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/type/matcher/v3/node.upb.h',
                              'src/core/ext/upb-gen/envoy/type/matcher/v3/node.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/type/matcher/v3/number.upb.h',
                              'src/core/ext/upb-gen/envoy/type/matcher/v3/number.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/type/matcher/v3/path.upb.h',
                              'src/core/ext/upb-gen/envoy/type/matcher/v3/path.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/type/matcher/v3/regex.upb.h',
                              'src/core/ext/upb-gen/envoy/type/matcher/v3/regex.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/type/matcher/v3/status_code_input.upb.h',
                              'src/core/ext/upb-gen/envoy/type/matcher/v3/status_code_input.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/type/matcher/v3/string.upb.h',
                              'src/core/ext/upb-gen/envoy/type/matcher/v3/string.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/type/matcher/v3/struct.upb.h',
                              'src/core/ext/upb-gen/envoy/type/matcher/v3/struct.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/type/matcher/v3/value.upb.h',
                              'src/core/ext/upb-gen/envoy/type/matcher/v3/value.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/type/metadata/v3/metadata.upb.h',
                              'src/core/ext/upb-gen/envoy/type/metadata/v3/metadata.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/type/tracing/v3/custom_tag.upb.h',
                              'src/core/ext/upb-gen/envoy/type/tracing/v3/custom_tag.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/type/v3/hash_policy.upb.h',
                              'src/core/ext/upb-gen/envoy/type/v3/hash_policy.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/type/v3/http.upb.h',
                              'src/core/ext/upb-gen/envoy/type/v3/http.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/type/v3/http_status.upb.h',
                              'src/core/ext/upb-gen/envoy/type/v3/http_status.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/type/v3/percent.upb.h',
                              'src/core/ext/upb-gen/envoy/type/v3/percent.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/type/v3/range.upb.h',
                              'src/core/ext/upb-gen/envoy/type/v3/range.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/type/v3/ratelimit_strategy.upb.h',
                              'src/core/ext/upb-gen/envoy/type/v3/ratelimit_strategy.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/type/v3/ratelimit_unit.upb.h',
                              'src/core/ext/upb-gen/envoy/type/v3/ratelimit_unit.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/type/v3/semantic_version.upb.h',
                              'src/core/ext/upb-gen/envoy/type/v3/semantic_version.upb_minitable.h',
                              'src/core/ext/upb-gen/envoy/type/v3/token_bucket.upb.h',
                              'src/core/ext/upb-gen/envoy/type/v3/token_bucket.upb_minitable.h',
                              'src/core/ext/upb-gen/google/api/annotations.upb.h',
                              'src/core/ext/upb-gen/google/api/annotations.upb_minitable.h',
                              'src/core/ext/upb-gen/google/api/expr/v1alpha1/checked.upb.h',
                              'src/core/ext/upb-gen/google/api/expr/v1alpha1/checked.upb_minitable.h',
                              'src/core/ext/upb-gen/google/api/expr/v1alpha1/syntax.upb.h',
                              'src/core/ext/upb-gen/google/api/expr/v1alpha1/syntax.upb_minitable.h',
                              'src/core/ext/upb-gen/google/api/http.upb.h',
                              'src/core/ext/upb-gen/google/api/http.upb_minitable.h',
                              'src/core/ext/upb-gen/google/api/httpbody.upb.h',
                              'src/core/ext/upb-gen/google/api/httpbody.upb_minitable.h',
                              'src/core/ext/upb-gen/google/protobuf/any.upb.h',
                              'src/core/ext/upb-gen/google/protobuf/any.upb_minitable.h',
                              'src/core/ext/upb-gen/google/protobuf/descriptor.upb.h',
                              'src/core/ext/upb-gen/google/protobuf/descriptor.upb_minitable.h',
                              'src/core/ext/upb-gen/google/protobuf/duration.upb.h',
                              'src/core/ext/upb-gen/google/protobuf/duration.upb_minitable.h',
                              'src/core/ext/upb-gen/google/protobuf/empty.upb.h',
                              'src/core/ext/upb-gen/google/protobuf/empty.upb_minitable.h',
                              'src/core/ext/upb-gen/google/protobuf/struct.upb.h',
                              'src/core/ext/upb-gen/google/protobuf/struct.upb_minitable.h',
                              'src/core/ext/upb-gen/google/protobuf/timestamp.upb.h',
                              'src/core/ext/upb-gen/google/protobuf/timestamp.upb_minitable.h',
                              'src/core/ext/upb-gen/google/protobuf/wrappers.upb.h',
                              'src/core/ext/upb-gen/google/protobuf/wrappers.upb_minitable.h',
                              'src/core/ext/upb-gen/google/rpc/status.upb.h',
                              'src/core/ext/upb-gen/google/rpc/status.upb_minitable.h',
                              'src/core/ext/upb-gen/src/proto/grpc/channelz/channelz.upb.h',
                              'src/core/ext/upb-gen/src/proto/grpc/channelz/channelz.upb_minitable.h',
                              'src/core/ext/upb-gen/src/proto/grpc/channelz/v2/channelz.upb.h',
                              'src/core/ext/upb-gen/src/proto/grpc/channelz/v2/channelz.upb_minitable.h',
                              'src/core/ext/upb-gen/src/proto/grpc/channelz/v2/promise.upb.h',
                              'src/core/ext/upb-gen/src/proto/grpc/channelz/v2/promise.upb_minitable.h',
                              'src/core/ext/upb-gen/src/proto/grpc/channelz/v2/property_list.upb.h',
                              'src/core/ext/upb-gen/src/proto/grpc/channelz/v2/property_list.upb_minitable.h',
                              'src/core/ext/upb-gen/src/proto/grpc/channelz/v2/service.upb.h',
                              'src/core/ext/upb-gen/src/proto/grpc/channelz/v2/service.upb_minitable.h',
                              'src/core/ext/upb-gen/src/proto/grpc/gcp/altscontext.upb.h',
                              'src/core/ext/upb-gen/src/proto/grpc/gcp/altscontext.upb_minitable.h',
                              'src/core/ext/upb-gen/src/proto/grpc/gcp/handshaker.upb.h',
                              'src/core/ext/upb-gen/src/proto/grpc/gcp/handshaker.upb_minitable.h',
                              'src/core/ext/upb-gen/src/proto/grpc/gcp/transport_security_common.upb.h',
                              'src/core/ext/upb-gen/src/proto/grpc/gcp/transport_security_common.upb_minitable.h',
                              'src/core/ext/upb-gen/src/proto/grpc/health/v1/health.upb.h',
                              'src/core/ext/upb-gen/src/proto/grpc/health/v1/health.upb_minitable.h',
                              'src/core/ext/upb-gen/src/proto/grpc/lb/v1/load_balancer.upb.h',
                              'src/core/ext/upb-gen/src/proto/grpc/lb/v1/load_balancer.upb_minitable.h',
                              'src/core/ext/upb-gen/src/proto/grpc/lookup/v1/rls.upb.h',
                              'src/core/ext/upb-gen/src/proto/grpc/lookup/v1/rls.upb_minitable.h',
                              'src/core/ext/upb-gen/src/proto/grpc/lookup/v1/rls_config.upb.h',
                              'src/core/ext/upb-gen/src/proto/grpc/lookup/v1/rls_config.upb_minitable.h',
                              'src/core/ext/upb-gen/udpa/annotations/migrate.upb.h',
                              'src/core/ext/upb-gen/udpa/annotations/migrate.upb_minitable.h',
                              'src/core/ext/upb-gen/udpa/annotations/security.upb.h',
                              'src/core/ext/upb-gen/udpa/annotations/security.upb_minitable.h',
                              'src/core/ext/upb-gen/udpa/annotations/sensitive.upb.h',
                              'src/core/ext/upb-gen/udpa/annotations/sensitive.upb_minitable.h',
                              'src/core/ext/upb-gen/udpa/annotations/status.upb.h',
                              'src/core/ext/upb-gen/udpa/annotations/status.upb_minitable.h',
                              'src/core/ext/upb-gen/udpa/annotations/versioning.upb.h',
                              'src/core/ext/upb-gen/udpa/annotations/versioning.upb_minitable.h',
                              'src/core/ext/upb-gen/validate/validate.upb.h',
                              'src/core/ext/upb-gen/validate/validate.upb_minitable.h',
                              'src/core/ext/upb-gen/xds/annotations/v3/migrate.upb.h',
                              'src/core/ext/upb-gen/xds/annotations/v3/migrate.upb_minitable.h',
                              'src/core/ext/upb-gen/xds/annotations/v3/security.upb.h',
                              'src/core/ext/upb-gen/xds/annotations/v3/security.upb_minitable.h',
                              'src/core/ext/upb-gen/xds/annotations/v3/sensitive.upb.h',
                              'src/core/ext/upb-gen/xds/annotations/v3/sensitive.upb_minitable.h',
                              'src/core/ext/upb-gen/xds/annotations/v3/status.upb.h',
                              'src/core/ext/upb-gen/xds/annotations/v3/status.upb_minitable.h',
                              'src/core/ext/upb-gen/xds/annotations/v3/versioning.upb.h',
                              'src/core/ext/upb-gen/xds/annotations/v3/versioning.upb_minitable.h',
                              'src/core/ext/upb-gen/xds/core/v3/authority.upb.h',
                              'src/core/ext/upb-gen/xds/core/v3/authority.upb_minitable.h',
                              'src/core/ext/upb-gen/xds/core/v3/cidr.upb.h',
                              'src/core/ext/upb-gen/xds/core/v3/cidr.upb_minitable.h',
                              'src/core/ext/upb-gen/xds/core/v3/collection_entry.upb.h',
                              'src/core/ext/upb-gen/xds/core/v3/collection_entry.upb_minitable.h',
                              'src/core/ext/upb-gen/xds/core/v3/context_params.upb.h',
                              'src/core/ext/upb-gen/xds/core/v3/context_params.upb_minitable.h',
                              'src/core/ext/upb-gen/xds/core/v3/extension.upb.h',
                              'src/core/ext/upb-gen/xds/core/v3/extension.upb_minitable.h',
                              'src/core/ext/upb-gen/xds/core/v3/resource.upb.h',
                              'src/core/ext/upb-gen/xds/core/v3/resource.upb_minitable.h',
                              'src/core/ext/upb-gen/xds/core/v3/resource_locator.upb.h',
                              'src/core/ext/upb-gen/xds/core/v3/resource_locator.upb_minitable.h',
                              'src/core/ext/upb-gen/xds/core/v3/resource_name.upb.h',
                              'src/core/ext/upb-gen/xds/core/v3/resource_name.upb_minitable.h',
                              'src/core/ext/upb-gen/xds/data/orca/v3/orca_load_report.upb.h',
                              'src/core/ext/upb-gen/xds/data/orca/v3/orca_load_report.upb_minitable.h',
                              'src/core/ext/upb-gen/xds/service/orca/v3/orca.upb.h',
                              'src/core/ext/upb-gen/xds/service/orca/v3/orca.upb_minitable.h',
                              'src/core/ext/upb-gen/xds/type/matcher/v3/cel.upb.h',
                              'src/core/ext/upb-gen/xds/type/matcher/v3/cel.upb_minitable.h',
                              'src/core/ext/upb-gen/xds/type/matcher/v3/domain.upb.h',
                              'src/core/ext/upb-gen/xds/type/matcher/v3/domain.upb_minitable.h',
                              'src/core/ext/upb-gen/xds/type/matcher/v3/http_inputs.upb.h',
                              'src/core/ext/upb-gen/xds/type/matcher/v3/http_inputs.upb_minitable.h',
                              'src/core/ext/upb-gen/xds/type/matcher/v3/ip.upb.h',
                              'src/core/ext/upb-gen/xds/type/matcher/v3/ip.upb_minitable.h',
                              'src/core/ext/upb-gen/xds/type/matcher/v3/matcher.upb.h',
                              'src/core/ext/upb-gen/xds/type/matcher/v3/matcher.upb_minitable.h',
                              'src/core/ext/upb-gen/xds/type/matcher/v3/range.upb.h',
                              'src/core/ext/upb-gen/xds/type/matcher/v3/range.upb_minitable.h',
                              'src/core/ext/upb-gen/xds/type/matcher/v3/regex.upb.h',
                              'src/core/ext/upb-gen/xds/type/matcher/v3/regex.upb_minitable.h',
                              'src/core/ext/upb-gen/xds/type/matcher/v3/string.upb.h',
                              'src/core/ext/upb-gen/xds/type/matcher/v3/string.upb_minitable.h',
                              'src/core/ext/upb-gen/xds/type/v3/cel.upb.h',
                              'src/core/ext/upb-gen/xds/type/v3/cel.upb_minitable.h',
                              'src/core/ext/upb-gen/xds/type/v3/range.upb.h',
                              'src/core/ext/upb-gen/xds/type/v3/range.upb_minitable.h',
                              'src/core/ext/upb-gen/xds/type/v3/typed_struct.upb.h',
                              'src/core/ext/upb-gen/xds/type/v3/typed_struct.upb_minitable.h',
                              'src/core/ext/upbdefs-gen/envoy/admin/v3/certs.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/admin/v3/clusters.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/admin/v3/config_dump.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/admin/v3/config_dump_shared.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/admin/v3/init_dump.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/admin/v3/listeners.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/admin/v3/memory.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/admin/v3/metrics.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/admin/v3/mutex_stats.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/admin/v3/server_info.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/admin/v3/tap.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/annotations/deprecation.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/annotations/resource.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/config/accesslog/v3/accesslog.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/config/bootstrap/v3/bootstrap.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/config/cluster/v3/circuit_breaker.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/config/cluster/v3/cluster.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/config/cluster/v3/filter.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/config/cluster/v3/outlier_detection.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/config/common/matcher/v3/matcher.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/config/core/v3/address.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/config/core/v3/backoff.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/config/core/v3/base.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/config/core/v3/config_source.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/config/core/v3/event_service_config.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/config/core/v3/extension.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/config/core/v3/grpc_method_list.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/config/core/v3/grpc_service.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/config/core/v3/health_check.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/config/core/v3/http_service.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/config/core/v3/http_uri.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/config/core/v3/protocol.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/config/core/v3/proxy_protocol.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/config/core/v3/resolver.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/config/core/v3/socket_cmsg_headers.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/config/core/v3/socket_option.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/config/core/v3/substitution_format_string.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/config/core/v3/udp_socket_config.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/config/endpoint/v3/endpoint.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/config/endpoint/v3/endpoint_components.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/config/endpoint/v3/load_report.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/config/listener/v3/api_listener.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/config/listener/v3/listener.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/config/listener/v3/listener_components.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/config/listener/v3/quic_config.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/config/listener/v3/udp_listener_config.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/config/metrics/v3/metrics_service.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/config/metrics/v3/stats.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/config/overload/v3/overload.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/config/rbac/v3/rbac.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/config/route/v3/route.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/config/route/v3/route_components.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/config/route/v3/scoped_route.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/config/tap/v3/common.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/config/trace/v3/datadog.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/config/trace/v3/dynamic_ot.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/config/trace/v3/http_tracer.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/config/trace/v3/lightstep.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/config/trace/v3/opentelemetry.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/config/trace/v3/service.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/config/trace/v3/skywalking.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/config/trace/v3/trace.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/config/trace/v3/xray.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/config/trace/v3/zipkin.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/data/accesslog/v3/accesslog.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/extensions/clusters/aggregate/v3/cluster.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/extensions/filters/common/fault/v3/fault.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/extensions/filters/http/fault/v3/fault.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/extensions/filters/http/gcp_authn/v3/gcp_authn.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/extensions/filters/http/rbac/v3/rbac.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/extensions/filters/http/router/v3/router.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/extensions/filters/http/stateful_session/v3/stateful_session.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/extensions/filters/network/http_connection_manager/v3/http_connection_manager.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/extensions/http/stateful_session/cookie/v3/cookie.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/extensions/transport_sockets/http_11_proxy/v3/upstream_http_11_connect.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/extensions/transport_sockets/tls/v3/cert.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/extensions/transport_sockets/tls/v3/common.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/extensions/transport_sockets/tls/v3/secret.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/extensions/transport_sockets/tls/v3/tls.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/extensions/transport_sockets/tls/v3/tls_spiffe_validator_config.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/extensions/upstreams/http/v3/http_protocol_options.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/service/discovery/v3/ads.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/service/discovery/v3/discovery.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/service/load_stats/v3/lrs.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/service/status/v3/csds.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/type/http/v3/cookie.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/type/http/v3/path_transformation.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/type/matcher/v3/address.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/type/matcher/v3/filter_state.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/type/matcher/v3/http_inputs.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/type/matcher/v3/metadata.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/type/matcher/v3/node.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/type/matcher/v3/number.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/type/matcher/v3/path.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/type/matcher/v3/regex.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/type/matcher/v3/status_code_input.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/type/matcher/v3/string.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/type/matcher/v3/struct.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/type/matcher/v3/value.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/type/metadata/v3/metadata.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/type/tracing/v3/custom_tag.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/type/v3/hash_policy.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/type/v3/http.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/type/v3/http_status.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/type/v3/percent.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/type/v3/range.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/type/v3/ratelimit_strategy.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/type/v3/ratelimit_unit.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/type/v3/semantic_version.upbdefs.h',
                              'src/core/ext/upbdefs-gen/envoy/type/v3/token_bucket.upbdefs.h',
                              'src/core/ext/upbdefs-gen/google/api/annotations.upbdefs.h',
                              'src/core/ext/upbdefs-gen/google/api/expr/v1alpha1/checked.upbdefs.h',
                              'src/core/ext/upbdefs-gen/google/api/expr/v1alpha1/syntax.upbdefs.h',
                              'src/core/ext/upbdefs-gen/google/api/http.upbdefs.h',
                              'src/core/ext/upbdefs-gen/google/api/httpbody.upbdefs.h',
                              'src/core/ext/upbdefs-gen/google/protobuf/any.upbdefs.h',
                              'src/core/ext/upbdefs-gen/google/protobuf/descriptor.upbdefs.h',
                              'src/core/ext/upbdefs-gen/google/protobuf/duration.upbdefs.h',
                              'src/core/ext/upbdefs-gen/google/protobuf/empty.upbdefs.h',
                              'src/core/ext/upbdefs-gen/google/protobuf/struct.upbdefs.h',
                              'src/core/ext/upbdefs-gen/google/protobuf/timestamp.upbdefs.h',
                              'src/core/ext/upbdefs-gen/google/protobuf/wrappers.upbdefs.h',
                              'src/core/ext/upbdefs-gen/google/rpc/status.upbdefs.h',
                              'src/core/ext/upbdefs-gen/src/proto/grpc/channelz/channelz.upbdefs.h',
                              'src/core/ext/upbdefs-gen/src/proto/grpc/channelz/v2/channelz.upbdefs.h',
                              'src/core/ext/upbdefs-gen/src/proto/grpc/channelz/v2/promise.upbdefs.h',
                              'src/core/ext/upbdefs-gen/src/proto/grpc/channelz/v2/property_list.upbdefs.h',
                              'src/core/ext/upbdefs-gen/src/proto/grpc/channelz/v2/service.upbdefs.h',
                              'src/core/ext/upbdefs-gen/src/proto/grpc/lookup/v1/rls_config.upbdefs.h',
                              'src/core/ext/upbdefs-gen/udpa/annotations/migrate.upbdefs.h',
                              'src/core/ext/upbdefs-gen/udpa/annotations/security.upbdefs.h',
                              'src/core/ext/upbdefs-gen/udpa/annotations/sensitive.upbdefs.h',
                              'src/core/ext/upbdefs-gen/udpa/annotations/status.upbdefs.h',
                              'src/core/ext/upbdefs-gen/udpa/annotations/versioning.upbdefs.h',
                              'src/core/ext/upbdefs-gen/validate/validate.upbdefs.h',
                              'src/core/ext/upbdefs-gen/xds/annotations/v3/migrate.upbdefs.h',
                              'src/core/ext/upbdefs-gen/xds/annotations/v3/security.upbdefs.h',
                              'src/core/ext/upbdefs-gen/xds/annotations/v3/sensitive.upbdefs.h',
                              'src/core/ext/upbdefs-gen/xds/annotations/v3/status.upbdefs.h',
                              'src/core/ext/upbdefs-gen/xds/annotations/v3/versioning.upbdefs.h',
                              'src/core/ext/upbdefs-gen/xds/core/v3/authority.upbdefs.h',
                              'src/core/ext/upbdefs-gen/xds/core/v3/cidr.upbdefs.h',
                              'src/core/ext/upbdefs-gen/xds/core/v3/collection_entry.upbdefs.h',
                              'src/core/ext/upbdefs-gen/xds/core/v3/context_params.upbdefs.h',
                              'src/core/ext/upbdefs-gen/xds/core/v3/extension.upbdefs.h',
                              'src/core/ext/upbdefs-gen/xds/core/v3/resource.upbdefs.h',
                              'src/core/ext/upbdefs-gen/xds/core/v3/resource_locator.upbdefs.h',
                              'src/core/ext/upbdefs-gen/xds/core/v3/resource_name.upbdefs.h',
                              'src/core/ext/upbdefs-gen/xds/type/matcher/v3/cel.upbdefs.h',
                              'src/core/ext/upbdefs-gen/xds/type/matcher/v3/domain.upbdefs.h',
                              'src/core/ext/upbdefs-gen/xds/type/matcher/v3/http_inputs.upbdefs.h',
                              'src/core/ext/upbdefs-gen/xds/type/matcher/v3/ip.upbdefs.h',
                              'src/core/ext/upbdefs-gen/xds/type/matcher/v3/matcher.upbdefs.h',
                              'src/core/ext/upbdefs-gen/xds/type/matcher/v3/range.upbdefs.h',
                              'src/core/ext/upbdefs-gen/xds/type/matcher/v3/regex.upbdefs.h',
                              'src/core/ext/upbdefs-gen/xds/type/matcher/v3/string.upbdefs.h',
                              'src/core/ext/upbdefs-gen/xds/type/v3/cel.upbdefs.h',
                              'src/core/ext/upbdefs-gen/xds/type/v3/range.upbdefs.h',
                              'src/core/ext/upbdefs-gen/xds/type/v3/typed_struct.upbdefs.h',
                              'src/core/filter/auth/auth_filters.h',
                              'src/core/filter/blackboard.h',
                              'src/core/filter/filter_args.h',
                              'src/core/handshaker/endpoint_info/endpoint_info_handshaker.h',
                              'src/core/handshaker/handshaker.h',
                              'src/core/handshaker/handshaker_factory.h',
                              'src/core/handshaker/handshaker_registry.h',
                              'src/core/handshaker/http_connect/http_connect_handshaker.h',
                              'src/core/handshaker/http_connect/http_proxy_mapper.h',
                              'src/core/handshaker/http_connect/xds_http_proxy_mapper.h',
                              'src/core/handshaker/proxy_mapper.h',
                              'src/core/handshaker/proxy_mapper_registry.h',
                              'src/core/handshaker/security/secure_endpoint.h',
                              'src/core/handshaker/security/security_handshaker.h',
                              'src/core/handshaker/tcp_connect/tcp_connect_handshaker.h',
                              'src/core/lib/address_utils/parse_address.h',
                              'src/core/lib/address_utils/sockaddr_utils.h',
                              'src/core/lib/channel/channel_args.h',
                              'src/core/lib/channel/channel_args_preconditioning.h',
                              'src/core/lib/channel/channel_fwd.h',
                              'src/core/lib/channel/channel_stack.h',
                              'src/core/lib/channel/channel_stack_builder.h',
                              'src/core/lib/channel/channel_stack_builder_impl.h',
                              'src/core/lib/channel/connected_channel.h',
                              'src/core/lib/channel/promise_based_filter.h',
                              'src/core/lib/compression/compression_internal.h',
                              'src/core/lib/compression/message_compress.h',
                              'src/core/lib/debug/trace.h',
                              'src/core/lib/debug/trace_flags.h',
                              'src/core/lib/debug/trace_impl.h',
                              'src/core/lib/event_engine/ares_resolver.h',
                              'src/core/lib/event_engine/cf_engine/cf_engine.h',
                              'src/core/lib/event_engine/cf_engine/cfsocket_listener.h',
                              'src/core/lib/event_engine/cf_engine/cfstream_endpoint.h',
                              'src/core/lib/event_engine/cf_engine/cftype_unique_ref.h',
                              'src/core/lib/event_engine/cf_engine/dns_service_resolver.h',
                              'src/core/lib/event_engine/channel_args_endpoint_config.h',
                              'src/core/lib/event_engine/common_closures.h',
                              'src/core/lib/event_engine/default_event_engine.h',
                              'src/core/lib/event_engine/default_event_engine_factory.h',
                              'src/core/lib/event_engine/endpoint_channel_arg_wrapper.h',
                              'src/core/lib/event_engine/event_engine_context.h',
                              'src/core/lib/event_engine/extensions/blocking_dns.h',
                              'src/core/lib/event_engine/extensions/can_track_errors.h',
                              'src/core/lib/event_engine/extensions/channelz.h',
                              'src/core/lib/event_engine/extensions/chaotic_good_extension.h',
                              'src/core/lib/event_engine/extensions/iomgr_compatible.h',
                              'src/core/lib/event_engine/extensions/supports_fd.h',
                              'src/core/lib/event_engine/extensions/supports_win_sockets.h',
                              'src/core/lib/event_engine/extensions/tcp_trace.h',
                              'src/core/lib/event_engine/grpc_polled_fd.h',
                              'src/core/lib/event_engine/handle_containers.h',
                              'src/core/lib/event_engine/memory_allocator_factory.h',
                              'src/core/lib/event_engine/nameser.h',
                              'src/core/lib/event_engine/poller.h',
                              'src/core/lib/event_engine/posix.h',
                              'src/core/lib/event_engine/posix_engine/ev_epoll1_linux.h',
                              'src/core/lib/event_engine/posix_engine/ev_poll_posix.h',
                              'src/core/lib/event_engine/posix_engine/event_poller.h',
                              'src/core/lib/event_engine/posix_engine/event_poller_posix_default.h',
                              'src/core/lib/event_engine/posix_engine/file_descriptor_collection.h',
                              'src/core/lib/event_engine/posix_engine/grpc_polled_fd_posix.h',
                              'src/core/lib/event_engine/posix_engine/internal_errqueue.h',
                              'src/core/lib/event_engine/posix_engine/lockfree_event.h',
                              'src/core/lib/event_engine/posix_engine/native_posix_dns_resolver.h',
                              'src/core/lib/event_engine/posix_engine/posix_endpoint.h',
                              'src/core/lib/event_engine/posix_engine/posix_engine.h',
                              'src/core/lib/event_engine/posix_engine/posix_engine_closure.h',
                              'src/core/lib/event_engine/posix_engine/posix_engine_listener.h',
                              'src/core/lib/event_engine/posix_engine/posix_engine_listener_utils.h',
                              'src/core/lib/event_engine/posix_engine/posix_interface.h',
                              'src/core/lib/event_engine/posix_engine/posix_write_event_sink.h',
                              'src/core/lib/event_engine/posix_engine/tcp_socket_utils.h',
                              'src/core/lib/event_engine/posix_engine/timer.h',
                              'src/core/lib/event_engine/posix_engine/timer_heap.h',
                              'src/core/lib/event_engine/posix_engine/timer_manager.h',
                              'src/core/lib/event_engine/posix_engine/traced_buffer_list.h',
                              'src/core/lib/event_engine/posix_engine/wakeup_fd_eventfd.h',
                              'src/core/lib/event_engine/posix_engine/wakeup_fd_pipe.h',
                              'src/core/lib/event_engine/posix_engine/wakeup_fd_posix.h',
                              'src/core/lib/event_engine/posix_engine/wakeup_fd_posix_default.h',
                              'src/core/lib/event_engine/query_extensions.h',
                              'src/core/lib/event_engine/ref_counted_dns_resolver_interface.h',
                              'src/core/lib/event_engine/resolved_address_internal.h',
                              'src/core/lib/event_engine/shim.h',
                              'src/core/lib/event_engine/tcp_socket_utils.h',
                              'src/core/lib/event_engine/thread_local.h',
                              'src/core/lib/event_engine/thread_pool/thread_count.h',
                              'src/core/lib/event_engine/thread_pool/thread_pool.h',
                              'src/core/lib/event_engine/thread_pool/work_stealing_thread_pool.h',
                              'src/core/lib/event_engine/thready_event_engine/thready_event_engine.h',
                              'src/core/lib/event_engine/time_util.h',
                              'src/core/lib/event_engine/utils.h',
                              'src/core/lib/event_engine/windows/grpc_polled_fd_windows.h',
                              'src/core/lib/event_engine/windows/iocp.h',
                              'src/core/lib/event_engine/windows/native_windows_dns_resolver.h',
                              'src/core/lib/event_engine/windows/win_socket.h',
                              'src/core/lib/event_engine/windows/windows_endpoint.h',
                              'src/core/lib/event_engine/windows/windows_engine.h',
                              'src/core/lib/event_engine/windows/windows_listener.h',
                              'src/core/lib/event_engine/work_queue/basic_work_queue.h',
                              'src/core/lib/event_engine/work_queue/work_queue.h',
                              'src/core/lib/experiments/config.h',
                              'src/core/lib/experiments/experiments.h',
                              'src/core/lib/iomgr/block_annotate.h',
                              'src/core/lib/iomgr/buffer_list.h',
                              'src/core/lib/iomgr/call_combiner.h',
                              'src/core/lib/iomgr/cfstream_handle.h',
                              'src/core/lib/iomgr/closure.h',
                              'src/core/lib/iomgr/combiner.h',
                              'src/core/lib/iomgr/dynamic_annotations.h',
                              'src/core/lib/iomgr/endpoint.h',
                              'src/core/lib/iomgr/endpoint_cfstream.h',
                              'src/core/lib/iomgr/endpoint_pair.h',
                              'src/core/lib/iomgr/error.h',
                              'src/core/lib/iomgr/error_cfstream.h',
                              'src/core/lib/iomgr/ev_apple.h',
                              'src/core/lib/iomgr/ev_epoll1_linux.h',
                              'src/core/lib/iomgr/ev_poll_posix.h',
                              'src/core/lib/iomgr/ev_posix.h',
                              'src/core/lib/iomgr/event_engine_shims/closure.h',
                              'src/core/lib/iomgr/event_engine_shims/endpoint.h',
                              'src/core/lib/iomgr/event_engine_shims/tcp_client.h',
                              'src/core/lib/iomgr/exec_ctx.h',
                              'src/core/lib/iomgr/internal_errqueue.h',
                              'src/core/lib/iomgr/iocp_windows.h',
                              'src/core/lib/iomgr/iomgr.h',
                              'src/core/lib/iomgr/iomgr_fwd.h',
                              'src/core/lib/iomgr/iomgr_internal.h',
                              'src/core/lib/iomgr/lockfree_event.h',
                              'src/core/lib/iomgr/nameser.h',
                              'src/core/lib/iomgr/polling_entity.h',
                              'src/core/lib/iomgr/pollset.h',
                              'src/core/lib/iomgr/pollset_set.h',
                              'src/core/lib/iomgr/pollset_set_windows.h',
                              'src/core/lib/iomgr/pollset_windows.h',
                              'src/core/lib/iomgr/port.h',
                              'src/core/lib/iomgr/resolve_address.h',
                              'src/core/lib/iomgr/resolve_address_impl.h',
                              'src/core/lib/iomgr/resolve_address_posix.h',
                              'src/core/lib/iomgr/resolve_address_windows.h',
                              'src/core/lib/iomgr/resolved_address.h',
                              'src/core/lib/iomgr/sockaddr.h',
                              'src/core/lib/iomgr/sockaddr_posix.h',
                              'src/core/lib/iomgr/sockaddr_windows.h',
                              'src/core/lib/iomgr/socket_factory_posix.h',
                              'src/core/lib/iomgr/socket_mutator.h',
                              'src/core/lib/iomgr/socket_utils.h',
                              'src/core/lib/iomgr/socket_utils_posix.h',
                              'src/core/lib/iomgr/socket_windows.h',
                              'src/core/lib/iomgr/systemd_utils.h',
                              'src/core/lib/iomgr/tcp_client.h',
                              'src/core/lib/iomgr/tcp_client_posix.h',
                              'src/core/lib/iomgr/tcp_posix.h',
                              'src/core/lib/iomgr/tcp_server.h',
                              'src/core/lib/iomgr/tcp_server_utils_posix.h',
                              'src/core/lib/iomgr/tcp_windows.h',
                              'src/core/lib/iomgr/timer.h',
                              'src/core/lib/iomgr/timer_generic.h',
                              'src/core/lib/iomgr/timer_heap.h',
                              'src/core/lib/iomgr/timer_manager.h',
                              'src/core/lib/iomgr/unix_sockets_posix.h',
                              'src/core/lib/iomgr/vsock.h',
                              'src/core/lib/iomgr/wakeup_fd_pipe.h',
                              'src/core/lib/iomgr/wakeup_fd_posix.h',
                              'src/core/lib/promise/activity.h',
                              'src/core/lib/promise/all_ok.h',
                              'src/core/lib/promise/arena_promise.h',
                              'src/core/lib/promise/cancel_callback.h',
                              'src/core/lib/promise/context.h',
                              'src/core/lib/promise/detail/basic_seq.h',
                              'src/core/lib/promise/detail/join_state.h',
                              'src/core/lib/promise/detail/promise_factory.h',
                              'src/core/lib/promise/detail/promise_like.h',
                              'src/core/lib/promise/detail/promise_variant.h',
                              'src/core/lib/promise/detail/seq_state.h',
                              'src/core/lib/promise/detail/status.h',
                              'src/core/lib/promise/exec_ctx_wakeup_scheduler.h',
                              'src/core/lib/promise/for_each.h',
                              'src/core/lib/promise/if.h',
                              'src/core/lib/promise/inter_activity_latch.h',
                              'src/core/lib/promise/inter_activity_mutex.h',
                              'src/core/lib/promise/interceptor_list.h',
                              'src/core/lib/promise/latch.h',
                              'src/core/lib/promise/loop.h',
                              'src/core/lib/promise/map.h',
                              'src/core/lib/promise/match_promise.h',
                              'src/core/lib/promise/mpsc.h',
                              'src/core/lib/promise/observable.h',
                              'src/core/lib/promise/party.h',
                              'src/core/lib/promise/pipe.h',
                              'src/core/lib/promise/poll.h',
                              'src/core/lib/promise/prioritized_race.h',
                              'src/core/lib/promise/promise.h',
                              'src/core/lib/promise/race.h',
                              'src/core/lib/promise/seq.h',
                              'src/core/lib/promise/sleep.h',
                              'src/core/lib/promise/status_flag.h',
                              'src/core/lib/promise/try_join.h',
                              'src/core/lib/promise/try_seq.h',
                              'src/core/lib/promise/wait_set.h',
                              'src/core/lib/resource_quota/api.h',
                              'src/core/lib/resource_quota/arena.h',
                              'src/core/lib/resource_quota/connection_quota.h',
                              'src/core/lib/resource_quota/memory_quota.h',
                              'src/core/lib/resource_quota/periodic_update.h',
                              'src/core/lib/resource_quota/resource_quota.h',
                              'src/core/lib/resource_quota/stream_quota.h',
                              'src/core/lib/resource_quota/telemetry.h',
                              'src/core/lib/resource_quota/thread_quota.h',
                              'src/core/lib/resource_tracker/resource_tracker.h',
                              'src/core/lib/security/authorization/audit_logging.h',
                              'src/core/lib/security/authorization/authorization_engine.h',
                              'src/core/lib/security/authorization/authorization_policy_provider.h',
                              'src/core/lib/security/authorization/evaluate_args.h',
                              'src/core/lib/security/authorization/grpc_authorization_engine.h',
                              'src/core/lib/security/authorization/grpc_server_authz_filter.h',
                              'src/core/lib/security/authorization/matchers.h',
                              'src/core/lib/security/authorization/rbac_policy.h',
                              'src/core/lib/security/authorization/stdout_logger.h',
                              'src/core/lib/slice/percent_encoding.h',
                              'src/core/lib/slice/slice.h',
                              'src/core/lib/slice/slice_buffer.h',
                              'src/core/lib/slice/slice_internal.h',
                              'src/core/lib/slice/slice_refcount.h',
                              'src/core/lib/slice/slice_string_helpers.h',
                              'src/core/lib/surface/call.h',
                              'src/core/lib/surface/call_test_only.h',
                              'src/core/lib/surface/call_utils.h',
                              'src/core/lib/surface/channel.h',
                              'src/core/lib/surface/channel_create.h',
                              'src/core/lib/surface/channel_init.h',
                              'src/core/lib/surface/channel_stack_type.h',
                              'src/core/lib/surface/completion_queue.h',
                              'src/core/lib/surface/completion_queue_factory.h',
                              'src/core/lib/surface/connection_context.h',
                              'src/core/lib/surface/event_string.h',
                              'src/core/lib/surface/filter_stack_call.h',
                              'src/core/lib/surface/init.h',
                              'src/core/lib/surface/init_internally.h',
                              'src/core/lib/surface/lame_client.h',
                              'src/core/lib/surface/legacy_channel.h',
                              'src/core/lib/surface/validate_metadata.h',
                              'src/core/lib/transport/bdp_estimator.h',
                              'src/core/lib/transport/call_final_info.h',
                              'src/core/lib/transport/connectivity_state.h',
                              'src/core/lib/transport/error_utils.h',
                              'src/core/lib/transport/promise_endpoint.h',
                              'src/core/lib/transport/status_conversion.h',
                              'src/core/lib/transport/timeout_encoding.h',
                              'src/core/lib/transport/transport.h',
                              'src/core/lib/transport/transport_framing_endpoint_extension.h',
                              'src/core/lib/transport/transport_fwd.h',
                              'src/core/load_balancing/address_filtering.h',
                              'src/core/load_balancing/backend_metric_data.h',
                              'src/core/load_balancing/backend_metric_parser.h',
                              'src/core/load_balancing/child_policy_handler.h',
                              'src/core/load_balancing/delegating_helper.h',
                              'src/core/load_balancing/endpoint_list.h',
                              'src/core/load_balancing/grpclb/client_load_reporting_filter.h',
                              'src/core/load_balancing/grpclb/grpclb.h',
                              'src/core/load_balancing/grpclb/grpclb_balancer_addresses.h',
                              'src/core/load_balancing/grpclb/grpclb_client_stats.h',
                              'src/core/load_balancing/grpclb/load_balancer_api.h',
                              'src/core/load_balancing/health_check_client.h',
                              'src/core/load_balancing/health_check_client_internal.h',
                              'src/core/load_balancing/lb_policy.h',
                              'src/core/load_balancing/lb_policy_factory.h',
                              'src/core/load_balancing/lb_policy_registry.h',
                              'src/core/load_balancing/oob_backend_metric.h',
                              'src/core/load_balancing/oob_backend_metric_internal.h',
                              'src/core/load_balancing/outlier_detection/outlier_detection.h',
                              'src/core/load_balancing/pick_first/pick_first.h',
                              'src/core/load_balancing/ring_hash/ring_hash.h',
                              'src/core/load_balancing/rls/rls.h',
                              'src/core/load_balancing/subchannel_interface.h',
                              'src/core/load_balancing/weighted_round_robin/static_stride_scheduler.h',
                              'src/core/load_balancing/weighted_target/weighted_target.h',
                              'src/core/load_balancing/xds/xds_channel_args.h',
                              'src/core/load_balancing/xds/xds_override_host.h',
                              'src/core/net/socket_mutator.h',
                              'src/core/resolver/dns/c_ares/dns_resolver_ares.h',
                              'src/core/resolver/dns/c_ares/grpc_ares_ev_driver.h',
                              'src/core/resolver/dns/c_ares/grpc_ares_wrapper.h',
                              'src/core/resolver/dns/dns_resolver_plugin.h',
                              'src/core/resolver/dns/event_engine/event_engine_client_channel_resolver.h',
                              'src/core/resolver/dns/event_engine/service_config_helper.h',
                              'src/core/resolver/dns/native/dns_resolver.h',
                              'src/core/resolver/endpoint_addresses.h',
                              'src/core/resolver/fake/fake_resolver.h',
                              'src/core/resolver/polling_resolver.h',
                              'src/core/resolver/resolver.h',
                              'src/core/resolver/resolver_factory.h',
                              'src/core/resolver/resolver_registry.h',
                              'src/core/resolver/server_address.h',
                              'src/core/resolver/xds/xds_config.h',
                              'src/core/resolver/xds/xds_dependency_manager.h',
                              'src/core/resolver/xds/xds_resolver_attributes.h',
                              'src/core/server/server.h',
                              'src/core/server/server_call_tracer_filter.h',
                              'src/core/server/server_config_selector.h',
                              'src/core/server/server_config_selector_filter.h',
                              'src/core/server/server_interface.h',
                              'src/core/server/xds_channel_stack_modifier.h',
                              'src/core/service_config/service_config.h',
                              'src/core/service_config/service_config_call_data.h',
                              'src/core/service_config/service_config_channel_arg_filter.h',
                              'src/core/service_config/service_config_impl.h',
                              'src/core/service_config/service_config_parser.h',
                              'src/core/telemetry/call_tracer.h',
                              'src/core/telemetry/context_list_entry.h',
                              'src/core/telemetry/default_tcp_tracer.h',
                              'src/core/telemetry/histogram.h',
                              'src/core/telemetry/histogram_view.h',
                              'src/core/telemetry/instrument.h',
                              'src/core/telemetry/metrics.h',
                              'src/core/telemetry/stats.h',
                              'src/core/telemetry/stats_data.h',
                              'src/core/telemetry/tcp_tracer.h',
                              'src/core/transport/auth_context.h',
                              'src/core/transport/auth_context_comparator_registry.h',
                              'src/core/transport/endpoint_transport.h',
                              'src/core/transport/endpoint_transport_client_channel_factory.h',
                              'src/core/tsi/alts/crypt/gsec.h',
                              'src/core/tsi/alts/frame_protector/alts_counter.h',
                              'src/core/tsi/alts/frame_protector/alts_crypter.h',
                              'src/core/tsi/alts/frame_protector/alts_frame_protector.h',
                              'src/core/tsi/alts/frame_protector/alts_record_protocol_crypter_common.h',
                              'src/core/tsi/alts/frame_protector/frame_handler.h',
                              'src/core/tsi/alts/handshaker/alts_handshaker_client.h',
                              'src/core/tsi/alts/handshaker/alts_shared_resource.h',
                              'src/core/tsi/alts/handshaker/alts_tsi_handshaker.h',
                              'src/core/tsi/alts/handshaker/alts_tsi_handshaker_private.h',
                              'src/core/tsi/alts/handshaker/alts_tsi_utils.h',
                              'src/core/tsi/alts/handshaker/transport_security_common_api.h',
                              'src/core/tsi/alts/zero_copy_frame_protector/alts_grpc_integrity_only_record_protocol.h',
                              'src/core/tsi/alts/zero_copy_frame_protector/alts_grpc_privacy_integrity_record_protocol.h',
                              'src/core/tsi/alts/zero_copy_frame_protector/alts_grpc_record_protocol.h',
                              'src/core/tsi/alts/zero_copy_frame_protector/alts_grpc_record_protocol_common.h',
                              'src/core/tsi/alts/zero_copy_frame_protector/alts_iovec_record_protocol.h',
                              'src/core/tsi/alts/zero_copy_frame_protector/alts_zero_copy_grpc_protector.h',
                              'src/core/tsi/fake_transport_security.h',
                              'src/core/tsi/local_transport_security.h',
                              'src/core/tsi/ssl/key_logging/ssl_key_logging.h',
                              'src/core/tsi/ssl/session_cache/ssl_session.h',
                              'src/core/tsi/ssl/session_cache/ssl_session_cache.h',
                              'src/core/tsi/ssl_transport_security.h',
                              'src/core/tsi/ssl_transport_security_utils.h',
                              'src/core/tsi/ssl_types.h',
                              'src/core/tsi/transport_security.h',
                              'src/core/tsi/transport_security_grpc.h',
                              'src/core/tsi/transport_security_interface.h',
                              'src/core/util/alloc.h',
                              'src/core/util/atomic_utils.h',
                              'src/core/util/avl.h',
                              'src/core/util/backoff.h',
                              'src/core/util/bitset.h',
                              'src/core/util/check_class_size.h',
                              'src/core/util/chunked_vector.h',
                              'src/core/util/construct_destruct.h',
                              'src/core/util/cpp_impl_of.h',
                              'src/core/util/crash.h',
                              'src/core/util/debug_location.h',
                              'src/core/util/directory_reader.h',
                              'src/core/util/down_cast.h',
                              'src/core/util/dual_ref_counted.h',
                              'src/core/util/dump_args.h',
                              'src/core/util/env.h',
                              'src/core/util/event_log.h',
                              'src/core/util/examine_stack.h',
                              'src/core/util/fork.h',
                              'src/core/util/function_signature.h',
                              'src/core/util/gcp_metadata_query.h',
                              'src/core/util/gethostname.h',
                              'src/core/util/glob.h',
                              'src/core/util/grpc_check.h',
                              'src/core/util/grpc_if_nametoindex.h',
                              'src/core/util/host_port.h',
                              'src/core/util/http_client/format_request.h',
                              'src/core/util/http_client/httpcli.h',
                              'src/core/util/http_client/httpcli_ssl_credentials.h',
                              'src/core/util/http_client/parser.h',
                              'src/core/util/if_list.h',
                              'src/core/util/json/json.h',
                              'src/core/util/json/json_args.h',
                              'src/core/util/json/json_channel_args.h',
                              'src/core/util/json/json_object_loader.h',
                              'src/core/util/json/json_reader.h',
                              'src/core/util/json/json_util.h',
                              'src/core/util/json/json_writer.h',
                              'src/core/util/latent_see.h',
                              'src/core/util/load_file.h',
                              'src/core/util/lru_cache.h',
                              'src/core/util/manual_constructor.h',
                              'src/core/util/match.h',
                              'src/core/util/matchers.h',
                              'src/core/util/memory.h',
                              'src/core/util/memory_usage.h',
                              'src/core/util/mpscq.h',
                              'src/core/util/no_destruct.h',
                              'src/core/util/notification.h',
                              'src/core/util/orphanable.h',
                              'src/core/util/overload.h',
                              'src/core/util/packed_table.h',
                              'src/core/util/per_cpu.h',
                              'src/core/util/postmortem_emit.h',
                              'src/core/util/random_early_detection.h',
                              'src/core/util/ref_counted.h',
                              'src/core/util/ref_counted_ptr.h',
                              'src/core/util/ref_counted_string.h',
                              'src/core/util/shared_bit_gen.h',
                              'src/core/util/single_set_ptr.h',
                              'src/core/util/sorted_pack.h',
                              'src/core/util/spinlock.h',
                              'src/core/util/stat.h',
                              'src/core/util/status_helper.h',
                              'src/core/util/strerror.h',
                              'src/core/util/string.h',
                              'src/core/util/sync.h',
                              'src/core/util/table.h',
                              'src/core/util/tchar.h',
                              'src/core/util/thd.h',
                              'src/core/util/time.h',
                              'src/core/util/time_averaged_stats.h',
                              'src/core/util/time_precise.h',
                              'src/core/util/time_util.h',
                              'src/core/util/tmpfile.h',
                              'src/core/util/trie_lookup.h',
                              'src/core/util/type_list.h',
                              'src/core/util/unique_ptr_with_bitset.h',
                              'src/core/util/unique_type_name.h',
                              'src/core/util/upb_utils.h',
                              'src/core/util/uri.h',
                              'src/core/util/useful.h',
                              'src/core/util/uuid_v4.h',
                              'src/core/util/validation_errors.h',
                              'src/core/util/wait_for_single_owner.h',
                              'src/core/util/work_serializer.h',
                              'src/core/util/xxhash_inline.h',
                              'src/core/xds/grpc/certificate_provider_store.h',
                              'src/core/xds/grpc/file_watcher_certificate_provider_factory.h',
                              'src/core/xds/grpc/xds_audit_logger_registry.h',
                              'src/core/xds/grpc/xds_bootstrap_grpc.h',
                              'src/core/xds/grpc/xds_certificate_provider.h',
                              'src/core/xds/grpc/xds_client_grpc.h',
                              'src/core/xds/grpc/xds_cluster.h',
                              'src/core/xds/grpc/xds_cluster_parser.h',
                              'src/core/xds/grpc/xds_cluster_specifier_plugin.h',
                              'src/core/xds/grpc/xds_common_types.h',
                              'src/core/xds/grpc/xds_common_types_parser.h',
                              'src/core/xds/grpc/xds_enabled_server.h',
                              'src/core/xds/grpc/xds_endpoint.h',
                              'src/core/xds/grpc/xds_endpoint_parser.h',
                              'src/core/xds/grpc/xds_health_status.h',
                              'src/core/xds/grpc/xds_http_fault_filter.h',
                              'src/core/xds/grpc/xds_http_filter.h',
                              'src/core/xds/grpc/xds_http_filter_registry.h',
                              'src/core/xds/grpc/xds_http_gcp_authn_filter.h',
                              'src/core/xds/grpc/xds_http_rbac_filter.h',
                              'src/core/xds/grpc/xds_http_stateful_session_filter.h',
                              'src/core/xds/grpc/xds_lb_policy_registry.h',
                              'src/core/xds/grpc/xds_listener.h',
                              'src/core/xds/grpc/xds_listener_parser.h',
                              'src/core/xds/grpc/xds_matcher.h',
                              'src/core/xds/grpc/xds_matcher_action.h',
                              'src/core/xds/grpc/xds_matcher_context.h',
                              'src/core/xds/grpc/xds_matcher_input.h',
                              'src/core/xds/grpc/xds_matcher_parse.h',
                              'src/core/xds/grpc/xds_metadata.h',
                              'src/core/xds/grpc/xds_metadata_parser.h',
                              'src/core/xds/grpc/xds_route_config.h',
                              'src/core/xds/grpc/xds_route_config_parser.h',
                              'src/core/xds/grpc/xds_routing.h',
                              'src/core/xds/grpc/xds_server_grpc.h',
                              'src/core/xds/grpc/xds_server_grpc_interface.h',
                              'src/core/xds/grpc/xds_transport_grpc.h',
                              'src/core/xds/xds_client/lrs_client.h',
                              'src/core/xds/xds_client/xds_api.h',
                              'src/core/xds/xds_client/xds_backend_metric_propagation.h',
                              'src/core/xds/xds_client/xds_bootstrap.h',
                              'src/core/xds/xds_client/xds_channel_args.h',
                              'src/core/xds/xds_client/xds_client.h',
                              'src/core/xds/xds_client/xds_locality.h',
                              'src/core/xds/xds_client/xds_metrics.h',
                              'src/core/xds/xds_client/xds_resource_type.h',
                              'src/core/xds/xds_client/xds_resource_type_impl.h',
                              'src/core/xds/xds_client/xds_transport.h',
                              'src/cpp/client/client_stats_interceptor.h',
                              'src/cpp/client/create_channel_internal.h',
                              'src/cpp/client/secure_credentials.h',
                              'src/cpp/common/secure_auth_context.h',
                              'src/cpp/server/backend_metric_recorder.h',
                              'src/cpp/server/dynamic_thread_pool.h',
                              'src/cpp/server/external_connection_acceptor_impl.h',
                              'src/cpp/server/health/default_health_check_service.h',
                              'src/cpp/server/secure_server_credentials.h',
                              'src/cpp/server/thread_pool_interface.h',
                              'src/cpp/thread_manager/thread_manager.h',
                              'third_party/address_sorting/address_sorting_internal.h',
                              'third_party/address_sorting/include/address_sorting/address_sorting.h',
                              'third_party/re2/re2/bitmap256.h',
                              'third_party/re2/re2/filtered_re2.h',
                              'third_party/re2/re2/pod_array.h',
                              'third_party/re2/re2/prefilter.h',
                              'third_party/re2/re2/prefilter_tree.h',
                              'third_party/re2/re2/prog.h',
                              'third_party/re2/re2/re2.h',
                              'third_party/re2/re2/regexp.h',
                              'third_party/re2/re2/set.h',
                              'third_party/re2/re2/sparse_array.h',
                              'third_party/re2/re2/sparse_set.h',
                              'third_party/re2/re2/stringpiece.h',
                              'third_party/re2/re2/unicode_casefold.h',
                              'third_party/re2/re2/unicode_groups.h',
                              'third_party/re2/re2/walker-inl.h',
                              'third_party/re2/util/logging.h',
                              'third_party/re2/util/mix.h',
                              'third_party/re2/util/mutex.h',
                              'third_party/re2/util/strutil.h',
                              'third_party/re2/util/utf.h',
                              'third_party/re2/util/util.h',
                              'third_party/upb/upb/base/descriptor_constants.h',
                              'third_party/upb/upb/base/internal/endian.h',
                              'third_party/upb/upb/base/internal/log2.h',
                              'third_party/upb/upb/base/status.h',
                              'third_party/upb/upb/base/status.hpp',
                              'third_party/upb/upb/base/string_view.h',
                              'third_party/upb/upb/base/upcast.h',
                              'third_party/upb/upb/generated_code_support.h',
                              'third_party/upb/upb/hash/common.h',
                              'third_party/upb/upb/hash/int_table.h',
                              'third_party/upb/upb/hash/str_table.h',
                              'third_party/upb/upb/json/decode.h',
                              'third_party/upb/upb/json/encode.h',
                              'third_party/upb/upb/lex/atoi.h',
                              'third_party/upb/upb/lex/round_trip.h',
                              'third_party/upb/upb/lex/strtod.h',
                              'third_party/upb/upb/lex/unicode.h',
                              'third_party/upb/upb/mem/alloc.h',
                              'third_party/upb/upb/mem/arena.h',
                              'third_party/upb/upb/mem/arena.hpp',
                              'third_party/upb/upb/mem/internal/arena.h',
                              'third_party/upb/upb/message/accessors.h',
                              'third_party/upb/upb/message/array.h',
                              'third_party/upb/upb/message/compat.h',
                              'third_party/upb/upb/message/copy.h',
                              'third_party/upb/upb/message/internal/accessors.h',
                              'third_party/upb/upb/message/internal/array.h',
                              'third_party/upb/upb/message/internal/extension.h',
                              'third_party/upb/upb/message/internal/iterator.h',
                              'third_party/upb/upb/message/internal/map.h',
                              'third_party/upb/upb/message/internal/map_entry.h',
                              'third_party/upb/upb/message/internal/map_sorter.h',
                              'third_party/upb/upb/message/internal/message.h',
                              'third_party/upb/upb/message/internal/tagged_ptr.h',
                              'third_party/upb/upb/message/internal/types.h',
                              'third_party/upb/upb/message/map.h',
                              'third_party/upb/upb/message/map_gencode_util.h',
                              'third_party/upb/upb/message/merge.h',
                              'third_party/upb/upb/message/message.h',
                              'third_party/upb/upb/message/tagged_ptr.h',
                              'third_party/upb/upb/message/value.h',
                              'third_party/upb/upb/mini_descriptor/build_enum.h',
                              'third_party/upb/upb/mini_descriptor/decode.h',
                              'third_party/upb/upb/mini_descriptor/internal/base92.h',
                              'third_party/upb/upb/mini_descriptor/internal/decoder.h',
                              'third_party/upb/upb/mini_descriptor/internal/encode.h',
                              'third_party/upb/upb/mini_descriptor/internal/encode.hpp',
                              'third_party/upb/upb/mini_descriptor/internal/modifiers.h',
                              'third_party/upb/upb/mini_descriptor/internal/wire_constants.h',
                              'third_party/upb/upb/mini_descriptor/link.h',
                              'third_party/upb/upb/mini_table/enum.h',
                              'third_party/upb/upb/mini_table/extension.h',
                              'third_party/upb/upb/mini_table/extension_registry.h',
                              'third_party/upb/upb/mini_table/field.h',
                              'third_party/upb/upb/mini_table/file.h',
                              'third_party/upb/upb/mini_table/internal/enum.h',
                              'third_party/upb/upb/mini_table/internal/extension.h',
                              'third_party/upb/upb/mini_table/internal/field.h',
                              'third_party/upb/upb/mini_table/internal/file.h',
                              'third_party/upb/upb/mini_table/internal/message.h',
                              'third_party/upb/upb/mini_table/internal/size_log2.h',
                              'third_party/upb/upb/mini_table/internal/sub.h',
                              'third_party/upb/upb/mini_table/message.h',
                              'third_party/upb/upb/mini_table/sub.h',
                              'third_party/upb/upb/port/atomic.h',
                              'third_party/upb/upb/port/def.inc',
                              'third_party/upb/upb/port/undef.inc',
                              'third_party/upb/upb/port/vsnprintf_compat.h',
                              'third_party/upb/upb/reflection/common.h',
                              'third_party/upb/upb/reflection/def.h',
                              'third_party/upb/upb/reflection/def.hpp',
                              'third_party/upb/upb/reflection/def_pool.h',
                              'third_party/upb/upb/reflection/def_type.h',
                              'third_party/upb/upb/reflection/descriptor_bootstrap.h',
                              'third_party/upb/upb/reflection/enum_def.h',
                              'third_party/upb/upb/reflection/enum_reserved_range.h',
                              'third_party/upb/upb/reflection/enum_value_def.h',
                              'third_party/upb/upb/reflection/extension_range.h',
                              'third_party/upb/upb/reflection/field_def.h',
                              'third_party/upb/upb/reflection/file_def.h',
                              'third_party/upb/upb/reflection/internal/def_builder.h',
                              'third_party/upb/upb/reflection/internal/def_pool.h',
                              'third_party/upb/upb/reflection/internal/desc_state.h',
                              'third_party/upb/upb/reflection/internal/enum_def.h',
                              'third_party/upb/upb/reflection/internal/enum_reserved_range.h',
                              'third_party/upb/upb/reflection/internal/enum_value_def.h',
                              'third_party/upb/upb/reflection/internal/extension_range.h',
                              'third_party/upb/upb/reflection/internal/field_def.h',
                              'third_party/upb/upb/reflection/internal/file_def.h',
                              'third_party/upb/upb/reflection/internal/message_def.h',
                              'third_party/upb/upb/reflection/internal/message_reserved_range.h',
                              'third_party/upb/upb/reflection/internal/method_def.h',
                              'third_party/upb/upb/reflection/internal/oneof_def.h',
                              'third_party/upb/upb/reflection/internal/service_def.h',
                              'third_party/upb/upb/reflection/internal/strdup2.h',
                              'third_party/upb/upb/reflection/internal/upb_edition_defaults.h',
                              'third_party/upb/upb/reflection/message.h',
                              'third_party/upb/upb/reflection/message.hpp',
                              'third_party/upb/upb/reflection/message_def.h',
                              'third_party/upb/upb/reflection/message_reserved_range.h',
                              'third_party/upb/upb/reflection/method_def.h',
                              'third_party/upb/upb/reflection/oneof_def.h',
                              'third_party/upb/upb/reflection/service_def.h',
                              'third_party/upb/upb/text/encode.h',
                              'third_party/upb/upb/text/internal/encode.h',
                              'third_party/upb/upb/text/options.h',
                              'third_party/upb/upb/wire/decode.h',
                              'third_party/upb/upb/wire/encode.h',
                              'third_party/upb/upb/wire/eps_copy_input_stream.h',
                              'third_party/upb/upb/wire/internal/constants.h',
                              'third_party/upb/upb/wire/internal/decode_fast.h',
                              'third_party/upb/upb/wire/internal/decoder.h',
                              'third_party/upb/upb/wire/internal/reader.h',
                              'third_party/upb/upb/wire/reader.h',
                              'third_party/upb/upb/wire/types.h',
                              'third_party/utf8_range/utf8_range.h',
                              'third_party/utf8_range/utf8_range_neon.inc',
                              'third_party/utf8_range/utf8_range_sse.inc',
                              'third_party/xxhash/xxhash.h',
                              'third_party/zlib/crc32.h',
                              'third_party/zlib/deflate.h',
                              'third_party/zlib/gzguts.h',
                              'third_party/zlib/inffast.h',
                              'third_party/zlib/inffixed.h',
                              'third_party/zlib/inflate.h',
                              'third_party/zlib/inftrees.h',
                              'third_party/zlib/trees.h',
                              'third_party/zlib/zconf.h',
                              'third_party/zlib/zlib.h',
                              'third_party/zlib/zutil.h'
  end

  s.subspec 'Protobuf' do |ss|
    ss.header_mappings_dir = 'include/grpcpp'
    ss.dependency "#{s.name}/Interface", version

    ss.source_files = 'include/grpcpp/impl/codegen/config_protobuf.h',
                      'include/grpcpp/impl/codegen/proto_buffer_reader.h',
                      'include/grpcpp/impl/codegen/proto_buffer_writer.h',
                      'include/grpcpp/impl/codegen/proto_utils.h'
  end

  # patch include of openssl to openssl_grpc
  s.prepare_command = <<-END_OF_COMMAND
    set -e
    find src/core -type f \\( -path '*.h' -or -path '*.cc' \\) -print0 | xargs -0 -L1 sed -E -i'.grpc_back' 's;#include <openssl/(.*)>;#if COCOAPODS==1\\\n  #include <openssl_grpc/\\1>\\\n#else\\\n  #include <openssl/\\1>\\\n#endif;g'
    find src/core/ -type f -name '*.grpc_back' -print0 | xargs -0 rm
  END_OF_COMMAND
end
