/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.print;

import com.sun.javafx.print.PrinterImpl;
import com.sun.javafx.print.Units;
import javafx.print.JobSettings;
import javafx.print.Paper;
import javafx.print.PaperSource;
import javafx.print.PrintResolution;
import javafx.print.Printer;

public class PrintHelper {
    private static PrintAccessor printAccessor;

    private PrintHelper() {
    }

    public static PrintResolution createPrintResolution(int fr, int cfr) {
        return printAccessor.createPrintResolution(fr, cfr);
    }

    public static Paper createPaper(String paperName, double paperWidth, double paperHeight, Units units) {
        return printAccessor.createPaper(paperName, paperWidth, paperHeight, units);
    }

    public static PaperSource createPaperSource(String name) {
        return printAccessor.createPaperSource(name);
    }

    public static JobSettings createJobSettings(Printer printer) {
        return printAccessor.createJobSettings(printer);
    }

    public static Printer createPrinter(PrinterImpl impl) {
        return printAccessor.createPrinter(impl);
    }

    public static PrinterImpl getPrinterImpl(Printer printer) {
        return printAccessor.getPrinterImpl(printer);
    }

    public static void setPrintAccessor(PrintAccessor newAccessor) {
        if (printAccessor != null) {
            throw new IllegalStateException();
        }
        printAccessor = newAccessor;
    }

    private static void forceInit(Class<?> classToInit) {
        try {
            Class.forName(classToInit.getName(), true, classToInit.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }

    static {
        PrintHelper.forceInit(Printer.class);
    }

    public static interface PrintAccessor {
        public PrintResolution createPrintResolution(int var1, int var2);

        public Paper createPaper(String var1, double var2, double var4, Units var6);

        public PaperSource createPaperSource(String var1);

        public JobSettings createJobSettings(Printer var1);

        public Printer createPrinter(PrinterImpl var1);

        public PrinterImpl getPrinterImpl(Printer var1);
    }
}

