/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene;

import com.sun.javafx.cursor.CursorFrame;
import com.sun.javafx.cursor.CursorType;
import com.sun.javafx.cursor.StandardCursorFrame;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import javafx.scene.ImageCursor;
import javafx.scene.image.Image;

public abstract class Cursor {
    public static final Cursor DEFAULT = new StandardCursor("DEFAULT", CursorType.DEFAULT);
    public static final Cursor CROSSHAIR = new StandardCursor("CROSSHAIR", CursorType.CROSSHAIR);
    public static final Cursor TEXT = new StandardCursor("TEXT", CursorType.TEXT);
    public static final Cursor WAIT = new StandardCursor("WAIT", CursorType.WAIT);
    public static final Cursor SW_RESIZE = new StandardCursor("SW_RESIZE", CursorType.SW_RESIZE);
    public static final Cursor SE_RESIZE = new StandardCursor("SE_RESIZE", CursorType.SE_RESIZE);
    public static final Cursor NW_RESIZE = new StandardCursor("NW_RESIZE", CursorType.NW_RESIZE);
    public static final Cursor NE_RESIZE = new StandardCursor("NE_RESIZE", CursorType.NE_RESIZE);
    public static final Cursor N_RESIZE = new StandardCursor("N_RESIZE", CursorType.N_RESIZE);
    public static final Cursor S_RESIZE = new StandardCursor("S_RESIZE", CursorType.S_RESIZE);
    public static final Cursor W_RESIZE = new StandardCursor("W_RESIZE", CursorType.W_RESIZE);
    public static final Cursor E_RESIZE = new StandardCursor("E_RESIZE", CursorType.E_RESIZE);
    public static final Cursor OPEN_HAND = new StandardCursor("OPEN_HAND", CursorType.OPEN_HAND);
    public static final Cursor CLOSED_HAND = new StandardCursor("CLOSED_HAND", CursorType.CLOSED_HAND);
    public static final Cursor HAND = new StandardCursor("HAND", CursorType.HAND);
    public static final Cursor MOVE = new StandardCursor("MOVE", CursorType.MOVE);
    public static final Cursor DISAPPEAR = new StandardCursor("DISAPPEAR", CursorType.DISAPPEAR);
    public static final Cursor H_RESIZE = new StandardCursor("H_RESIZE", CursorType.H_RESIZE);
    public static final Cursor V_RESIZE = new StandardCursor("V_RESIZE", CursorType.V_RESIZE);
    public static final Cursor NONE = new StandardCursor("NONE", CursorType.NONE);
    private String name = "CUSTOM";

    Cursor() {
    }

    Cursor(String name) {
        this.name = name;
    }

    abstract CursorFrame getCurrentFrame();

    void activate() {
    }

    void deactivate() {
    }

    public String toString() {
        return this.name;
    }

    public static Cursor cursor(String identifier) {
        if (identifier == null) {
            throw new NullPointerException("The cursor identifier must not be null");
        }
        if (Cursor.isUrl(identifier)) {
            return new ImageCursor(new Image(identifier));
        }
        String uName = identifier.toUpperCase(Locale.ROOT);
        if (uName.equals(Cursor.DEFAULT.name)) {
            return DEFAULT;
        }
        if (uName.equals(Cursor.CROSSHAIR.name)) {
            return CROSSHAIR;
        }
        if (uName.equals(Cursor.TEXT.name)) {
            return TEXT;
        }
        if (uName.equals(Cursor.WAIT.name)) {
            return WAIT;
        }
        if (uName.equals(Cursor.MOVE.name)) {
            return MOVE;
        }
        if (uName.equals(Cursor.SW_RESIZE.name)) {
            return SW_RESIZE;
        }
        if (uName.equals(Cursor.SE_RESIZE.name)) {
            return SE_RESIZE;
        }
        if (uName.equals(Cursor.NW_RESIZE.name)) {
            return NW_RESIZE;
        }
        if (uName.equals(Cursor.NE_RESIZE.name)) {
            return NE_RESIZE;
        }
        if (uName.equals(Cursor.N_RESIZE.name)) {
            return N_RESIZE;
        }
        if (uName.equals(Cursor.S_RESIZE.name)) {
            return S_RESIZE;
        }
        if (uName.equals(Cursor.W_RESIZE.name)) {
            return W_RESIZE;
        }
        if (uName.equals(Cursor.E_RESIZE.name)) {
            return E_RESIZE;
        }
        if (uName.equals(Cursor.OPEN_HAND.name)) {
            return OPEN_HAND;
        }
        if (uName.equals(Cursor.CLOSED_HAND.name)) {
            return CLOSED_HAND;
        }
        if (uName.equals(Cursor.HAND.name)) {
            return HAND;
        }
        if (uName.equals(Cursor.H_RESIZE.name)) {
            return H_RESIZE;
        }
        if (uName.equals(Cursor.V_RESIZE.name)) {
            return V_RESIZE;
        }
        if (uName.equals(Cursor.DISAPPEAR.name)) {
            return DISAPPEAR;
        }
        if (uName.equals(Cursor.NONE.name)) {
            return NONE;
        }
        throw new IllegalArgumentException("Invalid cursor specification");
    }

    private static boolean isUrl(String identifier) {
        try {
            new URL(identifier);
        }
        catch (MalformedURLException e) {
            return false;
        }
        return true;
    }

    private static final class StandardCursor
    extends Cursor {
        private final CursorFrame singleFrame;

        public StandardCursor(String name, CursorType type) {
            super(name);
            this.singleFrame = new StandardCursorFrame(type);
        }

        @Override
        CursorFrame getCurrentFrame() {
            return this.singleFrame;
        }
    }
}

