/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.video;

import org.openimaj.image.Image;
import org.openimaj.video.processor.VideoProcessor;

public abstract class VideoWriter<T extends Image<?, T>>
extends VideoProcessor<T> {
    protected double frameRate = 25.0;
    protected int width = 720;
    protected int height = 576;

    public VideoWriter(int width, int height, double frameRate) {
        this.width = width;
        this.height = height;
        this.frameRate = frameRate;
    }

    public abstract void addFrame(T var1);

    @Override
    public T processFrame(T frame) {
        if (frame.getWidth() == this.width && frame.getHeight() == this.height) {
            this.addFrame(frame);
            return frame;
        }
        throw new RuntimeException("Frame width and height (" + frame.getWidth() + "x" + frame.getHeight() + ") does not match the video width and height (" + this.width + "x" + this.height + ")");
    }

    @Override
    public long getTimeStamp() {
        return (long)((double)this.getCurrentFrameIndex() / this.frameRate) * 1000L;
    }

    @Override
    public double getFPS() {
        return this.frameRate;
    }
}

