/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.matrix;

import Jama.CholeskyDecomposition;
import Jama.Matrix;

public class UpdateableCholeskyDecomposition
extends CholeskyDecomposition {
    private static final long serialVersionUID = -7456377954967521480L;

    public UpdateableCholeskyDecomposition(Matrix m) {
        super(m);
    }

    public void choldowndate(double[] x) {
        this.choldowndate(x, true);
    }

    public void choldowndate(double[] x, boolean b) {
        if (b) {
            x = (double[])x.clone();
        }
        Matrix L = this.getL();
        double[][] data = L.transpose().getArray();
        UpdateableCholeskyDecomposition.choldowndate(data, x);
        int Ll = L.getRowDimension();
        L.setMatrix(0, Ll - 1, 0, Ll - 1, new Matrix(data, Ll, Ll).transpose());
    }

    public void cholupdate(double[] x) {
        this.cholupdate(x, true);
    }

    public void cholupdate(double[] x, boolean copyX) {
        if (copyX) {
            x = (double[])x.clone();
        }
        Matrix L = this.getL();
        double[][] data = L.transpose().getArray();
        UpdateableCholeskyDecomposition.cholupdate(data, x);
        int Ll = L.getRowDimension();
        L.setMatrix(0, Ll - 1, 0, Ll - 1, new Matrix(data, Ll, Ll).transpose());
    }

    public static void cholupdate(double[][] Larr, double[] x) {
        for (int k = 0; k < x.length; ++k) {
            double Lkk = Larr[k][k];
            double xk = x[k];
            double r = Math.sqrt(Lkk * Lkk + xk * xk);
            double c = r / Lkk;
            double s = xk / Lkk;
            Larr[k][k] = r;
            UpdateableCholeskyDecomposition.updateL(k, Larr, x, s, c);
            UpdateableCholeskyDecomposition.updateX(k, Larr, x, s, c);
        }
    }

    public static void choldowndate(double[][] Larr, double[] x) {
        for (int k = 0; k < x.length; ++k) {
            double Lkk = Larr[k][k];
            double xk = x[k];
            double r = Math.sqrt(Lkk * Lkk - xk * xk);
            double c = r / Lkk;
            double s = xk / Lkk;
            Larr[k][k] = r;
            UpdateableCholeskyDecomposition.downdateL(k, Larr, x, s, c);
            UpdateableCholeskyDecomposition.updateX(k, Larr, x, s, c);
        }
    }

    private static void updateX(int k, double[][] Larr, double[] x, double s, double c) {
        for (int i = k + 1; i < x.length; ++i) {
            x[i] = c * x[i] - s * Larr[k][i];
        }
    }

    private static void updateL(int k, double[][] Larr, double[] x, double s, double c) {
        for (int i = k + 1; i < x.length; ++i) {
            Larr[k][i] = (Larr[k][i] + s * x[i]) / c;
        }
    }

    private static void downdateL(int k, double[][] Larr, double[] x, double s, double c) {
        for (int i = k + 1; i < x.length; ++i) {
            Larr[k][i] = (Larr[k][i] - s * x[i]) / c;
        }
    }
}

