/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.io.Serializable;
import java.util.List;
import org.nlogo.agent.ImporterJ;
import org.nlogo.agent.Link;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.api.Color$;
import org.nlogo.api.ImporterUser;
import org.nlogo.api.PlotInterface;
import org.nlogo.api.PlotPenInterface;
import org.nlogo.api.PlotState;
import org.nlogo.core.AgentKind;
import org.nlogo.core.AgentKind$Link$;
import org.nlogo.core.AgentKind$Observer$;
import org.nlogo.core.AgentKind$Patch$;
import org.nlogo.core.AgentKind$Turtle$;
import org.nlogo.core.AgentVariables$;
import org.nlogo.core.Breed;
import org.nlogo.core.PlotPenState;
import org.nlogo.core.PlotPenState$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.NonLocalReturnControl$mcV$sp;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1$mcVI$sp;
import scala.runtime.java8.JFunction1$mcZI$sp;

@ScalaSignature(bytes="\u0006\u0001\u0005}c\u0001\u0002\u000b\u0016\u0001qA\u0001\"\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\tS\u0001\u0011\t\u0011)A\u0005U!AQ\u0006\u0001B\u0001B\u0003%a\u0006\u0003\u00055\u0001\t\u0005\t\u0015!\u00036\u0011\u0015A\u0004\u0001\"\u0001:\u0011\u0015y\u0004\u0001\"\u0011A\u0011\u0015Q\u0006\u0001\"\u0001\\\u0011\u0015a\u0006\u0001\"\u0001\\\u0011\u0015i\u0006\u0001\"\u0001\\\u0011\u0015q\u0006\u0001\"\u0001\\\u0011\u0015y\u0006\u0001\"\u0001a\u0011\u00151\b\u0001\"\u0001x\u0011\u0015Y\b\u0001\"\u0003}\u0011\u001d\t9\u0002\u0001C\u0001\u00033Aq!!\t\u0001\t\u0003\t\u0019\u0003C\u0004\u0002(\u0001!I!!\u000b\t\u000f\u0005}\u0002\u0001\"\u0003\u0002B!9\u0011Q\n\u0001\u0005\n\u0005=\u0003bBA-\u0001\u0011%\u00111\f\u0002\t\u00136\u0004xN\u001d;fe*\u0011acF\u0001\u0006C\u001e,g\u000e\u001e\u0006\u00031e\tQA\u001c7pO>T\u0011AG\u0001\u0004_J<7\u0001A\n\u0003\u0001u\u0001\"AH\u0010\u000e\u0003UI!\u0001I\u000b\u0003\u0013%k\u0007o\u001c:uKJT\u0015!D0feJ|'\u000fS1oI2,'\u000f\u0005\u0002$M9\u0011a\u0004J\u0005\u0003KU\t\u0011\"S7q_J$XM\u001d&\n\u0005\u001dB#\u0001D#se>\u0014\b*\u00198eY\u0016\u0014(BA\u0013\u0016\u0003\u0019yvo\u001c:mIB\u0011adK\u0005\u0003YU\u0011QaV8sY\u0012\fQbX5na>\u0014H/\u001a:Vg\u0016\u0014\bCA\u00183\u001b\u0005\u0001$BA\u0019\u0018\u0003\r\t\u0007/[\u0005\u0003gA\u0012A\"S7q_J$XM]+tKJ\fQbX:ue&twMU3bI\u0016\u0014\bCA\u00127\u0013\t9\u0004F\u0001\u0007TiJLgn\u001a*fC\u0012,'/\u0001\u0004=S:LGO\u0010\u000b\u0006umbTH\u0010\t\u0003=\u0001AQ!I\u0003A\u0002\tBQ!K\u0003A\u0002)BQ!L\u0003A\u00029BQ\u0001N\u0003A\u0002U\nAcZ3u\u00136\u0004H.[2jiZ\u000b'/[1cY\u0016\u001cHCA!S!\r\u0011UiR\u0007\u0002\u0007*\tA)A\u0003tG\u0006d\u0017-\u0003\u0002G\u0007\n)\u0011I\u001d:bsB\u0011\u0001j\u0014\b\u0003\u00136\u0003\"AS\"\u000e\u0003-S!\u0001T\u000e\u0002\rq\u0012xn\u001c;?\u0013\tq5)\u0001\u0004Qe\u0016$WMZ\u0005\u0003!F\u0013aa\u0015;sS:<'B\u0001(D\u0011\u0015\u0019f\u00011\u0001U\u0003\u0011Y\u0017N\u001c3\u0011\u0005UCV\"\u0001,\u000b\u0005];\u0012\u0001B2pe\u0016L!!\u0017,\u0003\u0013\u0005;WM\u001c;LS:$\u0017aG4fiN\u0003XmY5bY>\u00137/\u001a:wKJ4\u0016M]5bE2,7\u000fF\u0001B\u0003e9W\r^*qK\u000eL\u0017\r\u001c+veRdWMV1sS\u0006\u0014G.Z:\u00021\u001d,Go\u00159fG&\fG\u000eU1uG\"4\u0016M]5bE2,7/A\fhKR\u001c\u0006/Z2jC2d\u0015N\\6WCJL\u0017M\u00197fg\u0006Qq-\u001a;BY24\u0016M]:\u0015\u0005\u0005L\u0007c\u00012h\u000f6\t1M\u0003\u0002eK\u0006!Q\u000f^5m\u0015\u00051\u0017\u0001\u00026bm\u0006L!\u0001[2\u0003\t1K7\u000f\u001e\u0005\u0006U.\u0001\ra[\u0001\u0007EJ,W\rZ:\u0011\t1\fxi]\u0007\u0002[*\u0011an\\\u0001\nS6lW\u000f^1cY\u0016T!\u0001]\"\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002s[\n9A*[:u\u001b\u0006\u0004\bCA+u\u0013\t)hKA\u0003Ce\u0016,G-A\u0006j[B|'\u000f\u001e)m_R\u001cH#\u0001=\u0011\u0005\tK\u0018B\u0001>D\u0005\u0011)f.\u001b;\u0002\u0017%l\u0007o\u001c:u\u0013:$(o\u001c\u000b\u0004{\u00065\u0001C\u0002\"\u007f\u0003\u0003\t9!\u0003\u0002\u0000\u0007\n1A+\u001e9mKJ\u00022AQA\u0002\u0013\r\t)a\u0011\u0002\u0004\u0013:$\b\u0003\u0002\"\u0002\n\u001dK1!a\u0003D\u0005\u0019y\u0005\u000f^5p]\"9\u0011qB\u0007A\u0002\u0005E\u0011\u0001\u00029m_R\u00042aLA\n\u0013\r\t)\u0002\r\u0002\u000e!2|G/\u00138uKJ4\u0017mY3\u0002\u0015%l\u0007o\u001c:u!\u0016t7\u000fF\u0003y\u00037\ti\u0002C\u0004\u0002\u00109\u0001\r!!\u0005\t\u000f\u0005}a\u00021\u0001\u0002\u0002\u00059a.^7QK:\u001c\u0018\u0001D5na>\u0014H\u000fU8j]R\u001cHc\u0001=\u0002&!9\u0011qB\bA\u0002\u0005E\u0011!E5na>\u0014H\u000fU8j]RDU\r\u001c9feRI\u00010a\u000b\u0002.\u0005]\u00121\b\u0005\b\u0003\u001f\u0001\u0002\u0019AA\t\u0011\u001d\ty\u0003\u0005a\u0001\u0003c\t1\u0001]3o!\ry\u00131G\u0005\u0004\u0003k\u0001$\u0001\u0005)m_R\u0004VM\\%oi\u0016\u0014h-Y2f\u0011\u0019\tI\u0004\u0005a\u0001\u0003\u0006!A-\u0019;b\u0011\u001d\ti\u0004\u0005a\u0001\u0003\u0003\t\u0011![\u0001\u000be\u0016\fGMT;nE\u0016\u0014H\u0003BA\"\u0003\u0013\u00022AQA#\u0013\r\t9e\u0011\u0002\u0007\t>,(\r\\3\t\r\u0005-\u0013\u00031\u0001H\u0003\u0011a\u0017N\\3\u0002\u0017I,\u0017\r\u001a\"p_2,\u0017M\u001c\u000b\u0005\u0003#\n9\u0006E\u0002C\u0003'J1!!\u0016D\u0005\u001d\u0011un\u001c7fC:Da!a\u0013\u0013\u0001\u00049\u0015A\u0003:fC\u0012\u001cFO]5oOR\u0019q)!\u0018\t\r\u0005-3\u00031\u0001H\u0001")
public class Importer
extends ImporterJ {
    @Override
    public String[] getImplicitVariables(AgentKind kind) {
        String[] stringArray;
        if (AgentKind$Observer$.MODULE$.equals(kind)) {
            stringArray = (String[])AgentVariables$.MODULE$.implicitObserverVariables().toArray(ClassTag$.MODULE$.apply(String.class));
        } else if (AgentKind$Turtle$.MODULE$.equals(kind)) {
            stringArray = (String[])AgentVariables$.MODULE$.implicitTurtleVariables().toArray(ClassTag$.MODULE$.apply(String.class));
        } else if (AgentKind$Patch$.MODULE$.equals(kind)) {
            stringArray = (String[])AgentVariables$.MODULE$.implicitPatchVariables().toArray(ClassTag$.MODULE$.apply(String.class));
        } else if (AgentKind$Link$.MODULE$.equals(kind)) {
            stringArray = (String[])AgentVariables$.MODULE$.implicitLinkVariables().toArray(ClassTag$.MODULE$.apply(String.class));
        } else {
            throw new MatchError(kind);
        }
        return stringArray;
    }

    @Override
    public String[] getSpecialObserverVariables() {
        return (String[])((Object[])new String[]{"MIN-PXCOR", "MAX-PXCOR", "MIN-PYCOR", "MAX-PYCOR", "SCREEN-EDGE-X", "SCREEN-EDGE-Y", "PERSPECTIVE", "SUBJECT", "NEXTINDEX", "DIRECTED-LINKS", "TICKS"});
    }

    @Override
    public String[] getSpecialTurtleVariables() {
        Seq<String> vars = AgentVariables$.MODULE$.implicitTurtleVariables();
        return (String[])((Object[])new String[]{(String)vars.apply(Turtle.VAR_WHO), (String)vars.apply(Turtle.VAR_BREED), (String)vars.apply(Turtle.VAR_LABEL), (String)vars.apply(Turtle.VAR_SHAPE)});
    }

    @Override
    public String[] getSpecialPatchVariables() {
        Seq<String> vars = AgentVariables$.MODULE$.implicitPatchVariables();
        return (String[])((Object[])new String[]{(String)vars.apply(Patch.VAR_PXCOR), (String)vars.apply(Patch.VAR_PYCOR), (String)vars.apply(Patch.VAR_PLABEL)});
    }

    @Override
    public String[] getSpecialLinkVariables() {
        Seq<String> vars = AgentVariables$.MODULE$.implicitLinkVariables();
        return (String[])((Object[])new String[]{(String)vars.apply(Link.VAR_BREED), (String)vars.apply(Link.VAR_LABEL), (String)vars.apply(Link.VAR_END1), (String)vars.apply(Link.VAR_END2)});
    }

    @Override
    public List<String> getAllVars(ListMap<String, Breed> breeds) {
        return JavaConverters$.MODULE$.seqAsJavaListConverter(((TraversableOnce)breeds.values().flatMap((Function1<Breed, Seq> & Serializable & scala.Serializable)x$1 -> x$1.owns(), Iterable$.MODULE$.canBuildFrom())).toSeq()).asJava();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void importPlots() {
        if (this.hasMoreLines(false)) {
            String currentPlot = this.nextLine()[0];
            if (new StringOps(Predef$.MODULE$.augmentString(currentPlot)).nonEmpty()) {
                this.importerUser.currentPlot(currentPlot);
            }
            while (this.hasMoreLines(false)) {
                String[] line = this.nextLine();
                try {
                    void var7_7;
                    void var6_6;
                    String plotName = (String)this.getTokenValue(line[0], false, false);
                    PlotInterface plot = this.importerUser.getPlot(plotName);
                    if (plot == null) {
                        this.errorHandler.showError("Error Importing Plots", new StringBuilder(27).append("The plot \"").append(plotName).append("\" does not exist.").toString(), false);
                        while (this.hasMoreLines(false)) {
                        }
                        return;
                    }
                    Tuple2<Object, Option<String>> tuple2 = this.importIntro(plot);
                    if (tuple2 == null) {
                        throw new MatchError((Object)null);
                    }
                    int numPens = tuple2._1$mcI$sp();
                    Option<String> currentPenNameOpt = tuple2._2();
                    this.importPens(plot, (int)var6_6);
                    this.importPoints(plot);
                    var7_7.foreach((Function1<String, Object> & Serializable & scala.Serializable)pen -> {
                        plot.currentPenByName_$eq(pen);
                        return BoxedUnit.UNIT;
                    });
                }
                catch (ClassCastException classCastException) {
                    throw new ImporterJ.AbortingImportException(ImporterJ.ImportError.ILLEGAL_CLASS_CAST_ERROR, "");
                }
            }
        }
    }

    private Tuple2<Object, Option<String>> importIntro(PlotInterface plot) {
        if (!this.hasMoreLines(false)) {
            return new Tuple2<Object, Option<String>>(BoxesRunTime.boxToInteger(0), None$.MODULE$);
        }
        if (!this.hasMoreLines(false)) {
            return new Tuple2<Object, Option<String>>(BoxesRunTime.boxToInteger(0), None$.MODULE$);
        }
        String[] line = this.nextLine();
        double x$1 = this.readNumber(line[0]);
        double x$2 = this.readNumber(line[1]);
        double x$3 = this.readNumber(line[2]);
        double x$4 = this.readNumber(line[3]);
        boolean x$5 = this.readBoolean(line[4]);
        plot.state_$eq(new PlotState(x$5, x$1, x$2, x$3, x$4));
        plot.legendIsOpen_$eq(this.readBoolean(line[6]));
        return new Tuple2<Object, Option<String>>(BoxesRunTime.boxToInteger((int)this.readNumber(line[7])), Option$.MODULE$.apply(this.readString(line[5])));
    }

    public void importPens(PlotInterface plot, int numPens) {
        Object object = new Object();
        try {
            if (this.hasMoreLines(false)) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPens).withFilter((JFunction1$mcZI$sp & scala.Serializable)i -> this.hasMoreLines(false)).foreach((JFunction1$mcVI$sp & scala.Serializable)i -> {
                    String[] line = this.nextLine();
                    Object object = this.getTokenValue(line[0], false, false);
                    if (object instanceof ImporterJ.Junk) {
                        throw new NonLocalReturnControl$mcV$sp(object, BoxedUnit.UNIT);
                    }
                    if (!(object instanceof String)) throw new MatchError(object);
                    String string2 = (String)object;
                    Option<PlotPenInterface> option = plot.getPen(string2);
                    if (option instanceof Some) {
                        boolean x$1 = this.readBoolean(line[1]);
                        int x$2 = (int)this.readNumber(line[2]);
                        double x$3 = this.readNumber(line[3]);
                        int x$4 = Color$.MODULE$.getARGBbyPremodulatedColorNumber(this.readNumber(line[4]));
                        double x$5 = this.readNumber(line[5]);
                        boolean x$6 = PlotPenState$.MODULE$.apply$default$6();
                        ((PlotPenInterface)((Some)option).value()).state_$eq(new PlotPenState(x$5, x$4, x$3, x$2, x$1, x$6));
                        return;
                    }
                    if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                    $this.errorHandler.showError("Error Importing Plots", new StringBuilder(26).append("The pen \"").append(string2).append("\" does not exist.").toString(), false);
                    while (this.hasMoreLines(false)) {
                        this.nextLine();
                    }
                });
            }
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
                return;
            }
            throw ex;
        }
    }

    public void importPoints(PlotInterface plot) {
        if (this.hasMoreLines(false)) {
            String[] line = this.nextLine();
            int penCount = (new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])line)).size() - 1) / 4 + 1;
            String[] pens = (String[])Array$.MODULE$.tabulate(penCount, (Function1<Object, String> & Serializable & scala.Serializable)i -> this.readString(line[BoxesRunTime.unboxToInt(i) * 4]), ClassTag$.MODULE$.apply(String.class));
            if (this.hasMoreLines(false)) {
                while (this.hasMoreLines(true)) {
                    String[] data = this.nextLine();
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])pens)).size()).foreach((Function1<Object, Object> & Serializable & scala.Serializable)i -> Importer.$anonfun$importPoints$2(this, plot, pens, data, BoxesRunTime.unboxToInt(i)));
                }
            }
        }
    }

    private void importPointHelper(PlotInterface plot, PlotPenInterface pen, String[] data, int i) {
        try {
            PlotPenState qual$1 = pen.state();
            int x$1 = Color$.MODULE$.getARGBbyPremodulatedColorNumber(this.readNumber(data[i * 4 + 2]));
            boolean x$2 = this.readBoolean(data[i * 4 + 3]);
            double x$3 = qual$1.copy$default$1();
            double x$4 = qual$1.copy$default$3();
            int x$5 = qual$1.copy$default$4();
            boolean x$6 = qual$1.copy$default$6();
            pen.state_$eq(qual$1.copy(x$3, x$1, x$4, x$5, x$2, x$6));
            plot.plot(this.readNumber(data[i * 4]), this.readNumber(data[i * 4 + 1]));
            return;
        }
        catch (ClassCastException classCastException) {
            this.errorHandler.showError("Import Error", new StringBuilder(51).append("Error while importing ").append(plot.name()).append(", this point will be skipped.").toString(), false);
            return;
        }
    }

    private double readNumber(String line) {
        double d;
        Object object = this.getTokenValue(line, false, false);
        if (object instanceof Double) {
            d = (Double)object;
        } else if (object instanceof ImporterJ.Junk) {
            d = 0.0;
        } else {
            throw new MatchError(object);
        }
        return d;
    }

    private boolean readBoolean(String line) {
        boolean bl;
        Object object = this.getTokenValue(line, false, false);
        if (object instanceof Boolean) {
            bl = (Boolean)object;
        } else if (object instanceof ImporterJ.Junk) {
            bl = false;
        } else {
            throw new MatchError(object);
        }
        return bl;
    }

    private String readString(String line) {
        String string2;
        Object object = this.getTokenValue(line, false, false);
        if (object instanceof String) {
            string2 = (String)object;
        } else if (object instanceof ImporterJ.Junk) {
            string2 = null;
        } else {
            throw new MatchError(object);
        }
        return string2;
    }

    public static final /* synthetic */ Object $anonfun$importPoints$2(Importer $this, PlotInterface plot$3, String[] pens$1, String[] data$1, int i) {
        Serializable serializable;
        Option<PlotPenInterface> option = plot$3.getPen(pens$1[i]);
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            PlotPenInterface pen = (PlotPenInterface)((Some)option).value();
            plot$3.currentPenByName_$eq(pen.name());
            if (new StringOps(Predef$.MODULE$.augmentString(data$1[i * 4])).nonEmpty()) {
                PlotPenState oldState = pen.state();
                $this.importPointHelper(plot$3, pen, data$1, i);
                pen.state_$eq(oldState);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            serializable = boxedUnit;
        } else if (None$.MODULE$.equals(option)) {
            serializable = BoxesRunTime.boxToBoolean($this.errorHandler.showError("Error Importing Plots", new StringBuilder(26).append("The pen \"").append(pens$1[i]).append("\" does not exist.").toString(), false));
        } else {
            throw new MatchError(option);
        }
        return serializable;
    }

    public Importer(ImporterJ.ErrorHandler _errorHandler, World _world, ImporterUser _importerUser, ImporterJ.StringReader _stringReader) {
        super(_errorHandler, _world, _importerUser, _stringReader);
    }
}

