/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.decomposition;

import org.la4j.decomposition.MatrixDecompositor;
import org.la4j.factory.Factory;
import org.la4j.matrix.Matrices;
import org.la4j.matrix.Matrix;
import org.la4j.vector.Vector;

public class QRDecompositor
implements MatrixDecompositor {
    @Override
    public Matrix[] decompose(Matrix matrix, Factory factory) {
        if (matrix.rows() < matrix.columns()) {
            throw new IllegalArgumentException("Wrong matrix size: rows < columns");
        }
        Matrix qr = matrix.copy();
        Vector rdiag = factory.createVector(qr.columns());
        for (int k = 0; k < qr.columns(); ++k) {
            int i;
            double norm = 0.0;
            for (i = k; i < qr.rows(); ++i) {
                norm = Math.hypot(norm, qr.get(i, k));
            }
            if (Math.abs(norm) > Matrices.EPS) {
                if (qr.get(k, k) < 0.0) {
                    norm = -norm;
                }
                for (i = k; i < qr.rows(); ++i) {
                    qr.update(i, k, Matrices.asDivFunction(norm));
                }
                qr.update(k, k, Matrices.INC_FUNCTION);
                for (int j = k + 1; j < qr.columns(); ++j) {
                    int i2;
                    double summand = 0.0;
                    for (i2 = k; i2 < qr.rows(); ++i2) {
                        summand += qr.get(i2, k) * qr.get(i2, j);
                    }
                    summand = -summand / qr.get(k, k);
                    for (i2 = k; i2 < qr.rows(); ++i2) {
                        qr.update(i2, j, Matrices.asPlusFunction(summand * qr.get(i2, k)));
                    }
                }
            }
            rdiag.set(k, -norm);
        }
        Matrix q = qr.blank(factory);
        for (int k = q.columns() - 1; k >= 0; --k) {
            q.set(k, k, 1.0);
            for (int j = k; j < q.columns(); ++j) {
                int i;
                if (!(Math.abs(qr.get(k, k)) > Matrices.EPS)) continue;
                double summand = 0.0;
                for (i = k; i < q.rows(); ++i) {
                    summand += qr.get(i, k) * q.get(i, j);
                }
                summand = -summand / qr.get(k, k);
                for (i = k; i < q.rows(); ++i) {
                    q.update(i, j, Matrices.asPlusFunction(summand * qr.get(i, k)));
                }
            }
        }
        Matrix r = factory.createSquareMatrix(qr.columns());
        for (int i = 0; i < r.rows(); ++i) {
            for (int j = i; j < r.columns(); ++j) {
                if (i < j) {
                    r.set(i, j, qr.get(i, j));
                    continue;
                }
                if (i != j) continue;
                r.set(i, j, rdiag.get(i));
            }
        }
        return new Matrix[]{q, r};
    }
}

