/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.factory;

import java.util.Arrays;
import java.util.Random;
import org.la4j.factory.BasicFactory;
import org.la4j.factory.Factory;
import org.la4j.matrix.Matrix;
import org.la4j.matrix.dense.Basic2DMatrix;
import org.la4j.matrix.source.MatrixSource;

public class Basic2DFactory
extends BasicFactory
implements Factory {
    private static final long serialVersionUID = 4071505L;

    @Override
    public Matrix createMatrix() {
        return new Basic2DMatrix();
    }

    @Override
    public Matrix createMatrix(int rows, int columns) {
        return new Basic2DMatrix(rows, columns);
    }

    @Override
    public Matrix createMatrix(double[][] array) {
        return new Basic2DMatrix(array);
    }

    @Override
    public Matrix createMatrix(Matrix matrix) {
        return new Basic2DMatrix(matrix);
    }

    @Override
    public Matrix createMatrix(MatrixSource source) {
        return new Basic2DMatrix(source);
    }

    @Override
    public Matrix createConstantMatrix(int rows, int columns, double value) {
        double[][] array = new double[rows][columns];
        for (int i = 0; i < rows; ++i) {
            Arrays.fill(array[i], value);
        }
        return new Basic2DMatrix(array);
    }

    @Override
    public Matrix createRandomMatrix(int rows, int columns) {
        double[][] array = new double[rows][columns];
        Random rnd = new Random();
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                array[i][j] = rnd.nextDouble();
            }
        }
        return new Basic2DMatrix(array);
    }

    @Override
    public Matrix createRandomSymmetricMatrix(int size) {
        double[][] array = new double[size][size];
        Random rnd = new Random();
        for (int i = 0; i < size; ++i) {
            for (int j = i; j < size; ++j) {
                double value;
                array[i][j] = value = rnd.nextDouble();
                array[j][i] = value;
            }
        }
        return new Basic2DMatrix(array);
    }

    @Override
    public Matrix createSquareMatrix(int size) {
        return new Basic2DMatrix(size, size);
    }

    @Override
    public Matrix createIdentityMatrix(int size) {
        double[][] array = new double[size][size];
        for (int i = 0; i < size; ++i) {
            array[i][i] = 1.0;
        }
        return new Basic2DMatrix(array);
    }
}

