/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import java.util.StringTokenizer;
import org.la4j.factory.Factory;
import org.la4j.io.AbstractStream;
import org.la4j.io.MatrixStream;
import org.la4j.io.VectorStream;
import org.la4j.matrix.Matrices;
import org.la4j.matrix.Matrix;
import org.la4j.matrix.dense.DenseMatrix;
import org.la4j.matrix.functor.MatrixProcedure;
import org.la4j.matrix.sparse.SparseMatrix;
import org.la4j.vector.Vector;
import org.la4j.vector.Vectors;
import org.la4j.vector.dense.DenseVector;
import org.la4j.vector.functor.VectorProcedure;
import org.la4j.vector.sparse.SparseVector;

public class MatrixMarketStream
extends AbstractStream
implements MatrixStream,
VectorStream {
    private StringTokenizer tokenizer;

    public MatrixMarketStream(InputStream in) {
        super(in);
    }

    public MatrixMarketStream(OutputStream out) {
        super(out);
    }

    @Override
    public Vector readVector() throws IOException {
        return this.readVector(null);
    }

    @Override
    public Vector readVector(Factory factory) throws IOException {
        this.ensureReaderInitialized();
        Vector vector = this.parseVector(factory);
        this.closeReader();
        return vector;
    }

    @Override
    public void writeVector(Vector vector) throws IOException {
        this.ensureWriterInitialized();
        if (vector instanceof SparseVector) {
            this.writeSparseVector((SparseVector)vector);
        } else if (vector instanceof DenseVector) {
            this.writeDenseVector((DenseVector)vector);
        } else {
            throw new IllegalArgumentException("Unknown vector type.");
        }
        this.closeWriter();
    }

    @Override
    public Matrix readMatrix(Factory factory) throws IOException {
        this.ensureReaderInitialized();
        Matrix matrix = this.parseMatrix(factory);
        this.closeReader();
        return matrix;
    }

    @Override
    public Matrix readMatrix() throws IOException {
        return this.readMatrix(null);
    }

    @Override
    public void writeMatrix(Matrix matrix) throws IOException {
        this.ensureWriterInitialized();
        if (matrix instanceof SparseMatrix) {
            this.writeSparseMatrix((SparseMatrix)matrix);
        } else if (matrix instanceof DenseMatrix) {
            this.writeDenseMatrix((DenseMatrix)matrix);
        } else {
            throw new IllegalArgumentException("Unknow matrix type.");
        }
        this.closeWriter();
    }

    private void writeSparseVector(SparseVector vector) throws IOException {
        this.writer.write("%%MatrixMarket vector coordinate real general");
        this.writer.newLine();
        this.writer.write(vector.length() + " " + vector.cardinality());
        this.writer.newLine();
        vector.each(new SparseVectorWriteProcedure(this.writer));
    }

    private void writeDenseVector(DenseVector vector) throws IOException {
        this.writer.write("%%MatrixMarket vector array real general");
        this.writer.newLine();
        this.writer.write(Integer.toString(vector.length()));
        this.writer.newLine();
        for (int i = 0; i < vector.length(); ++i) {
            double value = vector.get(i);
            this.writer.write(String.format(Locale.US, "%.12f", value));
            this.writer.newLine();
        }
    }

    private void writeSparseMatrix(SparseMatrix matrix) throws IOException {
        this.writer.write("%%MatrixMarket matrix coordinate real general");
        this.writer.newLine();
        this.writer.write(matrix.rows() + " " + matrix.columns() + " " + matrix.cardinality());
        this.writer.newLine();
        matrix.each(new SparseMatrixWriteProcedure(this.writer));
    }

    private void writeDenseMatrix(DenseMatrix matrix) throws IOException {
        this.writer.write("%%MatrixMarket matrix array real general");
        this.writer.newLine();
        this.writer.write(matrix.rows() + " " + matrix.columns());
        this.writer.newLine();
        for (int i = 0; i < matrix.rows(); ++i) {
            for (int j = 0; j < matrix.columns(); ++j) {
                double value = matrix.get(i, j);
                this.writer.write(String.format(Locale.US, "%.12f", value));
                this.writer.newLine();
            }
        }
    }

    private Vector parseVector(Factory factory) throws IOException {
        this.ensureNext("%%MatrixMarket");
        this.ensureNext("vector");
        String token = this.nextToken();
        this.ensureNext("real");
        this.ensureNext("general");
        if (token.equals("array")) {
            return this.parseDenseVector(factory == null ? Vectors.DEFAULT_DENSE_FACTORY : factory);
        }
        if (token.equals("coordinate")) {
            return this.parseSparseVector(factory == null ? Vectors.DEFAULT_SPARSE_FACTORY : factory);
        }
        throw new IOException("Unexpected token at stream: \"" + token + "\".");
    }

    private Vector parseDenseVector(Factory factory) throws IOException {
        int length = Integer.valueOf(this.nextToken());
        Vector vector = factory.createVector(length);
        for (int i = 0; i < length; ++i) {
            double value = Double.valueOf(this.nextToken());
            vector.set(i, value);
        }
        return vector;
    }

    private Vector parseSparseVector(Factory factory) throws IOException {
        int length = Integer.valueOf(this.nextToken());
        int cardinality = Integer.valueOf(this.nextToken());
        Vector vector = factory.createVector(length);
        for (int k = 0; k < cardinality; ++k) {
            int i = Integer.valueOf(this.nextToken()) - 1;
            double value = Double.valueOf(this.nextToken());
            vector.set(i, value);
        }
        return vector;
    }

    private Matrix parseMatrix(Factory factory) throws IOException {
        this.ensureNext("%%MatrixMarket");
        this.ensureNext("matrix");
        String token = this.nextToken();
        this.ensureNext("real");
        this.ensureNext("general");
        if (token.equals("array")) {
            return this.parseDenseMatrix(factory == null ? Matrices.DEFAULT_DENSE_FACTORY : factory);
        }
        if (token.equals("coordinate")) {
            return this.parseSparseMatrix(factory == null ? Matrices.DEFAULT_SPARSE_FACTORY : factory);
        }
        throw new IOException("Unexpected token at stream: \"" + token + "\".");
    }

    private Matrix parseDenseMatrix(Factory factory) throws IOException {
        int rows = Integer.valueOf(this.nextToken());
        int columns = Integer.valueOf(this.nextToken());
        Matrix matrix = factory.createMatrix(rows, columns);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                double value = Double.valueOf(this.nextToken());
                matrix.set(i, j, value);
            }
        }
        return matrix;
    }

    private Matrix parseSparseMatrix(Factory factory) throws IOException {
        int rows = Integer.valueOf(this.nextToken());
        int columns = Integer.valueOf(this.nextToken());
        int cardinality = Integer.valueOf(this.nextToken());
        Matrix matrix = factory.createMatrix(rows, columns);
        for (int k = 0; k < cardinality; ++k) {
            int i = Integer.valueOf(this.nextToken()) - 1;
            int j = Integer.valueOf(this.nextToken()) - 1;
            double value = Double.valueOf(this.nextToken());
            matrix.set(i, j, value);
        }
        return matrix;
    }

    private String nextToken() throws IOException {
        while (this.tokenizer == null || !this.tokenizer.hasMoreTokens()) {
            String line = this.reader.readLine();
            if (line.charAt(0) == '#') continue;
            this.tokenizer = new StringTokenizer(line);
        }
        return this.tokenizer.nextToken();
    }

    private void ensureNext(String value) throws IOException {
        if (!value.equals(this.nextToken())) {
            throw new IOException();
        }
    }

    private static class SparseMatrixWriteProcedure
    implements MatrixProcedure {
        private BufferedWriter writer;

        public SparseMatrixWriteProcedure(BufferedWriter writer) {
            this.writer = writer;
        }

        @Override
        public void apply(int i, int j, double value) {
            try {
                this.writer.write(i + 1 + " " + (j + 1) + " " + String.format(Locale.US, "%.12f", value));
                this.writer.newLine();
            }
            catch (IOException expected) {
                throw new IllegalArgumentException("Can't write with writer.");
            }
        }
    }

    private static class SparseVectorWriteProcedure
    implements VectorProcedure {
        private BufferedWriter writer;

        public SparseVectorWriteProcedure(BufferedWriter writer) {
            this.writer = writer;
        }

        @Override
        public void apply(int i, double value) {
            try {
                this.writer.write(i + 1 + " " + String.format(Locale.US, "%.12f", value));
                this.writer.newLine();
            }
            catch (IOException expected) {
                throw new IllegalArgumentException("Can't write with writer.");
            }
        }
    }
}

