/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.vector.sparse;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.la4j.vector.AbstractVector;
import org.la4j.vector.Vector;
import org.la4j.vector.Vectors;
import org.la4j.vector.functor.VectorFunction;
import org.la4j.vector.functor.VectorProcedure;
import org.la4j.vector.source.VectorSource;
import org.la4j.vector.sparse.SparseSafeVector;
import org.la4j.vector.sparse.SparseVector;

public class CompressedVector
extends AbstractVector
implements SparseVector {
    private static final long serialVersionUID = 4071505L;
    private static final int MINIMUM_SIZE = 32;
    private double[] values;
    private int[] indices;
    private int cardinality;

    public CompressedVector() {
        this(0);
    }

    public CompressedVector(int length) {
        this(length, 0);
    }

    public CompressedVector(Vector vector) {
        this(Vectors.asUnsafeSource(vector));
    }

    public CompressedVector(double[] array) {
        this(Vectors.asArraySource(array));
    }

    public CompressedVector(VectorSource source) {
        this(source.length(), 0);
        for (int i = 0; i < this.length; ++i) {
            double value = source.get(i);
            if (!(Math.abs(value) > Vectors.EPS)) continue;
            if (this.values.length < this.cardinality + 1) {
                this.growup();
            }
            this.values[this.cardinality] = value;
            this.indices[this.cardinality] = i;
            ++this.cardinality;
        }
    }

    public CompressedVector(int length, int cardinality) {
        this(length, cardinality, new double[CompressedVector.align(length, cardinality)], new int[CompressedVector.align(length, cardinality)]);
    }

    public CompressedVector(int length, int cardinality, double[] values, int[] indices) {
        super(Vectors.COMPRESSED_FACTORY, length);
        this.cardinality = cardinality;
        this.values = values;
        this.indices = indices;
    }

    @Override
    public double get(int i) {
        int k = this.searchForIndex(i, 0, this.cardinality);
        if (k < this.cardinality && this.indices[k] == i) {
            return this.values[k];
        }
        return 0.0;
    }

    @Override
    public void set(int i, double value) {
        int k = this.searchForIndex(i, 0, this.cardinality);
        if (k < this.cardinality && this.indices[k] == i) {
            if (Math.abs(value) > Vectors.EPS) {
                this.values[k] = value;
            } else {
                this.remove(k);
            }
        } else {
            this.insert(k, i, value);
        }
    }

    @Override
    public void swap(int i, int j) {
        if (i == j) {
            return;
        }
        int ii = this.searchForIndex(i, 0, this.cardinality);
        int jj = this.searchForIndex(j, 0, this.cardinality);
        if (ii < this.cardinality && i == this.indices[ii] && jj < this.cardinality && j == this.indices[jj]) {
            double sd = this.values[ii];
            this.values[ii] = this.values[jj];
            this.values[jj] = sd;
        } else {
            boolean p;
            boolean bl = p = ii < this.cardinality && i == this.indices[ii];
            if (p || jj < this.cardinality && j == this.indices[jj]) {
                int max;
                double sd = this.values[p ? ii : jj];
                int min = ii < jj ? ii : jj;
                int n = max = ii < jj ? ii : jj;
                if (p && min == ii || !p && min == jj) {
                    System.arraycopy(this.values, min, this.values, min + 1, this.cardinality - max);
                    System.arraycopy(this.indices, min, this.indices, min + 1, this.cardinality - max);
                    this.values[max] = sd;
                } else {
                    System.arraycopy(this.values, min + 1, this.values, min, this.cardinality - max);
                    System.arraycopy(this.indices, min + 1, this.indices, min, this.cardinality - max);
                    this.values[min] = sd;
                }
                this.indices[max] = p ? j : i;
            }
        }
    }

    @Override
    public int cardinality() {
        return this.cardinality;
    }

    @Override
    public double density() {
        return this.cardinality / this.length;
    }

    @Override
    public Vector copy() {
        return this.resize(this.length);
    }

    @Override
    public Vector resize(int length) {
        this.ensureLengthIsNotNegative(length);
        int $cardinality = 0;
        double[] $values = new double[CompressedVector.align(length, 0)];
        int[] $indices = new int[CompressedVector.align(length, 0)];
        if (length >= this.length) {
            $cardinality = this.cardinality;
            System.arraycopy(this.values, 0, $values, 0, this.cardinality);
            System.arraycopy(this.indices, 0, $indices, 0, this.cardinality);
        } else {
            $cardinality = this.searchForIndex(length, 0, this.cardinality);
            for (int i = 0; i < $cardinality; ++i) {
                $values[i] = this.values[i];
                $indices[i] = this.indices[i];
            }
        }
        return new CompressedVector(length, $cardinality, $values, $indices);
    }

    @Override
    public void each(VectorProcedure procedure) {
        for (int i = 0; i < this.cardinality; ++i) {
            procedure.apply(this.indices[i], this.values[i]);
        }
    }

    @Override
    public void update(int i, VectorFunction function) {
        int k = this.searchForIndex(i, 0, this.cardinality);
        if (k < this.cardinality && this.indices[k] == i) {
            double value = function.evaluate(i, this.values[k]);
            if (Math.abs(value) > Vectors.EPS) {
                this.values[k] = value;
            } else {
                this.remove(k);
            }
        } else {
            this.insert(k, i, function.evaluate(i, 0.0));
        }
    }

    @Override
    public Vector safe() {
        return new SparseSafeVector(this);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.length);
        out.writeInt(this.cardinality);
        for (int i = 0; i < this.cardinality; ++i) {
            out.writeInt(this.indices[i]);
            out.writeDouble(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.length = in.readInt();
        this.cardinality = in.readInt();
        int alignedSize = CompressedVector.align(this.length, this.cardinality);
        this.values = new double[alignedSize];
        this.indices = new int[alignedSize];
        for (int i = 0; i < this.cardinality; ++i) {
            this.indices[i] = in.readInt();
            this.values[i] = in.readDouble();
        }
    }

    private int searchForIndex(int i, int left, int right) {
        if (left == right) {
            return left;
        }
        if (right - left < 8) {
            int ii;
            for (ii = left; ii < right && this.indices[ii] < i; ++ii) {
            }
            return ii;
        }
        int p = (left + right) / 2;
        if (this.indices[p] > i) {
            return this.searchForIndex(i, left, p);
        }
        if (this.indices[p] < i) {
            return this.searchForIndex(i, p + 1, right);
        }
        return p;
    }

    private void insert(int k, int i, double value) {
        if (Math.abs(value) < Vectors.EPS) {
            return;
        }
        if (this.values.length < this.cardinality + 1) {
            this.growup();
        }
        System.arraycopy(this.values, k, this.values, k + 1, this.cardinality - k);
        System.arraycopy(this.indices, k, this.indices, k + 1, this.cardinality - k);
        this.values[k] = value;
        this.indices[k] = i;
        ++this.cardinality;
    }

    private void remove(int k) {
        --this.cardinality;
        System.arraycopy(this.values, k + 1, this.values, k, this.cardinality - k);
        System.arraycopy(this.indices, k + 1, this.indices, k, this.cardinality - k);
    }

    private void growup() {
        if (this.values.length == this.length) {
            throw new IllegalStateException("This vector can't grow up.");
        }
        int capacity = Math.min(this.length, this.cardinality * 3 / 2 + 1);
        double[] $values = new double[capacity];
        int[] $indices = new int[capacity];
        System.arraycopy(this.values, 0, $values, 0, this.cardinality);
        System.arraycopy(this.indices, 0, $indices, 0, this.cardinality);
        this.values = $values;
        this.indices = $indices;
    }

    private static int align(int length, int cardinality) {
        return Math.min(length, (cardinality / 32 + 1) * 32);
    }
}

