/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt;

import com.jogamp.common.util.PropertyAccess;
import com.jogamp.nativewindow.AbstractGraphicsScreen;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.util.Dimension;
import com.jogamp.nativewindow.util.Rectangle;
import com.jogamp.nativewindow.util.RectangleImmutable;
import com.jogamp.newt.Display;
import com.jogamp.newt.MonitorDevice;
import com.jogamp.newt.MonitorMode;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.event.MonitorEvent;
import com.jogamp.newt.event.MonitorModeListener;
import com.jogamp.newt.util.MonitorModeUtil;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jogamp.newt.Debug;
import jogamp.newt.DisplayImpl;
import jogamp.newt.MonitorDeviceImpl;
import jogamp.newt.MonitorModeProps;
import jogamp.newt.ScreenMonitorState;

public abstract class ScreenImpl
extends Screen
implements MonitorModeListener {
    protected static final boolean DEBUG_TEST_SCREENMODE_DISABLED;
    public static final int default_sm_bpp = 32;
    public static final int default_sm_widthmm = 519;
    public static final int default_sm_heightmm = 324;
    public static final int default_sm_rate = 60;
    public static final int default_sm_rotation = 0;
    protected DisplayImpl display;
    protected int screen_idx;
    protected String fqname;
    protected int hashCode;
    protected AbstractGraphicsScreen aScreen;
    protected int refCount;
    protected Rectangle virtViewportPU = new Rectangle(0, 0, 0, 0);
    protected Rectangle virtViewportWU = new Rectangle(0, 0, 0, 0);
    protected static Dimension usrSize;
    protected static volatile boolean usrSizeQueried;
    private final ArrayList<MonitorModeListener> refMonitorModeListener = new ArrayList();
    private long tCreated;

    static void initSingleton() {
    }

    private static Class<?> getScreenClass(String string) throws ClassNotFoundException {
        return NewtFactory.getCustomClass(string, "ScreenDriver");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Screen create(Display display, int n) {
        try {
            Object object;
            if (!usrSizeQueried) {
                object = Screen.class;
                // MONITORENTER : com.jogamp.newt.Screen.class
                if (!usrSizeQueried) {
                    usrSizeQueried = true;
                    int n2 = PropertyAccess.getIntProperty((String)"newt.ws.swidth", (boolean)true, (int)0);
                    int n3 = PropertyAccess.getIntProperty((String)"newt.ws.sheight", (boolean)true, (int)0);
                    if (n2 > 0 && n3 > 0) {
                        usrSize = new Dimension(n2, n3);
                        System.err.println("User screen size " + usrSize);
                    }
                }
                // MONITOREXIT : object
            }
            object = screenList;
            // MONITORENTER : object
            Class<?> clazz = ScreenImpl.getScreenClass(display.getType());
            ScreenImpl screenImpl = (ScreenImpl)clazz.newInstance();
            screenImpl.display = (DisplayImpl)display;
            n = screenImpl.validateScreenIndex(n);
            Screen screen = Screen.getLastScreenOf(display, n, -1);
            if (null != screen) {
                if (DEBUG) {
                    System.err.println("Screen.create() REUSE: " + screen + " " + Display.getThreadName());
                }
                screenImpl = null;
                // MONITOREXIT : object
                return screen;
            }
            screenImpl.screen_idx = n;
            screenImpl.fqname = display.getFQName() + "-s" + n;
            screenImpl.hashCode = screenImpl.fqname.hashCode();
            screenImpl.instantiationFinished();
            Screen.addScreen2List(screenImpl);
            if (DEBUG) {
                System.err.println("Screen.create() NEW: " + screenImpl + " " + Display.getThreadName());
            }
            // MONITOREXIT : object
            return screenImpl;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    protected void instantiationFinished() {
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ScreenImpl screenImpl = (ScreenImpl)object;
        if (!(this.display == screenImpl.display || this.display != null && this.display.equals(screenImpl.display))) {
            return false;
        }
        return this.screen_idx == screenImpl.screen_idx;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized void createNative() throws NativeWindowException {
        if (null == this.aScreen) {
            if (DEBUG) {
                this.tCreated = System.nanoTime();
                System.err.println("Screen.createNative() START (" + Display.getThreadName() + ", " + this + ")");
            } else {
                this.tCreated = 0L;
            }
            this.display.addReference();
            this.createNativeImpl();
            if (null == this.aScreen) {
                throw new NativeWindowException("Screen.createNative() failed to instanciate an AbstractGraphicsScreen");
            }
            this.initMonitorState();
            ArrayList arrayList = screenList;
            synchronized (arrayList) {
                ++screensActive;
                if (DEBUG) {
                    System.err.println("Screen.createNative() END (" + Display.getThreadName() + ", " + this + "), active " + screensActive + ", total " + (double)(System.nanoTime() - this.tCreated) / 1000000.0 + "ms");
                }
            }
            ScreenMonitorState.getScreenMonitorState(this.getFQName()).addListener(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized void destroy() {
        ArrayList arrayList = screenList;
        synchronized (arrayList) {
            if (0 < screensActive) {
                --screensActive;
            }
            if (DEBUG) {
                System.err.println("Screen.destroy() (" + Display.getThreadName() + "): active " + screensActive);
            }
        }
        if (null != this.aScreen) {
            this.releaseMonitorState();
            this.closeNativeImpl();
            this.aScreen = null;
        }
        this.refCount = 0;
        this.display.removeReference();
    }

    @Override
    public final synchronized int addReference() throws NativeWindowException {
        if (DEBUG) {
            System.err.println("Screen.addReference() (" + Display.getThreadName() + "): " + this.refCount + " -> " + (this.refCount + 1));
        }
        if (0 == this.refCount) {
            this.createNative();
        } else if (null == this.aScreen) {
            throw new NativeWindowException("Screen.addReference() (refCount " + this.refCount + ") null AbstractGraphicsScreen");
        }
        return ++this.refCount;
    }

    @Override
    public final synchronized int removeReference() {
        if (DEBUG) {
            System.err.println("Screen.removeReference() (" + Display.getThreadName() + "): " + this.refCount + " -> " + (this.refCount - 1));
        }
        --this.refCount;
        if (0 >= this.refCount) {
            this.destroy();
            this.refCount = 0;
        }
        return this.refCount;
    }

    @Override
    public final synchronized int getReferenceCount() {
        return this.refCount;
    }

    protected abstract void createNativeImpl();

    protected abstract void closeNativeImpl();

    protected abstract int validateScreenIndex(int var1);

    protected void calcVirtualScreenOriginAndSize(Rectangle rectangle, Rectangle rectangle2) {
        this.unionOfMonitorViewports(rectangle, rectangle2);
    }

    @Override
    public final String getFQName() {
        return this.fqname;
    }

    protected void updateVirtualScreenOriginAndSize() {
        if (null != usrSize) {
            this.virtViewportPU.set(0, 0, usrSize.getWidth(), usrSize.getHeight());
            this.virtViewportWU.set(0, 0, usrSize.getWidth(), usrSize.getHeight());
            if (DEBUG) {
                System.err.println("Update user virtual screen viewport @ " + Thread.currentThread().getName() + ": " + this.virtViewportPU);
            }
        } else {
            this.calcVirtualScreenOriginAndSize(this.virtViewportPU, this.virtViewportWU);
            if (DEBUG) {
                System.err.println("Updated virtual screen viewport @ " + Thread.currentThread().getName() + ": " + this.virtViewportPU + " [pixel], " + this.virtViewportWU + " [window]");
            }
        }
    }

    @Override
    public final Display getDisplay() {
        return this.display;
    }

    @Override
    public final int getIndex() {
        return this.screen_idx;
    }

    @Override
    public final AbstractGraphicsScreen getGraphicsScreen() {
        return this.aScreen;
    }

    @Override
    public final synchronized boolean isNativeValid() {
        return null != this.aScreen;
    }

    @Override
    public final int getX() {
        return this.virtViewportPU.getX();
    }

    @Override
    public final int getY() {
        return this.virtViewportPU.getY();
    }

    @Override
    public final int getWidth() {
        return this.virtViewportPU.getWidth();
    }

    @Override
    public final int getHeight() {
        return this.virtViewportPU.getHeight();
    }

    @Override
    public final RectangleImmutable getViewport() {
        return this.virtViewportPU;
    }

    @Override
    public final RectangleImmutable getViewportInWindowUnits() {
        return this.virtViewportWU;
    }

    public String toString() {
        return "NEWT-Screen[" + this.getFQName() + ", idx " + this.screen_idx + ", refCount " + this.refCount + ", vsize " + this.virtViewportPU + " [pixels], " + this.virtViewportWU + " [window], " + this.aScreen + ", " + this.display + ", monitors: " + this.getMonitorDevices() + "]";
    }

    protected abstract void collectNativeMonitorModesAndDevicesImpl(MonitorModeProps.Cache var1);

    protected boolean updateNativeMonitorDeviceViewportImpl(MonitorDevice monitorDevice, float[] fArray, Rectangle rectangle, Rectangle rectangle2) {
        return false;
    }

    protected abstract MonitorMode queryCurrentMonitorModeImpl(MonitorDevice var1);

    protected abstract boolean setCurrentMonitorModeImpl(MonitorDevice var1, MonitorMode var2);

    @Override
    public final List<MonitorMode> getMonitorModes() {
        ScreenMonitorState screenMonitorState = this.getScreenMonitorStatus(false);
        return null != screenMonitorState ? screenMonitorState.getMonitorModes().getData() : null;
    }

    @Override
    public final List<MonitorDevice> getMonitorDevices() {
        ScreenMonitorState screenMonitorState = this.getScreenMonitorStatus(false);
        return null != screenMonitorState ? screenMonitorState.getMonitorDevices().getData() : null;
    }

    @Override
    public MonitorDevice getPrimaryMonitor() {
        ScreenMonitorState screenMonitorState = this.getScreenMonitorStatus(false);
        return null != screenMonitorState ? screenMonitorState.getPrimaryMonitorDevice() : null;
    }

    final ScreenMonitorState getScreenMonitorStatus(boolean bl) {
        String string = this.getFQName();
        ScreenMonitorState screenMonitorState = ScreenMonitorState.getScreenMonitorState(string);
        if (null == screenMonitorState & bl) {
            throw new InternalError("ScreenMonitorStatus.getMonitorModeStatus(" + string + ") == null");
        }
        return screenMonitorState;
    }

    @Override
    public void monitorModeChangeNotify(MonitorEvent monitorEvent) {
        if (DEBUG) {
            System.err.println("monitorModeChangeNotify @ " + Thread.currentThread().getName() + ": " + monitorEvent);
        }
        for (int i = 0; i < this.refMonitorModeListener.size(); ++i) {
            this.refMonitorModeListener.get(i).monitorModeChangeNotify(monitorEvent);
        }
    }

    private void updateNativeMonitorDevicesViewport() {
        List<MonitorDevice> list = this.getMonitorDevices();
        for (int i = list.size() - 1; i >= 0; --i) {
            MonitorDeviceImpl monitorDeviceImpl = (MonitorDeviceImpl)list.get(i);
            float[] fArray = monitorDeviceImpl.getPixelScale(new float[2]);
            boolean bl = this.updateNativeMonitorDeviceViewportImpl(monitorDeviceImpl, fArray, monitorDeviceImpl.getMutuableViewportPU(), monitorDeviceImpl.getMutuableViewportWU());
            if (!DEBUG) continue;
            System.err.println("Screen.updateMonitorViewport[" + Display.toHexString(monitorDeviceImpl.getId()) + "] @  " + Thread.currentThread().getName() + ": updated: " + bl + ", PU " + monitorDeviceImpl.getViewport() + ", WU " + monitorDeviceImpl.getViewportInWindowUnits() + ", pixelScale [" + fArray[0] + ", " + fArray[1] + "]");
        }
    }

    @Override
    public void monitorModeChanged(MonitorEvent monitorEvent, boolean bl) {
        if (bl) {
            this.updateNativeMonitorDevicesViewport();
            this.updateVirtualScreenOriginAndSize();
        }
        if (DEBUG) {
            System.err.println("monitorModeChangeNotify @ " + Thread.currentThread().getName() + ": success " + bl + ", " + monitorEvent);
        }
        for (int i = 0; i < this.refMonitorModeListener.size(); ++i) {
            this.refMonitorModeListener.get(i).monitorModeChanged(monitorEvent, bl);
        }
    }

    @Override
    public final synchronized void addMonitorModeListener(MonitorModeListener monitorModeListener) {
        this.refMonitorModeListener.add(monitorModeListener);
    }

    @Override
    public final synchronized void removeMonitorModeListener(MonitorModeListener monitorModeListener) {
        this.refMonitorModeListener.remove(monitorModeListener);
    }

    private final MonitorMode getVirtualMonitorMode(MonitorModeProps.Cache cache, int n) {
        int[] nArray = new int[8];
        int n2 = 0;
        nArray[n2++] = 8;
        nArray[n2++] = this.getWidth();
        nArray[n2++] = this.getHeight();
        nArray[n2++] = 32;
        nArray[n2++] = 6000;
        nArray[n2++] = 0;
        nArray[n2++] = n;
        nArray[n2++] = 0;
        if (8 != n2) {
            throw new InternalError("XX");
        }
        return MonitorModeProps.streamInMonitorMode(null, cache, nArray, 0);
    }

    private final MonitorDevice getVirtualMonitorDevice(MonitorModeProps.Cache cache, int n, MonitorMode monitorMode) {
        int[] nArray = new int[17];
        int n2 = 0;
        nArray[n2++] = 17;
        nArray[n2++] = n;
        nArray[n2++] = 0;
        nArray[n2++] = 0 == n ? 1 : 0;
        nArray[n2++] = 519;
        nArray[n2++] = 324;
        nArray[n2++] = 0;
        nArray[n2++] = 0;
        nArray[n2++] = monitorMode.getRotatedWidth();
        nArray[n2++] = monitorMode.getRotatedHeight();
        nArray[n2++] = 0;
        nArray[n2++] = 0;
        nArray[n2++] = monitorMode.getRotatedWidth();
        nArray[n2++] = monitorMode.getRotatedHeight();
        nArray[n2++] = monitorMode.getId();
        nArray[n2++] = monitorMode.getRotation();
        nArray[n2++] = monitorMode.getId();
        if (17 != n2) {
            throw new InternalError("XX");
        }
        return MonitorModeProps.streamInMonitorDevice(cache, this, null, nArray, 0, null);
    }

    protected final MonitorMode queryCurrentMonitorModeIntern(MonitorDevice monitorDevice) {
        MonitorMode monitorMode = DEBUG_TEST_SCREENMODE_DISABLED ? null : this.queryCurrentMonitorModeImpl(monitorDevice);
        if (null == monitorMode) {
            if (0 >= this.getWidth() || 0 >= this.getHeight()) {
                this.updateVirtualScreenOriginAndSize();
            }
            monitorMode = this.getVirtualMonitorMode(null, monitorDevice.getCurrentMode().getId());
        }
        return monitorMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ScreenMonitorState initMonitorState() {
        ScreenMonitorState screenMonitorState;
        long l;
        if (DEBUG) {
            l = System.nanoTime();
            System.err.println("Screen.initMonitorState() START (" + Display.getThreadName() + ", " + this + ")");
        } else {
            l = 0L;
        }
        boolean bl = false;
        ScreenMonitorState.lockScreenMonitorState();
        try {
            screenMonitorState = ScreenMonitorState.getScreenMonitorState(this.getFQName());
            if (null == screenMonitorState) {
                Object object;
                Object object2;
                MonitorModeProps.Cache cache = new MonitorModeProps.Cache();
                if (0 >= this.collectNativeMonitorModes(cache)) {
                    this.updateVirtualScreenOriginAndSize();
                    bl = true;
                    object2 = this.getVirtualMonitorMode(cache, 0);
                    cache.monitorModes.getOrAdd(object2);
                    object = this.getVirtualMonitorDevice(cache, 0, (MonitorMode)object2);
                    ((MonitorDeviceImpl)object).setIsPrimary(true);
                    cache.monitorDevices.getOrAdd(object);
                    cache.setPrimary((MonitorDevice)object);
                }
                if (null == cache.getPrimary()) {
                    object2 = (MonitorDevice)cache.monitorDevices.get(0);
                    ((MonitorDeviceImpl)object2).setIsPrimary(true);
                    cache.setPrimary((MonitorDevice)object2);
                    if (DEBUG) {
                        System.err.println("WARNING: Fallback primary: " + object2);
                    }
                }
                MonitorModeUtil.sort(cache.monitorModes.getData(), false);
                object2 = cache.monitorDevices.iterator();
                while (object2.hasNext()) {
                    MonitorModeUtil.sort(((MonitorDevice)object2.next()).getSupportedModes(), false);
                }
                if (DEBUG) {
                    int n = 0;
                    object = cache.monitorModes.iterator();
                    while (object.hasNext()) {
                        System.err.println("All[" + n + "]: " + object.next());
                        ++n;
                    }
                    n = 0;
                    for (MonitorDevice monitorDevice : cache.monitorDevices) {
                        System.err.println("[" + n + "]: " + monitorDevice);
                        int n2 = 0;
                        Iterator<MonitorMode> iterator = monitorDevice.getSupportedModes().iterator();
                        while (iterator.hasNext()) {
                            System.err.println("[" + n + "][" + n2 + "]: " + iterator.next());
                            ++n2;
                        }
                        ++n;
                    }
                    System.err.println("Primary: " + cache.getPrimary());
                }
                screenMonitorState = new ScreenMonitorState(cache.monitorDevices, cache.monitorModes, cache.getPrimary());
                ScreenMonitorState.mapScreenMonitorState(this.getFQName(), screenMonitorState);
            }
        }
        finally {
            ScreenMonitorState.unlockScreenMonitorState();
        }
        if (DEBUG) {
            System.err.println("Screen.initMonitorState() END dt " + (double)(System.nanoTime() - l) / 1000000.0 + "ms");
        }
        if (!bl) {
            this.updateVirtualScreenOriginAndSize();
        }
        return screenMonitorState;
    }

    private final int collectNativeMonitorModes(MonitorModeProps.Cache cache) {
        if (!DEBUG_TEST_SCREENMODE_DISABLED) {
            this.collectNativeMonitorModesAndDevicesImpl(cache);
            MonitorModeProps.identifyMonitorDevices(cache);
        }
        for (int i = cache.monitorModes.size() - 1; i >= 0; --i) {
            MonitorDevice monitorDevice;
            int n;
            MonitorMode monitorMode = (MonitorMode)cache.monitorModes.get(i);
            if (16 <= monitorMode.getSurfaceSize().getBitsPerPixel()) continue;
            boolean bl = false;
            for (n = cache.monitorDevices.size() - 1; !bl && n >= 0; --n) {
                monitorDevice = (MonitorDevice)cache.monitorDevices.get(n);
                bl = monitorDevice.getCurrentMode().equals(monitorMode);
            }
            if (bl) continue;
            cache.monitorModes.remove(i);
            for (n = cache.monitorDevices.size() - 1; n >= 0; --n) {
                monitorDevice = (MonitorDeviceImpl)cache.monitorDevices.get(n);
                ((MonitorDeviceImpl)monitorDevice).getSupportedModesImpl().remove((Object)monitorMode);
            }
        }
        if (DEBUG) {
            System.err.println("ScreenImpl.collectNativeMonitorModes: MonitorDevice number : " + cache.monitorDevices.size());
            System.err.println("ScreenImpl.collectNativeMonitorModes: MonitorMode number   : " + cache.monitorModes.size());
            System.err.println("ScreenImpl.collectNativeMonitorModes: SizeAndRate number   : " + cache.sizeAndRates.size());
            System.err.println("ScreenImpl.collectNativeMonitorModes: SurfaceSize number   : " + cache.surfaceSizes.size());
            System.err.println("ScreenImpl.collectNativeMonitorModes: Resolution number    : " + cache.resolutions.size());
        }
        return cache.monitorDevices.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void releaseMonitorState() {
        block10: {
            ScreenMonitorState.lockScreenMonitorState();
            try {
                ScreenMonitorState screenMonitorState = ScreenMonitorState.getScreenMonitorState(this.getFQName());
                if (null == screenMonitorState) break block10;
                screenMonitorState.lock();
                try {
                    if (0 == screenMonitorState.removeListener(this)) {
                        ArrayList arrayList = screenMonitorState.getMonitorDevices().getData();
                        for (int i = 0; i < arrayList.size(); ++i) {
                            MonitorDevice monitorDevice = (MonitorDevice)arrayList.get(i);
                            if (!monitorDevice.isModeChangedByUs()) continue;
                            System.err.println("Screen.destroy(): Reset " + monitorDevice);
                            try {
                                monitorDevice.setCurrentMode(monitorDevice.getOriginalMode());
                                continue;
                            }
                            catch (Throwable throwable) {
                                throwable.printStackTrace();
                            }
                        }
                        ScreenMonitorState.unmapScreenMonitorState(this.getFQName());
                    }
                }
                finally {
                    screenMonitorState.unlock();
                }
            }
            finally {
                ScreenMonitorState.unlockScreenMonitorState();
            }
        }
    }

    private final void shutdown() {
        ScreenMonitorState screenMonitorState = ScreenMonitorState.getScreenMonitorStateUnlocked(this.getFQName());
        if (null != screenMonitorState) {
            ArrayList arrayList = screenMonitorState.getMonitorDevices().getData();
            for (int i = 0; i < arrayList.size(); ++i) {
                MonitorDevice monitorDevice = (MonitorDevice)arrayList.get(i);
                if (!monitorDevice.isModeChangedByUs()) continue;
                System.err.println("Screen.shutdown(): Reset " + monitorDevice);
                try {
                    monitorDevice.setCurrentMode(monitorDevice.getOriginalMode());
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            ScreenMonitorState.unmapScreenMonitorStateUnlocked(this.getFQName());
        }
    }

    static final void shutdownAll() {
        int n = screenList.size();
        if (DEBUG) {
            System.err.println("Screen.shutdownAll " + n + " instances, on thread " + Display.getThreadName());
        }
        for (int i = 0; i < n && screenList.size() > 0; ++i) {
            ScreenImpl screenImpl = (ScreenImpl)((WeakReference)screenList.remove(0)).get();
            if (DEBUG) {
                System.err.println("Screen.shutdownAll[" + (i + 1) + "/" + n + "]: " + screenImpl + ", GCed " + (null == screenImpl));
            }
            if (null == screenImpl) continue;
            screenImpl.shutdown();
        }
    }

    static {
        Debug.initSingleton();
        DEBUG_TEST_SCREENMODE_DISABLED = PropertyAccess.isPropertyDefined((String)"newt.test.Screen.disableScreenMode", (boolean)true);
        DisplayImpl.initSingleton();
        usrSize = null;
        usrSizeQueried = false;
    }
}

