/*
 * Decompiled with CFR 0.152.
 */
package org.ngs.ngunits.converter;

import org.ngs.ngunits.UnitConverter;
import org.ngs.ngunits.converter.AbstractUnitConverter;
import org.ngs.ngunits.converter.RationalConverter;

public final class MultiplyConverter
extends AbstractUnitConverter {
    private final double _factor;

    public MultiplyConverter(double d) {
        if ((double)((float)d) == 1.0) {
            throw new IllegalArgumentException("Identity converter not allowed");
        }
        this._factor = d;
    }

    public double getFactor() {
        return this._factor;
    }

    public UnitConverter concatenate(UnitConverter unitConverter) {
        if (unitConverter instanceof MultiplyConverter) {
            double d = this._factor * ((MultiplyConverter)unitConverter)._factor;
            if ((float)d == 1.0f) {
                return IDENTITY;
            }
            return new MultiplyConverter(d);
        }
        if (unitConverter instanceof RationalConverter) {
            double d = this._factor * (double)((RationalConverter)unitConverter).getDividend() / (double)((RationalConverter)unitConverter).getDivisor();
            if ((float)d == 1.0f) {
                return IDENTITY;
            }
            return new MultiplyConverter(d);
        }
        return super.concatenate(unitConverter);
    }

    public double convert(double d) {
        return d * this._factor;
    }

    public UnitConverter inverse() {
        return new MultiplyConverter(1.0 / this._factor);
    }
}

