/*
 * Decompiled with CFR 0.152.
 */
package view25d.prims;

import org.nlogo.api.Argument;
import org.nlogo.api.Command;
import org.nlogo.api.Context;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.LogoException;
import org.nlogo.core.Syntax;
import org.nlogo.core.SyntaxJ;
import view25d.View25DExtension;
import view25d.view.MouseableGLWindow;
import view25d.view.VarviewWindow;

public class SetObserverDistance
implements Command {
    public final double MIN_DISTANCE = 1.0;
    public final double MAX_DISTANCE = 130.0;

    public Syntax getSyntax() {
        int[] argTypes = new int[]{Syntax.StringType(), Syntax.NumberType()};
        return SyntaxJ.commandSyntax((int[])argTypes, (String)"O---");
    }

    public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
        MouseableGLWindow win;
        String whichView = args[0].getString();
        double newDistance = args[1].getDoubleValue();
        if (newDistance < 1.0) {
            throw new ExtensionException("Cannot set observer distance below 1.0");
        }
        VarviewWindow vvwp = View25DExtension.patchWindowMap.get(whichView);
        VarviewWindow vvwt = View25DExtension.turtleWindowMap.get(whichView);
        if (vvwp != null) {
            win = vvwp.getGLWindow();
            win.zoomToDistance(newDistance);
        }
        if (vvwt != null) {
            win = vvwt.getGLWindow();
            win.zoomToDistance(newDistance);
        }
    }
}

