/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.colour;

import java.awt.Color;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.openimaj.image.colour.ColourMap;

public class RGBColour {
    public static final Float[] WHITE = new Float[]{Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f)};
    public static final Float[] LIGHT_GRAY = new Float[]{Float.valueOf(0.75f), Float.valueOf(0.75f), Float.valueOf(0.75f)};
    public static final Float[] GRAY = new Float[]{Float.valueOf(0.5f), Float.valueOf(0.5f), Float.valueOf(0.5f)};
    public static final Float[] DARK_GRAY = new Float[]{Float.valueOf(0.25f), Float.valueOf(0.25f), Float.valueOf(0.25f)};
    public static final Float[] BLACK = new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)};
    public static final Float[] RED = new Float[]{Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)};
    public static final Float[] PINK = new Float[]{Float.valueOf(1.0f), Float.valueOf(0.68359375f), Float.valueOf(0.68359375f)};
    public static final Float[] ORANGE = new Float[]{Float.valueOf(1.0f), Float.valueOf(0.78125f), Float.valueOf(0.0f)};
    public static final Float[] YELLOW = new Float[]{Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(0.0f)};
    public static final Float[] GREEN = new Float[]{Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.0f)};
    public static final Float[] MAGENTA = new Float[]{Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(1.0f)};
    public static final Float[] CYAN = new Float[]{Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(1.0f)};
    public static final Float[] BLUE = new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f)};

    private RGBColour() {
    }

    public static Float[] fromColor(Color c) {
        Float r = Float.valueOf((float)c.getRed() / 255.0f);
        Float g = Float.valueOf((float)c.getRed() / 255.0f);
        Float b = Float.valueOf((float)c.getRed() / 255.0f);
        return new Float[]{r, g, b};
    }

    public static Float[] fromString(String s) {
        try {
            if (s.contains(",")) {
                String[] parts = s.split(",");
                Float[] col = new Float[3];
                for (int i = 0; i < 3; ++i) {
                    col[i] = Float.valueOf(Float.parseFloat(parts[i].trim()));
                }
                return col;
            }
            Field f = RGBColour.class.getField(s.toUpperCase());
            return (Float[])f.get(null);
        }
        catch (Exception e) {
            return BLACK;
        }
    }

    public static Float[] randomColour() {
        Float[] c = new Float[]{Float.valueOf((float)Math.random()), Float.valueOf((float)Math.random()), Float.valueOf((float)Math.random())};
        return c;
    }

    public static List<Float[]> randomColours(int n) {
        ArrayList<Float[]> colours = new ArrayList<Float[]>();
        for (int i = 0; i < n; ++i) {
            colours.add(RGBColour.randomColour());
        }
        return colours;
    }

    public static Float[][] coloursFromMap(ColourMap cm, int n) {
        Float[][] cols = new Float[n][];
        for (int i = 0; i < n; ++i) {
            float frac = (float)i / (float)n;
            cols[i] = cm.apply(frac);
        }
        return cols;
    }

    public static Float[] RGB(int r, int g, int b) {
        return new Float[]{Float.valueOf((float)r / 255.0f), Float.valueOf((float)g / 255.0f), Float.valueOf((float)b / 255.0f)};
    }

    public static Float[] RGB(float r, float g, float b) {
        return new Float[]{Float.valueOf(r), Float.valueOf(g), Float.valueOf(b)};
    }
}

