/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.data;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.Random;
import org.openimaj.data.DataSource;
import org.openimaj.data.RandomData;
import org.openimaj.util.array.ArrayIterator;

public abstract class ArrayBackedDataSource<T>
implements DataSource<T> {
    protected T[] data;
    protected Random rng;

    public ArrayBackedDataSource(T[] data) {
        this.data = data;
        this.rng = new Random();
    }

    public ArrayBackedDataSource(T[] data, Random rng) {
        this.data = data;
        this.rng = rng;
    }

    @Override
    public final void getData(int startRow, int stopRow, T[] output) {
        int i = startRow;
        int j = 0;
        while (i < stopRow) {
            output[j] = this.data[i];
            ++i;
            ++j;
        }
    }

    @Override
    public final void getRandomRows(T[] output) {
        int k = output.length;
        int[] ind = RandomData.getUniqueRandomInts(k, 0, this.data.length, this.rng);
        for (int i = 0; i < k; ++i) {
            output[i] = this.data[ind[i]];
        }
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public T getData(int row) {
        return this.data[row];
    }

    @Override
    public Iterator<T> iterator() {
        return new ArrayIterator<T>(this.data);
    }

    @Override
    public T[] createTemporaryArray(int size) {
        return (Object[])Array.newInstance(this.data.getClass().getComponentType(), size);
    }
}

