/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.pair;

import java.util.ArrayList;
import java.util.List;
import org.openimaj.util.function.Function;

public class IndependentPair<A, B> {
    A o1;
    B o2;

    public IndependentPair(A obj1, B obj2) {
        this.o1 = obj1;
        this.o2 = obj2;
    }

    public A firstObject() {
        return this.o1;
    }

    public B secondObject() {
        return this.o2;
    }

    public A getFirstObject() {
        return this.o1;
    }

    public B getSecondObject() {
        return this.o2;
    }

    public void setFirstObject(A obj) {
        this.o1 = obj;
    }

    public void setSecondObject(B obj) {
        this.o2 = obj;
    }

    public String toString() {
        return "[" + this.o1 + "," + this.o2 + "]";
    }

    public boolean equals(Object thatObject) {
        if (!(thatObject instanceof IndependentPair)) {
            return false;
        }
        IndependentPair that = (IndependentPair)thatObject;
        return this.o1 == that.o1 && this.o2 == that.o2;
    }

    public static <T, Q> IndependentPair<T, Q> pair(T t, Q q) {
        return new IndependentPair<T, Q>(t, q);
    }

    public static <T, Q> List<T> getFirst(Iterable<? extends IndependentPair<T, Q>> data) {
        ArrayList extracted = new ArrayList();
        for (IndependentPair<T, Q> item : data) {
            extracted.add(item.o1);
        }
        return extracted;
    }

    public static <T, Q> List<Q> getSecond(Iterable<? extends IndependentPair<T, Q>> data) {
        ArrayList extracted = new ArrayList();
        for (IndependentPair<T, Q> item : data) {
            extracted.add(item.o2);
        }
        return extracted;
    }

    public static <T, Q> Function<IndependentPair<T, Q>, T> getFirstFunction() {
        return new Function<IndependentPair<T, Q>, T>(){

            @Override
            public T apply(IndependentPair<T, Q> in) {
                return in.o1;
            }
        };
    }

    public static <T, Q> Function<IndependentPair<T, Q>, Q> getSecondFunction() {
        return new Function<IndependentPair<T, Q>, Q>(){

            @Override
            public Q apply(IndependentPair<T, Q> in) {
                return in.o2;
            }
        };
    }

    public static <T, Q> List<IndependentPair<T, Q>> pairList(List<T> t, List<Q> q) {
        ArrayList<IndependentPair<T, Q>> list = new ArrayList<IndependentPair<T, Q>>(t.size());
        for (int i = 0; i < t.size(); ++i) {
            list.add(new IndependentPair<T, Q>(t.get(i), q.get(i)));
        }
        return list;
    }

    public IndependentPair<B, A> swap() {
        return new IndependentPair<B, A>(this.o2, this.o1);
    }

    public static <T, Q> List<IndependentPair<? extends Q, ? extends T>> swapList(List<? extends IndependentPair<? extends T, ? extends Q>> data) {
        ArrayList<IndependentPair<Q, T>> list = new ArrayList<IndependentPair<Q, T>>(data.size());
        for (int i = 0; i < data.size(); ++i) {
            list.add(data.get(i).swap());
        }
        return list;
    }
}

