/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.stream.window;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.openimaj.util.pair.IndependentPair;
import org.openimaj.util.parallel.GlobalExecutorPool;
import org.openimaj.util.stream.AbstractStream;
import org.openimaj.util.stream.Stream;
import org.openimaj.util.stream.window.MetaPayload;

public class MetaPayloadStreamCombiner<AP, AM, BP, BM>
extends AbstractStream<MetaPayload<IndependentPair<AP, BP>, IndependentPair<AM, BM>>> {
    private Stream<? extends MetaPayload<BP, BM>> b;
    private Stream<? extends MetaPayload<AP, AM>> a;
    private Starter<MetaPayload<AP, AM>> astart;
    private Starter<MetaPayload<BP, BM>> bstart;
    private ThreadPoolExecutor service;

    public <A extends MetaPayload<AP, AM>> MetaPayloadStreamCombiner(Stream<A> a, Stream<? extends MetaPayload<BP, BM>> b) {
        this.a = a;
        this.b = b;
        this.astart = new Starter<MetaPayload<AP, AM>>(this.a);
        this.bstart = new Starter<MetaPayload<BP, BM>>(this.b);
        this.service = GlobalExecutorPool.getPool();
    }

    @Override
    public boolean hasNext() {
        return this.a.hasNext() && this.b.hasNext();
    }

    @Override
    public MetaPayload<IndependentPair<AP, BP>, IndependentPair<AM, BM>> next() {
        Future<MetaPayload<AP, AM>> futurea = this.service.submit(this.astart);
        Future<MetaPayload<BP, BM>> futureb = this.service.submit(this.bstart);
        try {
            MetaPayload<AP, AM> ai = futurea.get();
            MetaPayload<BP, BM> bi = futureb.get();
            IndependentPair<AP, BP> payloads = IndependentPair.pair(ai.getPayload(), bi.getPayload());
            IndependentPair<AM, BM> metas = IndependentPair.pair(ai.getMeta(), bi.getMeta());
            return new MetaPayload<IndependentPair<AP, BP>, IndependentPair<AM, BM>>(payloads, metas);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <AP, AM, BP, BM> MetaPayloadStreamCombiner<AP, AM, BP, BM> combine(Stream<? extends MetaPayload<AP, AM>> a, Stream<? extends MetaPayload<BP, BM>> b) {
        return new MetaPayloadStreamCombiner<AP, AM, BP, BM>(a, b);
    }

    class Starter<T>
    implements Callable<T> {
        private Stream<? extends T> stream;

        public Starter(Stream<? extends T> a) {
            this.stream = a;
        }

        @Override
        public T call() throws Exception {
            return (T)this.stream.next();
        }
    }
}

