/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.sun.media.rtp.SSRCCache;
import javax.media.Format;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;

public class FormatInfo {
    private SSRCCache cache = null;
    public static final int PAYLOAD_NOTFOUND = -1;
    Format[] formatList = new Format[64];
    static AudioFormat mpegAudio = new AudioFormat("mpegaudio/rtp");

    public FormatInfo() {
        this.initFormats();
    }

    public void setCache(SSRCCache cache) {
        this.cache = cache;
    }

    public void add(int payload, Format fmt) {
        Format located;
        if (payload >= this.formatList.length) {
            this.expandTable(payload);
        }
        if ((located = this.formatList[payload]) != null) {
            return;
        }
        this.formatList[payload] = fmt;
        if (this.cache != null && fmt instanceof VideoFormat) {
            this.cache.clockrate[payload] = 90000;
        }
        if (this.cache != null && fmt instanceof AudioFormat) {
            this.cache.clockrate[payload] = mpegAudio.matches(fmt) ? 90000 : (int)((AudioFormat)fmt).getSampleRate();
        }
    }

    private void expandTable(int num) {
        Format[] newList = new Format[num + 1];
        int i2 = 0;
        while (i2 < this.formatList.length) {
            newList[i2] = this.formatList[i2];
            ++i2;
        }
        this.formatList = newList;
    }

    public Format get(int payload) {
        return payload >= this.formatList.length ? null : this.formatList[payload];
    }

    public int getPayload(Format fmt) {
        if (fmt.getEncoding() != null && fmt.getEncoding().equals("g729a/rtp")) {
            fmt = new AudioFormat("g729/rtp");
        }
        int i2 = 0;
        while (i2 < this.formatList.length) {
            if (fmt.matches(this.formatList[i2])) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    public void initFormats() {
        this.formatList[0] = new AudioFormat("ULAW/rtp", 8000.0, 8, 1);
        this.formatList[3] = new AudioFormat("gsm/rtp", 8000.0, -1, 1);
        this.formatList[4] = new AudioFormat("g723/rtp", 8000.0, -1, 1);
        this.formatList[5] = new AudioFormat("dvi/rtp", 8000.0, 4, 1);
        this.formatList[14] = new AudioFormat("mpegaudio/rtp", -1.0, -1, -1);
        this.formatList[15] = new AudioFormat("g728/rtp", 8000.0, -1, 1);
        this.formatList[16] = new AudioFormat("dvi/rtp", 11025.0, 4, 1);
        this.formatList[17] = new AudioFormat("dvi/rtp", 22050.0, 4, 1);
        this.formatList[18] = new AudioFormat("g729/rtp", 8000.0, -1, 1);
        this.formatList[26] = new VideoFormat("jpeg/rtp");
        this.formatList[31] = new VideoFormat("h261/rtp");
        this.formatList[32] = new VideoFormat("mpeg/rtp");
        this.formatList[34] = new VideoFormat("h263/rtp");
        this.formatList[42] = new VideoFormat("h263-1998/rtp");
    }

    public static boolean isSupported(int payload) {
        switch (payload) {
            case 0: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 26: 
            case 31: 
            case 32: 
            case 34: {
                return true;
            }
        }
        return false;
    }
}

