/*
 * Decompiled with CFR 0.152.
 */
import org.nlogo.api.Argument;
import org.nlogo.api.Command;
import org.nlogo.api.Context;
import org.nlogo.api.ExtensionException;
import org.nlogo.core.LogoList;
import org.nlogo.core.Syntax;
import org.nlogo.core.SyntaxJ;

public class SetAgentHSB
implements Command {
    private int index;
    private String[] type = new String[]{"Hue", "Saturation", "Brightness"};
    private int[] range = new int[]{360, 100, 100};

    public SetAgentHSB(int ind) {
        this.index = ind;
    }

    public Syntax getSyntax() {
        int[] values = new int[]{Syntax.NumberType()};
        return SyntaxJ.commandSyntax((int[])values, (String)"-TPL");
    }

    public void perform(Argument[] args, Context context) throws ExtensionException {
        double newValue = args[0].getDoubleValue();
        if (newValue < 0.0 || newValue > (double)this.range[this.index]) {
            throw new ExtensionException(this.type[this.index] + " must be in the range from 0 to " + this.range[this.index] + ".");
        }
        LogoList rgb = ColorManager.getAgentColor(context);
        rgb = HSBUpdated.updateHSB(rgb, newValue, this.index);
        ColorManager.setAgentColor(context, rgb);
    }
}

