/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.figures;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import org.jhotdraw.figures.AttributeFigure;
import org.jhotdraw.figures.FontSizeHandle;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureAttributeConstant;
import org.jhotdraw.framework.FigureChangeEvent;
import org.jhotdraw.framework.FigureChangeListener;
import org.jhotdraw.framework.HandleEnumeration;
import org.jhotdraw.standard.HandleEnumerator;
import org.jhotdraw.standard.NullHandle;
import org.jhotdraw.standard.OffsetLocator;
import org.jhotdraw.standard.RelativeLocator;
import org.jhotdraw.standard.TextHolder;
import org.jhotdraw.util.CollectionsFactory;
import org.jhotdraw.util.ColorMap;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.StorableOutput;

public class TextFigure
extends AttributeFigure
implements FigureChangeListener,
TextHolder {
    private int fOriginX = 0;
    private int fOriginY = 0;
    private transient boolean fSizeIsDirty = true;
    private transient int fWidth;
    private transient int fHeight;
    private String fText;
    private Font fFont = TextFigure.createCurrentFont();
    private boolean fIsReadOnly;
    private Figure fObservedFigure = null;
    private OffsetLocator fLocator = null;
    private static String fgCurrentFontName = "Helvetica";
    private static int fgCurrentFontSize = 12;
    private static int fgCurrentFontStyle = 0;
    private static final long serialVersionUID = 4599820785949456124L;
    private int textFigureSerializedDataVersion = 1;

    public TextFigure() {
        this.setAttribute(FigureAttributeConstant.FILL_COLOR, (Object)ColorMap.color("None"));
        this.fText = "";
        this.fSizeIsDirty = true;
    }

    public void moveBy(int n, int n2) {
        this.willChange();
        this.basicMoveBy(n, n2);
        if (this.getLocator() != null) {
            this.getLocator().moveBy(n, n2);
        }
        this.changed();
    }

    protected void basicMoveBy(int n, int n2) {
        this.fOriginX += n;
        this.fOriginY += n2;
    }

    public void basicDisplayBox(Point point, Point point2) {
        this.fOriginX = point.x;
        this.fOriginY = point.y;
    }

    public Rectangle displayBox() {
        Dimension dimension = this.textExtent();
        return new Rectangle(this.fOriginX, this.fOriginY, dimension.width, dimension.height);
    }

    public Rectangle textDisplayBox() {
        return this.displayBox();
    }

    public boolean readOnly() {
        return this.fIsReadOnly;
    }

    public void setReadOnly(boolean bl) {
        this.fIsReadOnly = bl;
    }

    public Font getFont() {
        return this.fFont;
    }

    public Figure getRepresentingFigure() {
        return this;
    }

    public void setFont(Font font) {
        this.willChange();
        this.fFont = font;
        this.markDirty();
        this.changed();
    }

    public void changed() {
        super.changed();
    }

    public Object getAttribute(String string) {
        return this.getAttribute(FigureAttributeConstant.getConstant(string));
    }

    public Object getAttribute(FigureAttributeConstant figureAttributeConstant) {
        Font font = this.getFont();
        if (figureAttributeConstant.equals(FigureAttributeConstant.FONT_SIZE)) {
            return new Integer(font.getSize());
        }
        if (figureAttributeConstant.equals(FigureAttributeConstant.FONT_STYLE)) {
            return new Integer(font.getStyle());
        }
        if (figureAttributeConstant.equals(FigureAttributeConstant.FONT_NAME)) {
            return font.getName();
        }
        return super.getAttribute(figureAttributeConstant);
    }

    public void setAttribute(String string, Object object) {
        this.setAttribute(FigureAttributeConstant.getConstant(string), object);
    }

    public void setAttribute(FigureAttributeConstant figureAttributeConstant, Object object) {
        Font font = this.getFont();
        if (figureAttributeConstant.equals(FigureAttributeConstant.FONT_SIZE)) {
            Integer n = (Integer)object;
            this.setFont(new Font(font.getName(), font.getStyle(), n));
        } else if (figureAttributeConstant.equals(FigureAttributeConstant.FONT_STYLE)) {
            Integer n = (Integer)object;
            int n2 = font.getStyle();
            n2 = n == 0 ? 0 : (n2 ^= n.intValue());
            this.setFont(new Font(font.getName(), n2, font.getSize()));
        } else if (figureAttributeConstant.equals(FigureAttributeConstant.FONT_NAME)) {
            String string = (String)object;
            this.setFont(new Font(string, font.getStyle(), font.getSize()));
        } else {
            super.setAttribute(figureAttributeConstant, object);
        }
    }

    public String getText() {
        return this.fText;
    }

    public void setText(String string) {
        if (string == null || !string.equals(this.fText)) {
            this.willChange();
            this.fText = string;
            this.markDirty();
            this.changed();
        }
    }

    public boolean acceptsTyping() {
        return !this.fIsReadOnly;
    }

    public void drawBackground(Graphics graphics) {
        Rectangle rectangle = this.displayBox();
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void drawFrame(Graphics graphics) {
        graphics.setFont(this.fFont);
        graphics.setColor((Color)this.getAttribute(FigureAttributeConstant.TEXT_COLOR));
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.fFont);
        Rectangle rectangle = this.displayBox();
        graphics.drawString(this.getText(), rectangle.x, rectangle.y + fontMetrics.getAscent());
    }

    protected Dimension textExtent() {
        if (!this.fSizeIsDirty) {
            return new Dimension(this.fWidth, this.fHeight);
        }
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.fFont);
        this.fWidth = fontMetrics.stringWidth(this.getText());
        this.fHeight = fontMetrics.getHeight();
        this.fSizeIsDirty = false;
        return new Dimension(this.fWidth, this.fHeight);
    }

    protected void markDirty() {
        this.fSizeIsDirty = true;
    }

    public int overlayColumns() {
        int n = this.getText().length();
        int n2 = 20;
        if (n != 0) {
            n2 = this.getText().length() + 3;
        }
        return n2;
    }

    public HandleEnumeration handles() {
        List list = CollectionsFactory.current().createList();
        list.add(new NullHandle(this, RelativeLocator.northWest()));
        list.add(new NullHandle(this, RelativeLocator.northEast()));
        list.add(new NullHandle(this, RelativeLocator.southEast()));
        list.add(new FontSizeHandle(this, RelativeLocator.southWest()));
        return new HandleEnumerator(list);
    }

    public void write(StorableOutput storableOutput) {
        super.write(storableOutput);
        Rectangle rectangle = this.displayBox();
        storableOutput.writeInt(rectangle.x);
        storableOutput.writeInt(rectangle.y);
        storableOutput.writeString(this.getText());
        storableOutput.writeString(this.fFont.getName());
        storableOutput.writeInt(this.fFont.getStyle());
        storableOutput.writeInt(this.fFont.getSize());
        storableOutput.writeBoolean(this.fIsReadOnly);
        storableOutput.writeStorable(this.getObservedFigure());
        storableOutput.writeStorable(this.getLocator());
    }

    public void read(StorableInput storableInput) throws IOException {
        super.read(storableInput);
        this.markDirty();
        this.basicDisplayBox(new Point(storableInput.readInt(), storableInput.readInt()), null);
        this.setText(storableInput.readString());
        this.fFont = new Font(storableInput.readString(), storableInput.readInt(), storableInput.readInt());
        this.fIsReadOnly = storableInput.readBoolean();
        this.setObservedFigure((Figure)storableInput.readStorable());
        if (this.getObservedFigure() != null) {
            this.getObservedFigure().addFigureChangeListener(this);
        }
        this.setLocator((OffsetLocator)storableInput.readStorable());
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        if (this.getObservedFigure() != null) {
            this.getObservedFigure().addFigureChangeListener(this);
        }
        this.markDirty();
    }

    public void connect(Figure figure) {
        if (this.getObservedFigure() != null) {
            this.getObservedFigure().removeFigureChangeListener(this);
        }
        this.setObservedFigure(figure);
        this.setLocator(new OffsetLocator(this.getObservedFigure().connectedTextLocator(this)));
        this.getObservedFigure().addFigureChangeListener(this);
        this.willChange();
        this.updateLocation();
        this.changed();
    }

    public void figureChanged(FigureChangeEvent figureChangeEvent) {
        this.willChange();
        this.updateLocation();
        this.changed();
    }

    public void figureRemoved(FigureChangeEvent figureChangeEvent) {
        if (this.listener() != null) {
            Rectangle rectangle = this.invalidateRectangle(this.displayBox());
            this.listener().figureRemoved(new FigureChangeEvent(this, rectangle, figureChangeEvent));
        }
    }

    public void figureRequestRemove(FigureChangeEvent figureChangeEvent) {
    }

    public void figureInvalidated(FigureChangeEvent figureChangeEvent) {
    }

    public void figureRequestUpdate(FigureChangeEvent figureChangeEvent) {
    }

    protected void updateLocation() {
        if (this.getLocator() != null) {
            Point point = this.getLocator().locate(this.getObservedFigure());
            point.x -= this.size().width / 2 + this.fOriginX;
            point.y -= this.size().height / 2 + this.fOriginY;
            if (point.x != 0 || point.y != 0) {
                this.basicMoveBy(point.x, point.y);
            }
        }
    }

    public void release() {
        super.release();
        this.disconnect(this.getObservedFigure());
    }

    public void disconnect(Figure figure) {
        if (figure != null) {
            figure.removeFigureChangeListener(this);
        }
        this.setLocator(null);
        this.setObservedFigure(null);
    }

    protected void setObservedFigure(Figure figure) {
        this.fObservedFigure = figure;
    }

    public Figure getObservedFigure() {
        return this.fObservedFigure;
    }

    protected void setLocator(OffsetLocator offsetLocator) {
        this.fLocator = offsetLocator;
    }

    protected OffsetLocator getLocator() {
        return this.fLocator;
    }

    public TextHolder getTextHolder() {
        return this;
    }

    public static Font createCurrentFont() {
        return new Font(fgCurrentFontName, fgCurrentFontStyle, fgCurrentFontSize);
    }

    public static void setCurrentFontName(String string) {
        fgCurrentFontName = string;
    }

    public static void setCurrentFontSize(int n) {
        fgCurrentFontSize = n;
    }

    public static void setCurrentFontStyle(int n) {
        fgCurrentFontStyle = n;
    }
}

