/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.javadraw;

import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JApplet;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureAttributeConstant;
import org.jhotdraw.standard.AbstractTool;

class FollowURLTool
extends AbstractTool {
    private JApplet fApplet;

    FollowURLTool(DrawingEditor drawingEditor, JApplet jApplet) {
        super(drawingEditor);
        this.fApplet = jApplet;
    }

    public void mouseMove(MouseEvent mouseEvent, int n, int n2) {
        String string = null;
        Figure figure = this.drawing().findFigureInside(n, n2);
        if (figure != null) {
            string = (String)figure.getAttribute(FigureAttributeConstant.URL);
        }
        if (string != null) {
            this.fApplet.showStatus(string);
        } else {
            this.fApplet.showStatus("");
        }
    }

    public void mouseUp(MouseEvent mouseEvent, int n, int n2) {
        Figure figure = this.getActiveDrawing().findFigureInside(n, n2);
        if (figure == null) {
            return;
        }
        String string = (String)figure.getAttribute(FigureAttributeConstant.URL);
        if (string == null) {
            return;
        }
        try {
            URL uRL = new URL(this.fApplet.getDocumentBase(), string);
            this.fApplet.getAppletContext().showDocument(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            this.fApplet.showStatus(malformedURLException.toString());
        }
    }
}

