/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.net;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.List;
import org.jhotdraw.figures.LineConnection;
import org.jhotdraw.figures.TextFigure;
import org.jhotdraw.framework.ConnectionFigure;
import org.jhotdraw.framework.Connector;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.HandleEnumeration;
import org.jhotdraw.standard.ConnectionHandle;
import org.jhotdraw.standard.HandleEnumerator;
import org.jhotdraw.standard.LocatorConnector;
import org.jhotdraw.standard.NullHandle;
import org.jhotdraw.standard.RelativeLocator;
import org.jhotdraw.util.CollectionsFactory;
import org.jhotdraw.util.Geom;

public class NodeFigure
extends TextFigure {
    private static final int BORDER = 6;
    private List fConnectors;
    private boolean fConnectorsVisible;

    public NodeFigure() {
        this.initialize();
        this.fConnectors = null;
    }

    public Rectangle displayBox() {
        Rectangle rectangle = super.displayBox();
        int n = 6;
        rectangle.grow(n, n);
        return rectangle;
    }

    public boolean containsPoint(int n, int n2) {
        if (this.fConnectorsVisible) {
            Rectangle rectangle = this.displayBox();
            int n3 = 4;
            rectangle.grow(n3, n3);
            return rectangle.contains(n, n2);
        }
        return super.containsPoint(n, n2);
    }

    private void drawBorder(Graphics graphics) {
        Rectangle rectangle = this.displayBox();
        graphics.setColor(this.getFrameColor());
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
    }

    public void draw(Graphics graphics) {
        super.draw(graphics);
        this.drawBorder(graphics);
        this.drawConnectors(graphics);
    }

    public HandleEnumeration handles() {
        LineConnection lineConnection = new LineConnection();
        List list = CollectionsFactory.current().createList();
        list.add(new ConnectionHandle(this, RelativeLocator.east(), lineConnection));
        list.add(new ConnectionHandle(this, RelativeLocator.west(), lineConnection));
        list.add(new ConnectionHandle(this, RelativeLocator.south(), lineConnection));
        list.add(new ConnectionHandle(this, RelativeLocator.north(), lineConnection));
        list.add(new NullHandle(this, RelativeLocator.southEast()));
        list.add(new NullHandle(this, RelativeLocator.southWest()));
        list.add(new NullHandle(this, RelativeLocator.northEast()));
        list.add(new NullHandle(this, RelativeLocator.northWest()));
        return new HandleEnumerator(list);
    }

    private void drawConnectors(Graphics graphics) {
        if (this.fConnectorsVisible) {
            Iterator iterator = this.connectors();
            while (iterator.hasNext()) {
                ((Connector)iterator.next()).draw(graphics);
            }
        }
    }

    public void connectorVisibility(boolean bl, ConnectionFigure connectionFigure) {
        this.fConnectorsVisible = bl;
        this.invalidate();
    }

    public Connector connectorAt(int n, int n2) {
        return this.findConnector(n, n2);
    }

    private Iterator connectors() {
        if (this.fConnectors == null) {
            this.createConnectors();
        }
        return this.fConnectors.iterator();
    }

    private void createConnectors() {
        this.fConnectors = CollectionsFactory.current().createList(4);
        this.fConnectors.add(new LocatorConnector(this, RelativeLocator.north()));
        this.fConnectors.add(new LocatorConnector(this, RelativeLocator.south()));
        this.fConnectors.add(new LocatorConnector(this, RelativeLocator.west()));
        this.fConnectors.add(new LocatorConnector(this, RelativeLocator.east()));
    }

    private Connector findConnector(int n, int n2) {
        long l = Long.MAX_VALUE;
        Connector connector = null;
        Iterator iterator = this.connectors();
        while (iterator.hasNext()) {
            Connector connector2 = (Connector)iterator.next();
            Point point = Geom.center(connector2.displayBox());
            long l2 = Geom.length2(n, n2, point.x, point.y);
            if (l2 >= l) continue;
            l = l2;
            connector = connector2;
        }
        return connector;
    }

    private void initialize() {
        this.setText("node");
        Font font = new Font("Helvetica", 1, 12);
        this.setFont(font);
        this.createConnectors();
    }

    public Figure getRepresentingFigure() {
        return this;
    }
}

