/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.projection;

import com.vividsolutions.jts.geom.Coordinate;
import java.text.ParseException;
import org.myworldgis.projection.Ellipsoid;
import org.myworldgis.projection.HemisphericalProjection;
import org.myworldgis.projection.ProjectionParameters;
import org.myworldgis.util.GeometryUtils;
import org.ngs.ngunits.SI;
import org.ngs.ngunits.Unit;
import org.ngs.ngunits.quantity.Angle;
import org.ngs.ngunits.quantity.Length;

public strictfp final class Polyconic
extends HemisphericalProjection {
    public static final String WKT_NAME = "Polyconic";
    public static final String CENTER_LON_PROPERTY = "central_meridian";
    public static final String CENTER_LAT_PROPERTY = "latitude_of_origin";
    private static final double EPSILON = 1.0E-6;
    private static final int MAX_ITERATIONS = 75;
    private double[] _subM;
    private double _M0;
    protected Coordinate _hemisphereCenter;

    public Polyconic(Ellipsoid ellipsoid, Coordinate center, Unit<Length> units, double falseEasting, double falseNorthing) {
        super(ellipsoid, center, units, falseEasting, falseNorthing);
        this._name = WKT_NAME;
        this._subM = new double[4];
        this.computeParameters();
    }

    public Polyconic(Ellipsoid ellipsoid, ProjectionParameters parameters) throws ParseException {
        super(ellipsoid, parameters);
        this._name = WKT_NAME;
        this._subM = new double[4];
        this.computeParameters();
    }

    @Override
    protected double getMaxC() {
        return 1.5707963267948966;
    }

    @Override
    protected Coordinate getHemisphereCenter() {
        return this._hemisphereCenter;
    }

    @Override
    protected Coordinate forwardPointRaw(double lambda, double phi, Coordinate storage) {
        if (phi == 0.0) {
            storage.x = this._a * GeometryUtils.wrap_longitude(lambda - this._lambda0);
            storage.y = -this._M0;
        } else {
            double sinPhi = StrictMath.sin(phi);
            double cotPhi = 1.0 / StrictMath.tan(phi);
            double E = GeometryUtils.wrap_longitude(lambda - this._lambda0) * sinPhi;
            double N = this._a / StrictMath.sqrt(1.0 - this._e2 * sinPhi * sinPhi);
            double M = this._a * (this._subM[0] * phi - this._subM[1] * StrictMath.sin(2.0 * phi) + this._subM[2] * StrictMath.sin(4.0 * phi) - this._subM[3] * StrictMath.sin(6.0 * phi));
            storage.x = N * cotPhi * StrictMath.sin(E);
            storage.y = M - this._M0 + N * cotPhi * (1.0 - StrictMath.cos(E));
        }
        return storage;
    }

    @Override
    protected Coordinate inversePointRaw(double x, double y, Coordinate storage) {
        double MnPrime;
        double Ma;
        double C;
        double phiN;
        double A = (this._M0 + y) / this._a;
        double B = x * x / (this._a * this._a) + A * A;
        double phiN1 = A;
        int i = 0;
        do {
            phiN = phiN1;
            C = StrictMath.sqrt(1.0 - this._e2 * StrictMath.sin(phiN) * StrictMath.sin(phiN)) * StrictMath.tan(phiN);
            Ma = this._subM[0] * phiN - this._subM[1] * StrictMath.sin(2.0 * phiN) + this._subM[2] * StrictMath.sin(4.0 * phiN) - this._subM[3] * StrictMath.sin(6.0 * phiN);
            MnPrime = this._subM[0] - 2.0 * this._subM[1] * StrictMath.cos(2.0 * phiN) + 4.0 * this._subM[2] * StrictMath.cos(4.0 * phiN) - 6.0 * this._subM[3] * StrictMath.cos(6.0 * phiN);
        } while (StrictMath.abs(phiN - (phiN1 = phiN - (A * (C * Ma + 1.0) - Ma - 0.5 * (Ma * Ma + B) * C) / (this._e2 * StrictMath.sin(2.0 * phiN) * (Ma * Ma + B - 2.0 * A * Ma) / (4.0 * C) + (A - Ma) * (C * MnPrime - 2.0 / StrictMath.sin(2.0 * phiN)) - MnPrime))) > 1.0E-6 && i++ < 75);
        storage.y = i > 75 ? Double.NaN : phiN1;
        storage.x = this._lambda0 + StrictMath.asin(x * C / this._a) / StrictMath.sin(storage.y);
        return storage;
    }

    @Override
    protected void computeParameters() {
        this._subM[0] = 1.0 - this._e2 / 4.0 - 3.0 * this._e2 * this._e2 / 64.0 - 5.0 * this._e2 * this._e2 * this._e2 / 256.0;
        this._subM[1] = 3.0 * this._e2 / 8.0 + 3.0 * this._e2 * this._e2 / 32.0 + 45.0 * this._e2 * this._e2 * this._e2 / 1024.0;
        this._subM[2] = 15.0 * this._e2 * this._e2 / 256.0 + 45.0 * this._e2 * this._e2 * this._e2 / 1024.0;
        this._subM[3] = 35.0 * this._e2 * this._e2 * this._e2 / 3072.0;
        this._M0 = this._a * (this._subM[0] * this._phi0 - this._subM[1] * StrictMath.sin(2.0 * this._phi0) + this._subM[2] * StrictMath.sin(4.0 * this._phi0) - this._subM[3] * StrictMath.sin(6.0 * this._phi0));
        this._hemisphereCenter = new Coordinate(0.0, this._lambda0);
        super.computeParameters();
    }

    @Override
    public ProjectionParameters getParameters() {
        ProjectionParameters result = super.getParameters();
        result.addAngularParameter(CENTER_LON_PROPERTY, this._lambda0, (Unit<Angle>)SI.RADIAN);
        result.addAngularParameter(CENTER_LAT_PROPERTY, this._phi0, (Unit<Angle>)SI.RADIAN);
        return result;
    }

    @Override
    public Object clone() {
        Polyconic clone = (Polyconic)super.clone();
        clone._subM = (double[])this._subM.clone();
        return clone;
    }
}

