#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 51
#define LARGE_STATE_COUNT 5
#define SYMBOL_COUNT 41
#define ALIAS_COUNT 0
#define TOKEN_COUNT 19
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 2
#define MAX_ALIAS_SEQUENCE_LENGTH 5
#define PRODUCTION_ID_COUNT 5

enum {
  sym__identifier = 1,
  sym_comment = 2,
  sym_one_or_more = 3,
  sym_zero_or_one = 4,
  sym_zero_or_more = 5,
  sym_capture = 6,
  anon_sym_LBRACK = 7,
  anon_sym_RBRACK = 8,
  anon_sym_DQUOTE = 9,
  aux_sym__string_token1 = 10,
  sym_escape_sequence = 11,
  anon_sym_LPAREN = 12,
  anon_sym_RPAREN = 13,
  sym_anchor = 14,
  anon_sym_COLON = 15,
  anon_sym_BANG = 16,
  sym_predicate_name = 17,
  anon_sym__ = 18,
  sym_query = 19,
  sym_pattern = 20,
  sym__pattern = 21,
  sym__quantifier = 22,
  sym_alternation = 23,
  sym_choice = 24,
  sym_anonymous_leaf = 25,
  sym__string = 26,
  sym_group = 27,
  sym_named_node = 28,
  sym_node_name = 29,
  sym_child = 30,
  sym_field_name = 31,
  sym_negated_child = 32,
  sym_predicate = 33,
  sym_string = 34,
  sym_wildcard_node = 35,
  aux_sym_query_repeat1 = 36,
  aux_sym_alternation_repeat1 = 37,
  aux_sym__string_repeat1 = 38,
  aux_sym_named_node_repeat1 = 39,
  aux_sym_predicate_repeat1 = 40,
};

static const char *ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym__identifier] = "_identifier",
  [sym_comment] = "comment",
  [sym_one_or_more] = "one_or_more",
  [sym_zero_or_one] = "zero_or_one",
  [sym_zero_or_more] = "zero_or_more",
  [sym_capture] = "capture",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym__string_token1] = "_string_token1",
  [sym_escape_sequence] = "escape_sequence",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [sym_anchor] = "anchor",
  [anon_sym_COLON] = ":",
  [anon_sym_BANG] = "!",
  [sym_predicate_name] = "predicate_name",
  [anon_sym__] = "_",
  [sym_query] = "query",
  [sym_pattern] = "pattern",
  [sym__pattern] = "_pattern",
  [sym__quantifier] = "_quantifier",
  [sym_alternation] = "alternation",
  [sym_choice] = "choice",
  [sym_anonymous_leaf] = "anonymous_leaf",
  [sym__string] = "_string",
  [sym_group] = "group",
  [sym_named_node] = "named_node",
  [sym_node_name] = "node_name",
  [sym_child] = "child",
  [sym_field_name] = "field_name",
  [sym_negated_child] = "negated_child",
  [sym_predicate] = "predicate",
  [sym_string] = "string",
  [sym_wildcard_node] = "wildcard_node",
  [aux_sym_query_repeat1] = "query_repeat1",
  [aux_sym_alternation_repeat1] = "alternation_repeat1",
  [aux_sym__string_repeat1] = "_string_repeat1",
  [aux_sym_named_node_repeat1] = "named_node_repeat1",
  [aux_sym_predicate_repeat1] = "predicate_repeat1",
};

static TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym__identifier] = sym__identifier,
  [sym_comment] = sym_comment,
  [sym_one_or_more] = sym_one_or_more,
  [sym_zero_or_one] = sym_zero_or_one,
  [sym_zero_or_more] = sym_zero_or_more,
  [sym_capture] = sym_capture,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym__string_token1] = aux_sym__string_token1,
  [sym_escape_sequence] = sym_escape_sequence,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [sym_anchor] = sym_anchor,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_BANG] = anon_sym_BANG,
  [sym_predicate_name] = sym_predicate_name,
  [anon_sym__] = anon_sym__,
  [sym_query] = sym_query,
  [sym_pattern] = sym_pattern,
  [sym__pattern] = sym__pattern,
  [sym__quantifier] = sym__quantifier,
  [sym_alternation] = sym_alternation,
  [sym_choice] = sym_choice,
  [sym_anonymous_leaf] = sym_anonymous_leaf,
  [sym__string] = sym__string,
  [sym_group] = sym_group,
  [sym_named_node] = sym_named_node,
  [sym_node_name] = sym_node_name,
  [sym_child] = sym_child,
  [sym_field_name] = sym_field_name,
  [sym_negated_child] = sym_negated_child,
  [sym_predicate] = sym_predicate,
  [sym_string] = sym_string,
  [sym_wildcard_node] = sym_wildcard_node,
  [aux_sym_query_repeat1] = aux_sym_query_repeat1,
  [aux_sym_alternation_repeat1] = aux_sym_alternation_repeat1,
  [aux_sym__string_repeat1] = aux_sym__string_repeat1,
  [aux_sym_named_node_repeat1] = aux_sym_named_node_repeat1,
  [aux_sym_predicate_repeat1] = aux_sym_predicate_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym__identifier] = {
    .visible = false,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_one_or_more] = {
    .visible = true,
    .named = true,
  },
  [sym_zero_or_one] = {
    .visible = true,
    .named = true,
  },
  [sym_zero_or_more] = {
    .visible = true,
    .named = true,
  },
  [sym_capture] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__string_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [sym_anchor] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [sym_predicate_name] = {
    .visible = true,
    .named = true,
  },
  [anon_sym__] = {
    .visible = true,
    .named = false,
  },
  [sym_query] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__pattern] = {
    .visible = false,
    .named = true,
  },
  [sym__quantifier] = {
    .visible = false,
    .named = true,
  },
  [sym_alternation] = {
    .visible = true,
    .named = true,
  },
  [sym_choice] = {
    .visible = true,
    .named = true,
  },
  [sym_anonymous_leaf] = {
    .visible = true,
    .named = true,
  },
  [sym__string] = {
    .visible = false,
    .named = true,
  },
  [sym_group] = {
    .visible = true,
    .named = true,
  },
  [sym_named_node] = {
    .visible = true,
    .named = true,
  },
  [sym_node_name] = {
    .visible = true,
    .named = true,
  },
  [sym_child] = {
    .visible = true,
    .named = true,
  },
  [sym_field_name] = {
    .visible = true,
    .named = true,
  },
  [sym_negated_child] = {
    .visible = true,
    .named = true,
  },
  [sym_predicate] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_wildcard_node] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_query_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_alternation_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_named_node_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_predicate_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum {
  field_pattern = 1,
  field_quantifier = 2,
};

static const char *ts_field_names[] = {
  [0] = NULL,
  [field_pattern] = "pattern",
  [field_quantifier] = "quantifier",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 2},
  [2] = {.index = 2, .length = 1},
  [3] = {.index = 3, .length = 2},
  [4] = {.index = 5, .length = 2},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_pattern, 0, .inherited = true},
    {field_quantifier, 0, .inherited = true},
  [2] =
    {field_pattern, 0},
  [3] =
    {field_pattern, 0},
    {field_quantifier, 1},
  [5] =
    {field_pattern, 2, .inherited = true},
    {field_quantifier, 2, .inherited = true},
};

static TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(7);
      if (lookahead == '!') ADVANCE(24);
      if (lookahead == '"') ADVANCE(15);
      if (lookahead == '#') ADVANCE(4);
      if (lookahead == '(') ADVANCE(20);
      if (lookahead == ')') ADVANCE(21);
      if (lookahead == '*') ADVANCE(11);
      if (lookahead == '+') ADVANCE(9);
      if (lookahead == '.') ADVANCE(22);
      if (lookahead == ':') ADVANCE(23);
      if (lookahead == ';') ADVANCE(8);
      if (lookahead == '?') ADVANCE(10);
      if (lookahead == '@') ADVANCE(5);
      if (lookahead == '[') ADVANCE(13);
      if (lookahead == '\\') ADVANCE(3);
      if (lookahead == ']') ADVANCE(14);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(6)
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(19);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(2)
      if (lookahead == '"') ADVANCE(15);
      if (lookahead == ';') ADVANCE(17);
      if (lookahead == '\\') ADVANCE(3);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(16);
      if (lookahead != 0) ADVANCE(17);
      END_STATE();
    case 2:
      if (lookahead == '"') ADVANCE(15);
      if (lookahead == ';') ADVANCE(8);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(2)
      END_STATE();
    case 3:
      if (lookahead == '0' ||
          lookahead == '\\' ||
          lookahead == 'n' ||
          lookahead == 'r' ||
          lookahead == 't') ADVANCE(18);
      END_STATE();
    case 4:
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(25);
      END_STATE();
    case 5:
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(12);
      END_STATE();
    case 6:
      if (eof) ADVANCE(7);
      if (lookahead == '!') ADVANCE(24);
      if (lookahead == '"') ADVANCE(15);
      if (lookahead == '#') ADVANCE(4);
      if (lookahead == '(') ADVANCE(20);
      if (lookahead == ')') ADVANCE(21);
      if (lookahead == '*') ADVANCE(11);
      if (lookahead == '+') ADVANCE(9);
      if (lookahead == '.') ADVANCE(22);
      if (lookahead == ':') ADVANCE(23);
      if (lookahead == ';') ADVANCE(8);
      if (lookahead == '?') ADVANCE(10);
      if (lookahead == '@') ADVANCE(5);
      if (lookahead == '[') ADVANCE(13);
      if (lookahead == ']') ADVANCE(14);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(6)
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(19);
      END_STATE();
    case 7:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 8:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(8);
      END_STATE();
    case 9:
      ACCEPT_TOKEN(sym_one_or_more);
      END_STATE();
    case 10:
      ACCEPT_TOKEN(sym_zero_or_one);
      END_STATE();
    case 11:
      ACCEPT_TOKEN(sym_zero_or_more);
      END_STATE();
    case 12:
      ACCEPT_TOKEN(sym_capture);
      if (lookahead == '!' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(12);
      END_STATE();
    case 13:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 14:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 15:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 16:
      ACCEPT_TOKEN(aux_sym__string_token1);
      if (lookahead == ';') ADVANCE(17);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(16);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(17);
      END_STATE();
    case 17:
      ACCEPT_TOKEN(aux_sym__string_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(17);
      END_STATE();
    case 18:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 19:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == '!' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(19);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 22:
      ACCEPT_TOKEN(sym_anchor);
      END_STATE();
    case 23:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(sym_predicate_name);
      if (lookahead == '!' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(25);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == '_') ADVANCE(1);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      ACCEPT_TOKEN(anon_sym__);
      END_STATE();
    default:
      return false;
  }
}

static TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 0},
  [2] = {.lex_state = 0},
  [3] = {.lex_state = 0},
  [4] = {.lex_state = 0},
  [5] = {.lex_state = 0},
  [6] = {.lex_state = 0},
  [7] = {.lex_state = 0},
  [8] = {.lex_state = 0},
  [9] = {.lex_state = 0},
  [10] = {.lex_state = 0},
  [11] = {.lex_state = 0},
  [12] = {.lex_state = 0},
  [13] = {.lex_state = 0},
  [14] = {.lex_state = 0},
  [15] = {.lex_state = 0},
  [16] = {.lex_state = 0},
  [17] = {.lex_state = 0},
  [18] = {.lex_state = 0},
  [19] = {.lex_state = 0},
  [20] = {.lex_state = 0},
  [21] = {.lex_state = 0},
  [22] = {.lex_state = 0},
  [23] = {.lex_state = 0},
  [24] = {.lex_state = 0},
  [25] = {.lex_state = 0},
  [26] = {.lex_state = 0},
  [27] = {.lex_state = 0},
  [28] = {.lex_state = 0},
  [29] = {.lex_state = 0},
  [30] = {.lex_state = 0},
  [31] = {.lex_state = 0},
  [32] = {.lex_state = 0},
  [33] = {.lex_state = 0},
  [34] = {.lex_state = 0},
  [35] = {.lex_state = 0},
  [36] = {.lex_state = 0},
  [37] = {.lex_state = 0},
  [38] = {.lex_state = 0},
  [39] = {.lex_state = 0},
  [40] = {.lex_state = 0},
  [41] = {.lex_state = 0},
  [42] = {.lex_state = 0},
  [43] = {.lex_state = 0},
  [44] = {.lex_state = 1},
  [45] = {.lex_state = 1},
  [46] = {.lex_state = 1},
  [47] = {.lex_state = 0},
  [48] = {.lex_state = 0},
  [49] = {.lex_state = 0},
  [50] = {.lex_state = 0},
};

static uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym__identifier] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym_one_or_more] = ACTIONS(1),
    [sym_zero_or_one] = ACTIONS(1),
    [sym_zero_or_more] = ACTIONS(1),
    [sym_capture] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [sym_anchor] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [sym_predicate_name] = ACTIONS(1),
    [anon_sym__] = ACTIONS(1),
  },
  [1] = {
    [sym_query] = STATE(50),
    [sym_pattern] = STATE(12),
    [sym__pattern] = STATE(39),
    [sym_alternation] = STATE(10),
    [sym_anonymous_leaf] = STATE(10),
    [sym__string] = STATE(24),
    [sym_group] = STATE(10),
    [sym_named_node] = STATE(10),
    [sym_predicate] = STATE(12),
    [sym_wildcard_node] = STATE(10),
    [aux_sym_query_repeat1] = STATE(12),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(11),
    [anon_sym__] = ACTIONS(13),
  },
  [2] = {
    [sym__pattern] = STATE(34),
    [sym_alternation] = STATE(10),
    [sym_anonymous_leaf] = STATE(10),
    [sym__string] = STATE(24),
    [sym_group] = STATE(10),
    [sym_named_node] = STATE(10),
    [sym_child] = STATE(2),
    [sym_field_name] = STATE(49),
    [sym_negated_child] = STATE(2),
    [sym_predicate] = STATE(2),
    [sym_wildcard_node] = STATE(10),
    [aux_sym_named_node_repeat1] = STATE(2),
    [sym__identifier] = ACTIONS(15),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(18),
    [anon_sym_DQUOTE] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(24),
    [anon_sym_RPAREN] = ACTIONS(27),
    [sym_anchor] = ACTIONS(29),
    [anon_sym_BANG] = ACTIONS(32),
    [anon_sym__] = ACTIONS(35),
  },
  [3] = {
    [sym__pattern] = STATE(34),
    [sym_alternation] = STATE(10),
    [sym_anonymous_leaf] = STATE(10),
    [sym__string] = STATE(24),
    [sym_group] = STATE(10),
    [sym_named_node] = STATE(10),
    [sym_child] = STATE(2),
    [sym_field_name] = STATE(49),
    [sym_negated_child] = STATE(2),
    [sym_predicate] = STATE(2),
    [sym_wildcard_node] = STATE(10),
    [aux_sym_named_node_repeat1] = STATE(2),
    [sym__identifier] = ACTIONS(38),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(11),
    [anon_sym_RPAREN] = ACTIONS(40),
    [sym_anchor] = ACTIONS(42),
    [anon_sym_BANG] = ACTIONS(44),
    [anon_sym__] = ACTIONS(46),
  },
  [4] = {
    [sym__pattern] = STATE(34),
    [sym_alternation] = STATE(10),
    [sym_anonymous_leaf] = STATE(10),
    [sym__string] = STATE(24),
    [sym_group] = STATE(10),
    [sym_named_node] = STATE(10),
    [sym_child] = STATE(3),
    [sym_field_name] = STATE(49),
    [sym_negated_child] = STATE(3),
    [sym_predicate] = STATE(3),
    [sym_wildcard_node] = STATE(10),
    [aux_sym_named_node_repeat1] = STATE(3),
    [sym__identifier] = ACTIONS(38),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(11),
    [anon_sym_RPAREN] = ACTIONS(48),
    [sym_anchor] = ACTIONS(50),
    [anon_sym_BANG] = ACTIONS(44),
    [anon_sym__] = ACTIONS(46),
  },
};

static uint16_t ts_small_parse_table[] = {
  [0] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_LBRACK,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(38), 1,
      sym__identifier,
    ACTIONS(44), 1,
      anon_sym_BANG,
    ACTIONS(46), 1,
      anon_sym__,
    ACTIONS(52), 1,
      anon_sym_RPAREN,
    STATE(24), 1,
      sym__string,
    STATE(34), 1,
      sym__pattern,
    STATE(49), 1,
      sym_field_name,
    STATE(35), 3,
      sym_child,
      sym_negated_child,
      sym_predicate,
    STATE(10), 5,
      sym_alternation,
      sym_anonymous_leaf,
      sym_group,
      sym_named_node,
      sym_wildcard_node,
  [46] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_LBRACK,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(54), 1,
      sym__identifier,
    ACTIONS(56), 1,
      sym_predicate_name,
    ACTIONS(58), 1,
      anon_sym__,
    STATE(4), 1,
      sym_node_name,
    STATE(24), 1,
      sym__string,
    STATE(39), 1,
      sym__pattern,
    STATE(14), 3,
      sym_pattern,
      sym_predicate,
      aux_sym_query_repeat1,
    STATE(10), 5,
      sym_alternation,
      sym_anonymous_leaf,
      sym_group,
      sym_named_node,
      sym_wildcard_node,
  [89] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_LBRACK,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(38), 1,
      sym__identifier,
    ACTIONS(44), 1,
      anon_sym_BANG,
    ACTIONS(46), 1,
      anon_sym__,
    STATE(24), 1,
      sym__string,
    STATE(34), 1,
      sym__pattern,
    STATE(49), 1,
      sym_field_name,
    STATE(35), 3,
      sym_child,
      sym_negated_child,
      sym_predicate,
    STATE(10), 5,
      sym_alternation,
      sym_anonymous_leaf,
      sym_group,
      sym_named_node,
      sym_wildcard_node,
  [132] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_LBRACK,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(54), 1,
      sym__identifier,
    ACTIONS(58), 1,
      anon_sym__,
    STATE(4), 1,
      sym_node_name,
    STATE(24), 1,
      sym__string,
    STATE(39), 1,
      sym__pattern,
    STATE(14), 3,
      sym_pattern,
      sym_predicate,
      aux_sym_query_repeat1,
    STATE(10), 5,
      sym_alternation,
      sym_anonymous_leaf,
      sym_group,
      sym_named_node,
      sym_wildcard_node,
  [172] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(62), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_DQUOTE,
    ACTIONS(68), 1,
      anon_sym_LPAREN,
    ACTIONS(71), 1,
      anon_sym__,
    STATE(24), 1,
      sym__string,
    STATE(39), 1,
      sym__pattern,
    ACTIONS(60), 2,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
    STATE(9), 3,
      sym_pattern,
      sym_predicate,
      aux_sym_query_repeat1,
    STATE(10), 5,
      sym_alternation,
      sym_anonymous_leaf,
      sym_group,
      sym_named_node,
      sym_wildcard_node,
  [210] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(80), 1,
      sym_capture,
    STATE(26), 1,
      sym__quantifier,
    ACTIONS(76), 2,
      sym__identifier,
      anon_sym__,
    ACTIONS(78), 3,
      sym_one_or_more,
      sym_zero_or_one,
      sym_zero_or_more,
    ACTIONS(74), 8,
      ts_builtin_sym_end,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_anchor,
      anon_sym_BANG,
  [239] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(82), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_RBRACK,
    ACTIONS(87), 1,
      anon_sym_DQUOTE,
    ACTIONS(90), 1,
      anon_sym_LPAREN,
    ACTIONS(93), 1,
      anon_sym__,
    STATE(24), 1,
      sym__string,
    STATE(43), 1,
      sym__pattern,
    STATE(11), 3,
      sym_choice,
      sym_predicate,
      aux_sym_alternation_repeat1,
    STATE(10), 5,
      sym_alternation,
      sym_anonymous_leaf,
      sym_group,
      sym_named_node,
      sym_wildcard_node,
  [276] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_LBRACK,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym__,
    ACTIONS(96), 1,
      ts_builtin_sym_end,
    STATE(24), 1,
      sym__string,
    STATE(39), 1,
      sym__pattern,
    STATE(9), 3,
      sym_pattern,
      sym_predicate,
      aux_sym_query_repeat1,
    STATE(10), 5,
      sym_alternation,
      sym_anonymous_leaf,
      sym_group,
      sym_named_node,
      sym_wildcard_node,
  [313] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_LBRACK,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym__,
    ACTIONS(98), 1,
      anon_sym_RBRACK,
    STATE(24), 1,
      sym__string,
    STATE(43), 1,
      sym__pattern,
    STATE(11), 3,
      sym_choice,
      sym_predicate,
      aux_sym_alternation_repeat1,
    STATE(10), 5,
      sym_alternation,
      sym_anonymous_leaf,
      sym_group,
      sym_named_node,
      sym_wildcard_node,
  [350] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_LBRACK,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym__,
    ACTIONS(100), 1,
      anon_sym_RPAREN,
    STATE(24), 1,
      sym__string,
    STATE(39), 1,
      sym__pattern,
    STATE(9), 3,
      sym_pattern,
      sym_predicate,
      aux_sym_query_repeat1,
    STATE(10), 5,
      sym_alternation,
      sym_anonymous_leaf,
      sym_group,
      sym_named_node,
      sym_wildcard_node,
  [387] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(104), 2,
      sym__identifier,
      anon_sym__,
    ACTIONS(102), 12,
      ts_builtin_sym_end,
      sym_one_or_more,
      sym_zero_or_one,
      sym_zero_or_more,
      sym_capture,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_anchor,
      anon_sym_BANG,
  [409] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(108), 2,
      sym__identifier,
      anon_sym__,
    ACTIONS(106), 12,
      ts_builtin_sym_end,
      sym_one_or_more,
      sym_zero_or_one,
      sym_zero_or_more,
      sym_capture,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_anchor,
      anon_sym_BANG,
  [431] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(112), 2,
      sym__identifier,
      anon_sym__,
    ACTIONS(110), 12,
      ts_builtin_sym_end,
      sym_one_or_more,
      sym_zero_or_one,
      sym_zero_or_more,
      sym_capture,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_anchor,
      anon_sym_BANG,
  [453] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(116), 2,
      sym__identifier,
      anon_sym__,
    ACTIONS(114), 12,
      ts_builtin_sym_end,
      sym_one_or_more,
      sym_zero_or_one,
      sym_zero_or_more,
      sym_capture,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_anchor,
      anon_sym_BANG,
  [475] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(120), 2,
      sym__identifier,
      anon_sym__,
    ACTIONS(118), 12,
      ts_builtin_sym_end,
      sym_one_or_more,
      sym_zero_or_one,
      sym_zero_or_more,
      sym_capture,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_anchor,
      anon_sym_BANG,
  [497] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(124), 2,
      sym__identifier,
      anon_sym__,
    ACTIONS(122), 12,
      ts_builtin_sym_end,
      sym_one_or_more,
      sym_zero_or_one,
      sym_zero_or_more,
      sym_capture,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_anchor,
      anon_sym_BANG,
  [519] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(128), 2,
      sym__identifier,
      anon_sym__,
    ACTIONS(126), 12,
      ts_builtin_sym_end,
      sym_one_or_more,
      sym_zero_or_one,
      sym_zero_or_more,
      sym_capture,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_anchor,
      anon_sym_BANG,
  [541] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(132), 2,
      sym__identifier,
      anon_sym__,
    ACTIONS(130), 12,
      ts_builtin_sym_end,
      sym_one_or_more,
      sym_zero_or_one,
      sym_zero_or_more,
      sym_capture,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_anchor,
      anon_sym_BANG,
  [563] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_LBRACK,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym__,
    STATE(24), 1,
      sym__string,
    STATE(43), 1,
      sym__pattern,
    STATE(13), 3,
      sym_choice,
      sym_predicate,
      aux_sym_alternation_repeat1,
    STATE(10), 5,
      sym_alternation,
      sym_anonymous_leaf,
      sym_group,
      sym_named_node,
      sym_wildcard_node,
  [597] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(136), 2,
      sym__identifier,
      anon_sym__,
    ACTIONS(134), 12,
      ts_builtin_sym_end,
      sym_one_or_more,
      sym_zero_or_one,
      sym_zero_or_more,
      sym_capture,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_anchor,
      anon_sym_BANG,
  [619] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(140), 2,
      sym__identifier,
      anon_sym__,
    ACTIONS(138), 12,
      ts_builtin_sym_end,
      sym_one_or_more,
      sym_zero_or_one,
      sym_zero_or_more,
      sym_capture,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_anchor,
      anon_sym_BANG,
  [641] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(146), 1,
      sym_capture,
    ACTIONS(144), 2,
      sym__identifier,
      anon_sym__,
    ACTIONS(142), 8,
      ts_builtin_sym_end,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_anchor,
      anon_sym_BANG,
  [662] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_LBRACK,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(13), 1,
      anon_sym__,
    ACTIONS(148), 1,
      anon_sym_LPAREN,
    STATE(24), 1,
      sym__string,
    STATE(38), 1,
      sym__pattern,
    STATE(10), 5,
      sym_alternation,
      sym_anonymous_leaf,
      sym_group,
      sym_named_node,
      sym_wildcard_node,
  [691] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(152), 2,
      sym__identifier,
      anon_sym__,
    ACTIONS(150), 8,
      ts_builtin_sym_end,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_anchor,
      anon_sym_BANG,
  [709] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(156), 2,
      sym__identifier,
      anon_sym__,
    ACTIONS(154), 8,
      ts_builtin_sym_end,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_anchor,
      anon_sym_BANG,
  [727] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 2,
      sym__identifier,
      anon_sym__,
    ACTIONS(158), 8,
      ts_builtin_sym_end,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_anchor,
      anon_sym_BANG,
  [745] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(164), 2,
      sym__identifier,
      anon_sym__,
    ACTIONS(162), 8,
      ts_builtin_sym_end,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_anchor,
      anon_sym_BANG,
  [763] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(166), 2,
      sym__identifier,
      anon_sym__,
    ACTIONS(168), 7,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_anchor,
      anon_sym_COLON,
      anon_sym_BANG,
  [780] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(170), 1,
      anon_sym_RPAREN,
    ACTIONS(118), 8,
      sym_one_or_more,
      sym_zero_or_one,
      sym_zero_or_more,
      sym_capture,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym__,
  [797] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(172), 2,
      sym__identifier,
      anon_sym__,
    ACTIONS(174), 6,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_anchor,
      anon_sym_BANG,
  [813] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(176), 2,
      sym__identifier,
      anon_sym__,
    ACTIONS(27), 6,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_anchor,
      anon_sym_BANG,
  [829] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(178), 2,
      sym__identifier,
      anon_sym__,
    ACTIONS(180), 6,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_anchor,
      anon_sym_BANG,
  [845] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(182), 2,
      sym__identifier,
      anon_sym__,
    ACTIONS(184), 6,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_anchor,
      anon_sym_BANG,
  [861] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(186), 2,
      sym__identifier,
      anon_sym__,
    ACTIONS(188), 6,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_anchor,
      anon_sym_BANG,
  [877] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(190), 6,
      ts_builtin_sym_end,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym__,
  [889] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(192), 1,
      sym_capture,
    ACTIONS(194), 1,
      anon_sym_RPAREN,
    STATE(47), 1,
      sym__string,
    STATE(41), 2,
      sym_string,
      aux_sym_predicate_repeat1,
  [909] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(196), 1,
      sym_capture,
    ACTIONS(199), 1,
      anon_sym_DQUOTE,
    ACTIONS(202), 1,
      anon_sym_RPAREN,
    STATE(47), 1,
      sym__string,
    STATE(41), 2,
      sym_string,
      aux_sym_predicate_repeat1,
  [929] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(204), 1,
      sym_capture,
    ACTIONS(206), 1,
      anon_sym_RPAREN,
    STATE(47), 1,
      sym__string,
    STATE(40), 2,
      sym_string,
      aux_sym_predicate_repeat1,
  [949] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(208), 5,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym__,
  [960] = 4,
    ACTIONS(210), 1,
      sym_comment,
    ACTIONS(212), 1,
      anon_sym_DQUOTE,
    STATE(44), 1,
      aux_sym__string_repeat1,
    ACTIONS(214), 2,
      aux_sym__string_token1,
      sym_escape_sequence,
  [974] = 4,
    ACTIONS(210), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_DQUOTE,
    STATE(46), 1,
      aux_sym__string_repeat1,
    ACTIONS(219), 2,
      aux_sym__string_token1,
      sym_escape_sequence,
  [988] = 4,
    ACTIONS(210), 1,
      sym_comment,
    ACTIONS(221), 1,
      anon_sym_DQUOTE,
    STATE(44), 1,
      aux_sym__string_repeat1,
    ACTIONS(223), 2,
      aux_sym__string_token1,
      sym_escape_sequence,
  [1002] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(225), 3,
      sym_capture,
      anon_sym_DQUOTE,
      anon_sym_RPAREN,
  [1011] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 1,
      sym__identifier,
    STATE(36), 1,
      sym_field_name,
  [1021] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(229), 1,
      anon_sym_COLON,
  [1028] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(231), 1,
      ts_builtin_sym_end,
};

static uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(5)] = 0,
  [SMALL_STATE(6)] = 46,
  [SMALL_STATE(7)] = 89,
  [SMALL_STATE(8)] = 132,
  [SMALL_STATE(9)] = 172,
  [SMALL_STATE(10)] = 210,
  [SMALL_STATE(11)] = 239,
  [SMALL_STATE(12)] = 276,
  [SMALL_STATE(13)] = 313,
  [SMALL_STATE(14)] = 350,
  [SMALL_STATE(15)] = 387,
  [SMALL_STATE(16)] = 409,
  [SMALL_STATE(17)] = 431,
  [SMALL_STATE(18)] = 453,
  [SMALL_STATE(19)] = 475,
  [SMALL_STATE(20)] = 497,
  [SMALL_STATE(21)] = 519,
  [SMALL_STATE(22)] = 541,
  [SMALL_STATE(23)] = 563,
  [SMALL_STATE(24)] = 597,
  [SMALL_STATE(25)] = 619,
  [SMALL_STATE(26)] = 641,
  [SMALL_STATE(27)] = 662,
  [SMALL_STATE(28)] = 691,
  [SMALL_STATE(29)] = 709,
  [SMALL_STATE(30)] = 727,
  [SMALL_STATE(31)] = 745,
  [SMALL_STATE(32)] = 763,
  [SMALL_STATE(33)] = 780,
  [SMALL_STATE(34)] = 797,
  [SMALL_STATE(35)] = 813,
  [SMALL_STATE(36)] = 829,
  [SMALL_STATE(37)] = 845,
  [SMALL_STATE(38)] = 861,
  [SMALL_STATE(39)] = 877,
  [SMALL_STATE(40)] = 889,
  [SMALL_STATE(41)] = 909,
  [SMALL_STATE(42)] = 929,
  [SMALL_STATE(43)] = 949,
  [SMALL_STATE(44)] = 960,
  [SMALL_STATE(45)] = 974,
  [SMALL_STATE(46)] = 988,
  [SMALL_STATE(47)] = 1002,
  [SMALL_STATE(48)] = 1011,
  [SMALL_STATE(49)] = 1021,
  [SMALL_STATE(50)] = 1028,
};

static TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_query, 0),
  [7] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [9] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [15] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_named_node_repeat1, 2), SHIFT_REPEAT(32),
  [18] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_named_node_repeat1, 2), SHIFT_REPEAT(23),
  [21] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_named_node_repeat1, 2), SHIFT_REPEAT(45),
  [24] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_named_node_repeat1, 2), SHIFT_REPEAT(6),
  [27] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_named_node_repeat1, 2),
  [29] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_named_node_repeat1, 2), SHIFT_REPEAT(7),
  [32] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_named_node_repeat1, 2), SHIFT_REPEAT(48),
  [35] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_named_node_repeat1, 2), SHIFT_REPEAT(19),
  [38] = {.entry = {.count = 1, .reusable = false}}, SHIFT(32),
  [40] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [42] = {.entry = {.count = 1, .reusable = true}}, SHIFT(5),
  [44] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [46] = {.entry = {.count = 1, .reusable = false}}, SHIFT(19),
  [48] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [50] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [52] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [54] = {.entry = {.count = 1, .reusable = false}}, SHIFT(37),
  [56] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [58] = {.entry = {.count = 1, .reusable = false}}, SHIFT(33),
  [60] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_query_repeat1, 2),
  [62] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_query_repeat1, 2), SHIFT_REPEAT(23),
  [65] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_query_repeat1, 2), SHIFT_REPEAT(45),
  [68] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_query_repeat1, 2), SHIFT_REPEAT(6),
  [71] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_query_repeat1, 2), SHIFT_REPEAT(19),
  [74] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__pattern, 1, .production_id = 2),
  [76] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__pattern, 1, .production_id = 2),
  [78] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [80] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [82] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_alternation_repeat1, 2), SHIFT_REPEAT(23),
  [85] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_alternation_repeat1, 2),
  [87] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_alternation_repeat1, 2), SHIFT_REPEAT(45),
  [90] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_alternation_repeat1, 2), SHIFT_REPEAT(6),
  [93] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_alternation_repeat1, 2), SHIFT_REPEAT(19),
  [96] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_query, 1),
  [98] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [100] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [102] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_alternation, 3),
  [104] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_alternation, 3),
  [106] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_node, 3),
  [108] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_node, 3),
  [110] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_node, 5),
  [112] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_node, 5),
  [114] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__string, 2),
  [116] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__string, 2),
  [118] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_wildcard_node, 1),
  [120] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_wildcard_node, 1),
  [122] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_node, 4),
  [124] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_node, 4),
  [126] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_group, 3),
  [128] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_group, 3),
  [130] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_wildcard_node, 3),
  [132] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_wildcard_node, 3),
  [134] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_anonymous_leaf, 1),
  [136] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_anonymous_leaf, 1),
  [138] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__string, 3),
  [140] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__string, 3),
  [142] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__pattern, 2, .production_id = 3),
  [144] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__pattern, 2, .production_id = 3),
  [146] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [148] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [150] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__pattern, 3, .production_id = 3),
  [152] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__pattern, 3, .production_id = 3),
  [154] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__pattern, 2, .production_id = 2),
  [156] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__pattern, 2, .production_id = 2),
  [158] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_predicate, 3),
  [160] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_predicate, 3),
  [162] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_predicate, 4),
  [164] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_predicate, 4),
  [166] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_field_name, 1),
  [168] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field_name, 1),
  [170] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [172] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_child, 1, .production_id = 1),
  [174] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_child, 1, .production_id = 1),
  [176] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_named_node_repeat1, 2),
  [178] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_negated_child, 2),
  [180] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_negated_child, 2),
  [182] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_node_name, 1),
  [184] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_node_name, 1),
  [186] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_child, 3, .production_id = 4),
  [188] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_child, 3, .production_id = 4),
  [190] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pattern, 1, .production_id = 1),
  [192] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [194] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [196] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_predicate_repeat1, 2), SHIFT_REPEAT(41),
  [199] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_predicate_repeat1, 2), SHIFT_REPEAT(45),
  [202] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_predicate_repeat1, 2),
  [204] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [206] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [208] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_choice, 1, .production_id = 1),
  [210] = {.entry = {.count = 1, .reusable = false}}, SHIFT_EXTRA(),
  [212] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__string_repeat1, 2),
  [214] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__string_repeat1, 2), SHIFT_REPEAT(44),
  [217] = {.entry = {.count = 1, .reusable = false}}, SHIFT(18),
  [219] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [221] = {.entry = {.count = 1, .reusable = false}}, SHIFT(25),
  [223] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [225] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 1),
  [227] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [229] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [231] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_tsq(void) {
  static TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = (const uint16_t *)ts_parse_table,
    .small_parse_table = (const uint16_t *)ts_small_parse_table,
    .small_parse_table_map = (const uint32_t *)ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = (const TSFieldMapSlice *)ts_field_map_slices,
    .field_map_entries = (const TSFieldMapEntry *)ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = (const TSSymbol *)ts_alias_sequences,
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .keyword_lex_fn = ts_lex_keywords,
    .keyword_capture_token = sym__identifier,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
